/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.controllinginterface.lib.projections;

import com.arcway.lib.geometry.Corner;
import com.arcway.lib.geometry.Corners;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.graphics.Alignment;
import com.arcway.lib.graphics.Color;
import com.arcway.lib.graphics.FillColor;
import com.arcway.lib.graphics.device.Device;
import com.arcway.lib.graphics.fillstyles.FillStyle;
import com.arcway.lib.graphics.linestyles.LineStyle;
import com.arcway.lib.graphics.text.TextStyle;
import com.arcway.planagent.controllinginterface.planviewer.IProjection;

public class ProgressBarProjection
implements IProjection {
    private static final double CONVERSION_FACTOR_X = 0.35277777777777775;
    private static final double CONVERSION_FACTOR_Y = 0.35277777777777775;
    private static final double width = 24.694444444444443;
    private static final double height = 4.2333333333333325;
    private static final double spacing = 0.7055555555555555;
    private static final Color white = new Color(255, 255, 255);
    private static final Color darkBlue = new Color(0, 0, 127);
    private static final Color lightGrey = new Color(230, 230, 255);
    private static final FillStyle backgroundFillStyle = FillStyle.SOLID;
    private static final FillColor backgroundFillColor = new FillColor(white);
    private static final LineStyle backgroundLineStyle = LineStyle.SOLID;
    private static final Color backgroundLineColor = darkBlue;
    private static final double backgroundLineThickness = 0.35277777777777775;
    private static final FillStyle completeFillStyle = FillStyle.SOLID;
    private static final FillColor completeFillColor = new FillColor(lightGrey);
    private static final LineStyle completeLineStyle = LineStyle.SOLID;
    private static final Color completeLineColor = lightGrey;
    private static final double completeLineThickness = 0.35277777777777775;
    private static final FillStyle doneFillStyle = FillStyle.SOLID;
    private static final FillColor doneFillColor = new FillColor(darkBlue);
    private static final LineStyle doneLineStyle = LineStyle.SOLID;
    private static final Color doneLineColor = darkBlue;
    private static final double doneLineThickness = 0.35277777777777775;
    private static final Alignment textAlignment = new Alignment();
    private static final TextStyle textStyle = new TextStyle("ARIAL");
    private static final Color textColorRight = darkBlue;
    private static final Color textColorLeft = lightGrey;
    private final int progress;

    public ProgressBarProjection(int progress) {
        this.progress = progress;
    }

    @Override
    public String getProjectionTypeID() {
        return "progressBar";
    }

    public int getProgress() {
        return this.progress;
    }

    @Override
    public void drawProjection(Device device) {
        Color c;
        Rectangle r;
        Corners background = new Corners();
        background.add((Point)new Corner(-0.7055555555555555, -0.7055555555555555));
        background.add((Point)new Corner(25.4, -0.7055555555555555));
        background.add((Point)new Corner(25.4, 4.938888888888888));
        background.add((Point)new Corner(-0.7055555555555555, 4.938888888888888));
        device.polygon(background, backgroundFillColor, backgroundFillStyle, 0.35277777777777775, backgroundLineColor, backgroundLineStyle);
        Corners complete = new Corners();
        complete.add((Point)new Corner(0.0, 0.0));
        complete.add((Point)new Corner(24.694444444444443, 0.0));
        complete.add((Point)new Corner(24.694444444444443, 4.2333333333333325));
        complete.add((Point)new Corner(0.0, 4.2333333333333325));
        device.polygon(complete, completeFillColor, completeFillStyle, 0.35277777777777775, completeLineColor, completeLineStyle);
        Corners done = new Corners();
        double doneWidth = (double)this.progress / 100.0 * 20.46111111111111 + 4.2333333333333325;
        done.add((Point)new Corner(0.0, 0.0));
        done.add((Point)new Corner(doneWidth, 0.0));
        done.add((Point)new Corner(doneWidth, 4.2333333333333325));
        done.add((Point)new Corner(0.0, 4.2333333333333325));
        device.polygon(done, doneFillColor, doneFillStyle, 0.35277777777777775, doneLineColor, doneLineStyle);
        if (this.progress < 50) {
            r = new Rectangle(doneWidth, 0.0, 24.694444444444443, 4.2333333333333325);
            c = textColorRight;
        } else {
            r = new Rectangle(0.0, 0.0, doneWidth, 4.2333333333333325);
            c = textColorLeft;
        }
        device.text(r, textAlignment, String.valueOf(this.progress) + "%", textStyle, 3.7333333333333325, c, false);
    }

    @Override
    public Point getPosition(Rectangle area) {
        return new Point(area.lowerRight.x - 24.694444444444443 - 7.0, area.upperLeft.y + 6.0);
    }

    @Override
    public Rectangle getBoundary() {
        return new Rectangle(Math.floor(-0.8819444444444444), Math.floor(-0.8819444444444444), Math.ceil(25.576388888888886), Math.ceil(5.115277777777777));
    }
}

