/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.java.date;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class DateUtils {
    public static final long MS_PER_MS = 1L;
    public static final long MS_PER_S = 1000L;
    public static final long MS_PER_MIN = 60000L;
    public static final long MS_PER_H = 3600000L;
    public static final long MS_PER_DAY_UT1 = 86400000L;
    public static final long MS_PER_WORKINGDAY = 28800000L;
    private static TimeZone TIMEZONE_UTC;
    private static DateFormat UTC_DATE_FORMAT;
    private static GregorianCalendar GMT_CALENDAR;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convertDateToUniqueString(Date date) {
        String uniqueString;
        DateFormat dateFormat;
        DateFormat dateFormat2 = dateFormat = DateUtils.getUTCDateFormat();
        synchronized (dateFormat2) {
            uniqueString = dateFormat.format(date);
        }
        return uniqueString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date convertUniqueStringToDate(String uniqueString) throws ParseException {
        Date date;
        DateFormat dateFormat;
        DateFormat dateFormat2 = dateFormat = DateUtils.getUTCDateFormat();
        synchronized (dateFormat2) {
            date = dateFormat.parse(uniqueString);
        }
        return date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date addTimeSpanUT1(Date date, long msUT1) {
        Date newDate;
        GregorianCalendar utcCalendar;
        GregorianCalendar gregorianCalendar = utcCalendar = DateUtils.getUTCCalendar();
        synchronized (gregorianCalendar) {
            Date dateSaved = utcCalendar.getTime();
            int daysUT1 = (int)(msUT1 / 86400000L);
            int msUT1Rest = (int)(msUT1 % 86400000L);
            if (msUT1Rest < 0) {
                --daysUT1;
                msUT1Rest += 86400000;
            }
            utcCalendar.setTime(date);
            utcCalendar.add(5, daysUT1);
            utcCalendar.add(14, msUT1Rest);
            int seconds = utcCalendar.get(13);
            while (seconds >= 60) {
                utcCalendar.add(13, 1);
                seconds = utcCalendar.get(13);
            }
            newDate = utcCalendar.getTime();
            utcCalendar.setTime(dateSaved);
        }
        return newDate;
    }

    public static Date addTimeSpanSI(Date date, long msSI) {
        long dateAsLong = date.getTime();
        long newDateAsLong = dateAsLong + msSI;
        Date newDate = new Date(newDateAsLong);
        return newDate;
    }

    public static long subTimeSpanSI(Date endDate, Date startDate) {
        long endDateAsLong = endDate.getTime();
        long startDateAsLong = startDate.getTime();
        long timeSpan = endDateAsLong - startDateAsLong;
        return timeSpan;
    }

    private static synchronized TimeZone getUTCTimeZone() {
        if (TIMEZONE_UTC == null) {
            TIMEZONE_UTC = TimeZone.getTimeZone("GMT");
        }
        return TIMEZONE_UTC;
    }

    private static synchronized GregorianCalendar getUTCCalendar() {
        if (GMT_CALENDAR == null) {
            GMT_CALENDAR = new GregorianCalendar(DateUtils.getUTCTimeZone(), Locale.GERMANY);
        }
        return GMT_CALENDAR;
    }

    private static synchronized DateFormat getUTCDateFormat() {
        if (UTC_DATE_FORMAT == null) {
            UTC_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd' 'HH:mm:ss','S' UTC'");
            UTC_DATE_FORMAT.setTimeZone(DateUtils.getUTCTimeZone());
            UTC_DATE_FORMAT.setCalendar(DateUtils.getUTCCalendar());
        }
        return UTC_DATE_FORMAT;
    }

    public static Date getBeginOfDayInVirtualMachineTimezone(Date date) {
        Calendar virtualMachineTimeZoneCalender = Calendar.getInstance();
        virtualMachineTimeZoneCalender.setTime(date);
        virtualMachineTimeZoneCalender.set(11, 0);
        virtualMachineTimeZoneCalender.set(12, 0);
        virtualMachineTimeZoneCalender.set(13, 0);
        virtualMachineTimeZoneCalender.set(14, 0);
        return virtualMachineTimeZoneCalender.getTime();
    }

    public static Date getMiddleOfDayInVirtualMachineTimezone(Date date) {
        Calendar virtualMachineTimeZoneCalender = Calendar.getInstance();
        virtualMachineTimeZoneCalender.setTime(date);
        virtualMachineTimeZoneCalender.set(11, 12);
        virtualMachineTimeZoneCalender.set(12, 0);
        virtualMachineTimeZoneCalender.set(13, 0);
        virtualMachineTimeZoneCalender.set(14, 0);
        return virtualMachineTimeZoneCalender.getTime();
    }

    public static Date getEndOfDayInVirtualMachineTimezone(Date date) {
        Calendar virtualMachineTimeZoneCalender = Calendar.getInstance();
        virtualMachineTimeZoneCalender.setTime(date);
        virtualMachineTimeZoneCalender.set(11, 23);
        virtualMachineTimeZoneCalender.set(12, 59);
        virtualMachineTimeZoneCalender.set(13, 59);
        virtualMachineTimeZoneCalender.set(14, 999);
        return virtualMachineTimeZoneCalender.getTime();
    }
}

