/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.codec.xml;

import com.arcway.lib.codec.xml.EXXMLDecodingFailed;
import com.arcway.lib.codec.xml.IXMLDecodingHandler;
import com.arcway.lib.codec.xml.XMLAttribute;
import com.arcway.lib.codec.xml.XMLAttributeName;
import com.arcway.lib.codec.xml.XMLAttributeValue;
import com.arcway.lib.codec.xml.XMLCharacters;
import com.arcway.lib.codec.xml.XMLElementName;
import com.arcway.lib.codec.xml.XMLProcessingInstruction;
import com.arcway.lib.java.Assert;
import com.arcway.lib.java.collections.ArrayList_;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SaxParsingHandler
extends DefaultHandler {
    private final IXMLDecodingHandler xmlDecoder;
    private final StringBuffer accumulatedCharacters = new StringBuffer();
    private int currentDepth = -1;

    public SaxParsingHandler(IXMLDecodingHandler xmlDecoder) {
        Assert.checkArgumentBeeingNotNull(xmlDecoder);
        this.xmlDecoder = xmlDecoder;
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        XMLProcessingInstruction processingInstruction = new XMLProcessingInstruction(target, data);
        try {
            this.xmlDecoder.processingInstruction(processingInstruction);
        }
        catch (EXXMLDecodingFailed e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.flushAccumulatedCharacters();
        String elementName = localName == null || localName.length() == 0 ? qName : localName;
        XMLElementName xmlElementName = new XMLElementName(uri, elementName);
        ArrayList_<XMLAttribute> xmlAttributes = new ArrayList_<XMLAttribute>();
        int i = 0;
        while (i < attributes.getLength()) {
            String attributeName = attributes.getLocalName(i);
            if (attributeName == null || attributeName.length() == 0) {
                attributeName = attributes.getQName(i);
            }
            String attributeValue = attributes.getValue(i);
            XMLAttributeName xmlAttributeName = new XMLAttributeName(attributeName);
            XMLAttributeValue xmlAttributeValue = new XMLAttributeValue(attributeValue);
            XMLAttribute xmlAttribute = new XMLAttribute(xmlAttributeName, xmlAttributeValue);
            xmlAttributes.add(xmlAttribute);
            ++i;
        }
        try {
            ++this.currentDepth;
            if (this.currentDepth == 0) {
                this.xmlDecoder.startRootElement(xmlElementName, xmlAttributes);
            } else {
                this.xmlDecoder.startChildElement(xmlElementName, xmlAttributes);
            }
        }
        catch (EXXMLDecodingFailed e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void endElement(String nameSpaceURI, String localName, String qName) throws SAXException {
        this.flushAccumulatedCharacters();
        try {
            this.xmlDecoder.endElement();
            --this.currentDepth;
        }
        catch (EXXMLDecodingFailed e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.accumulateCharacters(ch, start, length);
    }

    @Override
    public void endDocument() throws SAXException {
        this.flushAccumulatedCharacters();
    }

    private void accumulateCharacters(char[] ch, int start, int length) {
        this.accumulatedCharacters.append(ch, start, length);
    }

    private void flushAccumulatedCharacters() throws SAXException {
        String rawCharacters = this.accumulatedCharacters.toString();
        this.accumulatedCharacters.delete(0, this.accumulatedCharacters.length());
        if (rawCharacters.length() > 0) {
            XMLCharacters xmlCharacters = new XMLCharacters(rawCharacters);
            try {
                this.xmlDecoder.characters(xmlCharacters);
            }
            catch (EXXMLDecodingFailed e) {
                throw new SAXException(e);
            }
        }
    }
}

