/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.axes;

import java.util.Vector;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xpath.Expression;
import org.apache.xpath.ExpressionNode;
import org.apache.xpath.ExpressionOwner;
import org.apache.xpath.XPathContext;
import org.apache.xpath.XPathVisitor;
import org.apache.xpath.axes.BasicTestIterator;
import org.apache.xpath.axes.FilterExprIterator;
import org.apache.xpath.axes.FilterExprIteratorSimple;
import org.apache.xpath.axes.PathComponent;
import org.apache.xpath.objects.XNodeSet;

public class FilterExprIterator
extends BasicTestIterator {
    static final long serialVersionUID = 2552176105165737614L;
    private Expression m_expr;
    private transient XNodeSet m_exprObj;
    private boolean m_mustHardReset = false;
    private boolean m_canDetachNodeset = true;

    public FilterExprIterator() {
        super(null);
    }

    public FilterExprIterator(Expression expr) {
        super(null);
        this.m_expr = expr;
    }

    public void setRoot(int context, Object environment) {
        super.setRoot(context, environment);
        this.m_exprObj = FilterExprIteratorSimple.executeFilterExpr((int)context, (XPathContext)this.m_execContext, (PrefixResolver)this.getPrefixResolver(), (boolean)this.getIsTopLevel(), (int)this.m_stackFrame, (Expression)this.m_expr);
    }

    protected int getNextNode() {
        this.m_lastFetched = null != this.m_exprObj ? this.m_exprObj.nextNode() : -1;
        return this.m_lastFetched;
    }

    public void detach() {
        super.detach();
        this.m_exprObj.detach();
        this.m_exprObj = null;
    }

    public void fixupVariables(Vector vars, int globalsSize) {
        super.fixupVariables(vars, globalsSize);
        this.m_expr.fixupVariables(vars, globalsSize);
    }

    public Expression getInnerExpression() {
        return this.m_expr;
    }

    public void setInnerExpression(Expression expr) {
        expr.exprSetParent((ExpressionNode)this);
        this.m_expr = expr;
    }

    public int getAnalysisBits() {
        if (null != this.m_expr && this.m_expr instanceof PathComponent) {
            return ((PathComponent)this.m_expr).getAnalysisBits();
        }
        return 0x4000000;
    }

    public boolean isDocOrdered() {
        return this.m_exprObj.isDocOrdered();
    }

    public void callPredicateVisitors(XPathVisitor visitor) {
        this.m_expr.callVisitors((ExpressionOwner)new filterExprOwner(this), visitor);
        super.callPredicateVisitors(visitor);
    }

    public boolean deepEquals(Expression expr) {
        if (!super.deepEquals(expr)) {
            return false;
        }
        FilterExprIterator fet = (FilterExprIterator)expr;
        return this.m_expr.deepEquals(fet.m_expr);
    }

    static /* synthetic */ Expression access$000(FilterExprIterator x0) {
        return x0.m_expr;
    }

    static /* synthetic */ Expression access$002(FilterExprIterator x0, Expression x1) {
        x0.m_expr = x1;
        return x0.m_expr;
    }
}

