/*
 * Decompiled with CFR 0.152.
 */
package de.plans.psc.client.dialogs.swt;

import com.arcway.lib.eclipse.gui.ModificationProblemsDialog;
import com.arcway.lib.ui.IModificationProblem;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerAccessRestrictedToUpdatesException;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.client.communication.transmissionprocessor.AlienHTTPResponseException;
import de.plans.psc.client.dialogs.swt.HTTPResponseProblemDialog;
import de.plans.psc.client.dialogs.swt.Messages;
import de.plans.psc.client.dialogs.swt.SSLProblemDialog;
import de.plans.psc.shared.serverexceptions.EXNeedReloginException;
import de.plans.psc.shared.serverexceptions.EXServerException;
import java.util.Collections;
import javax.net.ssl.SSLException;
import org.eclipse.swt.widgets.Shell;

public class ServerConnectionFailureUI {
    public static void troubleshootServerConnectionFailure(Shell parentShell, String p_dialogMessage, final Throwable th) {
        if (th == null) {
            assert (false) : "no connection Failure! - troubleshooting makes no sense.";
            return;
        }
        String dialogTitle = Messages.getString("ServerConnectionFailureUI.ConnectionFailureStandardDialogTitle");
        String dialogMessage = p_dialogMessage == null || p_dialogMessage.length() == 0 ? Messages.getString("ServerConnectionFailureUI.ConnectionFailureStandardMessage") : p_dialogMessage;
        if (th.getCause() instanceof SSLException) {
            String serverID = th instanceof ServerNotAvailableException ? ((ServerNotAvailableException)th).getServerID() : null;
            SSLProblemDialog dialog = new SSLProblemDialog(parentShell, serverID, dialogTitle, dialogMessage, Collections.singletonList(new IModificationProblem(){

                public String getHumanReadableDescriptionOfCause() {
                    return Messages.getString("ServerConnectionFailureUI.Cause4SSLException");
                }

                public String getHumanReadableDescriptionOfConsequence() {
                    return th.getLocalizedMessage();
                }

                public int getSeverity() {
                    return 2;
                }
            }), (SSLException)th.getCause());
            dialog.open();
        } else if (th.getCause() instanceof AlienHTTPResponseException) {
            HTTPResponseProblemDialog dialog = new HTTPResponseProblemDialog(parentShell, dialogTitle, dialogMessage, Collections.singletonList(new IModificationProblem(){

                public String getHumanReadableDescriptionOfCause() {
                    return Messages.getString("ServerConnectionFailureUI.Cause4AlienHTTPResponseException");
                }

                public String getHumanReadableDescriptionOfConsequence() {
                    return th.getLocalizedMessage();
                }

                public int getSeverity() {
                    return 2;
                }
            }), (AlienHTTPResponseException)th.getCause());
            dialog.open();
        } else {
            boolean showDialog;
            String humanReadableDescriptionOfCause = th.getLocalizedMessage();
            String humanReadableDescriptionOfConsequence = dialogMessage;
            int severity = 2;
            if (th instanceof LoginCanceledException) {
                assert (false);
                showDialog = false;
            } else if (th instanceof ServerAccessRestrictedToUpdatesException) {
                humanReadableDescriptionOfCause = Messages.getString("ServerConnectionFailureUI.Cause4ServerAccessRestrictedToUpdatesException");
                humanReadableDescriptionOfConsequence = Messages.getString("ServerConnectionFailureUI.Consequence4ServerAccessRestrictedToUpdatesException");
                severity = 4;
                showDialog = true;
            } else if (th instanceof ServerNotAvailableException) {
                humanReadableDescriptionOfCause = Messages.getString("ServerConnectionFailureUI.Cause4ServerNotAvailableException");
                humanReadableDescriptionOfConsequence = th.getLocalizedMessage();
                showDialog = true;
            } else if (th instanceof UnknownServerException) {
                showDialog = true;
                assert (false);
            } else if (th instanceof EXNeedReloginException) {
                humanReadableDescriptionOfCause = Messages.getString("ServerConnectionFailureUI.Cause4EXNeedReloginException");
                humanReadableDescriptionOfConsequence = th.getLocalizedMessage();
                showDialog = true;
            } else if (th instanceof EXServerException) {
                humanReadableDescriptionOfCause = Messages.getString("ServerConnectionFailureUI.Cause4EXServerException");
                humanReadableDescriptionOfConsequence = th.getLocalizedMessage();
                showDialog = true;
            } else {
                showDialog = true;
            }
            if (showDialog) {
                final int f_severity = severity;
                final String f_humanReadableDescriptionOfCause = humanReadableDescriptionOfCause;
                final String f_humanReadableDescriptionOfConsequence = humanReadableDescriptionOfConsequence;
                ModificationProblemsDialog mpDialog = new ModificationProblemsDialog(Collections.singletonList(new IModificationProblem(){

                    public String getHumanReadableDescriptionOfCause() {
                        return f_humanReadableDescriptionOfCause;
                    }

                    public String getHumanReadableDescriptionOfConsequence() {
                        return f_humanReadableDescriptionOfConsequence;
                    }

                    public int getSeverity() {
                        return f_severity;
                    }
                }), dialogTitle, dialogMessage, parentShell);
                mpDialog.open();
            }
        }
    }
}

