/*
 * Decompiled with CFR 0.152.
 */
package de.plans.psc.client.dialogs;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.util.IniFile;
import de.plans.lib.util.PasswordEncoder2;
import de.plans.psc.client.PSCClientServiceFacade;
import de.plans.psc.client.dialogs.DlgLoginIF;

public class CtrlLogin {
    private static final ILogger logger = Logger.getLogger(CtrlLogin.class);
    private static final String INI_FILE_PREFIX_USERNAME = "LoginUsername-";
    private static final String INI_FILE_PREFIX_PASSWORD2 = "LoginPassword2-";
    private static final String INI_FILE_PREFIX_REMEMBER = "LoginRemember-";
    private static final String REMEMBERED_PASSWORD_EXISTS_TOKEN = "$STOREDPW$";
    private DlgLoginIF dlgLogin = null;
    private String currentServerID;
    private String currentServerName;
    private Object currentAuthenticationReceiverInfo;
    private boolean currentRememberPasswordAllowed;
    private String rememberedPassword2;
    private String rememberedUsername;
    private boolean rememberPassword;
    private String currentPassword2;
    private String currentUsername;

    public CtrlLogin(DlgLoginIF dlgLogin) {
        this.dlgLogin = dlgLogin;
        dlgLogin.construct(this);
    }

    public LoginAdvice doLogin(String serverID, String serverName, Object authenticationReceiverInfo, boolean rememberPasswordAllowed, String msg) {
        LoginAdvice loginAdvice = null;
        if (this.dlgLogin != null) {
            this.currentServerID = serverID;
            this.currentServerName = serverName;
            this.currentAuthenticationReceiverInfo = authenticationReceiverInfo;
            this.currentRememberPasswordAllowed = rememberPasswordAllowed;
            this.loadValuesFromIniFile(this.currentServerID);
            boolean doLogin = this.dlgLogin.doLogin(msg);
            if (doLogin) {
                CtrlLogin.storeValuesInInitFile(this, this.currentServerID);
            }
            loginAdvice = new LoginAdvice(!doLogin, this.currentUsername, this.currentPassword2);
        } else {
            loginAdvice = new LoginAdvice(false, null, null);
        }
        this.currentServerID = "";
        this.currentServerName = "";
        this.currentAuthenticationReceiverInfo = "";
        this.currentRememberPasswordAllowed = false;
        this.rememberedUsername = "";
        this.rememberedPassword2 = "";
        this.rememberPassword = false;
        this.currentUsername = null;
        this.currentPassword2 = null;
        return loginAdvice;
    }

    public LoginAdvice doLogin(String serverID, String serverName, Object authenticationReceiverInfo, boolean rememberPasswordAllowed) {
        return this.doLogin(serverID, serverName, authenticationReceiverInfo, rememberPasswordAllowed, null);
    }

    public boolean displayLoginFailedNotice(String serverName, String reason) {
        if (this.dlgLogin != null) {
            return this.dlgLogin.displayLoginFailedNotice(serverName, reason);
        }
        logger.info("login to server " + serverName + " failed. Reason: " + reason);
        return false;
    }

    public String getServerName() {
        return this.currentServerName;
    }

    public String getServerID() {
        return this.currentServerID;
    }

    public Object getAuthenticationReceiverInfo() {
        return this.currentAuthenticationReceiverInfo;
    }

    public String getRememberedUserName() {
        return this.rememberedUsername;
    }

    public String getRememberedPassword() {
        if (this.rememberedPassword2 != null && !this.rememberedPassword2.equals("")) {
            return REMEMBERED_PASSWORD_EXISTS_TOKEN;
        }
        return "";
    }

    public void setUsername(String username) {
        this.currentUsername = username;
    }

    public void setPassword(String password) {
        this.currentPassword2 = password.equals(REMEMBERED_PASSWORD_EXISTS_TOKEN) ? this.rememberedPassword2 : password;
    }

    public void setRememberPassword(boolean rememberPassword) {
        this.rememberPassword = rememberPassword && this.currentRememberPasswordAllowed;
    }

    public boolean getRememberPassword() {
        return this.rememberPassword && this.currentRememberPasswordAllowed;
    }

    public boolean getRememberPasswordAllowed() {
        return this.currentRememberPasswordAllowed;
    }

    private void loadValuesFromIniFile(String serverID) {
        this.loadValuesFromIniFile(serverID, PSCClientServiceFacade.getFacade().getIniFile());
    }

    private void loadValuesFromIniFile(String serverID, IniFile iniFile) {
        this.rememberedUsername = iniFile.getStringProperty(INI_FILE_PREFIX_USERNAME + serverID);
        this.rememberedPassword2 = iniFile.getStringProperty(INI_FILE_PREFIX_PASSWORD2 + serverID);
        this.rememberPassword = this.currentRememberPasswordAllowed && iniFile.getBoolProperty(INI_FILE_PREFIX_REMEMBER + serverID);
    }

    private static void storeValuesInInitFile(CtrlLogin controller, String serverID) {
        IniFile iniFile = PSCClientServiceFacade.getFacade().getIniFile();
        iniFile.setProperty(INI_FILE_PREFIX_USERNAME + serverID, controller.currentUsername);
        iniFile.setProperty(INI_FILE_PREFIX_REMEMBER + serverID, controller.rememberPassword);
        if (controller.getRememberPassword()) {
            String password = controller.currentPassword2;
            if (!PasswordEncoder2.isEncoded((String)password) && !"".equals(password)) {
                password = PasswordEncoder2.encodePassword((String)password);
            }
            iniFile.setProperty(INI_FILE_PREFIX_PASSWORD2 + serverID, password);
        } else {
            iniFile.removeProperty(INI_FILE_PREFIX_PASSWORD2 + serverID);
        }
        iniFile.store();
    }

    public static class LoginAdvice {
        public final boolean loginAborted;
        public final String username;
        public final String password2;

        private LoginAdvice(boolean p_loginAborted, String p_username, String p_password2) {
            this.loginAborted = p_loginAborted;
            this.username = p_username;
            this.password2 = p_password2;
        }
    }
}

