/*
 * Decompiled with CFR 0.152.
 */
package de.plans.psc.client.communication.transmissionprocessor;

import com.arcway.lib.concurrent.Future;
import de.plans.psc.shared.message.ClientSegmentHeader;
import de.plans.psc.shared.message.FragmentedStreamDataBuffer;
import de.plans.psc.shared.message.ServerSegmentHeader;
import de.plans.psc.shared.message.StreamDataBuffer;
import java.net.URL;

public class SegmentExchangeJob {
    private final URL serverURL;
    private final ClientSegmentHeader clientSegmentHeader;
    private final StreamDataBuffer requestBuffer;
    private final FragmentedStreamDataBuffer response;
    private SegmentExchangeJobStatus segmentExchangeJobStatus;
    private Future statusChangeFuture;
    private ServerSegmentHeader serverSegmentHeader;
    private Exception failureReason;
    private long progressScore;

    public SegmentExchangeJob(URL serverURL, ClientSegmentHeader clientSegmentHeader, StreamDataBuffer requestBuffer, FragmentedStreamDataBuffer response) {
        this.serverURL = serverURL;
        this.clientSegmentHeader = clientSegmentHeader;
        this.requestBuffer = requestBuffer;
        this.response = response;
        this.segmentExchangeJobStatus = SegmentExchangeJobStatus.Virgin;
        this.statusChangeFuture = new Future();
        this.serverSegmentHeader = null;
        this.progressScore = 0L;
    }

    public URL getServerURL() {
        return this.serverURL;
    }

    public ClientSegmentHeader getClientSegmentHeader() {
        return this.clientSegmentHeader;
    }

    public StreamDataBuffer getRequestBuffer() {
        return this.requestBuffer;
    }

    public FragmentedStreamDataBuffer getResponse() {
        return this.response;
    }

    public ServerSegmentHeader getServerSegmentHeader() {
        return this.serverSegmentHeader;
    }

    public Exception getFailureReason() {
        return this.failureReason;
    }

    public synchronized void updateSegmentExchangeJobStatus(SegmentExchangeJobStatus newStatus) {
        assert (newStatus.ordinal() >= this.segmentExchangeJobStatus.ordinal());
        switch (newStatus) {
            case Virgin: 
            case SendingRequest: {
                assert (this.failureReason == null);
                assert (this.serverSegmentHeader == null);
                break;
            }
            case ServerSegmentHeaderReceived: 
            case Completed: {
                assert (this.failureReason == null);
                assert (this.serverSegmentHeader != null);
                break;
            }
            case FailedWithError: {
                assert (this.segmentExchangeJobStatus != SegmentExchangeJobStatus.Completed);
                break;
            }
        }
        if (this.segmentExchangeJobStatus != newStatus) {
            this.progressScore += 111L;
            this.segmentExchangeJobStatus = newStatus;
            this.statusChangeFuture.triggerWaitingThreads();
            this.statusChangeFuture = new Future();
        }
    }

    public void markAsFailed(Exception e) {
        assert (this.failureReason == null);
        this.failureReason = e;
        this.updateSegmentExchangeJobStatus(SegmentExchangeJobStatus.FailedWithError);
    }

    public void updateSegmentExchangeJobStatus(ServerSegmentHeader p_serverSegmentHeader) {
        assert (this.serverSegmentHeader == null);
        this.serverSegmentHeader = p_serverSegmentHeader;
        this.updateSegmentExchangeJobStatus(SegmentExchangeJobStatus.ServerSegmentHeaderReceived);
    }

    public synchronized SegmentExchangeJobStatus getSegmentExchangeJobStatus() {
        return this.segmentExchangeJobStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SegmentExchangeJobStatus waitForStatusChange(SegmentExchangeJobStatus currentStatus, long timeout) {
        Future statusChangeFuture_ret;
        SegmentExchangeJobStatus segmentExchangeJobStatus_ret;
        SegmentExchangeJob segmentExchangeJob = this;
        synchronized (segmentExchangeJob) {
            segmentExchangeJobStatus_ret = this.segmentExchangeJobStatus;
            statusChangeFuture_ret = this.statusChangeFuture;
        }
        if (segmentExchangeJobStatus_ret == currentStatus) {
            statusChangeFuture_ret.waitUntilTriggered(timeout);
        }
        return segmentExchangeJobStatus_ret;
    }

    public synchronized long getProgressScore() {
        return this.progressScore;
    }

    public synchronized void incrementProgressScore(long increment) {
        assert (increment > 0L);
        this.progressScore += increment;
    }

    public static enum SegmentExchangeJobStatus {
        Virgin,
        SendingRequest,
        ServerSegmentHeaderReceived,
        Completed,
        FailedWithError;

    }
}

