/*
 * Decompiled with CFR 0.152.
 */
package de.plans.psc.client.communication;

import com.arcway.lib.concurrent.Future;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.eclipse.JFaceProgressMonitorToProgressDisplayAdapter;
import de.plans.psc.client.communication.IAbstractRequestJob;
import de.plans.psc.client.communication.ICancelableRequestJob;
import de.plans.psc.client.communication.IProgressProvidingRequestJob;
import de.plans.psc.client.communication.Messages;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class RequestJobProgressMonitor {
    private static final ILogger logger = Logger.getLogger(RequestJobProgressMonitor.class);
    private static final long ProgessMonitorDisplayDelayTime = 5000L;
    private static final long ProgessMonitorRefreshTime = 1000L;
    private boolean cancel = false;

    public void run(final IAbstractRequestJob job, final String serverName) throws ExJobCancelledByUser {
        final long requestStartTime = System.currentTimeMillis();
        if (job.waitUntilRequestIsProcessed(5000L) != Future.UnblockReason.TriggerReceived) {
            final boolean[] canceled = new boolean[]{false};
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        IWorkbenchWindow ww = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        if (ww == null && PlatformUI.getWorkbench().getWorkbenchWindows().length > 0) {
                            ww = PlatformUI.getWorkbench().getWorkbenchWindows()[0];
                        }
                        Shell shell = ww != null ? ww.getShell() : null;
                        ProgressMonitorDialog pmd = new ProgressMonitorDialog(shell);
                        IRunnableWithProgress runable = new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                JFaceProgressMonitorToProgressDisplayAdapter comfortableMonitor = new JFaceProgressMonitorToProgressDisplayAdapter(monitor);
                                boolean monitorProgressBlocked = false;
                                Future.UnblockReason unblockReason = null;
                                RequestJobProgressMonitor.this.cancelReset();
                                while (!RequestJobProgressMonitor.this.isCancel() && !comfortableMonitor.isTaskToCancel() && unblockReason != Future.UnblockReason.TriggerReceived) {
                                    boolean isProgressBlocked;
                                    String progressMessage;
                                    String tasklabel;
                                    if (job instanceof IProgressProvidingRequestJob) {
                                        IProgressProvidingRequestJob.IProgressSummary progressSummary = ((IProgressProvidingRequestJob)((Object)job)).getProgressSummary();
                                        tasklabel = progressSummary.getTaskLabel(RequestJobProgressMonitor.getDurationAsString(System.currentTimeMillis() - requestStartTime), serverName);
                                        progressMessage = progressSummary.getProgressMessage();
                                        isProgressBlocked = progressSummary.isProgressBlocked();
                                    } else {
                                        tasklabel = NLS.bind((String)Messages.getString("RequestJobProgressMonitor.Contacting_Server_01"), (Object[])new Object[]{RequestJobProgressMonitor.getDurationAsString(System.currentTimeMillis() - requestStartTime), serverName});
                                        progressMessage = "";
                                        isProgressBlocked = false;
                                    }
                                    comfortableMonitor.beginUnquantifiedTask(tasklabel, true);
                                    comfortableMonitor.reportUnquantifiedProgress(progressMessage);
                                    if (isProgressBlocked != monitorProgressBlocked) {
                                        if (monitorProgressBlocked) {
                                            comfortableMonitor.unsetDisplayProgressIsBlocked();
                                        } else {
                                            comfortableMonitor.setDisplayProgressIsBlocked(tasklabel);
                                        }
                                        monitorProgressBlocked = !monitorProgressBlocked;
                                    }
                                    unblockReason = job.waitUntilRequestIsProcessed(1000L);
                                }
                                if (RequestJobProgressMonitor.this.isCancel() || comfortableMonitor.isTaskToCancel()) {
                                    if (job instanceof ICancelableRequestJob) {
                                        ((ICancelableRequestJob)((Object)job)).cancelRequest();
                                    }
                                    comfortableMonitor.reportUnquantifiedProgress(Messages.getString("RequestJobProgressMonitor.CancelingRequest"));
                                    canceled[0] = true;
                                    Thread.sleep(500L);
                                }
                                if (monitorProgressBlocked) {
                                    comfortableMonitor.unsetDisplayProgressIsBlocked();
                                    monitorProgressBlocked = false;
                                }
                                comfortableMonitor.endTask();
                            }
                        };
                        pmd.run(true, true, runable);
                    }
                    catch (InvocationTargetException e) {
                        logger.error("unhandled catch block", (Throwable)e);
                    }
                    catch (InterruptedException e) {
                        logger.error("unhandled catch block", (Throwable)e);
                    }
                }
            });
            if (canceled[0]) {
                throw new ExJobCancelledByUser();
            }
        }
    }

    private static String getDurationAsString(long duration) {
        long seconds = duration / 1000L;
        long secondsfraction = seconds % 60L;
        long minutesfraction = seconds / 60L % 60L;
        long hoursfraction = seconds / 3600L;
        String durationString = Long.toString(secondsfraction);
        if (minutesfraction > 0L || hoursfraction > 0L) {
            if (secondsfraction < 10L) {
                durationString = "0" + durationString;
            }
            durationString = String.valueOf(Long.toString(minutesfraction)) + ":" + durationString;
        }
        if (hoursfraction > 0L) {
            if (minutesfraction < 10L) {
                durationString = "0" + durationString;
            }
            durationString = String.valueOf(Long.toString(hoursfraction)) + ":" + durationString;
        }
        String durationUnit = Messages.getString("RequestJobProgressMonitor.ElapsedTimeUnitSeconds");
        return String.valueOf(durationString) + " " + durationUnit;
    }

    private synchronized void cancelReset() {
        this.cancel = false;
    }

    public synchronized boolean isCancel() {
        return this.cancel;
    }

    public synchronized void cancel() {
        this.cancel = true;
    }

    public static class ExJobCancelledByUser
    extends Exception {
    }
}

