/*
 * Decompiled with CFR 0.152.
 */
package de.plans.psc.client.communication;

import com.arcway.lib.codec.EXDecoderException;
import com.arcway.lib.concurrent.Future;
import com.arcway.lib.eclipse.EclipseProductRetriever;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.psc.eclipse.client.configlogging.ClientSoftwareConfigLogger;
import com.arcway.psc.eclipse.client.update.ClientCompatibilityOfficer;
import de.plans.lib.util.Notification;
import de.plans.lib.util.PasswordEncoder2;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import de.plans.lib.xml.encoding.XMLContext;
import de.plans.lib.xml.parameter.EOParameterSet;
import de.plans.lib.xml.parameter.EOParameterSetList;
import de.plans.lib.xml.parameter.XMLConfigParameterMgr;
import de.plans.lib.xml.parameter.XMLParameterChangeListenerIF;
import de.plans.lib.xml.primitiveTypes.EOString;
import de.plans.psc.client.IExecUIOperations;
import de.plans.psc.client.PSCAbstractClientFactory;
import de.plans.psc.client.PSCApplicationIdentifier;
import de.plans.psc.client.PSCClientLicenseInfo;
import de.plans.psc.client.PSCClientNotificationBus;
import de.plans.psc.client.PSCClientServiceFacade;
import de.plans.psc.client.PSCEffectiveLicenseInfo;
import de.plans.psc.client.communication.EOTrustedParameter;
import de.plans.psc.client.communication.ExPrematureEndOfTransfer;
import de.plans.psc.client.communication.HttpServerConnection;
import de.plans.psc.client.communication.ICancelableRequestJob;
import de.plans.psc.client.communication.IDataTransferRequestJob;
import de.plans.psc.client.communication.IRequestJob;
import de.plans.psc.client.communication.IServerStatusChangedListener;
import de.plans.psc.client.communication.ISnoopRequestJob;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.Messages;
import de.plans.psc.client.communication.PSCAuthenticator;
import de.plans.psc.client.communication.PermissionChangeListener;
import de.plans.psc.client.communication.RequestJobProgressMonitor;
import de.plans.psc.client.communication.ServerAccessRestrictedToUpdatesException;
import de.plans.psc.client.communication.ServerConnection;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.client.dialogs.CtrlLogin;
import de.plans.psc.shared.message.EOClientRequest;
import de.plans.psc.shared.message.EOLicenseInfo;
import de.plans.psc.shared.message.EOLoginResponse;
import de.plans.psc.shared.message.EONotification;
import de.plans.psc.shared.message.EONotificationPacket;
import de.plans.psc.shared.message.EOServer;
import de.plans.psc.shared.message.EOServerInfo;
import de.plans.psc.shared.message.EOServerResponse;
import de.plans.psc.shared.message.EOUserAndGroupAndPermissions;
import de.plans.psc.shared.message.PSCAbstractMessageDataFactory;
import de.plans.psc.shared.serverexceptions.EXNeedReloginException;
import de.plans.psc.shared.serverexceptions.EXServerException;
import de.plans.psc.shared.serverexceptions.PSCAbstractExceptionDecoder;
import java.io.File;
import java.io.IOException;
import java.net.PasswordAuthentication;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;

public class RequestForwarder
implements IEncodableObjectFactory,
XMLParameterChangeListenerIF {
    private static final ILogger logger = Logger.getLogger(RequestForwarder.class);
    protected EOParameterSetList serverList;
    public static final String SERVER_LIST_NAME = "serverList";
    protected EOTrustedParameter trustedParameter;
    protected Map<String, PermissionChangeListener> permissionChangeListeners = new HashMap<String, PermissionChangeListener>();
    private PSCAbstractExceptionDecoder exceptionDecoder;
    private PSCAbstractMessageDataFactory messageFactory;
    private IExecUIOperations asyncUIOperationExecuter;
    private final List<IServerStatusChangedListener> serverStatusListeners = new ArrayList<IServerStatusChangedListener>();
    private PSCApplicationIdentifier applicationIdentifier;
    private PSCClientLicenseInfo clientLicenseSetting = null;
    private RequestJobProgressMonitor requestJobProgressMonitor;
    private static final long DisconnectGraceTime = 500L;
    private boolean serverConnectionsAlreadyLoaded = false;
    private final NotificationDeliveryAgent notificationDeliveryAgent = new NotificationDeliveryAgent();
    private final IServerStatusListenerInformer serverAdditionInformer = new IServerStatusListenerInformer(){

        @Override
        public boolean informListener(ServerConnection connection, IServerStatusChangedListener listener) {
            listener.addedServer(connection);
            return false;
        }
    };
    private final IServerStatusListenerInformer serverModificationInformer = new IServerStatusListenerInformer(){

        @Override
        public boolean informListener(ServerConnection connection, IServerStatusChangedListener listener) {
            listener.modifiedServer(connection);
            return false;
        }
    };
    private final IServerStatusListenerInformer serverAboutToDeleteInformer = new IServerStatusListenerInformer(){

        @Override
        public boolean informListener(ServerConnection connection, IServerStatusChangedListener listener) {
            return !listener.serverAboutToBeDeleted(connection);
        }
    };
    private final IServerStatusListenerInformer serverDeletedInformer = new IServerStatusListenerInformer(){

        @Override
        public boolean informListener(ServerConnection connection, IServerStatusChangedListener listener) {
            listener.deletedServer(connection);
            return false;
        }
    };
    private final IServerStatusListenerInformer serverLoginInformer = new IServerStatusListenerInformer(){

        @Override
        public boolean informListener(ServerConnection connection, IServerStatusChangedListener listener) {
            listener.login(connection);
            return false;
        }
    };
    private final IServerStatusListenerInformer serverLogoffInformer = new IServerStatusListenerInformer(){

        @Override
        public boolean informListener(ServerConnection connection, IServerStatusChangedListener listener) {
            listener.logoff(connection);
            return false;
        }
    };

    public RequestForwarder() {
        this.serverList = new EOParameterSetList(SERVER_LIST_NAME);
        this.trustedParameter = new EOTrustedParameter();
    }

    public void construct(PSCAbstractMessageDataFactory p_messageFactory, PSCAbstractExceptionDecoder p_exceptionDecoder, IExecUIOperations p_asyncUIOperationExecuter, PSCApplicationIdentifier p_applicationIdentifier) {
        this.messageFactory = p_messageFactory;
        this.exceptionDecoder = p_exceptionDecoder;
        this.asyncUIOperationExecuter = p_asyncUIOperationExecuter;
        this.applicationIdentifier = p_applicationIdentifier;
        this.requestJobProgressMonitor = new RequestJobProgressMonitor();
        this.setupSSL();
    }

    private void setupSSL() {
        HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String urlHostName, SSLSession session) {
                logger.debug("HostnameVerifier.verify(urlHostName=" + urlHostName + ", session.peerHost=" + session.getPeerHost());
                return true;
            }
        });
        if (this.trustedParameter.getTrustStore() != null && this.trustedParameter.getTrustStorePassword() != null) {
            System.setProperty("javax.net.ssl.trustStore", this.trustedParameter.getTrustStore());
            System.setProperty("javax.net.ssl.trustStorePassword", this.trustedParameter.getTrustStorePassword());
        } else {
            String msg = "TrustStore information not found. Client SSL communication will use trust store \"" + System.getProperty("javax.net.ssl.trustStore") + "\" with password \"" + System.getProperty("javax.net.ssl.trustStorePassword") + "\"";
            logger.debug(msg);
        }
    }

    public void setClientLicenseSetting(PSCClientLicenseInfo licenseSetting) {
        this.clientLicenseSetting = licenseSetting;
    }

    public PSCClientLicenseInfo getClientLicenseSetting() {
        return this.clientLicenseSetting;
    }

    public void registerParameterSets(XMLConfigParameterMgr parameterMgr) {
        parameterMgr.addSubtreeRootElement((EOParameterSet)this.serverList);
        parameterMgr.registerEncodableObjectFactory(this.serverList.getTag(), (IEncodableObjectFactory)this);
        parameterMgr.registerEncodableObjectFactory(EOServer.XML_NAME, (IEncodableObjectFactory)this);
        parameterMgr.addSubtreeRootElement((EOParameterSet)this.trustedParameter);
        parameterMgr.registerEncodableObjectFactory(this.trustedParameter.getTag(), (IEncodableObjectFactory)this);
        parameterMgr.addParameterChangedListener((XMLParameterChangeListenerIF)this);
    }

    public EncodableObjectBase createEncodableObject(String elementName, XMLContext context) throws EXDecoderException {
        if (this.serverList.getTag().equals(elementName)) {
            return this.serverList;
        }
        if (EOServer.XML_NAME.equals(elementName)) {
            return new EOServer(context);
        }
        if (this.trustedParameter.getTag().equals(elementName)) {
            return this.trustedParameter;
        }
        return null;
    }

    public EOServer getServerConfigurationParameters(String serverID) {
        ArrayList servers = this.serverList.getArrayList();
        for (EOServer server : servers) {
            if (!server.getServerID().equals(serverID)) continue;
            return server;
        }
        return null;
    }

    public synchronized EOServerResponse sendRequest(String serverID, EOClientRequest request) throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException {
        return this.sendRequest(serverID, request, 0);
    }

    public synchronized EOServerResponse sendRequest(String serverID, EOClientRequest request, int timeOutInSeconds) throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException {
        assert (serverID != null) : "Server ID is missing";
        assert (request != null) : "Request is missing";
        RFConnectionRelatedData connectionData = RFConnectionRelatedData.getConnectionData(serverID);
        if (connectionData == null) {
            throw new UnknownServerException(serverID);
        }
        if (!connectionData.connected) {
            throw new ServerNotAvailableException(connectionData.serverConnection.getServerID(), request);
        }
        return this.sendRequest(connectionData.serverConnection, request, timeOutInSeconds);
    }

    private EOServerResponse awaitResponse(RFConnectionRelatedData connectionData, IRequestJobCharger<IRequestJob> requestJobCharger) throws ServerNotAvailableException, EXServerException {
        return this.awaitResponse(connectionData, requestJobCharger, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized EOServerResponse awaitResponse(RFConnectionRelatedData connectionData, IRequestJobCharger<IRequestJob> requestJobCharger, final int timeOutInSeconds) throws ServerNotAvailableException, EXServerException {
        assert (requestJobCharger != null) : "RequestJobCharger is missing";
        Class<NotificationDlvrySyncData> clazz = NotificationDlvrySyncData.class;
        synchronized (NotificationDlvrySyncData.class) {
            if (NotificationDlvrySyncData.notificationDeliveryEnabledCounter != 0L) {
                logger.error("Sending requests while notification delivery is disabled. Re-enabling notification delivery.", (Throwable)new Exception());
                NotificationDlvrySyncData.notificationDeliveryEnabledCounter = 0L;
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            ServerConnection serverConnection = connectionData.serverConnection;
            this.notificationDeliveryAgent.cancelNotificationDelivery();
            Class<NotificationDlvrySyncData> clazz2 = NotificationDlvrySyncData.class;
            synchronized (NotificationDlvrySyncData.class) {
                if (NotificationDlvrySyncData.notificationEventInProcessOfBeingPosted != 0) {
                    logger.error("A Request was issued during Notification delivery. ", (Throwable)new Exception());
                }
                if (NotificationDlvrySyncData.processingOfRequestIsInProgress != 0) {
                    logger.error("A further Request was issued while another Request was being processed (new request depth=" + (NotificationDlvrySyncData.processingOfRequestIsInProgress + 1) + ").", (Throwable)new Exception());
                }
                // ** MonitorExit[var5_5] (shouldn't be in output)
                EOServerResponse response = null;
                Object object = NotificationDlvrySyncData.requestProcessingMutex;
                synchronized (object) {
                    NotificationDeliveryAgent notificationDeliveryAgent = this.notificationDeliveryAgent;
                    synchronized (notificationDeliveryAgent) {
                        Class<NotificationDlvrySyncData> clazz3 = NotificationDlvrySyncData.class;
                        synchronized (NotificationDlvrySyncData.class) {
                            ++NotificationDlvrySyncData.processingOfRequestIsInProgress;
                            this.notificationDeliveryAgent.cancelNotificationDelivery();
                            // ** MonitorExit[var8_8] (shouldn't be in output)
                        }
                    }
                    {
                        IRequestJob job = null;
                        try {
                            try {
                                job = requestJobCharger.chargeRequest();
                                if (timeOutInSeconds > 0 && job instanceof ICancelableRequestJob) {
                                    final IRequestJob jobFinal = job;
                                    new Thread("Timeout watcher"){

                                        @Override
                                        public void run() {
                                            long timeOutInMilliseconds = 1000L * (long)timeOutInSeconds;
                                            Future.UnblockReason unblockReason = jobFinal.waitUntilRequestIsProcessed(timeOutInMilliseconds);
                                            if (unblockReason == Future.UnblockReason.Timeout) {
                                                RequestForwarder.this.requestJobProgressMonitor.cancel();
                                            }
                                        }
                                    }.start();
                                }
                                this.requestJobProgressMonitor.run(job, serverConnection.getServerName());
                                job.waitUntilRequestIsProcessed(0L);
                                response = this.throwExceptionsOrReturnResponse(connectionData, job);
                            }
                            catch (EXNeedReloginException e) {
                                this.markServerConnectionToBeInDisconnectedState(connectionData);
                                throw e;
                            }
                            catch (ServerNotAvailableException e) {
                                this.disconnect(connectionData);
                                throw e;
                            }
                            catch (RequestJobProgressMonitor.ExJobCancelledByUser e) {
                                this.disconnect(connectionData);
                                throw new ServerNotAvailableException(connectionData.serverConnection.getServerID(), job.getRequest());
                            }
                        }
                        catch (Throwable throwable) {
                            Class<NotificationDlvrySyncData> clazz4 = NotificationDlvrySyncData.class;
                            synchronized (NotificationDlvrySyncData.class) {
                                --NotificationDlvrySyncData.processingOfRequestIsInProgress;
                                // ** MonitorExit[var10_13] (shouldn't be in output)
                                this.triggerNotificationDelivery();
                                throw throwable;
                            }
                        }
                        Class<NotificationDlvrySyncData> clazz5 = NotificationDlvrySyncData.class;
                        synchronized (NotificationDlvrySyncData.class) {
                            --NotificationDlvrySyncData.processingOfRequestIsInProgress;
                            // ** MonitorExit[var10_14] (shouldn't be in output)
                            this.triggerNotificationDelivery();
                            return response;
                        }
                    }
                }
            }
        }
    }

    private synchronized EOServerResponse sendRequest(final ServerConnection c, final EOClientRequest request, int timeOutInSeconds) throws ServerNotAvailableException, EXServerException {
        RFConnectionRelatedData connectionData = RFConnectionRelatedData.getConnectionData(c);
        assert (connectionData != null) : "Connection agent is missing";
        assert (request != null) : "Request is missing";
        if (!connectionData.connected) {
            throw new ServerNotAvailableException(c.getServerID(), request);
        }
        if (!connectionData.clientCompatibilityOfficer.mayClientSendThisRequest(request)) {
            throw new ServerAccessRestrictedToUpdatesException(connectionData.serverConnection.getServerID(), request);
        }
        IRequestJobCharger requestJobCharger = new IRequestJobCharger(){
            private ICancelableRequestJob step = null;

            public IRequestJob chargeRequest() {
                return c.chargeRequest(request);
            }
        };
        return this.awaitResponse(connectionData, requestJobCharger, timeOutInSeconds);
    }

    public boolean login(final ServerConnection serverConnection, String username, String password) throws ServerNotAvailableException, EXServerException {
        PSCAuthenticator.RequestorInfo requestorInfo;
        PasswordAuthentication passwordAuthentication;
        RFConnectionRelatedData connectionData = RFConnectionRelatedData.getConnectionData(serverConnection);
        String typedUsername = null;
        String pscPassword = null;
        String pscPassword2 = null;
        boolean errorOccuredDuringLogin = true;
        if (connectionData.connected) {
            logger.error("Login requested while being logged in", (Throwable)new Exception());
            this.disconnect(connectionData);
        }
        ISnoopRequestJob snoopJob = serverConnection.chargeSnoopRequest();
        snoopJob.waitUntilRequestIsProcessed(0L);
        IOException ioException = null;
        try {
            snoopJob.throwTransmissionExceptions();
        }
        catch (IOException e) {
            ioException = e;
        }
        if (snoopJob.getAuthenticatedUsersName() != null) {
            typedUsername = snoopJob.getAuthenticatedUsersName();
            pscPassword = "<dummy>";
            pscPassword2 = "<dummy>";
            passwordAuthentication = null;
            requestorInfo = null;
        } else if (snoopJob.getAuthenticationRequestor() != null) {
            assert (false) : "PSCAuthenticator is not expected to be active => snoopJob.getAuthenticationRequestor() will allways return null.";
            PSCAuthenticator.RequestorInfo requestor = snoopJob.getAuthenticationRequestor();
            typedUsername = username;
            pscPassword = "<dummy>";
            pscPassword2 = "<dummy>";
            passwordAuthentication = new PasswordAuthentication(username, password.toCharArray());
            requestorInfo = requestor;
        } else if (ioException == null) {
            String encodedPassword2 = "";
            if (ServerConnection.transmitPasswordsAsCleartext() || PasswordEncoder2.isEncoded((String)password)) {
                encodedPassword2 = password;
            } else if (!password.equals("")) {
                encodedPassword2 = PasswordEncoder2.encodePassword((String)password);
            }
            typedUsername = username;
            pscPassword2 = encodedPassword2;
            passwordAuthentication = null;
            requestorInfo = null;
        } else {
            throw serverConnection.translateTransmissionException(null, ioException, false);
        }
        final PasswordAuthentication f_passwordAuthentication = passwordAuthentication;
        final PSCAuthenticator.RequestorInfo f_requestorInfo = requestorInfo;
        final String f_typedUsername = typedUsername;
        final String f_pscPassword2 = pscPassword2;
        IRequestJobCharger<IRequestJob> loginJobCharger = new IRequestJobCharger<IRequestJob>(){

            @Override
            public IRequestJob chargeRequest() {
                return serverConnection.chargeLoginRequest(RequestForwarder.this.applicationIdentifier, RequestForwarder.this.clientLicenseSetting, f_passwordAuthentication, f_requestorInfo, f_typedUsername, f_pscPassword2);
            }
        };
        EOServerResponse res = this.awaitResponse(connectionData, loginJobCharger);
        if (res == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("handleLogin() - Server did not return a response on the login request " + username);
            }
            return false;
        }
        EOLoginResponse loginRes = (EOLoginResponse)res.getResponseData();
        if (loginRes.getLoginStatus().equals("loginOk")) {
            this.markServerConnectionToBeInConnectedStateAndCheckComaptibiltyConstraints(connectionData, loginRes);
            errorOccuredDuringLogin = false;
        } else {
            this.logFailedLoginAndCalculateLocalizedMessage(serverConnection, loginRes);
        }
        return errorOccuredDuringLogin;
    }

    private boolean handleLogin(RFConnectionRelatedData connectionData) throws ServerNotAvailableException, EXServerException, LoginCanceledException {
        assert (connectionData != null) : "Connection agent is missing";
        if (connectionData.preventLogin) {
            return false;
        }
        long AUTH_TYPE_CONTAINER_TRANSPARENT = 1L;
        long AUTH_TYPE_CONTAINER_PASSWORD = 2L;
        long AUTH_TYPE_PSC = 3L;
        long AUTH_TYPE_INVALID = 4L;
        final ServerConnection serverConnection = connectionData.serverConnection;
        CtrlLogin logInDialog = PSCAbstractClientFactory.getClientFactory().getLoginDialog();
        long auth_type = 4L;
        String errorMsg = null;
        while (true) {
            PSCAuthenticator.RequestorInfo requestorInfo;
            PasswordAuthentication passwordAuthentication;
            String typedUsername = null;
            String pscPassword2 = null;
            if (connectionData.connected) {
                logger.error("Login requested while being logged in", (Throwable)new Exception());
                this.disconnect(connectionData);
            }
            ISnoopRequestJob snoopJob = serverConnection.chargeSnoopRequest();
            try {
                this.requestJobProgressMonitor.run(snoopJob, serverConnection.getServerName());
            }
            catch (RequestJobProgressMonitor.ExJobCancelledByUser e1) {
                if (logger.isDebugEnabled()) {
                    logger.debug("handleLogin() - User canceled log in to server " + RequestForwarder.calculateServerIdentificationForLogMessage(connectionData.serverConnection));
                }
                throw new LoginCanceledException(serverConnection.getServerID());
            }
            snoopJob.waitUntilRequestIsProcessed(0L);
            IOException ioException = null;
            try {
                snoopJob.throwTransmissionExceptions();
            }
            catch (IOException e) {
                ioException = e;
            }
            if (snoopJob.getAuthenticatedUsersName() != null) {
                auth_type = 1L;
                typedUsername = snoopJob.getAuthenticatedUsersName();
                pscPassword2 = "<dummy>";
                passwordAuthentication = null;
                requestorInfo = null;
            } else if (snoopJob.getAuthenticationRequestor() != null) {
                assert (false) : "PSCAuthenticator is not expected to be active => snoopJob.getAuthenticationRequestor() will allways return null.";
                auth_type = 2L;
                PSCAuthenticator.RequestorInfo requestor = snoopJob.getAuthenticationRequestor();
                CtrlLogin.LoginAdvice loginAdvice = logInDialog.doLogin(serverConnection.getServerID(), serverConnection.getServerName(), requestor, false, errorMsg);
                if (loginAdvice.loginAborted) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("handleLogin() - User canceled log in to server " + RequestForwarder.calculateServerIdentificationForLogMessage(connectionData.serverConnection));
                    }
                    throw new LoginCanceledException(serverConnection.getServerID());
                }
                typedUsername = loginAdvice.username;
                pscPassword2 = "<dummy>";
                passwordAuthentication = new PasswordAuthentication(loginAdvice.username, loginAdvice.password2.toCharArray());
                requestorInfo = requestor;
            } else if (ioException == null) {
                auth_type = 3L;
                CtrlLogin.LoginAdvice loginAdvice = logInDialog.doLogin(serverConnection.getServerID(), serverConnection.getServerName(), serverConnection.getURL(), !ServerConnection.transmitPasswordsAsCleartext(), errorMsg);
                if (loginAdvice.loginAborted) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("handleLogin() - User canceled log in to server " + RequestForwarder.calculateServerIdentificationForLogMessage(connectionData.serverConnection));
                    }
                    throw new LoginCanceledException(serverConnection.getServerID());
                }
                String encodedPassword2 = "";
                if (ServerConnection.transmitPasswordsAsCleartext() || PasswordEncoder2.isEncoded((String)loginAdvice.password2)) {
                    encodedPassword2 = loginAdvice.password2;
                } else if (!loginAdvice.password2.equals("")) {
                    encodedPassword2 = PasswordEncoder2.encodePassword((String)loginAdvice.password2);
                }
                typedUsername = loginAdvice.username;
                pscPassword2 = encodedPassword2;
                passwordAuthentication = null;
                requestorInfo = null;
            } else {
                throw serverConnection.translateTransmissionException(null, ioException, false);
            }
            final PasswordAuthentication f_passwordAuthentication = passwordAuthentication;
            final PSCAuthenticator.RequestorInfo f_requestorInfo = requestorInfo;
            final String f_typedUsername = typedUsername;
            final String f_pscPassword2 = pscPassword2;
            IRequestJobCharger<IRequestJob> loginJobCharger = new IRequestJobCharger<IRequestJob>(){

                @Override
                public IRequestJob chargeRequest() {
                    return serverConnection.chargeLoginRequest(RequestForwarder.this.applicationIdentifier, RequestForwarder.this.clientLicenseSetting, f_passwordAuthentication, f_requestorInfo, f_typedUsername, f_pscPassword2);
                }
            };
            EOServerResponse res = this.awaitResponse(connectionData, loginJobCharger);
            if (res == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("handleLogin() - Server did not return a response on the login request " + RequestForwarder.calculateServerIdentificationForLogMessage(connectionData.serverConnection));
                }
                return false;
            }
            EOLoginResponse loginRes = (EOLoginResponse)res.getResponseData();
            if (loginRes.getLoginStatus().equals("loginOk")) {
                this.markServerConnectionToBeInConnectedStateAndCheckComaptibiltyConstraints(connectionData, loginRes);
                try {
                    connectionData.clientCompatibilityOfficer.displayAvailableAnnouncement();
                }
                catch (IOException e) {
                    logger.error("unhandled catch block", (Throwable)e);
                }
                catch (UnknownServerException e) {
                    logger.error("unhandled catch block", (Throwable)e);
                }
                catch (EclipseProductRetriever.UnableToRetrieveEclipseProduct e) {
                    logger.error("unhandled catch block", (Throwable)e);
                }
                return true;
            }
            errorMsg = this.logFailedLoginAndCalculateLocalizedMessage(serverConnection, loginRes);
            if (auth_type == 2L || auth_type == 3L) continue;
            boolean retry = logInDialog.displayLoginFailedNotice(serverConnection.getServerName(), errorMsg);
            if (auth_type == 4L) {
                logger.info("handleLogin(AUTH_TYPE_INVALID) - Login to Server " + RequestForwarder.calculateServerIdentificationForLogMessage(connectionData.serverConnection) + " failed.");
            }
            if (!retry) break;
        }
        throw new LoginCanceledException(serverConnection.getServerID());
    }

    private String logFailedLoginAndCalculateLocalizedMessage(ServerConnection serverConnection, EOLoginResponse loginRes) {
        String errorMsg = null;
        if (!loginRes.getLoginStatus().equals("loginOk")) {
            if (loginRes.getLoginStatus().equals("invalidUserNameOrPassword")) {
                errorMsg = Messages.getString("RequestForwarder.Invalid_username_or_password._14");
                if (logger.isDebugEnabled()) {
                    logger.debug("handleLogin() - User entered invalid username or password (User: " + serverConnection.getUserName() + " Server: " + RequestForwarder.calculateServerIdentificationForLogMessage(serverConnection) + ")");
                }
            } else if (loginRes.getLoginStatus().equals("noLicenseAvailable")) {
                errorMsg = Messages.getString("RequestForwarder.No_license_available._18");
                if (logger.isDebugEnabled()) {
                    logger.debug("handleLogin() - No free license available (User: " + serverConnection.getUserName() + " Server: " + RequestForwarder.calculateServerIdentificationForLogMessage(serverConnection) + ")");
                }
            } else if (loginRes.getLoginStatus().equals("incompatibleClient")) {
                errorMsg = Messages.getString("RequestForwarder.Incompatible_client._19");
                if (logger.isDebugEnabled()) {
                    logger.debug("handleLogin() - Incompatible Client Version (User: " + serverConnection.getUserName() + " Server " + RequestForwarder.calculateServerIdentificationForLogMessage(serverConnection) + ")");
                }
            } else {
                errorMsg = Messages.getString("RequestForwarder.Login_refused._20");
                if (logger.isDebugEnabled()) {
                    logger.debug("handleLogin() - Login refused - reason unknown (User: " + serverConnection.getUserName() + " Server: " + RequestForwarder.calculateServerIdentificationForLogMessage(serverConnection) + " Returned login status: " + loginRes.getLoginStatus() + ")");
                }
            }
        }
        return errorMsg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void suspendAsynchronousUpdateEnquiryUntilNextServerRequest() {
        Class<NotificationDlvrySyncData> clazz = NotificationDlvrySyncData.class;
        synchronized (NotificationDlvrySyncData.class) {
            if (NotificationDlvrySyncData.notificationDeliveryEnabledCounter == 0L) {
                this.notificationDeliveryAgent.cancelNotificationDelivery();
            } else if (NotificationDlvrySyncData.notificationDeliveryEnabledCounter <= 0L && NotificationDlvrySyncData.notificationDeliveryEnabledCounter == Long.MAX_VALUE) {
                NotificationDlvrySyncData.notificationDeliveryEnabledCounter = NotificationDlvrySyncData.notificationDeliveryEnabledCounter - 1L;
                logger.fatal("suspendAsynchronousUpdateEnquiryUntilNextServerRequest() notificationDeliveryEnabledCounter overflow.", (Throwable)new Exception());
            }
            NotificationDlvrySyncData.notificationDeliveryEnabledCounter = NotificationDlvrySyncData.notificationDeliveryEnabledCounter + 1L;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeAsynchronousUpdateEnquiry() {
        Class<NotificationDlvrySyncData> clazz = NotificationDlvrySyncData.class;
        synchronized (NotificationDlvrySyncData.class) {
            NotificationDlvrySyncData.notificationDeliveryEnabledCounter = NotificationDlvrySyncData.notificationDeliveryEnabledCounter - 1L;
            if (NotificationDlvrySyncData.notificationDeliveryEnabledCounter == 0L) {
                this.triggerNotificationDelivery();
            } else if (NotificationDlvrySyncData.notificationDeliveryEnabledCounter <= 0L) {
                logger.error("resumeAsynchronousUpdateEnquiry() was called too often ", (Throwable)new Exception());
                NotificationDlvrySyncData.notificationDeliveryEnabledCounter = 0L;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processNotificationEnquiryResponse(ServerConnection connection, IRequestJob job) {
        NotificationDeliveryAgent notificationDeliveryAgent = this.notificationDeliveryAgent;
        synchronized (notificationDeliveryAgent) {
            Class<NotificationDlvrySyncData> clazz = NotificationDlvrySyncData.class;
            synchronized (NotificationDlvrySyncData.class) {
                RFConnectionRelatedData connectionData = RFConnectionRelatedData.getConnectionData(connection);
                if (connectionData != null) {
                    if (connectionData.connected) {
                        Object object = NotificationDlvrySyncData.notificationStoreAccessMutex;
                        synchronized (object) {
                            connectionData.unprocessedUpdateEnquiryRequestJobs.add(job);
                        }
                        this.triggerNotificationDelivery();
                    } else {
                        logger.debug("Received notification enquiry response from disconnected server: " + (connectionData.serverConnection != null ? String.valueOf(RequestForwarder.calculateServerIdentificationForLogMessage(connectionData.serverConnection)) + " \n" : "?\n"));
                    }
                } else {
                    logger.debug("Received notification enquiry response for unknown server connection from tread with the name: " + Thread.currentThread().getName());
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void triggerNotificationDelivery() {
        NotificationDeliveryAgent notificationDeliveryAgent = this.notificationDeliveryAgent;
        synchronized (notificationDeliveryAgent) {
            Class<NotificationDlvrySyncData> clazz = NotificationDlvrySyncData.class;
            synchronized (NotificationDlvrySyncData.class) {
                if (NotificationDlvrySyncData.notificationDeliveryEnabledCounter == 0L && NotificationDlvrySyncData.processingOfRequestIsInProgress == 0) {
                    this.notificationDeliveryAgent.queueNotificationDelivery();
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
        }
    }

    public void deliverAsynchronousUpdatesNow(String serverID) {
        this.notificationDeliveryAgent.deliverAsynchronousUpdatesNow(serverID);
    }

    public void markServerConnectionToBeInConnectedStateAndCheckComaptibiltyConstraints(RFConnectionRelatedData connectionData, EOLoginResponse loginRes) throws ServerNotAvailableException, EXServerException {
        this.markServerConnectionToBeInConnectedState(connectionData, loginRes);
        try {
            ClientSoftwareConfigLogger.sendClientSoftwareConfigInfoToServer(this, connectionData.serverConnection.getServerID());
        }
        catch (Exception e) {
            logger.info("Unable to add this clients software configuration info to the servers archive.", (Throwable)e);
        }
        try {
            connectionData.clientCompatibilityOfficer.assessCompatibilityLevel();
        }
        catch (UnknownServerException e) {
            logger.error("unhandled catch block", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("unhandled catch block", (Throwable)e);
        }
        catch (LoginCanceledException e) {
            logger.error("unhandled catch block", (Throwable)e);
        }
        catch (EclipseProductRetriever.UnableToRetrieveEclipseProduct e) {
            logger.error("unhandled catch block", (Throwable)e);
        }
    }

    private void markServerConnectionToBeInConnectedState(RFConnectionRelatedData connectionData, EOLoginResponse loginRes) {
        assert (loginRes.getLoginStatus().equals("loginOk"));
        connectionData.preventLogin = false;
        connectionData.unprocessedUpdateEnquiryRequestJobs = new LinkedList();
        connectionData.undeliveredNotifications = new LinkedList();
        connectionData.lastNotificationPacketSerial = 0L;
        connectionData.fetchedNotificationsExhaustedPending = false;
        connectionData.serverConnection.setServerInfo(loginRes.getServerInfo());
        connectionData.serverConnection.setUserData(loginRes.getUser());
        connectionData.serverConnection.setLicenseInfo(this.translateLicenseResponse(loginRes.getLicenseInfo()));
        connectionData.connected = true;
        connectionData.serverConnection.startNotificationEnquiry();
        this.subscribeForPermissionChangeNotifications(connectionData.serverConnection);
        if (logger.isDebugEnabled()) {
            logger.debug("handleLogin() - Succesfully logged in user " + connectionData.serverConnection.getUserName() + " on server " + RequestForwarder.calculateServerIdentificationForLogMessage(connectionData.serverConnection));
        }
        this.informListenersAboutLogin(connectionData);
    }

    private PSCEffectiveLicenseInfo translateLicenseResponse(EOLicenseInfo licenseResponse) {
        PSCEffectiveLicenseInfo effectiveLicenseInfo = !licenseResponse.isLicenseAvailable() ? new PSCEffectiveLicenseInfo(3, null) : (licenseResponse.getHandle() != null && licenseResponse.getHandle().length() > 0 ? new PSCEffectiveLicenseInfo(2, licenseResponse.getHandle()) : new PSCEffectiveLicenseInfo(1, licenseResponse.getHandle()));
        return effectiveLicenseInfo;
    }

    private void markServerConnectionToBeInDisconnectedState(RFConnectionRelatedData connectionData) {
        if (connectionData.connected) {
            connectionData.preventLogin = true;
            try {
                connectionData.connected = false;
                connectionData.clientCompatibilityOfficer = new ClientCompatibilityOfficer(this, connectionData.serverConnection);
                connectionData.unprocessedUpdateEnquiryRequestJobs = new LinkedList();
                connectionData.undeliveredNotifications = new LinkedList();
                connectionData.lastNotificationPacketSerial = 0L;
                connectionData.fetchedNotificationsExhaustedPending = false;
                PermissionChangeListener listener = this.permissionChangeListeners.get(connectionData.serverConnection.getServerID());
                if (listener != null) {
                    listener.unsubscribeAllEventsAtServerDisconnect();
                }
                this.permissionChangeListeners.remove(connectionData.serverConnection.getServerID());
                this.informListenersAboutLogoff(connectionData);
                connectionData.serverConnection.stopNotificationEnquiry();
            }
            finally {
                connectionData.preventLogin = false;
            }
        }
    }

    private void extractNotificationsAndThrowExceptions(RFConnectionRelatedData connectionData, IRequestJob requestJob) throws ServerNotAvailableException, EXServerException {
        EOServerResponse response = this.throwExceptionsOrReturnResponse(connectionData, requestJob);
        if (connectionData.connected) {
            assert (response != null);
            assert (requestJob.getRequest().getReqGroup().equals("Notification") && requestJob.getRequest().getReqSubID().equals("Fetch"));
            assert (response.getResponseData() instanceof EONotificationPacket);
            EONotificationPacket notificationPacket = (EONotificationPacket)response.getResponseData();
            long notificationPacketSerial = notificationPacket.getNotificationPacketSerial();
            List notifications = notificationPacket.getNotifications();
            String serverID = connectionData.serverConnection.getServerID();
            if (notifications.size() > 0 && logger.isDebugEnabled()) {
                logger.debug("handleNotifications() - Received Notification Packet #" + notificationPacketSerial + " from server " + serverID + " containing " + notifications.size() + " Notification(s).");
            }
            if (notificationPacketSerial != connectionData.lastNotificationPacketSerial + 1L) {
                logger.error("handleNotifications() - Error: Notification Packets do not arrive or do not arrive in proper Sequence. Received Notification Packet #" + notificationPacketSerial + " from server " + serverID + " containing " + notifications.size() + " Notification(s). " + "The expected Notification Packet number was #" + (connectionData.lastNotificationPacketSerial + 1L) + ".");
                assert (false);
            }
            connectionData.lastNotificationPacketSerial = notificationPacketSerial;
            connectionData.undeliveredNotifications.addAll(notifications);
        }
    }

    private EOServerResponse throwExceptionsOrReturnResponse(RFConnectionRelatedData connectionData, IRequestJob requestJob) throws ServerNotAvailableException, EXServerException {
        EOServerResponse response = null;
        try {
            response = requestJob.getServerResponse();
        }
        catch (Exception e) {
            ServerNotAvailableException translatedException = connectionData.serverConnection.translateTransmissionException(requestJob.getRequest(), e, connectionData.connected);
            this.disconnect(connectionData);
            throw translatedException;
        }
        if (response != null && response.isExceptionMsg()) {
            this.exceptionDecoder.throwServerException(response.getException());
        }
        return response;
    }

    protected void subscribeForPermissionChangeNotifications(ServerConnection serverConnection) {
        PermissionChangeListener listener = new PermissionChangeListener(serverConnection);
        this.permissionChangeListeners.put(serverConnection.getServerID(), listener);
    }

    public void disconnect(String serverID) {
        RFConnectionRelatedData connectionData = RFConnectionRelatedData.getConnectionData(serverID);
        if (connectionData != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("disconnect() - Disconnetced from server " + RequestForwarder.calculateServerIdentificationForLogMessage(connectionData.serverConnection));
            }
            this.disconnect(connectionData);
        }
    }

    public void disconnectAll() {
        Iterator<RFConnectionRelatedData> iterator = RFConnectionRelatedData.connectionDataMap_Connection.values().iterator();
        while (iterator.hasNext()) {
            RFConnectionRelatedData element;
            RFConnectionRelatedData connectionData = element = iterator.next();
            this.disconnect(connectionData);
        }
    }

    private void disconnect(RFConnectionRelatedData connectionData) {
        final ServerConnection serverConnection = connectionData.serverConnection;
        boolean waitForDisconnectResponse = false;
        if (connectionData.connected) {
            this.markServerConnectionToBeInDisconnectedState(connectionData);
            IRequestJobCharger<IRequestJob> disconnectJobCharger = new IRequestJobCharger<IRequestJob>(){

                @Override
                public IRequestJob chargeRequest() {
                    return serverConnection.chargeDisconnectRequest();
                }
            };
            if (waitForDisconnectResponse) {
                try {
                    this.awaitResponse(connectionData, disconnectJobCharger);
                }
                catch (EXServerException e) {
                    logger.error("disconnect() - Disconnect from server " + RequestForwarder.calculateServerIdentificationForLogMessage(serverConnection) + " failed", (Throwable)e);
                }
                catch (ServerNotAvailableException e) {
                    logger.error("disconnect() - Disconnect from server " + RequestForwarder.calculateServerIdentificationForLogMessage(serverConnection) + ": Server not available.", (Throwable)e);
                }
            } else {
                ((IRequestJob)disconnectJobCharger.chargeRequest()).waitUntilRequestIsProcessed(500L);
            }
        }
    }

    public void addServerConnection(EOServer server) {
        RFConnectionRelatedData connectionData = RFConnectionRelatedData.getConnectionData(server.getServerID());
        if (connectionData == null) {
            HttpServerConnection sc = new HttpServerConnection(server, this.messageFactory, this);
            RFConnectionRelatedData.addServerConnection(this, sc);
            this.informListenersAboutServerAddition(RFConnectionRelatedData.getConnectionData(sc));
        } else {
            logger.warn("Attempt to modify existing connection while adding a new one was requested", (Throwable)new Exception());
            this.modifyServerConnection(server);
        }
    }

    public void modifyServerConnection(EOServer server) {
        RFConnectionRelatedData connectionData = RFConnectionRelatedData.getConnectionData(server.getServerID());
        if (connectionData != null) {
            if (!connectionData.serverConnection.getURL().equals(server.getServerURL())) {
                if (connectionData.connected) {
                    this.disconnect(connectionData);
                }
                connectionData.serverConnection.setURL(server.getServerURL());
            }
            connectionData.serverConnection.setServerName(server.getServerName());
            connectionData.serverConnection.setTimerInterval(server.getTimerInterval());
            this.informListenersAboutServerModification(connectionData);
        }
    }

    public boolean removeServerConnection(EOServer server) {
        RFConnectionRelatedData connectionData = RFConnectionRelatedData.getConnectionData(server.getServerID());
        assert (connectionData != null) : "trying to remove non existing server connection";
        if (this.informListenersAboutComingServerDeletion(connectionData)) {
            if (connectionData.connected) {
                this.disconnect(connectionData);
            }
            RFConnectionRelatedData.removeServerConnection(connectionData.serverConnection);
            this.informListenersAboutServerDeletion(connectionData);
            connectionData.serverConnection.shutdownAndFreeResources();
            return true;
        }
        return false;
    }

    public List<ServerConnection> getServerConnections() {
        ArrayList<ServerConnection> connectionList = new ArrayList<ServerConnection>();
        if (!this.serverConnectionsAlreadyLoaded) {
            this.loadServerConnections();
            this.serverConnectionsAlreadyLoaded = true;
        }
        connectionList.addAll(RFConnectionRelatedData.connectionDataMap_Connection.keySet());
        return connectionList;
    }

    private void loadServerConnections() {
        RFConnectionRelatedData.clearConnectionsData();
        ArrayList servers = this.serverList.getArrayList();
        for (EOServer server : servers) {
            this.addServerConnection(server);
        }
    }

    public List<ServerConnection> getOpenServerConnections() {
        ArrayList<ServerConnection> openConnections = new ArrayList<ServerConnection>();
        for (RFConnectionRelatedData element : RFConnectionRelatedData.connectionDataMap_Connection.values()) {
            RFConnectionRelatedData connectionData = element;
            if (!connectionData.connected) continue;
            openConnections.add(connectionData.serverConnection);
        }
        return openConnections;
    }

    public String getServerName(String serverID) {
        ArrayList servers = this.serverList.getArrayList();
        int i = 0;
        while (i < servers.size()) {
            EOServer server = (EOServer)servers.get(i);
            if (server.getServerID().equals(serverID)) {
                return server.getServerName();
            }
            ++i;
        }
        return null;
    }

    public ServerConnection getServerConnection(String serverID) {
        return RFConnectionRelatedData.getServerConnection(serverID);
    }

    public EOUserAndGroupAndPermissions getUserData(String clusterID) {
        return RFConnectionRelatedData.getServerConnection(clusterID).getUserData();
    }

    public EOUserAndGroupAndPermissions getUserData(String serverID, boolean forceLogin) throws ServerNotAvailableException, EXServerException, LoginCanceledException {
        RFConnectionRelatedData connectionData = RFConnectionRelatedData.getConnectionData(serverID);
        if (!connectionData.connected && forceLogin) {
            this.handleLogin(connectionData);
        }
        return RFConnectionRelatedData.getServerConnection(serverID).getUserData();
    }

    public EOServerInfo getServerInfo(String clusterID) {
        ServerConnection connection = RFConnectionRelatedData.getServerConnection(clusterID);
        assert (connection != null);
        assert (connection.isConnected());
        return connection.getServerInfo();
    }

    public void parametersChanged() {
        this.setupSSL();
    }

    public boolean isConnected(ServerConnection serverConnection) {
        RFConnectionRelatedData connectionData = RFConnectionRelatedData.getConnectionData(serverConnection);
        if (connectionData != null) {
            return connectionData.connected;
        }
        return false;
    }

    public void addServerStatusChangedListener(IServerStatusChangedListener listener) {
        this.serverStatusListeners.add(listener);
    }

    public void removeServerStatusChangedListener(IServerStatusChangedListener listener) {
        this.serverStatusListeners.remove(listener);
    }

    private void informListenersAboutServerAddition(RFConnectionRelatedData connectionData) {
        this.informServerStatusListeners(connectionData.serverConnection, this.serverAdditionInformer);
    }

    private void informListenersAboutServerModification(RFConnectionRelatedData connectionData) {
        this.informServerStatusListeners(connectionData.serverConnection, this.serverModificationInformer);
    }

    private boolean informListenersAboutComingServerDeletion(RFConnectionRelatedData connectionData) {
        boolean aborted = this.informServerStatusListeners(connectionData.serverConnection, this.serverAboutToDeleteInformer);
        return !aborted;
    }

    private void informListenersAboutServerDeletion(RFConnectionRelatedData connectionData) {
        this.informServerStatusListeners(connectionData.serverConnection, this.serverDeletedInformer);
    }

    private void informListenersAboutLogin(RFConnectionRelatedData connectionData) {
        this.informServerStatusListeners(connectionData.serverConnection, this.serverLoginInformer);
    }

    private void informListenersAboutLogoff(RFConnectionRelatedData connectionData) {
        this.informServerStatusListeners(connectionData.serverConnection, this.serverLogoffInformer);
    }

    private boolean informServerStatusListeners(ServerConnection connection, IServerStatusListenerInformer informer) {
        int lastindex = -1;
        HashSet<IServerStatusChangedListener> informedListeners = new HashSet<IServerStatusChangedListener>(this.serverStatusListeners.size() * 2);
        boolean prematureAbort = false;
        while (!prematureAbort) {
            IServerStatusChangedListener listener;
            IServerStatusChangedListener nextListenerToBeInformed = null;
            int serverStatusListenersSize = this.serverStatusListeners.size();
            if (lastindex + 1 < serverStatusListenersSize && !informedListeners.contains(listener = this.serverStatusListeners.get(lastindex + 1))) {
                nextListenerToBeInformed = listener;
                ++lastindex;
            }
            if (nextListenerToBeInformed == null) {
                int i = 0;
                while (i < serverStatusListenersSize) {
                    IServerStatusChangedListener listener2 = this.serverStatusListeners.get(i);
                    if (!informedListeners.contains(listener2)) {
                        nextListenerToBeInformed = listener2;
                        lastindex = i;
                        break;
                    }
                    ++i;
                }
            }
            if (nextListenerToBeInformed == null) break;
            informedListeners.add(nextListenerToBeInformed);
            boolean bl = prematureAbort = prematureAbort || informer.informListener(connection, nextListenerToBeInformed);
        }
        return prematureAbort;
    }

    private static String calculateServerIdentificationForLogMessage(ServerConnection serverConnection) {
        return String.valueOf(serverConnection.getServerName()) + " (ServerID=" + serverConnection.getServerID() + ")";
    }

    public void uploadFiles(String serverID, final List<String> transferIDs, final List<File> files) throws UnknownServerException, ExPrematureEndOfTransfer, ServerNotAvailableException, EXServerException, LoginCanceledException {
        final RFConnectionRelatedData connectionData = RFConnectionRelatedData.getConnectionData(serverID);
        if (connectionData == null) {
            throw new UnknownServerException(serverID);
        }
        if (!connectionData.connected) {
            StringBuilder sb = new StringBuilder();
            sb.append(serverID);
            sb.append(" - ");
            for (String transferID : transferIDs) {
                sb.append(transferID);
                sb.append(' ');
            }
            throw new ServerNotAvailableException(connectionData.serverConnection.getServerID(), new EOClientRequest("fileTransfer", "uploadFiles", (EncodableObjectBase)new EOString(sb.toString().trim())));
        }
        IRequestJobCharger<IDataTransferRequestJob> requestJobCharger = new IRequestJobCharger<IDataTransferRequestJob>(){

            @Override
            public IDataTransferRequestJob chargeRequest() {
                return ((HttpServerConnection)connectionData.serverConnection).chargeFileUploadRequest(transferIDs, files);
            }
        };
        this.awaitTransferResponse(connectionData, requestJobCharger);
    }

    public void downloadFiles(String serverID, final List<String> transferIDs, final List<File> files) throws UnknownServerException, ExPrematureEndOfTransfer, ServerNotAvailableException, EXServerException, LoginCanceledException {
        final RFConnectionRelatedData connectionData = RFConnectionRelatedData.getConnectionData(serverID);
        if (connectionData == null) {
            throw new UnknownServerException(serverID);
        }
        if (!connectionData.connected) {
            StringBuilder sb = new StringBuilder();
            sb.append(serverID);
            sb.append(" - ");
            for (String transferID : transferIDs) {
                sb.append(transferID);
                sb.append(' ');
            }
            throw new ServerNotAvailableException(connectionData.serverConnection.getServerID(), new EOClientRequest("fileTransfer", "downloadFiles", (EncodableObjectBase)new EOString(sb.toString().trim())));
        }
        IRequestJobCharger<IDataTransferRequestJob> requestJobCharger = new IRequestJobCharger<IDataTransferRequestJob>(){

            @Override
            public IDataTransferRequestJob chargeRequest() {
                return ((HttpServerConnection)connectionData.serverConnection).chargeFileDownloadRequest(transferIDs, files);
            }
        };
        this.awaitTransferResponse(connectionData, requestJobCharger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized void awaitTransferResponse(RFConnectionRelatedData connectionData, IRequestJobCharger<IDataTransferRequestJob> requestJobCharger) throws ServerNotAvailableException, ExPrematureEndOfTransfer {
        assert (requestJobCharger != null) : "RequestJobCharger is missing";
        Class<NotificationDlvrySyncData> clazz = NotificationDlvrySyncData.class;
        synchronized (NotificationDlvrySyncData.class) {
            if (NotificationDlvrySyncData.notificationDeliveryEnabledCounter != 0L) {
                logger.error("Sending requests while notification delivery is disabled. Re-enabling notification delivery.", (Throwable)new Exception());
                NotificationDlvrySyncData.notificationDeliveryEnabledCounter = 0L;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            ServerConnection serverConnection = connectionData.serverConnection;
            this.notificationDeliveryAgent.cancelNotificationDelivery();
            Object object = NotificationDlvrySyncData.class;
            synchronized (NotificationDlvrySyncData.class) {
                if (NotificationDlvrySyncData.notificationEventInProcessOfBeingPosted != 0) {
                    logger.error("A Request was issued during Notification delivery. ", (Throwable)new Exception());
                }
                if (NotificationDlvrySyncData.processingOfRequestIsInProgress != 0) {
                    logger.error("A further Request was issued while another Request was being processed (new request depth=" + (NotificationDlvrySyncData.processingOfRequestIsInProgress + 1) + ").", (Throwable)new Exception());
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
                object = NotificationDlvrySyncData.requestProcessingMutex;
                synchronized (object) {
                    NotificationDeliveryAgent notificationDeliveryAgent = this.notificationDeliveryAgent;
                    synchronized (notificationDeliveryAgent) {
                        Class<NotificationDlvrySyncData> clazz2 = NotificationDlvrySyncData.class;
                        synchronized (NotificationDlvrySyncData.class) {
                            ++NotificationDlvrySyncData.processingOfRequestIsInProgress;
                            this.notificationDeliveryAgent.cancelNotificationDelivery();
                            // ** MonitorExit[var6_6] (shouldn't be in output)
                        }
                    }
                    {
                        IDataTransferRequestJob job = null;
                        try {
                            try {
                                job = requestJobCharger.chargeRequest();
                                this.requestJobProgressMonitor.run(job, serverConnection.getServerName());
                                job.waitUntilRequestIsProcessed(0L);
                                IDataTransferRequestJob.TransferState transferResult = job.getTransferResult();
                                if (IDataTransferRequestJob.TransferState.TRANSFER_COMPLETED_SUCCESSFULLY != transferResult) {
                                    throw new ExPrematureEndOfTransfer(job.getErrorCause());
                                }
                            }
                            catch (ExPrematureEndOfTransfer e) {
                                this.disconnect(connectionData);
                                throw e;
                            }
                            catch (RequestJobProgressMonitor.ExJobCancelledByUser e) {
                                this.disconnect(connectionData);
                                throw new ServerNotAvailableException(connectionData.serverConnection.getServerID(), null);
                            }
                        }
                        catch (Throwable throwable) {
                            Class<NotificationDlvrySyncData> clazz3 = NotificationDlvrySyncData.class;
                            synchronized (NotificationDlvrySyncData.class) {
                                --NotificationDlvrySyncData.processingOfRequestIsInProgress;
                                // ** MonitorExit[var8_10] (shouldn't be in output)
                                this.triggerNotificationDelivery();
                                throw throwable;
                            }
                        }
                        Class<NotificationDlvrySyncData> clazz4 = NotificationDlvrySyncData.class;
                        synchronized (NotificationDlvrySyncData.class) {
                            --NotificationDlvrySyncData.processingOfRequestIsInProgress;
                            // ** MonitorExit[var8_11] (shouldn't be in output)
                            this.triggerNotificationDelivery();
                            return;
                        }
                    }
                }
            }
        }
    }

    private static interface IRequestJobCharger<JobType> {
        public JobType chargeRequest();
    }

    private static interface IServerStatusListenerInformer {
        public boolean informListener(ServerConnection var1, IServerStatusChangedListener var2);
    }

    private class NotificationDeliveryAgent
    implements Runnable {
        private boolean isQueuedInEventLoop = false;
        private boolean isCanceled = false;
        private Thread notificationDeliveryThread = null;

        private NotificationDeliveryAgent() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void queueNotificationDelivery() {
            boolean newEnqueueNeeded = false;
            NotificationDeliveryAgent notificationDeliveryAgent = this;
            synchronized (notificationDeliveryAgent) {
                this.isCanceled = false;
                if (!this.isQueuedInEventLoop) {
                    newEnqueueNeeded = true;
                    this.isQueuedInEventLoop = true;
                }
            }
            if (newEnqueueNeeded) {
                RequestForwarder.this.asyncUIOperationExecuter.asyncExecUIOperation(this);
            }
        }

        public synchronized void cancelNotificationDelivery() {
            this.isCanceled = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void deliverAsynchronousUpdatesNow(String serverID) {
            if (!this.maybeNotificationDeliveryThread(Thread.currentThread())) {
                RequestForwarder.access$1().error("calling deliverAsynchronousUpdatesNow() from other threads than the UI/NotificationDeliveryThread is illegal.", (Throwable)new Exception());
            }
            while (true) {
                causeForNotificationDeliveryAbort = null;
                try {
                    block12: {
                        workPackage = null;
                        var4_5 = this;
                        // MONITORENTER : var4_5
                        workPackage = this.pickWorkAndDoInitalSynchronizedProcessing(serverID);
                        if (workPackage != null) break block12;
                        // MONITOREXIT : var4_5
                        return;
                        {
                            catch (Throwable v0) {
                                // MONITOREXIT : var4_5
                                throw v0;
                            }
                        }
                    }
                    // MONITOREXIT : var4_5
                    workPackage.doUnsynchronizedWorkPostprocessing();
                    continue;
                }
                catch (Throwable t) {
                    cause = causeForNotificationDeliveryAbort = t;
                    causeForNotificationDeliveryAbort = null;
                    if (cause == null) continue;
                    RequestForwarder.access$1().error("An unexpected Exception was thrown during synchronous delivery of Notifications.", cause);
                    if (!(cause instanceof Error)) continue;
                    error = (Error)cause;
                    throw error;
                }
                finally {
                    cause = causeForNotificationDeliveryAbort;
                    causeForNotificationDeliveryAbort = null;
                    if (cause == null) continue;
                    RequestForwarder.access$1().error("An unexpected Exception was thrown during synchronous delivery of Notifications.", cause);
                    if (cause instanceof Error) ** break;
                    continue;
                    error = (Error)cause;
                    throw error;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private WorkPackage pickWorkAndDoInitalSynchronizedProcessing(String serverID) {
            WorkPackage workPackage = null;
            Class<NotificationDlvrySyncData> clazz = NotificationDlvrySyncData.class;
            synchronized (NotificationDlvrySyncData.class) {
                Object object = NotificationDlvrySyncData.notificationStoreAccessMutex;
                synchronized (object) {
                    Iterator<RFConnectionRelatedData> i = RFConnectionRelatedData.connectionDataMap_Connection.values().iterator();
                    while (i.hasNext() && workPackage == null) {
                        RFConnectionRelatedData connectionData = i.next();
                        if (serverID != null && !serverID.equals(connectionData.serverConnection.getServerID())) continue;
                        IRequestJob pickedRequestJob = null;
                        if (connectionData.connected && !connectionData.unprocessedUpdateEnquiryRequestJobs.isEmpty()) {
                            pickedRequestJob = connectionData.unprocessedUpdateEnquiryRequestJobs.removeFirst();
                        }
                        if (pickedRequestJob != null) {
                            Exception catchedRequestJobResponseException = null;
                            try {
                                RequestForwarder.this.extractNotificationsAndThrowExceptions(connectionData, pickedRequestJob);
                            }
                            catch (Exception e) {
                                catchedRequestJobResponseException = e;
                            }
                            final RFConnectionRelatedData fConnectionDataOfPickedRequestJob = connectionData;
                            final Exception fCatchedRequestJobResponseException = catchedRequestJobResponseException;
                            workPackage = new WorkPackage(this){

                                @Override
                                public void doUnsynchronizedWorkPostprocessing() {
                                    if (fCatchedRequestJobResponseException != null) {
                                        PSCClientServiceFacade.getFacade().showException(fCatchedRequestJobResponseException, fConnectionDataOfPickedRequestJob.serverConnection.getServerID());
                                        RequestForwarder.this.markServerConnectionToBeInDisconnectedState(fConnectionDataOfPickedRequestJob);
                                    }
                                }
                            };
                        }
                        if (workPackage == null && connectionData.connected && connectionData.undeliveredNotifications.isEmpty() && connectionData.fetchedNotificationsExhaustedPending) {
                            connectionData.fetchedNotificationsExhaustedPending = false;
                            final String fFetchedNotificationsExhaustedServerID = connectionData.serverConnection.getServerID();
                            workPackage = new WorkPackage(this){

                                @Override
                                public void doUnsynchronizedWorkPostprocessing() {
                                    PSCClientNotificationBus clientNotificationBus = PSCClientServiceFacade.getFacade().getNotificationBus();
                                    clientNotificationBus.postFetchedNotificationsExhausted(fFetchedNotificationsExhaustedServerID);
                                }
                            };
                        }
                        if (workPackage != null || !connectionData.connected || connectionData.undeliveredNotifications.isEmpty()) continue;
                        EONotification pickedServerNotification = connectionData.undeliveredNotifications.removeFirst();
                        connectionData.fetchedNotificationsExhaustedPending = true;
                        final Notification fPickedClientNotification = pickedServerNotification.convertIntoNotification(connectionData.serverConnection.getServerID());
                        workPackage = new WorkPackage(this){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void doUnsynchronizedWorkPostprocessing() {
                                try {
                                    Class<NotificationDlvrySyncData> clazz = NotificationDlvrySyncData.class;
                                    synchronized (NotificationDlvrySyncData.class) {
                                        if (NotificationDlvrySyncData.notificationEventInProcessOfBeingPosted != 0) {
                                            logger.error("Concurrent Delivery of Notifications in progress. (Threadname=" + Thread.currentThread().getName() + ") " + "(Concurrency-level=" + NotificationDlvrySyncData.notificationEventInProcessOfBeingPosted + ")\n", (Throwable)new Exception());
                                        }
                                        ++NotificationDlvrySyncData.notificationEventInProcessOfBeingPosted;
                                        // ** MonitorExit[var1_1] (shouldn't be in output)
                                        PSCClientServiceFacade.getFacade().getNotificationBus().postNotification(fPickedClientNotification);
                                    }
                                }
                                catch (Throwable throwable) {
                                    Class<NotificationDlvrySyncData> clazz = NotificationDlvrySyncData.class;
                                    synchronized (NotificationDlvrySyncData.class) {
                                        --NotificationDlvrySyncData.notificationEventInProcessOfBeingPosted;
                                        // ** MonitorExit[var3_3] (shouldn't be in output)
                                        throw throwable;
                                    }
                                }
                                {
                                    Class<NotificationDlvrySyncData> clazz = NotificationDlvrySyncData.class;
                                    synchronized (NotificationDlvrySyncData.class) {
                                        --NotificationDlvrySyncData.notificationEventInProcessOfBeingPosted;
                                        // ** MonitorExit[var3_4] (shouldn't be in output)
                                        return;
                                    }
                                }
                            }
                        };
                    }
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return workPackage;
            }
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private void rememberNotificationDeliveryThread(Thread thread) {
            if (this.notificationDeliveryThread != null && this.notificationDeliveryThread != thread) {
                logger.error("NotificationDeliveryAgent - UI Thread has changed.");
            }
            this.notificationDeliveryThread = thread;
        }

        public boolean maybeNotificationDeliveryThread(Thread thread) {
            return this.notificationDeliveryThread == null || this.notificationDeliveryThread == thread;
        }

        private abstract class WorkPackage {
            private WorkPackage() {
            }

            public abstract void doUnsynchronizedWorkPostprocessing();
        }
    }

    private static class NotificationDlvrySyncData {
        public static Object notificationStoreAccessMutex = new Object();
        public static final int NotificationEventInProcessOfBeingPostedFloor = 0;
        public static int notificationEventInProcessOfBeingPosted = 0;
        public static final int ProcessingOfRequestIsInProgressFloor = 0;
        public static int processingOfRequestIsInProgress = 0;
        public static Object requestProcessingMutex = new Object();
        private static final long DELIVERY_COUNTER_FLOOR_VALUE = 0L;
        private static long notificationDeliveryEnabledCounter = 0L;

        private NotificationDlvrySyncData() {
        }
    }

    private static class RFConnectionRelatedData {
        public static HashMap<ServerConnection, RFConnectionRelatedData> connectionDataMap_Connection = new HashMap();
        public static HashMap<String, RFConnectionRelatedData> connectionDataMap_ConnectionID = new HashMap();
        private boolean connected = false;
        private boolean preventLogin = false;
        public ServerConnection serverConnection;
        public ClientCompatibilityOfficer clientCompatibilityOfficer;
        public LinkedList<IRequestJob> unprocessedUpdateEnquiryRequestJobs;
        public LinkedList<EONotification> undeliveredNotifications;
        public long lastNotificationPacketSerial;
        public boolean fetchedNotificationsExhaustedPending = false;

        public static void clearConnectionsData() {
            connectionDataMap_Connection = new HashMap();
            connectionDataMap_ConnectionID = new HashMap();
        }

        public static void addServerConnection(RequestForwarder requestForwarder, ServerConnection serverConnection) {
            RFConnectionRelatedData connData = new RFConnectionRelatedData(requestForwarder, serverConnection);
            connectionDataMap_Connection.put(serverConnection, connData);
            connectionDataMap_ConnectionID.put(serverConnection.getServerID(), connData);
        }

        public static void removeServerConnection(ServerConnection serverConnection) {
            connectionDataMap_Connection.remove(serverConnection);
            connectionDataMap_ConnectionID.remove(serverConnection.getServerID());
        }

        public static ServerConnection getServerConnection(String serverID) {
            RFConnectionRelatedData connData = connectionDataMap_ConnectionID.get(serverID);
            if (connData != null) {
                return connData.serverConnection;
            }
            return null;
        }

        public static RFConnectionRelatedData getConnectionData(String serverID) {
            return connectionDataMap_ConnectionID.get(serverID);
        }

        public static RFConnectionRelatedData getConnectionData(ServerConnection serverConnection) {
            return connectionDataMap_Connection.get(serverConnection);
        }

        private RFConnectionRelatedData(RequestForwarder requestForwarder, ServerConnection serverConnection) {
            this.serverConnection = serverConnection;
            this.clientCompatibilityOfficer = new ClientCompatibilityOfficer(requestForwarder, serverConnection);
            this.unprocessedUpdateEnquiryRequestJobs = new LinkedList();
            this.undeliveredNotifications = new LinkedList();
            this.lastNotificationPacketSerial = 0L;
            this.fetchedNotificationsExhaustedPending = false;
        }
    }
}

