/*
 * Decompiled with CFR 0.152.
 */
package de.plans.psc.client;

import de.plans.psc.client.PSCClientServiceFacade;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.shared.message.EOPermission;
import de.plans.psc.shared.message.EOUser;
import de.plans.psc.shared.serverexceptions.EXServerException;
import java.util.Collection;

public class ServerOperationsPermissionChecker {
    public static boolean isAdminUser(String serverID) {
        try {
            return ServerOperationsPermissionChecker.isAdminUser(serverID, false);
        }
        catch (EXServerException e) {
            PSCClientServiceFacade.getFacade().showException((Exception)((Object)e), serverID);
            return false;
        }
        catch (ServerNotAvailableException e) {
            return false;
        }
        catch (LoginCanceledException e) {
            return false;
        }
    }

    public static boolean isAdminUser(String serverID, boolean forceLogin) throws ServerNotAvailableException, EXServerException, LoginCanceledException {
        return PSCClientServiceFacade.getFacade().isAdminUser(serverID, forceLogin);
    }

    public static boolean isAdminUser(Collection permissionsOfCurrentUser) {
        boolean granted = false;
        for (EOPermission permission : permissionsOfCurrentUser) {
            if (!permission.getSubSetType().equals("SERVER") || !permission.getSubSetUID().equals("SERVER") || !permission.getOperation().equals("adminServer")) continue;
            granted = true;
            break;
        }
        return granted;
    }

    public static boolean isUserAdministrator(EOUser user) {
        return user.getUserName().equals("Administrator");
    }

    public static boolean isOperator(Collection permissionsOfCurrentUser) {
        boolean granted = false;
        for (EOPermission permission : permissionsOfCurrentUser) {
            if (!permission.getSubSetType().equals("SERVER") || !permission.getSubSetUID().equals("SERVER") || !permission.getOperation().equals("serverOperator")) continue;
            granted = true;
            break;
        }
        return granted;
    }
}

