/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.xml.parameter;

import com.arcway.lib.codec.EXDecoderException;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import de.plans.lib.xml.encoding.XMLContext;
import de.plans.lib.xml.encoding.XMLDecoder;
import de.plans.lib.xml.parameter.EOParameterSet;
import de.plans.lib.xml.parameter.EOParameterSetRoot;
import de.plans.lib.xml.parameter.XMLParameterChangeListenerIF;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class XMLConfigParameterMgr
implements IEncodableObjectFactory {
    private final Map factories = new HashMap();
    private final List subtreeRootElements = new ArrayList();
    private EOParameterSetRoot rootElement;
    private final List listeners = new ArrayList();
    private static XMLDecoder decoder = new XMLDecoder();
    private File parameterFile;

    public void setParameterFile(File f) {
        this.parameterFile = f;
    }

    public boolean registerEncodableObjectFactory(String elementName, IEncodableObjectFactory factory) {
        if (this.factories.containsKey(elementName)) {
            return false;
        }
        this.factories.put(elementName, factory);
        return true;
    }

    public void addSubtreeRootElement(EOParameterSet subTreeRootElement) {
        if (!this.subtreeRootElements.contains(subTreeRootElement)) {
            this.subtreeRootElements.add(subTreeRootElement);
        }
    }

    public EOParameterSet getSubtree(String rootElementName) {
        int i = 0;
        while (i < this.subtreeRootElements.size()) {
            EOParameterSet eo = (EOParameterSet)this.subtreeRootElements.get(i);
            if (eo.getTag().equals(rootElementName)) {
                return eo;
            }
            ++i;
        }
        return null;
    }

    public void setRootElement(EOParameterSetRoot rootElement) {
        this.rootElement = rootElement;
    }

    public EOParameterSetRoot getRootElement() {
        return this.rootElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readParameters() throws FileNotFoundException, EXDecoderException {
        BufferedInputStream b_in = null;
        b_in = new BufferedInputStream(new FileInputStream(this.parameterFile));
        XMLDecoder xMLDecoder = decoder;
        synchronized (xMLDecoder) {
            decoder.decodeXML(b_in, (IEncodableObjectFactory)this, true);
        }
    }

    public void commitParameters() throws IOException {
        this.writeParameters();
        this.parametersChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeParameters() throws IOException {
        Object pset;
        this.rootElement.detachChildNodes();
        int i = 0;
        while (i < this.subtreeRootElements.size()) {
            pset = (EOParameterSet)this.subtreeRootElements.get(i);
            this.rootElement.addChild((EncodableObjectBase)pset);
            ++i;
        }
        try (BufferedOutputStream b_out = new BufferedOutputStream(new FileOutputStream(this.parameterFile));){
            try {
                pset = this;
                synchronized (pset) {
                    this.rootElement.writeToXMLStream(b_out, false);
                }
            }
            catch (EXEncoderException e) {
                throw e.toNewIOException("Unable to write Parameters to file " + this.parameterFile);
            }
        }
    }

    private void parametersChanged() {
        int i = 0;
        while (i < this.listeners.size()) {
            ((XMLParameterChangeListenerIF)this.listeners.get(i)).parametersChanged();
            ++i;
        }
    }

    public void addParameterChangedListener(XMLParameterChangeListenerIF listener) {
        this.listeners.add(listener);
    }

    public void removeParameterChangedListener(XMLParameterChangeListenerIF listener) {
        this.listeners.remove(listener);
    }

    @Override
    public EncodableObjectBase createEncodableObject(String elementName, XMLContext context) throws EXDecoderException {
        if (this.factories.containsKey(elementName)) {
            IEncodableObjectFactory factory = (IEncodableObjectFactory)this.factories.get(elementName);
            return factory.createEncodableObject(elementName, context);
        }
        return null;
    }
}

