/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.util.gui;

import de.plans.lib.util.gui.IProgressDisplay;
import de.plans.lib.util.gui.IRunnableWithProgressDisplay;

public class MultiStepProcessor
implements IProgressDisplay {
    private static final int WORK_UNQUANTIFIED = -1;
    private final ISubTask[] subTasks;
    private final int[] weights;
    private final int lastSubTaskThatCanBeReverted;
    private final int totalWeight;
    private final IProgressDisplay targetDisplay;
    private final String taskName;
    private boolean progessDisplayInitialized = false;
    private boolean processMayBeCanceled;
    private int currentSubTaskIndex = -1;
    private String currentSubTaskName = null;
    private int currentSubTaskTotalWork;
    private int currentSubTaskWorkDone;
    private String currentSubTaskWhatsNext;
    private boolean cancleingReported = false;

    public static boolean process(String taskName, ISubTask[] subTasks, IProgressDisplay targetDisplay) throws Exception {
        MultiStepProcessor processor = new MultiStepProcessor(taskName, subTasks, targetDisplay);
        while (subTasks.length > 0 && processor.hasNext()) {
            ISubTask currentSubTask = processor.getCurrentTask();
            currentSubTask.process(processor);
            processor.gotoNextTask();
        }
        return !processor.isTaskToCancel();
    }

    private MultiStepProcessor(String taskName, ISubTask[] subTasks, IProgressDisplay targetDisplay) {
        this.subTasks = subTasks;
        this.targetDisplay = targetDisplay;
        this.taskName = taskName;
        int numberOfSteps = subTasks.length;
        int totalWeight = 0;
        this.weights = new int[numberOfSteps];
        int lastSubTaskThatCanBeCanceled = numberOfSteps;
        int i = numberOfSteps - 1;
        while (i >= 0) {
            int weight = subTasks[i].getWeight() * 1000;
            assert (weight > 0);
            this.weights[i] = weight;
            totalWeight += weight;
            if (subTasks[i].getSubTaskReverter() == null) {
                lastSubTaskThatCanBeCanceled = i - 1;
            }
            --i;
        }
        this.totalWeight = totalWeight;
        this.lastSubTaskThatCanBeReverted = lastSubTaskThatCanBeCanceled;
    }

    private boolean hasNext() {
        return this.currentSubTaskIndex < this.subTasks.length && !this.isTaskToCancel();
    }

    private ISubTask getCurrentTask() {
        if (this.currentSubTaskIndex < 0) {
            this.currentSubTaskIndex = 0;
        }
        this.currentSubTaskName = null;
        this.currentSubTaskTotalWork = 0;
        this.currentSubTaskWorkDone = 0;
        this.currentSubTaskWhatsNext = null;
        this.updateProgress();
        return this.subTasks[this.currentSubTaskIndex];
    }

    private void gotoNextTask() {
        if (!this.cancleingReported) {
            ++this.currentSubTaskIndex;
            this.currentSubTaskName = null;
            this.currentSubTaskTotalWork = 0;
            this.currentSubTaskWorkDone = 0;
            this.currentSubTaskWhatsNext = null;
            this.updateProgress();
            if (this.currentSubTaskIndex >= this.subTasks.length && this.progessDisplayInitialized) {
                this.targetDisplay.endTask();
                this.progessDisplayInitialized = false;
            }
        } else {
            int i = this.currentSubTaskIndex - 1;
            while (i >= 0) {
                ISubTask subTask = this.subTasks[i];
                ISubTaskReverter reverter = subTask.getSubTaskReverter();
                assert (reverter != null);
                reverter.revert();
                --i;
            }
        }
    }

    @Override
    public void beginQuantifiedTask(String taskName, int workTotal, boolean mayBeCanceled) {
        this.beginSubTask(taskName, workTotal, mayBeCanceled);
    }

    @Override
    public void beginUnquantifiedTask(String taskName, boolean mayBeCanceled) {
        this.beginSubTask(taskName, -1, mayBeCanceled);
    }

    @Override
    public void endTask() {
        this.endSubTask();
    }

    @Override
    public boolean isTaskToCancel() {
        int lastSubTaskDone;
        boolean isTaskToCancel = this.cancleingReported;
        if (!isTaskToCancel && this.currentSubTaskIndex >= 0 && this.processMayBeCanceled && ((lastSubTaskDone = this.currentSubTaskIndex - 1) < 0 || lastSubTaskDone <= this.lastSubTaskThatCanBeReverted)) {
            isTaskToCancel = this.targetDisplay.isTaskToCancel();
        }
        return isTaskToCancel;
    }

    @Override
    public void reportCancelingInProgress() {
        this.targetDisplay.reportCancelingInProgress();
        this.cancleingReported = true;
    }

    @Override
    public void reportQuantifiedProgress(int workSinceBeginning, String whatsNext) {
        this.currentSubTaskWhatsNext = whatsNext;
        this.currentSubTaskWorkDone = workSinceBeginning;
        this.updateProgress();
    }

    @Override
    public void reportQuantifiedProgress(int workSinceBeginning) {
        this.currentSubTaskWorkDone = workSinceBeginning;
        this.updateProgress();
    }

    @Override
    public void reportUnquantifiedProgress(String whatsNext) {
        this.currentSubTaskWhatsNext = whatsNext;
        this.updateProgress();
    }

    private void beginSubTask(String subTaskName, int subTaskWorkTotal, boolean subTaskMayBeCanceled) {
        if (!this.progessDisplayInitialized) {
            this.processMayBeCanceled = subTaskMayBeCanceled || this.lastSubTaskThatCanBeReverted >= 0;
            this.targetDisplay.beginQuantifiedTask(this.taskName, this.totalWeight, this.processMayBeCanceled);
            this.progessDisplayInitialized = true;
        }
        this.currentSubTaskName = subTaskName;
        this.currentSubTaskTotalWork = subTaskWorkTotal;
        this.updateProgress();
    }

    private void endSubTask() {
        if (!this.cancleingReported) {
            this.currentSubTaskName = null;
            this.currentSubTaskWhatsNext = null;
            this.updateProgress();
        }
    }

    private void updateProgress() {
        if (this.progessDisplayInitialized && !this.cancleingReported) {
            String whatsNext = this.currentSubTaskWhatsNext;
            if (whatsNext == null) {
                whatsNext = this.currentSubTaskName;
            }
            this.targetDisplay.reportQuantifiedProgress(this.getWorkDone(), whatsNext);
        }
    }

    private int getWorkDone() {
        int workDone = 0;
        int i = 0;
        while (i < Math.min(this.currentSubTaskIndex, this.subTasks.length)) {
            workDone += this.weights[i];
            ++i;
        }
        if (this.currentSubTaskIndex >= 0 && this.currentSubTaskTotalWork > 0) {
            workDone += (int)Math.round((double)this.weights[this.currentSubTaskIndex] * (double)this.currentSubTaskWorkDone / (double)this.currentSubTaskTotalWork);
        }
        return workDone;
    }

    public static interface ISubTask
    extends IRunnableWithProgressDisplay {
        public int getWeight();

        public ISubTaskReverter getSubTaskReverter();
    }

    public static interface ISubTaskReverter {
        public void revert();
    }
}

