/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.ui.editor.widgetAdapter;

import com.arcway.lib.java.collections.IComparator_;
import com.arcway.lib.java.collections.ISetRW_;
import com.arcway.lib.java.collections.ISet_;
import com.arcway.lib.java.collections.SortedSet_;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.ui.editor.EnumerationItem;
import com.arcway.lib.ui.editor.datatype.IDataWidget;
import com.arcway.lib.ui.editor.playground.IEditorPlayground;
import com.arcway.lib.ui.editor.widgetAdapter.AbstractRelationWidgetAdapter;
import com.arcway.lib.ui.editor.widgetAdapter.IWidgetAdapter;
import com.arcway.lib.ui.editor.widgetAdapter.IWidgetAdapterManager;
import java.util.Collection;

public class SingleChoiceWidgetRelationWidgetAdapter
extends AbstractRelationWidgetAdapter {
    private static final ILogger logger = Logger.getLogger(SingleChoiceWidgetRelationWidgetAdapter.class);
    private Object latestSelectedKey = null;

    public SingleChoiceWidgetRelationWidgetAdapter(IWidgetAdapterManager widgetAdapterManager, Collection<IEditorPlayground> playgrounds, Object objectID, Object roleID) {
        super(widgetAdapterManager, playgrounds, objectID, roleID);
    }

    @Override
    public void widgetModified() {
        IDataWidget widget = this.getWidget();
        try {
            this.removeWidgetAdapterError();
            Object selectedKey = widget.getCurrentValue();
            if (this.latestSelectedKey == null && selectedKey != null || this.latestSelectedKey != null && selectedKey == null || this.latestSelectedKey != null && selectedKey != null && !this.getKeyHasher().isEqual(selectedKey, this.latestSelectedKey)) {
                if (this.latestSelectedKey != null) {
                    this.getPlayground().removeRelation(this.getObjectID(), this.getRoleID(), this.latestSelectedKey);
                }
                if (selectedKey != null) {
                    this.getPlayground().addRelation(this.getObjectID(), this.getRoleID(), selectedKey);
                }
            }
            this.latestSelectedKey = selectedKey;
        }
        catch (Exception e) {
            this.setWidgetAdapterError(null);
            logger.error("Wrong value in single choice widget for relations.", (Throwable)e);
            return;
        }
        this.getPlayground().updateAdapters(this);
    }

    @Override
    public Object getValue(IWidgetAdapter.WidgetUpdateMode mode) {
        ISet_<Object> value = this.getPlayground().getCreatedAndNotDeletedRelations(this.getObjectID(), this.getRoleID(), false);
        if (!value.isEmpty()) {
            assert (value.size() == 1) : "single choice widgets allow for at most one active relation";
            this.latestSelectedKey = value.iterator().next();
        } else {
            this.latestSelectedKey = null;
        }
        SortedSet_ enumerationItems = new SortedSet_((IComparator_)new IComparator_<EnumerationItem>(){

            public int getHashCode(EnumerationItem enumerationItem) {
                return enumerationItem.getLabel().hashCode();
            }

            public int sgn(EnumerationItem enumerationItem1, EnumerationItem enumerationItem2) {
                int comp = String.CASE_INSENSITIVE_ORDER.compare(enumerationItem1.getLabel(), enumerationItem2.getLabel());
                if (comp > 0) {
                    return 1;
                }
                if (comp < 0) {
                    return -1;
                }
                return 0;
            }
        });
        this.addEnumerationItemsForRelations(this.getPlayground().getRelationsThatMayBeDeleted(this.getObjectID(), this.getRoleID(), false), this.latestSelectedKey, (ISetRW_<EnumerationItem>)enumerationItems);
        this.addEnumerationItemsForRelations(this.getPlayground().getRelationsThatMayBeCreated(this.getObjectID(), this.getRoleID(), true), this.latestSelectedKey, (ISetRW_<EnumerationItem>)enumerationItems);
        if (!enumerationItems.isEmpty()) {
            enumerationItems.add((Object)new EnumerationItem(null, "", null, false));
        }
        return enumerationItems;
    }

    private void addEnumerationItemsForRelations(ISet_<? extends Object> relations, Object selectedKey, ISetRW_<EnumerationItem> enumerationItems) {
        for (Object relation : relations) {
            enumerationItems.add((Object)new EnumerationItem(relation, this.getPlayground().getLabel(this.getObjectID(), this.getRoleID(), relation), this.getPlayground().getIcon16x16(this.getObjectID(), this.getRoleID(), relation), selectedKey != null && this.getKeyHasher().isEqual(relation, selectedKey)));
        }
    }
}

