/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.ui.editor.widgetAdapter;

import com.arcway.lib.java.collections.IComparator_;
import com.arcway.lib.java.collections.ISetRW_;
import com.arcway.lib.java.collections.ISet_;
import com.arcway.lib.java.collections.SortedSet_;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.ui.editor.EnumerationItem;
import com.arcway.lib.ui.editor.datatype.IDataWidget;
import com.arcway.lib.ui.editor.playground.IEditorPlayground;
import com.arcway.lib.ui.editor.widgetAdapter.AbstractRelationWidgetAdapter;
import com.arcway.lib.ui.editor.widgetAdapter.IWidgetAdapter;
import com.arcway.lib.ui.editor.widgetAdapter.IWidgetAdapterManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RelationsTreeWidgetRelationWidgetAdapter
extends AbstractRelationWidgetAdapter {
    private static final ILogger logger = Logger.getLogger(RelationsTreeWidgetRelationWidgetAdapter.class);
    private List<Object> lastSelection;

    public RelationsTreeWidgetRelationWidgetAdapter(IWidgetAdapterManager widgetAdapterManager, Collection<IEditorPlayground> playgrounds, Object objectID, Object roleID) {
        super(widgetAdapterManager, playgrounds, objectID, roleID);
    }

    @Override
    public Object getValue(IWidgetAdapter.WidgetUpdateMode mode) {
        ISet_<Object> activeRelations = this.getPlayground().getCreatedAndNotDeletedRelations(this.getObjectID(), this.getRoleID(), false);
        this.lastSelection = new ArrayList<Object>();
        for (Object activeRelation : activeRelations) {
            this.lastSelection.add(activeRelation);
        }
        SortedSet_ enumerationItems = new SortedSet_((IComparator_)new IComparator_<EnumerationItem>(){

            public int getHashCode(EnumerationItem enumerationItem) {
                return enumerationItem.getLabel().hashCode();
            }

            public int sgn(EnumerationItem enumerationItem1, EnumerationItem enumerationItem2) {
                return String.CASE_INSENSITIVE_ORDER.compare(enumerationItem1.getLabel(), enumerationItem2.getLabel());
            }
        });
        this.addEnumerationItemsForRelations(this.getPlayground().getRelationsThatMayBeDeleted(this.getObjectID(), this.getRoleID(), false), activeRelations, (ISetRW_<EnumerationItem>)enumerationItems);
        this.addEnumerationItemsForRelations(this.getPlayground().getRelationsThatMayBeCreated(this.getObjectID(), this.getRoleID(), false), activeRelations, (ISetRW_<EnumerationItem>)enumerationItems);
        return enumerationItems;
    }

    private void addEnumerationItemsForRelations(ISet_<? extends Object> relations, ISet_<Object> activeRelations, ISetRW_<EnumerationItem> enumerationItems) {
        for (Object relation : relations) {
            enumerationItems.add((Object)new EnumerationItem(relation, this.getPlayground().getLabel(this.getObjectID(), this.getRoleID(), relation), this.getPlayground().getIcon16x16(this.getObjectID(), this.getRoleID(), relation), activeRelations.contains(relation)));
        }
    }

    @Override
    public void widgetModified() {
        IDataWidget widget = this.getWidget();
        ArrayList<Object> selectedValues = new ArrayList<Object>();
        try {
            this.removeWidgetAdapterError();
            Object object = widget.getCurrentValue();
            if (object == null) {
                return;
            }
            List valueList = (List)object;
            for (EnumerationItem enumerationItem : valueList) {
                selectedValues.add(enumerationItem.getKey());
            }
        }
        catch (Exception exception) {
            this.setWidgetAdapterError(null);
            logger.error("Wrong value in relations tree widget.", (Throwable)exception);
            return;
        }
        for (Object e : selectedValues) {
            if (this.listContainsKey(this.lastSelection, e)) continue;
            this.getPlayground().addRelation(this.getObjectID(), this.getRoleID(), e);
        }
        for (Object object : this.lastSelection) {
            if (this.listContainsKey(selectedValues, object)) continue;
            this.getPlayground().removeRelation(this.getObjectID(), this.getRoleID(), object);
        }
        this.lastSelection = selectedValues;
        this.getPlayground().updateAdapters(this);
    }

    private boolean listContainsKey(List<?> l, Object o) {
        for (Object name : l) {
            if (!this.getKeyHasher().isEqual(o, name)) continue;
            return true;
        }
        return false;
    }

    public int getHashCode(EnumerationItem item) {
        return this.getKeyHasher().getHashCode(item.getKey());
    }

    public boolean isEqual(EnumerationItem item, EnumerationItem item2) {
        return this.getKeyHasher().isEqual(item.getKey(), item2.getKey());
    }

    public EnumerationItem getParent(EnumerationItem item) {
        Object parentObj = this.getPlayground().getParent(this.getObjectID(), this.getRoleID(), item.getKey());
        if (parentObj == null) {
            return null;
        }
        return new EnumerationItem(parentObj, this.getPlayground().getLabel(this.getObjectID(), this.getRoleID(), parentObj), null, false);
    }
}

