/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.ui.editor.widgetAdapter;

import com.arcway.lib.java.collections.HashSet_;
import com.arcway.lib.java.collections.IHasher_;
import com.arcway.lib.java.collections.IList_;
import com.arcway.lib.java.collections.ISet_;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.ui.editor.EnumerationItem_WithLabelIconDecorationsAndSelectability;
import com.arcway.lib.ui.editor.datatype.ConstantTextProvider;
import com.arcway.lib.ui.editor.datatype.IMessageLevel;
import com.arcway.lib.ui.editor.playground.IEditorPlayground;
import com.arcway.lib.ui.editor.playground.PlaygroundError;
import com.arcway.lib.ui.editor.playground.PropertyPlayground;
import com.arcway.lib.ui.editor.widgetAdapter.AbstractPropertyWidgetAdapter;
import com.arcway.lib.ui.editor.widgetAdapter.IWidgetAdapter;
import com.arcway.lib.ui.editor.widgetAdapter.IWidgetAdapterManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MultipleChoiceWidgetMultipleChoicePropertyWidgetAdapter
extends AbstractPropertyWidgetAdapter {
    private static final ILogger logger = Logger.getLogger(MultipleChoiceWidgetMultipleChoicePropertyWidgetAdapter.class);
    private final PropertyPlayground<?, ?, ?, ?> playground;

    public MultipleChoiceWidgetMultipleChoicePropertyWidgetAdapter(IWidgetAdapterManager widgetAdapterManager, Collection<IEditorPlayground> playgrounds) {
        super(widgetAdapterManager, playgrounds);
        this.playground = (PropertyPlayground)playgrounds.iterator().next();
    }

    @Override
    public List<Object> getValueRange() {
        IList_ valueRange = this.playground.getValueRange();
        ArrayList<Object> enumerationItems = new ArrayList<Object>();
        for (String key : valueRange) {
            enumerationItems.add(new EnumerationItem_WithLabelIconDecorationsAndSelectability(key, this.playground.getLabel(key), null, EnumerationItem_WithLabelIconDecorationsAndSelectability.Selectability.SELECTABLE_INITIALLYCHECKED));
        }
        return enumerationItems;
    }

    public IHasher_<Object> getKeyHasher() {
        return IHasher_.EQUALS_HASHER;
    }

    @Override
    public Object getValue(IWidgetAdapter.WidgetUpdateMode mode) {
        HashSet_ value = new HashSet_(IHasher_.EQUALS_HASHER);
        Set valueFromPlayground = (Set)this.playground.getValue();
        if (valueFromPlayground != null) {
            value.addAll((Collection)valueFromPlayground);
        }
        return value;
    }

    @Override
    public void widgetModified() {
        try {
            this.removeWidgetAdapterError();
            ISet_ currentValue = (ISet_)this.getWidget().getCurrentValue();
            this.playground.setValue(new HashSet(currentValue.asJavaSet()), this);
        }
        catch (Exception e) {
            this.setWidgetAdapterError(null);
            this.playground.setError(new PlaygroundError(IMessageLevel.NORMAL, new ConstantTextProvider(e.getLocalizedMessage())));
            logger.error("Wrong value in multiple choice widget for enumerations.", (Throwable)e);
        }
    }
}

