/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.ui.editor.widgetAdapter;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.ui.editor.WidgetFactoryController;
import com.arcway.lib.ui.editor.datatype.ICompositeLayoutWidget;
import com.arcway.lib.ui.editor.datatype.ICompositeWidget;
import com.arcway.lib.ui.editor.datatype.INonPageWidget;
import com.arcway.lib.ui.editor.datatype.IWidgetTypeID;
import com.arcway.lib.ui.editor.parameters.WidgetParameters;
import com.arcway.lib.ui.editor.playground.IEditorPlayground;
import com.arcway.lib.ui.editor.widgetAdapter.AbstractWidgetAdapter;
import com.arcway.lib.ui.editor.widgetAdapter.IComplexWidgetAdapter;
import com.arcway.lib.ui.editor.widgetAdapter.IWidgetAdapterManager;
import java.util.Collection;
import java.util.List;

public abstract class AbstractComplexWidgetAdapter
extends AbstractWidgetAdapter
implements IComplexWidgetAdapter {
    private static final ILogger LOGGER = Logger.getLogger(AbstractComplexWidgetAdapter.class);
    private ICompositeLayoutWidget widget;

    public AbstractComplexWidgetAdapter(IWidgetAdapterManager widgetAdapterManager, Collection<IEditorPlayground> playgrounds) {
        super(widgetAdapterManager, playgrounds);
    }

    @Override
    public final ICompositeLayoutWidget createWidget(IWidgetTypeID widgetTypeID, WidgetFactoryController widgetFactory, WidgetParameters parameters, ICompositeWidget parentWidget) {
        this.widget = widgetFactory.createComplexWidget(widgetTypeID, parameters, parentWidget, this);
        List<INonPageWidget> childWidgets = this.createSubWidgets(widgetFactory, parameters);
        for (INonPageWidget childWidget : childWidgets) {
            this.widget.addChildWidget(childWidget);
        }
        return this.widget;
    }

    protected abstract List<INonPageWidget> createSubWidgets(WidgetFactoryController var1, WidgetParameters var2);

    @Override
    public ICompositeLayoutWidget getWidget() {
        return this.widget;
    }
}

