/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.ui.dnd;

import com.arcway.lib.codec.data.IDataType;
import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.ui.dnd.DragNDropContributorExtensionPoint;
import com.arcway.lib.ui.dnd.IDragContributor;
import com.arcway.lib.ui.dnd.IDragNDropManager;
import com.arcway.lib.ui.dnd.IDropContributor;
import com.arcway.lib.ui.dnd.IModelDragHandler;
import com.arcway.lib.ui.dnd.IModelDropHandler;
import java.util.Collection;
import java.util.HashSet;

public class DragNDropManager
implements IDragNDropManager {
    private static DragNDropManager INSTANCE = null;

    public static synchronized DragNDropManager getDragNDropManager() {
        if (INSTANCE == null) {
            INSTANCE = new DragNDropManager();
        }
        return INSTANCE;
    }

    private DragNDropManager() {
    }

    @Override
    public IDataType[] getDragDataTypes(int operation) {
        HashSet<IDataType> resultSet = new HashSet<IDataType>();
        DragNDropContributorExtensionPoint extensionPoint = DragNDropContributorExtensionPoint.getInstance();
        ICollection_<IDragContributor> contributors = extensionPoint.getDragContributors();
        for (IDragContributor dragContributor : contributors) {
            IDataType[] iDataTypeArray = dragContributor.getSupportedDataTypes(operation);
            int n = iDataTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IDataType dataType = iDataTypeArray[n2];
                resultSet.add(dataType);
                ++n2;
            }
        }
        return resultSet.toArray(new IDataType[resultSet.size()]);
    }

    @Override
    public IModelDragHandler getModelDragHandler(Collection<Object> selectedItems, int operation) {
        DragNDropContributorExtensionPoint extensionPoint = DragNDropContributorExtensionPoint.getInstance();
        ICollection_<IDragContributor> contributors = extensionPoint.getDragContributors();
        for (IDragContributor dragContributor : contributors) {
            IModelDragHandler result = dragContributor.getModelDragHandler(selectedItems, operation);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public IDataType[] getDropDataTypes(int operation) {
        HashSet<IDataType> resultSet = new HashSet<IDataType>();
        DragNDropContributorExtensionPoint extensionPoint = DragNDropContributorExtensionPoint.getInstance();
        ICollection_<IDropContributor> contributors = extensionPoint.getDropContributors();
        for (IDropContributor dropContributor : contributors) {
            IDataType[] iDataTypeArray = dropContributor.getSupportedDataTypes(operation);
            int n = iDataTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IDataType dataType = iDataTypeArray[n2];
                resultSet.add(dataType);
                ++n2;
            }
        }
        return resultSet.toArray(new IDataType[resultSet.size()]);
    }

    @Override
    public IModelDropHandler getModelDropHandler(Object droppedElements, Object targetFolderElement, int operation) {
        DragNDropContributorExtensionPoint extensionPoint = DragNDropContributorExtensionPoint.getInstance();
        ICollection_<IDropContributor> contributors = extensionPoint.getDropContributors();
        for (IDropContributor dropContributor : contributors) {
            IModelDropHandler result = dropContributor.getModelDropHandler(droppedElements, targetFolderElement, operation);
            if (result == null) continue;
            return result;
        }
        return null;
    }
}

