/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.graphics.print;

import com.arcway.lib.geometry.Dimension;
import com.arcway.lib.geometry.Insets;
import com.arcway.lib.graphics.Color;
import com.arcway.lib.graphics.print.IImagePrinterPageDescription;
import com.arcway.lib.graphics.print.PageDescription;

public class ImagePrinterPageDescription
extends PageDescription
implements IImagePrinterPageDescription {
    private final double verticalDPI;
    private final double horizontalDPI;
    private final Color bgColor;

    private ImagePrinterPageDescription(Dimension pageDimension, Insets insets, double hDPI, double vDPI, Color bgColor) {
        super(pageDimension, insets);
        this.horizontalDPI = hDPI;
        this.verticalDPI = vDPI;
        this.bgColor = bgColor;
    }

    public static IImagePrinterPageDescription createImageInfoInMM(double wInMM, double hInMM, Insets insetsInMM, double hDPI, double vDPI, Color bgColor) {
        return new ImagePrinterPageDescription(new Dimension(wInMM, hInMM), insetsInMM, hDPI, vDPI, bgColor);
    }

    public static IImagePrinterPageDescription createImageInfoInMM(double wInMM, double hInMM, double insetsInMM, double hDPI, double vDPI, Color bgColor) {
        return new ImagePrinterPageDescription(new Dimension(wInMM, hInMM), new Insets(insetsInMM), hDPI, vDPI, bgColor);
    }

    public static IImagePrinterPageDescription createImageInfoInPixels(int wInPixels, int hInPixels, int insetsInPixels, double hDPI, double vDPI, Color bgColor) {
        double wInInch = (double)wInPixels / hDPI;
        double hInInch = (double)hInPixels / vDPI;
        double insetsHInInch = (double)insetsInPixels / hDPI;
        double insetsVInInch = (double)insetsInPixels / vDPI;
        double wInMM = wInInch * 25.4;
        double hInMM = hInInch * 25.4;
        double insetsHInMM = insetsHInInch * 25.4;
        double insetsVInMM = insetsVInInch * 25.4;
        return new ImagePrinterPageDescription(new Dimension(wInMM, hInMM), new Insets(insetsVInMM, insetsVInMM, insetsHInMM, insetsHInMM), hDPI, vDPI, bgColor);
    }

    @Override
    public double getHorizontalDPI() {
        return this.horizontalDPI;
    }

    @Override
    public double getVerticalDPI() {
        return this.verticalDPI;
    }

    @Override
    public Color getBGColor() {
        return this.bgColor;
    }
}

