/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.geometry.snap;

import com.arcway.lib.geometry.Geo;
import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Points;
import com.arcway.lib.geometry.snap.IGridDescriptor;
import com.arcway.lib.geometry.snap.IPointSnapper;
import com.arcway.lib.geometry.snap.ISnappablePoint;
import com.arcway.lib.graphics.Alignment;
import java.util.Collection;

public class Grid
implements IGridDescriptor,
IPointSnapper {
    private final double gridOriginX;
    private final double gridOriginY;
    private final double gridSpacingX;
    private final double gridSpacingY;

    public Grid(Point gridOrigin, double gridSpacingX, double gridSpacingY) {
        assert (gridOrigin != null);
        assert (gridSpacingX > 1.0E-10);
        assert (gridSpacingY > 1.0E-10);
        this.gridOriginX = gridOrigin.x;
        this.gridOriginY = gridOrigin.y;
        this.gridSpacingX = gridSpacingX;
        this.gridSpacingY = gridSpacingY;
    }

    public Grid(Grid grid) {
        assert (grid != null);
        this.gridOriginX = grid.gridOriginX;
        this.gridOriginY = grid.gridOriginY;
        this.gridSpacingX = grid.gridSpacingX;
        this.gridSpacingY = grid.gridSpacingY;
    }

    @Override
    public double getGridOriginX() {
        return this.gridOriginX;
    }

    @Override
    public double getGridOriginY() {
        return this.gridOriginY;
    }

    @Override
    public double getGridSpacingX() {
        return this.gridSpacingX;
    }

    @Override
    public double getGridSpacingY() {
        return this.gridSpacingY;
    }

    @Override
    public Points snapPoints(Collection snappablePoints) {
        Points points = new Points(snappablePoints.size());
        for (ISnappablePoint snappablePoint : snappablePoints) {
            points.add(this.snapPoint(snappablePoint));
        }
        return points;
    }

    @Override
    public Point snapPoint(ISnappablePoint point) {
        double gridProxyOriginX = this.getGridProxyOriginX(point, false);
        double gridProxyOriginY = this.getGridProxyOriginY(point, false);
        double gridProxySpacingX = this.getGridProxySpacingX(point, false);
        double gridProxySpacingY = this.getGridProxySpacingY(point, false);
        double snappedX = Grid.snapPosition(point.getX(), gridProxyOriginX, gridProxySpacingX);
        double snappedY = Grid.snapPosition(point.getY(), gridProxyOriginY, gridProxySpacingY);
        return new Point(snappedX, snappedY);
    }

    @Override
    public double snapObjectAlignment(Collection points, int alignment, double wishedPosition) {
        double gridSpacing;
        double gridOrigin;
        boolean isHorizontalAlignment = Alignment.isHorizintalAlignment(alignment);
        if (isHorizontalAlignment) {
            gridOrigin = this.gridOriginX;
            gridSpacing = this.gridSpacingX;
        } else {
            gridOrigin = this.gridOriginY;
            gridSpacing = this.gridSpacingY;
        }
        ISnappablePoint.GridSnapType mostRestrictedGridSnapType = ISnappablePoint.GRID_SNAP_TYPE_FREE;
        for (ISnappablePoint point : points) {
            ISnappablePoint.GridSnapType currentGridSnapType = isHorizontalAlignment ? point.getGridSnapTypeX() : point.getGridSnapTypeY();
            mostRestrictedGridSnapType = this.getMoreRestricted(mostRestrictedGridSnapType, currentGridSnapType);
        }
        double snappedPosition = mostRestrictedGridSnapType == ISnappablePoint.GRID_SNAP_TYPE_FREE ? wishedPosition : (mostRestrictedGridSnapType == ISnappablePoint.GRID_SNAP_TYPE_GRID_HALF ? Grid.snapPosition(wishedPosition, gridOrigin, gridSpacing / 2.0) : (mostRestrictedGridSnapType == ISnappablePoint.GRID_SNAP_TYPE_POINT_GRID_FULL_OBJECT_GRID_HALF ? Grid.snapPosition(wishedPosition, gridOrigin, gridSpacing / 2.0) : (mostRestrictedGridSnapType == ISnappablePoint.GRID_SNAP_TYPE_GRID_FULL ? Grid.snapPosition(wishedPosition, gridOrigin, gridSpacing) : wishedPosition)));
        return snappedPosition;
    }

    private ISnappablePoint.GridSnapType getMoreRestricted(ISnappablePoint.GridSnapType a, ISnappablePoint.GridSnapType b) {
        ISnappablePoint.GridSnapType moreRestricted = a == b ? a : (a == ISnappablePoint.GRID_SNAP_TYPE_GRID_FULL || b == ISnappablePoint.GRID_SNAP_TYPE_GRID_FULL ? ISnappablePoint.GRID_SNAP_TYPE_GRID_FULL : (a == ISnappablePoint.GRID_SNAP_TYPE_FREE ? b : (b == ISnappablePoint.GRID_SNAP_TYPE_FREE ? a : ISnappablePoint.GRID_SNAP_TYPE_POINT_GRID_FULL_OBJECT_GRID_HALF)));
        return moreRestricted;
    }

    @Override
    public GeoVector snapObjectTranslation(Collection points, GeoVector wishedTranslation) {
        double snapX = 0.0;
        double snapY = 0.0;
        int snapPriorityX = 0;
        int snapPriorityY = 0;
        for (ISnappablePoint point : points) {
            ISnappablePoint.GridSnapType gridSnapTypeY;
            Point snappedPoint = this.snapPoint(point);
            ISnappablePoint.GridSnapType gridSnapTypeX = point.getGridSnapTypeX();
            int currentPriorityX = gridSnapTypeX == ISnappablePoint.GRID_SNAP_TYPE_FREE ? 0 : (gridSnapTypeX == ISnappablePoint.GRID_SNAP_TYPE_GRID_HALF ? 1 : (gridSnapTypeX == ISnappablePoint.GRID_SNAP_TYPE_POINT_GRID_FULL_OBJECT_GRID_HALF ? 1 : (gridSnapTypeX == ISnappablePoint.GRID_SNAP_TYPE_GRID_FULL ? 2 : 0)));
            if (Geo.equals(point.getX(), snappedPoint.x)) {
                currentPriorityX += 10;
            }
            int currentPriorityY = (gridSnapTypeY = point.getGridSnapTypeY()) == ISnappablePoint.GRID_SNAP_TYPE_FREE ? 0 : (gridSnapTypeY == ISnappablePoint.GRID_SNAP_TYPE_GRID_HALF ? 1 : (gridSnapTypeY == ISnappablePoint.GRID_SNAP_TYPE_POINT_GRID_FULL_OBJECT_GRID_HALF ? 1 : (gridSnapTypeY == ISnappablePoint.GRID_SNAP_TYPE_GRID_FULL ? 2 : 0)));
            if (Geo.equals(point.getY(), snappedPoint.y)) {
                currentPriorityY += 10;
            }
            double currentSnapX = this.snapObjectTranslationX(point, wishedTranslation.x);
            if (currentPriorityX > snapPriorityX || currentPriorityX == snapPriorityX && Math.abs(currentSnapX) > Math.abs(snapX)) {
                snapX = currentSnapX;
            }
            double currentSnapY = this.snapObjectTranslationY(point, wishedTranslation.y);
            if (currentPriorityY > snapPriorityY || currentPriorityY == snapPriorityY && Math.abs(currentSnapY) > Math.abs(snapY)) {
                snapY = currentSnapY;
            }
            if (currentPriorityX > snapPriorityX) {
                snapPriorityX = currentPriorityX;
            }
            if (currentPriorityY <= snapPriorityY) continue;
            snapPriorityY = currentPriorityY;
        }
        return new GeoVector(snapX, snapY);
    }

    @Override
    public GeoVector snapPointTranslation(Collection points, GeoVector wishedTranslation) {
        double snapX = 0.0;
        double snapY = 0.0;
        for (ISnappablePoint point : points) {
            double currentSnapY;
            double currentSnapX = this.snapPointTranslationX(point, wishedTranslation.x);
            if (Math.abs(currentSnapX) > Math.abs(snapX)) {
                snapX = currentSnapX;
            }
            if (!(Math.abs(currentSnapY = this.snapPointTranslationY(point, wishedTranslation.y)) > Math.abs(snapY))) continue;
            snapY = currentSnapY;
        }
        return new GeoVector(snapX, snapY);
    }

    private double snapObjectTranslationX(ISnappablePoint point, double wishedTranslationX) {
        double gridProxyOriginX = this.getGridProxyOriginX(point, true);
        double gridProxySpacingX = this.getGridProxySpacingX(point, true);
        return this.snapTranslation(point.getX(), wishedTranslationX, gridProxyOriginX, gridProxySpacingX);
    }

    private double snapObjectTranslationY(ISnappablePoint point, double wishedTranslationY) {
        double gridProxyOriginY = this.getGridProxyOriginY(point, true);
        double gridProxySpacingY = this.getGridProxySpacingY(point, true);
        return this.snapTranslation(point.getY(), wishedTranslationY, gridProxyOriginY, gridProxySpacingY);
    }

    private double snapPointTranslationX(ISnappablePoint point, double wishedTranslationX) {
        double gridProxyOriginX = this.getGridProxyOriginX(point, false);
        double gridProxySpacingX = this.getGridProxySpacingX(point, false);
        return this.snapTranslation(point.getX(), wishedTranslationX, gridProxyOriginX, gridProxySpacingX);
    }

    private double snapPointTranslationY(ISnappablePoint point, double wishedTranslationY) {
        double gridProxyOriginY = this.getGridProxyOriginY(point, false);
        double gridProxySpacingY = this.getGridProxySpacingY(point, false);
        return this.snapTranslation(point.getY(), wishedTranslationY, gridProxyOriginY, gridProxySpacingY);
    }

    private boolean areAllOnGridHalfX(Points points) {
        boolean allAreOnGridHalf = points.size() > 0;
        int i = 0;
        while (allAreOnGridHalf && i < points.size()) {
            Point point = points.get(i);
            allAreOnGridHalf &= this.isOnGridHalfX(point.x);
            ++i;
        }
        return allAreOnGridHalf;
    }

    private boolean areAllOnGridHalfY(Points points) {
        boolean allAreOnGridHalf = points.size() > 0;
        int i = 0;
        while (allAreOnGridHalf && i < points.size()) {
            Point point = points.get(i);
            allAreOnGridHalf &= this.isOnGridHalfY(point.y);
            ++i;
        }
        return allAreOnGridHalf;
    }

    private boolean isOnGridHalfX(double x) {
        return this.isOnGrid(x, this.gridOriginX + this.gridSpacingX / 2.0, this.gridSpacingX);
    }

    private boolean isOnGridHalfY(double y) {
        return this.isOnGrid(y, this.gridOriginY + this.gridSpacingY / 2.0, this.gridSpacingY);
    }

    private boolean isOnGrid(double position, double gridOrigin, double gridSpacing) {
        double gridOriginToOrigin = 0.0 - gridOrigin;
        double p = position + gridOriginToOrigin;
        return Math.abs(p % gridSpacing) < 1.0E-10;
    }

    private double getGridProxyOriginX(ISnappablePoint snappablePoint, boolean objectSnap) {
        assert (snappablePoint != null);
        return this.getProxyOrigin(this.gridOriginX, this.gridSpacingX, !objectSnap && this.areAllOnGridHalfX(snappablePoint.getObjectPoints()), snappablePoint.getGridSnapTypeX());
    }

    private double getGridProxyOriginY(ISnappablePoint snappablePoint, boolean objectSnap) {
        assert (snappablePoint != null);
        return this.getProxyOrigin(this.gridOriginY, this.gridSpacingY, !objectSnap && this.areAllOnGridHalfY(snappablePoint.getObjectPoints()), snappablePoint.getGridSnapTypeY());
    }

    private double getGridProxySpacingX(ISnappablePoint snappablePoint, boolean objectSnap) {
        assert (snappablePoint != null);
        return this.getProxySpacing(this.gridSpacingX, objectSnap, snappablePoint.getGridSnapTypeX());
    }

    private double getGridProxySpacingY(ISnappablePoint snappablePoint, boolean objectSnap) {
        assert (snappablePoint != null);
        return this.getProxySpacing(this.gridSpacingY, objectSnap, snappablePoint.getGridSnapTypeY());
    }

    private double getProxyOrigin(double gridOrigin, double gridSpacing, boolean objectIsOnGridHalf, ISnappablePoint.GridSnapType gridSnapType) {
        double gridProxyOrigin = gridSnapType == ISnappablePoint.GRID_SNAP_TYPE_FREE ? gridOrigin : (gridSnapType == ISnappablePoint.GRID_SNAP_TYPE_GRID_HALF ? gridOrigin : (gridSnapType == ISnappablePoint.GRID_SNAP_TYPE_POINT_GRID_FULL_OBJECT_GRID_HALF ? (objectIsOnGridHalf ? gridOrigin + gridSpacing / 2.0 : gridOrigin) : (gridSnapType == ISnappablePoint.GRID_SNAP_TYPE_GRID_FULL ? gridOrigin : gridOrigin)));
        return gridProxyOrigin;
    }

    private double getProxySpacing(double gridSpacing, boolean objectSnap, ISnappablePoint.GridSnapType gridSnapType) {
        double gridProxySpacing = objectSnap ? (gridSnapType == ISnappablePoint.GRID_SNAP_TYPE_FREE ? 0.0 : (gridSnapType == ISnappablePoint.GRID_SNAP_TYPE_GRID_HALF ? gridSpacing / 2.0 : (gridSnapType == ISnappablePoint.GRID_SNAP_TYPE_POINT_GRID_FULL_OBJECT_GRID_HALF ? gridSpacing / 2.0 : (gridSnapType == ISnappablePoint.GRID_SNAP_TYPE_GRID_FULL ? gridSpacing : gridSpacing)))) : (gridSnapType == ISnappablePoint.GRID_SNAP_TYPE_FREE ? 0.0 : (gridSnapType == ISnappablePoint.GRID_SNAP_TYPE_GRID_HALF ? gridSpacing / 2.0 : (gridSnapType == ISnappablePoint.GRID_SNAP_TYPE_POINT_GRID_FULL_OBJECT_GRID_HALF ? gridSpacing : (gridSnapType == ISnappablePoint.GRID_SNAP_TYPE_GRID_FULL ? gridSpacing : gridSpacing))));
        return gridProxySpacing;
    }

    public static double snapPosition(double position, double gridOrigin, double gridSpacing) {
        double translation = position - gridOrigin;
        double snap = 0.0;
        if (gridSpacing > 1.0E-10) {
            snap = translation % gridSpacing;
            if (snap > gridSpacing / 2.0 - 1.0E-10) {
                snap -= gridSpacing;
            } else if (snap < -gridSpacing / 2.0 + 1.0E-10) {
                snap += gridSpacing;
            }
        }
        return position - snap;
    }

    private double snapTranslation(double oldPosition, double translation, double gridOrigin, double gridSpacing) {
        double newPosition = Grid.snapPosition(oldPosition + translation, gridOrigin, gridSpacing);
        return newPosition - oldPosition;
    }
}

