/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.geometry.polygon;

import com.arcway.lib.geometry.Arc;
import com.arcway.lib.geometry.Geo;
import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Point;

public class PolygonCorner
extends Point {
    public PolygonCorner prev = null;
    public PolygonCorner next = null;
    public double radiusToPrev = 0.0;
    public double radiusToNext = 0.0;
    public Arc arc = null;

    public PolygonCorner(double x, double y) {
        super(x, y);
    }

    protected void initialize() {
        if (this.prev != null && this.next != null && this.radiusToPrev > 1.0E-10 && this.radiusToNext > 1.0E-10) {
            Point to;
            GeoVector CornerToTo;
            Point from = this.movePoint(this, this.prev, this.radiusToPrev);
            GeoVector FromToCorner = new GeoVector(from, this);
            this.arc = GeoVector.isLinearlyDependent(FromToCorner, CornerToTo = new GeoVector(this, to = this.movePoint(this, this.next, this.radiusToNext))) ? null : new Arc(from, this, to);
        }
    }

    private Point movePoint(Point point, Point to, double distanceToMove) {
        assert (new GeoVector(point, to).abs() > 1.0E-10) : "to equals point";
        double distance = Geo.arcLengthLine(to.x, to.y, point.x, point.y);
        double distanceX = to.x - point.x;
        double distanceY = to.y - point.y;
        if (distance > 1.0E-10) {
            return new Point(point.x + distanceToMove * distanceX / distance, point.y + distanceToMove * distanceY / distance);
        }
        return Point.getAsPoint(point);
    }

    public Point getRealPosition() {
        Point realPosition = this.arc == null ? Point.getAsPoint(this) : (GeoVector.getDistance(this.arc.center, this) > 1.0E-10 ? this.arc.getPointByAngle(GeoVector.getDifferenceVectorAngle(this.arc.center, this)) : Point.getAsPoint(this));
        return realPosition;
    }

    public double getAngle() {
        assert (GeoVector.getDistance(this.arc.center, this) > 1.0E-10) : "center equals this";
        return GeoVector.getDifferenceVectorAngle(this.arc.center, this);
    }
}

