/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.java__i;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.StdOutStdErrLogger;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;

public class AssertToStdOutStdError {
    private static final ILogger logger = new StdOutStdErrLogger(AssertToStdOutStdError.class);

    public static boolean illegalType() {
        return AssertToStdOutStdError.throwRuntimeException(new ClassCastException());
    }

    public static boolean illegalType(String message) {
        return AssertToStdOutStdError.throwRuntimeException(new ClassCastException(message));
    }

    public static boolean illegalArgument() {
        return AssertToStdOutStdError.throwRuntimeException(new IllegalArgumentException());
    }

    public static boolean illegalArgument(String message) {
        return AssertToStdOutStdError.throwRuntimeException(new IllegalArgumentException(message));
    }

    public static boolean illegalState() {
        return AssertToStdOutStdError.throwRuntimeException(new IllegalStateException());
    }

    public static boolean illegalState(String message) {
        return AssertToStdOutStdError.throwRuntimeException(new IllegalStateException(message));
    }

    public static boolean unsupportedOperation() {
        return AssertToStdOutStdError.throwRuntimeException(new UnsupportedOperationException());
    }

    public static boolean unsupportedOperation(String message) {
        return AssertToStdOutStdError.throwRuntimeException(new UnsupportedOperationException(message));
    }

    public static boolean concurrentAccess() {
        return AssertToStdOutStdError.throwRuntimeException(new ConcurrentModificationException());
    }

    public static boolean concurrentAccess(String message) {
        return AssertToStdOutStdError.throwRuntimeException(new ConcurrentModificationException(message));
    }

    public static boolean checkArgumentBeeingNotNull(Object o) {
        return AssertToStdOutStdError.checkArgument(o != null);
    }

    public static boolean checkStringToContainNoInvalidCharacters(String stringToBeChecked, String allowedCharacters) {
        boolean stringIsOk = true;
        int i = 0;
        while (stringIsOk && i < stringToBeChecked.length()) {
            stringIsOk &= allowedCharacters.indexOf(stringToBeChecked.charAt(i)) >= 0;
            ++i;
        }
        return AssertToStdOutStdError.checkArgument(stringIsOk);
    }

    public static boolean checkStringToBeNotEmpty(String stringToBeChecked) {
        return AssertToStdOutStdError.checkArgument(stringToBeChecked.length() != 0);
    }

    public static boolean checkObjectArgumentToBeInstanceOf(Object o, Class<?> t) {
        AssertToStdOutStdError.checkArgumentBeeingNotNull(o);
        AssertToStdOutStdError.checkArgumentBeeingNotNull(t);
        return AssertToStdOutStdError.checkArgument(t.isInstance(o));
    }

    public static boolean checkCollectionArgumentToContainACertainType(Collection<?> c, Class<?> t) {
        AssertToStdOutStdError.checkArgumentBeeingNotNull(c);
        AssertToStdOutStdError.checkArgumentBeeingNotNull(t);
        boolean isCollectionOk = true;
        Iterator<?> i = c.iterator();
        while (isCollectionOk && i.hasNext()) {
            Object currentObject = i.next();
            if (t.isInstance(currentObject)) continue;
            isCollectionOk = false;
            AssertToStdOutStdError.illegalArgument();
        }
        return isCollectionOk;
    }

    public static boolean checkArgument(boolean isValueOk) {
        if (!isValueOk) {
            AssertToStdOutStdError.illegalArgument();
        }
        return isValueOk;
    }

    public static boolean checkState(boolean isValueOk) {
        if (!isValueOk) {
            AssertToStdOutStdError.illegalState();
        }
        return isValueOk;
    }

    public static boolean checkState(boolean isValueOk, String message) {
        AssertToStdOutStdError.checkArgumentBeeingNotNull(message);
        if (!isValueOk) {
            AssertToStdOutStdError.illegalState(message);
        }
        return isValueOk;
    }

    public static boolean checkOperationSupport(boolean isValueOk) {
        if (!isValueOk) {
            AssertToStdOutStdError.unsupportedOperation();
        }
        return isValueOk;
    }

    public static boolean checkOperationSupport(boolean isValueOk, String message) {
        if (!isValueOk) {
            AssertToStdOutStdError.unsupportedOperation(message);
        }
        return isValueOk;
    }

    public static boolean checkConcurrentAccess(boolean isValueOk) {
        if (!isValueOk) {
            AssertToStdOutStdError.concurrentAccess();
        }
        return isValueOk;
    }

    public static boolean checkArgument(boolean isValueOk, String message) {
        AssertToStdOutStdError.checkArgumentBeeingNotNull(message);
        if (!isValueOk) {
            AssertToStdOutStdError.illegalArgument(message);
        }
        return isValueOk;
    }

    public static boolean throwRuntimeException(RuntimeException e) {
        AssertToStdOutStdError.checkArgumentBeeingNotNull(e);
        logger.error("Assertion error", e);
        throw e;
    }

    private AssertToStdOutStdError() {
    }
}

