/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.uiframework.widgets;

import com.arcway.lib.eclipse.Messages;
import com.arcway.lib.eclipse.file.UrlLauncher;
import com.arcway.lib.eclipse.gui.EclipseSWTHelper;
import com.arcway.lib.eclipse.transfer.old.URLTransfer;
import com.arcway.lib.eclipse.uiframework.widgets.AbstractDataWidget;
import com.arcway.lib.eclipse.uiframework.widgets.IEclipseCompositeWidget;
import com.arcway.lib.eclipse.uiframework.widgets.dragndrop.IDropSupportingWidget;
import com.arcway.lib.eclipse.uiframework.widgets.dragndrop.SimpleWidgetDropListener;
import com.arcway.lib.ui.editor.datatype.ICompositeWidget;
import com.arcway.lib.ui.editor.parameters.WidgetParameters;
import com.arcway.lib.ui.editor.widgetAdapter.IDataWidgetAdapter;
import com.arcway.lib.ui.editor.widgetAdapter.IWidgetAdapter;
import com.arcway.lib.ui.editor.widgetAdapter.URLWidgetURLPropertyWidgetAdapter;
import java.net.URL;
import java.util.Locale;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class URLWidget
extends AbstractDataWidget
implements IHyperlinkListener,
ModifyListener,
IDropSupportingWidget {
    private Control control;
    private Composite widgetComposite;
    private String value;
    private final URLTransfer transferAgent = URLTransfer.getInstance();

    public URLWidget(WidgetParameters parameters, ICompositeWidget parent, IDataWidgetAdapter adapter) {
        super(parameters, adapter, (IEclipseCompositeWidget)parent);
        assert (parent instanceof IEclipseCompositeWidget);
    }

    @Override
    public void createControl(Composite parentComposite) {
        FormToolkit toolkit = this.getFormToolkit();
        this.widgetComposite = parentComposite;
        this.value = (String)this.getWidgetAdapter().getValue(IWidgetAdapter.WidgetUpdateMode.UPDATE_VALUE);
        boolean isModificationPermitted = this.getWidgetAdapter().isModificationPermitted();
        boolean isModificationLocked = this.getWidgetAdapter().isModificationLocked();
        if (this.isEditable() && isModificationPermitted && isModificationLocked) {
            this.createEditableControl(toolkit);
        } else {
            this.createUneditableControl(toolkit);
        }
    }

    public Object getCurrentValue() {
        return this.value;
    }

    public void setValue(Object value) {
        if (this.control instanceof Text) {
            ((Text)this.control).setText((String)value);
        }
        if (this.control instanceof Hyperlink) {
            ((Hyperlink)this.control).setText((String)value);
        }
    }

    @Override
    public void updateWidget_internal(IWidgetAdapter.WidgetUpdateMode mode) {
        this.updateWidgetMessageDisplay();
        if (mode != IWidgetAdapter.WidgetUpdateMode.DONT_UPDATE_VALUE) {
            String newValue;
            this.value = newValue = (String)this.getWidgetAdapter().getValue(mode);
            if (this.isEditable() && this.getWidgetAdapter().isModificationPermitted() && this.getWidgetAdapter().isModificationLocked()) {
                Text text = (Text)this.control;
                text.removeModifyListener((ModifyListener)this);
                text.setText(this.value);
                text.addModifyListener((ModifyListener)this);
            } else {
                Hyperlink link = (Hyperlink)this.control;
                link.setText(this.value);
            }
        }
    }

    @Override
    public void refreshWidget_internal() {
        if (this.widgetComposite != null) {
            Control[] children;
            FormToolkit toolkit = this.getFormToolkit();
            Control[] controlArray = children = this.widgetComposite.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control element = controlArray[n2];
                element.dispose();
                ++n2;
            }
            boolean isModificationPermitted = this.getWidgetAdapter().isModificationPermitted();
            boolean isModificationLocked = this.getWidgetAdapter().isModificationLocked();
            this.value = (String)this.getWidgetAdapter().getValue(IWidgetAdapter.WidgetUpdateMode.UPDATE_VALUE);
            if (this.isEditable() && isModificationPermitted && isModificationLocked) {
                this.createEditableControl(toolkit);
            } else {
                this.createUneditableControl(toolkit);
            }
            this.updateWidgetMessageDisplay();
            this.widgetComposite.pack();
        }
    }

    private void createEditableControl(FormToolkit toolkit) {
        toolkit.setBorderStyle(2048);
        Composite composite = toolkit.createComposite(this.widgetComposite);
        TableWrapData td = new TableWrapData(256);
        composite.setLayoutData((Object)td);
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        layout.topMargin = 0;
        layout.leftMargin = 0;
        layout.makeColumnsEqualWidth = false;
        composite.setLayout((Layout)layout);
        this.control = toolkit.createText(composite, this.value);
        this.control.setEnabled(true);
        ((Text)this.control).addModifyListener((ModifyListener)this);
        td = new TableWrapData(256);
        this.control.setLayoutData((Object)td);
        Hyperlink hyperLink = new Hyperlink(composite, 0);
        hyperLink.setBackground(this.widgetComposite.getBackground());
        hyperLink.setFont(this.widgetComposite.getFont());
        hyperLink.setForeground(Display.getDefault().getSystemColor(9));
        hyperLink.setText(Messages.getString("URLWidget.open", Locale.getDefault()));
        hyperLink.addHyperlinkListener((IHyperlinkListener)this);
        td = new TableWrapData(8);
        hyperLink.setLayoutData((Object)td);
        SimpleWidgetDropListener.addDropListenerToControl(this, 4, 8, this.control);
    }

    private void createUneditableControl(FormToolkit toolkit) {
        toolkit.setBorderStyle(2048);
        this.control = new Hyperlink(this.widgetComposite, 0);
        this.control.setBackground(this.widgetComposite.getBackground());
        this.control.setFont(this.widgetComposite.getFont());
        this.control.setForeground(Display.getDefault().getSystemColor(9));
        Hyperlink hyperlink = (Hyperlink)this.control;
        hyperlink.setText(this.value);
        hyperlink.addHyperlinkListener((IHyperlinkListener)this);
    }

    public void linkActivated(HyperlinkEvent e) {
        if (this.getWidgetAdapter().getErrorMessage() == null) {
            this.openURL();
        }
    }

    public void linkEntered(HyperlinkEvent e) {
    }

    public void linkExited(HyperlinkEvent e) {
    }

    public void modifyText(ModifyEvent e) {
        this.value = ((Text)this.control).getText();
        this.getWidgetAdapter().widgetModified();
    }

    public void openURL() {
        URL url = ((URLWidgetURLPropertyWidgetAdapter)this.getWidgetAdapter()).getValueAsURL();
        if (url != null) {
            IWorkbenchPage workbenchPage = this.getContainingWorkbenchPage();
            UrlLauncher.launchUrl_noEx(url, workbenchPage != null ? workbenchPage : EclipseSWTHelper.getWorkbenchPage(null));
        }
    }

    @Override
    public Object getContentsFromTransferAgent(TransferData transferData) {
        return this.transferAgent.nativeToJava(transferData);
    }

    @Override
    public Transfer getTransferAgent() {
        return this.transferAgent;
    }

    @Override
    public boolean hasCorrectObjectType(Object contents) {
        return (this.value == null || this.value.length() == 0) && contents instanceof URLTransfer.URLType;
    }

    @Override
    public void performDrop(Object contents) {
        URLTransfer.URLType url = (URLTransfer.URLType)contents;
        this.value = url.getUrl();
        if (this.control instanceof Text) {
            Text t = (Text)this.control;
            t.removeModifyListener((ModifyListener)this);
            t.setText(this.value);
            t.addModifyListener((ModifyListener)this);
        }
        this.getWidgetAdapter().widgetModified();
    }
}

