/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.uiframework.widgets;

import com.arcway.lib.eclipse.uiframework.widgets.AbstractDataWidget;
import com.arcway.lib.eclipse.uiframework.widgets.IEclipseCompositeWidget;
import com.arcway.lib.ui.editor.datatype.ICompositeWidget;
import com.arcway.lib.ui.editor.parameters.DateWidgetParameters;
import com.arcway.lib.ui.editor.parameters.WidgetParameters;
import com.arcway.lib.ui.editor.widgetAdapter.IDataWidgetAdapter;
import com.arcway.lib.ui.editor.widgetAdapter.IWidgetAdapter;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class DateWidget
extends AbstractDataWidget
implements SelectionListener {
    private DateTime dateControl;
    private DateTime timeControl;
    private Text textControl;
    private Composite widgetComposite;
    private Button button;
    private final boolean isWithTimeComponent;
    private final Calendar calender;

    public DateWidget(WidgetParameters parameters, ICompositeWidget parent, IDataWidgetAdapter adapter) {
        super(parameters, adapter, (IEclipseCompositeWidget)parent);
        assert (parent instanceof IEclipseCompositeWidget);
        this.isWithTimeComponent = ((DateWidgetParameters)parameters).isWithTimeComponent();
        this.calender = Calendar.getInstance(this.getCurrentPresentationContext().getTimeZone(), this.getContentLocale());
    }

    @Override
    public void createControl(Composite parentComposite) {
        FormToolkit toolkit = this.getFormToolkit();
        this.widgetComposite = toolkit.createComposite(parentComposite);
        TableWrapData td = new TableWrapData(256);
        td.valign = 32;
        this.widgetComposite.setLayoutData((Object)td);
        TableWrapLayout layout = new TableWrapLayout();
        layout.topMargin = 0;
        layout.leftMargin = 0;
        layout.rightMargin = 0;
        layout.bottomMargin = 0;
        layout.numColumns = 3;
        this.widgetComposite.setLayout((Layout)layout);
        Date value = (Date)this.getWidgetAdapter().getValue(IWidgetAdapter.WidgetUpdateMode.UPDATE_VALUE);
        boolean isModificationPermitted = this.getWidgetAdapter().isModificationPermitted();
        boolean isModificationLocked = this.getWidgetAdapter().isModificationLocked();
        if (!(this.isEditable() && isModificationPermitted && isModificationLocked)) {
            this.createUneditableControl(toolkit, value);
        } else {
            this.createEditableControl(value);
        }
    }

    @Override
    public void updateWidget_internal(IWidgetAdapter.WidgetUpdateMode mode) {
        if (mode != IWidgetAdapter.WidgetUpdateMode.DONT_UPDATE_VALUE) {
            Date value = (Date)this.getWidgetAdapter().getValue(mode);
            this.updateWidgetToValue(value);
        }
        this.updateWidgetMessageDisplay();
    }

    private void updateWidgetToValue(Date value) {
        if (!(this.isEditable() && this.getWidgetAdapter().isModificationPermitted() && this.getWidgetAdapter().isModificationLocked())) {
            assert (this.textControl != null);
            this.setDateForTextControl(value);
        } else {
            assert (this.dateControl != null);
            this.dateControl.removeSelectionListener((SelectionListener)this);
            this.dateControl.addSelectionListener((SelectionListener)this);
            this.dateControl.setEnabled(value != null);
            if (this.isWithTimeComponent) {
                assert (this.timeControl != null);
                this.timeControl.removeSelectionListener((SelectionListener)this);
                this.timeControl.addSelectionListener((SelectionListener)this);
                this.timeControl.setEnabled(value != null);
            }
            if (value != null) {
                this.setDateForDateControl(value);
            }
            if (this.button != null && !this.button.isDisposed()) {
                this.button.removeSelectionListener((SelectionListener)this);
                this.button.setSelection(value != null);
                this.button.addSelectionListener((SelectionListener)this);
            }
        }
    }

    @Override
    public void refreshWidget_internal() {
        if (this.widgetComposite != null) {
            Control[] children;
            FormToolkit toolkit = this.getFormToolkit();
            Control[] controlArray = children = this.widgetComposite.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control element = controlArray[n2];
                element.dispose();
                ++n2;
            }
            Date value = (Date)this.getWidgetAdapter().getValue(IWidgetAdapter.WidgetUpdateMode.UPDATE_VALUE);
            boolean isModificationPermitted = this.getWidgetAdapter().isModificationPermitted();
            boolean isModificationLocked = this.getWidgetAdapter().isModificationLocked();
            if (!(this.isEditable() && isModificationPermitted && isModificationLocked)) {
                this.createUneditableControl(toolkit, value);
            } else {
                this.createEditableControl(value);
            }
            this.updateWidgetMessageDisplay();
            this.widgetComposite.getParent().pack();
        }
    }

    public Object getCurrentValue() {
        if (this.isEditable() && this.getWidgetAdapter().isModificationPermitted() && this.getWidgetAdapter().isModificationLocked()) {
            assert (!(this.button == null || this.dateControl == null || this.isWithTimeComponent && this.timeControl == null));
            if (this.button.getSelection()) {
                return this.getDateFromDateControl();
            }
            return null;
        }
        assert (this.textControl != null);
        return this.getDateFromTextControl();
    }

    public void setValue(Object value) {
        Date val = (Date)value;
        if (val == null) {
            if (this.button.getSelection()) {
                this.button.setSelection(false);
                this.dateControl.setEnabled(false);
                if (this.isWithTimeComponent) {
                    this.timeControl.setEnabled(false);
                }
            }
        } else if (!this.button.getSelection()) {
            this.button.setSelection(true);
            this.dateControl.setEnabled(true);
            if (this.isWithTimeComponent) {
                this.timeControl.setEnabled(true);
            }
        }
        if (!(this.isEditable() && this.getWidgetAdapter().isModificationPermitted() && this.getWidgetAdapter().isModificationLocked())) {
            this.setDateForTextControl(val);
        } else if (value != null) {
            this.setDateForDateControl(val);
        }
    }

    private void createEditableControl(Date value) {
        this.button = new Button(this.widgetComposite, 32);
        this.button.setBackground(this.widgetComposite.getDisplay().getSystemColor(1));
        this.button.addSelectionListener((SelectionListener)this);
        TableWrapData td = new TableWrapData();
        td.valign = 32;
        this.button.setLayoutData((Object)td);
        this.dateControl = new DateTime(this.widgetComposite, 2080);
        td = new TableWrapData(256);
        td.maxWidth = 1;
        td.valign = 32;
        if (!this.isWithTimeComponent) {
            td.colspan = 2;
        }
        this.dateControl.setLayoutData((Object)td);
        this.dateControl.addSelectionListener((SelectionListener)this);
        if (this.isWithTimeComponent) {
            this.timeControl = new DateTime(this.widgetComposite, 2176);
            this.timeControl.addSelectionListener((SelectionListener)this);
            td = new TableWrapData(256);
            td.valign = 32;
            td.maxWidth = 1;
            this.timeControl.setLayoutData((Object)td);
        }
        this.updateWidgetToValue(value);
    }

    private void createUneditableControl(FormToolkit toolkit, Date value) {
        toolkit.setBorderStyle(0);
        this.textControl = toolkit.createText(this.widgetComposite, "", 8);
        this.setDateForTextControl(value);
        TableWrapData tdcontrol = new TableWrapData(256);
        tdcontrol.colspan = 3;
        this.textControl.setLayoutData((Object)tdcontrol);
    }

    private void setDateForDateControl(Date dateToSet) {
        assert (dateToSet != null);
        assert (this.dateControl != null);
        this.calender.setTime(dateToSet);
        this.dateControl.setYear(this.calender.get(1));
        this.dateControl.setMonth(this.calender.get(2));
        this.dateControl.setDay(this.calender.get(5));
        if (this.isWithTimeComponent) {
            assert (this.timeControl != null);
            this.timeControl.setHours(this.calender.get(11));
            this.timeControl.setMinutes(this.calender.get(12));
            this.timeControl.setSeconds(this.calender.get(13));
        }
    }

    private Date getDateFromDateControl() {
        assert (this.dateControl != null);
        this.calender.set(this.dateControl.getYear(), this.dateControl.getMonth(), this.dateControl.getDay());
        if (this.isWithTimeComponent) {
            this.calender.set(10, this.timeControl.getHours());
            this.calender.set(12, this.timeControl.getMinutes());
            this.calender.set(13, this.timeControl.getSeconds());
        }
        return this.calender.getTime();
    }

    private void setDateForTextControl(Date dateToSet) {
        assert (this.textControl != null);
        String date = dateToSet != null ? (this.isWithTimeComponent ? this.getCurrentPresentationContext().convertDateAndTimeWithoutSecondsToString(dateToSet, this.getContentLocale()) : this.getCurrentPresentationContext().convertDateWithoutTimeToString(dateToSet, this.getContentLocale())) : "-";
        this.textControl.setText(date);
    }

    private Date getDateFromTextControl() {
        Date date;
        block6: {
            assert (this.textControl != null);
            String dateSetInControl = this.textControl.getText();
            if (!dateSetInControl.equals("-")) {
                try {
                    if (this.isWithTimeComponent) {
                        date = this.getCurrentPresentationContext().convertStringToDateAndTimeWithoutSeconds(dateSetInControl, this.getContentLocale());
                        break block6;
                    }
                    date = this.getCurrentPresentationContext().convertStringToDateWithoutTime(dateSetInControl, this.getContentLocale());
                }
                catch (ParseException e) {
                    date = null;
                }
            } else {
                date = null;
            }
        }
        return date;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource() == this.button) {
            boolean isDateSet = this.button.getSelection();
            if (isDateSet) {
                this.updateWidgetToValue(this.getDateFromDateControl());
            } else {
                this.updateWidgetToValue(null);
            }
        }
        this.getWidgetAdapter().widgetModified();
    }
}

