/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.uiframework.widgets;

import com.arcway.lib.eclipse.uiframework.widgets.AbstractDataWidget;
import com.arcway.lib.eclipse.uiframework.widgets.IEclipseCompositeWidget;
import com.arcway.lib.ui.editor.datatype.ICompositeWidget;
import com.arcway.lib.ui.editor.parameters.WidgetParameters;
import com.arcway.lib.ui.editor.widgetAdapter.IDataWidgetAdapter;
import com.arcway.lib.ui.editor.widgetAdapter.IWidgetAdapter;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;

public abstract class AbstractStringWidget
extends AbstractDataWidget
implements ModifyListener {
    private StyledText control;
    private Composite parentComposite;

    public AbstractStringWidget(WidgetParameters parameters, IDataWidgetAdapter adapter, ICompositeWidget parent) {
        super(parameters, adapter, (IEclipseCompositeWidget)parent);
        assert (parent instanceof IEclipseCompositeWidget);
    }

    protected abstract StyledText createTextControl(Composite var1);

    protected abstract StyledText refreshTextControl(Composite var1);

    protected abstract String getValue(IWidgetAdapter.WidgetUpdateMode var1);

    @Override
    public void createControl(Composite parent) {
        this.parentComposite = parent;
        this.control = this.createTextControl(this.parentComposite);
    }

    @Override
    public void refreshWidget_internal() {
        if (this.parentComposite != null) {
            this.control.dispose();
            this.control = this.refreshTextControl(this.parentComposite);
            this.updateWidgetMessageDisplay();
            this.parentComposite.pack();
        }
    }

    @Override
    public void updateWidget_internal(IWidgetAdapter.WidgetUpdateMode mode) {
        if (mode != IWidgetAdapter.WidgetUpdateMode.DONT_UPDATE_VALUE && this.control != null) {
            String toBeValue = this.createToBeValue(mode);
            if (!this.control.getText().equals(toBeValue)) {
                this.control.removeModifyListener((ModifyListener)this);
                this.control.setText(toBeValue);
                this.control.addModifyListener((ModifyListener)this);
            }
        }
        this.updateWidgetMessageDisplay();
    }

    public Object getCurrentValue() {
        return this.control.getText();
    }

    public void setValue(Object value) {
        String valueToSet = (String)value;
        boolean isModificationPermitted = this.getWidgetAdapter().isModificationPermitted();
        boolean isModificationLocked = this.getWidgetAdapter().isModificationLocked();
        if (!(this.isEditable() && isModificationPermitted && isModificationLocked)) {
            this.control.setText(valueToSet);
        } else {
            if (valueToSet.equals("-")) {
                valueToSet = "";
            }
            this.control.setText(valueToSet);
        }
    }

    public void modifyText(ModifyEvent e) {
        this.getWidgetAdapter().widgetModified();
    }

    protected String createToBeValue(IWidgetAdapter.WidgetUpdateMode mode) {
        String value = this.getValue(mode);
        boolean isModificationPermitted = this.getWidgetAdapter().isModificationPermitted();
        boolean isModificationLocked = this.getWidgetAdapter().isModificationLocked();
        String toBeValue = !(this.isEditable() && isModificationPermitted && isModificationLocked || value != null && !value.equals("")) ? "-" : (value != null ? value : "");
        return toBeValue;
    }
}

