/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.resources;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.osgi.framework.Bundle;

public class ResourceLoader {
    private static final ILogger LOGGER = Logger.getLogger(ResourceLoader.class);

    public static URL getURL(Plugin plugin, String fileName) {
        return ResourceLoader.getURL(plugin.getBundle(), fileName);
    }

    public static URL getURL(String pluginID, String fileName) {
        return ResourceLoader.getURL(Platform.getBundle((String)pluginID), fileName);
    }

    private static URL getURL(Bundle bundle, String fileName) {
        URL url;
        try {
            URL installURL = bundle.getEntry("/");
            url = new URL(installURL, fileName);
        }
        catch (MalformedURLException e) {
            ResourceLoader.logFileNotFound(bundle.getSymbolicName(), fileName, e);
            url = null;
        }
        return url;
    }

    public static ImageDescriptor getImageDescriptor(Plugin plugin, String fileName) {
        return ResourceLoader.getImageDescriptor(plugin.getBundle(), fileName);
    }

    public static ImageDescriptor getImageDescriptor(String pluginID, String fileName) {
        return ResourceLoader.getImageDescriptor(Platform.getBundle((String)pluginID), fileName);
    }

    private static ImageDescriptor getImageDescriptor(Bundle bundle, String fileName) {
        URL url = ResourceLoader.getURL(bundle, fileName);
        if (url != null) {
            return ImageDescriptor.createFromURL((URL)url);
        }
        return null;
    }

    public static File getFile(Plugin plugin, String fileName) {
        return ResourceLoader.getFile(plugin.getBundle(), fileName);
    }

    public static File getFile(String pluginID, String fileName) {
        return ResourceLoader.getFile(Platform.getBundle((String)pluginID), fileName);
    }

    private static File getFile(Bundle bundle, String fileName) {
        URL url = ResourceLoader.getURL(bundle, fileName);
        if (url != null) {
            try {
                URL fileURLTransformed = FileLocator.toFileURL((URL)url);
                File file = new File(fileURLTransformed.getPath());
                return file;
            }
            catch (IOException ioE) {
                ResourceLoader.logFileNotFound(bundle.getSymbolicName(), fileName, ioE);
                return null;
            }
        }
        return null;
    }

    private static void logFileNotFound(String pluginID, String fileName, Exception e) {
        LOGGER.error("Can not find file: " + fileName + " in plugin " + pluginID, (Throwable)e);
    }
}

