/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.gui.viewers;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Table;

public class FixedColumnTable
extends Composite {
    private Composite fixedComposite;
    private Table fixedTableHeader;
    private Table fixedTable;
    private Table scrollableTable;
    private Runnable adjustmentStrategy = "win32".equals(SWT.getPlatform()) ? new Runnable(){

        @Override
        public void run() {
            FixedColumnTable.this.adjustFixedPartPositionWin32();
        }
    } : ("gtk".equals(SWT.getPlatform()) ? new Runnable(){

        @Override
        public void run() {
            FixedColumnTable.this.adjustFixedPartPositionGTK();
        }
    } : ("motif".equals(SWT.getPlatform()) ? new Runnable(){

        @Override
        public void run() {
            FixedColumnTable.this.adjustFixedPartPositionMotif();
        }
    } : new Runnable(){

        @Override
        public void run() {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)("Plattform \"" + SWT.getPlatform() + "\" is not supported by the FixedColumnTable."));
            }
        }
    }));

    public FixedColumnTable(Composite parent, int style) {
        super(parent, style);
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(4, 4, true, true, 1, 1));
        this.createFixedPart();
        this.createScrollablePart();
        this.registerListeners();
    }

    private void createFixedPart() {
        this.fixedComposite = new Composite(this, 0){

            public Point computeSize(int wHint, int hHint) {
                if (!($assertionsDisabled || FixedColumnTable.this.fixedTable != null && FixedColumnTable.this.fixedTableHeader != null)) {
                    throw new AssertionError((Object)"Fixed table and fixed table header must not be null.");
                }
                Point table = FixedColumnTable.this.fixedTable.computeSize(wHint, hHint);
                Point header = FixedColumnTable.this.fixedTableHeader.computeSize(wHint, hHint);
                return new Point(Math.max(table.x, header.x), table.y + header.y);
            }

            public Point computeSize(int wHint, int hHint, boolean changed) {
                if (!($assertionsDisabled || FixedColumnTable.this.fixedTable != null && FixedColumnTable.this.fixedTableHeader != null)) {
                    throw new AssertionError((Object)"Fixed table and fixed table header must not be null.");
                }
                Point table = FixedColumnTable.this.fixedTable.computeSize(wHint, hHint, changed);
                Point header = FixedColumnTable.this.fixedTableHeader.computeSize(wHint, hHint, changed);
                return new Point(Math.max(table.x, header.x), table.y + header.y);
            }
        };
        this.fixedComposite.setLayoutData((Object)new GridData(1, 4, false, true, 1, 1));
        this.fixedTableHeader = new Table(this.fixedComposite, 0);
        this.fixedTableHeader.setLocation(0, 0);
        this.fixedTableHeader.setHeaderVisible(true);
        this.fixedTable = new Table(this.fixedComposite, 65536);
        this.fixedTable.setLocation(0, this.fixedTableHeader.getHeaderHeight());
        this.fixedTable.setLinesVisible(true);
        this.fixedTable.setSize(0, Integer.MAX_VALUE);
        this.fixedTable.getVerticalBar().setVisible(false);
    }

    private void createScrollablePart() {
        this.scrollableTable = new Table((Composite)this, 65536);
        this.scrollableTable.setLinesVisible(true);
        this.scrollableTable.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.scrollableTable.setHeaderVisible(true);
    }

    private void registerListeners() {
        this.scrollableTable.getVerticalBar().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FixedColumnTable.this.adjustFixedPartPosition();
            }
        });
        this.scrollableTable.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                FixedColumnTable.this.adjustFixedPartPosition();
            }
        });
        this.scrollableTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!$assertionsDisabled && FixedColumnTable.this.fixedTable.getItemCount() != FixedColumnTable.this.scrollableTable.getItemCount()) {
                    throw new AssertionError((Object)("Both tables must contain the same number of items (fixed table: " + FixedColumnTable.this.fixedTable.getItemCount() + ", scrollable table:" + FixedColumnTable.this.scrollableTable.getItemCount() + ")."));
                }
                FixedColumnTable.this.fixedTable.setSelection(FixedColumnTable.this.scrollableTable.getSelectionIndex());
            }
        });
        this.fixedTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!$assertionsDisabled && FixedColumnTable.this.fixedTable.getItemCount() != FixedColumnTable.this.scrollableTable.getItemCount()) {
                    throw new AssertionError((Object)("Both tables must contain the same number of items (fixed table: " + FixedColumnTable.this.fixedTable.getItemCount() + ", scrollable table:" + FixedColumnTable.this.scrollableTable.getItemCount() + ")."));
                }
                FixedColumnTable.this.scrollableTable.setSelection(FixedColumnTable.this.fixedTable.getSelectionIndex());
                FixedColumnTable.this.scrollableTable.getVerticalBar().notifyListeners(13, new Event());
            }
        });
        this.fixedComposite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                FixedColumnTable.this.fixedTableHeader.setSize(((FixedColumnTable)FixedColumnTable.this).fixedComposite.getSize().x, FixedColumnTable.this.fixedTableHeader.getHeaderHeight());
                FixedColumnTable.this.fixedTable.setSize(((FixedColumnTable)FixedColumnTable.this).fixedComposite.getSize().x, ((FixedColumnTable)FixedColumnTable.this).fixedTable.getSize().y);
            }
        });
    }

    private void adjustFixedPartPosition() {
        assert (this.fixedTable.getItemCount() == this.scrollableTable.getItemCount()) : "Both tables must contain the same number of items (fixed table: " + this.fixedTable.getItemCount() + ", scrollable table:" + this.scrollableTable.getItemCount() + ").";
        this.adjustmentStrategy.run();
    }

    private void adjustFixedPartPositionWin32() {
        int index = this.scrollableTable.getTopIndex();
        int y = index * this.fixedTable.getItemHeight();
        this.fixedTable.setLocation(this.fixedTable.getLocation().x, this.fixedTableHeader.getHeaderHeight() - y);
    }

    private void adjustFixedPartPositionGTK() {
        ScrollBar bar = this.scrollableTable.getVerticalBar();
        if (bar != null && bar.isVisible()) {
            int itemHeight = this.scrollableTable.getItemHeight() + 2;
            int height = this.scrollableTable.getItemCount() * itemHeight;
            height -= this.scrollableTable.getClientArea().height;
            height = Math.max(0, height);
            int barRange = bar.getMaximum() - bar.getThumb();
            if (barRange > 0) {
                int y = bar.getSelection() * height / barRange;
                this.fixedTable.setLocation(this.fixedTable.getLocation().x, this.fixedTableHeader.getHeaderHeight() - y);
            }
        }
    }

    private void adjustFixedPartPositionMotif() {
        this.adjustFixedPartPositionWin32();
        if (this.scrollableTable.getHorizontalBar().isVisible()) {
            this.fixedTable.setLocation(this.fixedTable.getLocation().x, this.fixedTable.getLocation().y + 3);
        }
    }

    public Table getFixedTableHeader() {
        return this.fixedTableHeader;
    }

    public Table getFixedTable() {
        return this.fixedTable;
    }

    public Table getScrollableTable() {
        return this.scrollableTable;
    }

    public void setLinesVisible(boolean show) {
        this.getFixedTableHeader().setLinesVisible(show);
        this.getFixedTable().setLinesVisible(show);
        this.getScrollableTable().setLinesVisible(show);
    }

    public void setHeaderVisible(boolean show) {
        this.getFixedTableHeader().setHeaderVisible(show);
        this.getScrollableTable().setHeaderVisible(show);
    }

    public int getNumberOfFixedCols() {
        return 1;
    }
}

