/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.graphics.print;

import com.arcway.lib.eclipse.graphics.devicedrivers.DeviceDriverSWTGC;
import com.arcway.lib.eclipse.graphics.print.ISWTPrinterRequiringDispose;
import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Transformation;
import com.arcway.lib.geometry.TransformationAffiliate;
import com.arcway.lib.graphics.devicedrivers.IDeviceDriver;
import com.arcway.lib.graphics.print.IPrinter;
import com.arcway.lib.graphics.print.PrintingFailure;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Display;

public class SWTPrinter
implements IPrinter,
ISWTPrinterRequiringDispose {
    public static final Point SWT_DPI = Display.getDefault().getDPI();
    private final Printer printer;
    private final TransformationAffiliate mmToPrinter;
    private final TransformationAffiliate printerToMm;
    private DeviceDriverSWTGC driver;

    public SWTPrinter(PrinterData swtPrinterData) {
        this(new Printer(swtPrinterData));
    }

    public SWTPrinter(Printer p_printer) {
        assert (p_printer != null) : "printer is null";
        this.printer = p_printer;
        int dpi_hor = this.printer.getDPI().x;
        int dpi_ver = this.printer.getDPI().y;
        double FX = (double)dpi_hor / 25.4;
        double FY = (double)dpi_ver / 25.4;
        this.mmToPrinter = TransformationAffiliate.newTransformationScaling((GeoVector)new GeoVector(FX, FY));
        this.printerToMm = this.mmToPrinter.getInverse();
    }

    public com.arcway.lib.geometry.Rectangle getPageSize() {
        Rectangle paperBounds = this.printer.getBounds();
        Rectangle trim = this.printer.computeTrim(0, 0, 0, 0);
        com.arcway.lib.geometry.Rectangle pageSize = new com.arcway.lib.geometry.Rectangle((double)trim.x, (double)trim.y, (double)(trim.x + paperBounds.width), (double)(trim.y + paperBounds.height));
        return pageSize.transform((Transformation)this.printerToMm);
    }

    public com.arcway.lib.geometry.Rectangle getDrawingArea() {
        Rectangle rect = this.printer.getClientArea();
        com.arcway.lib.geometry.Rectangle pageSize = new com.arcway.lib.geometry.Rectangle((double)rect.x, (double)rect.y, (double)(rect.x + rect.width), (double)(rect.y + rect.height));
        return pageSize.transform((Transformation)this.printerToMm);
    }

    public void performJob(String jobName, IPrinter.IPrintingJobProcessor jobProcessor) throws PrintingFailure {
        this.printer.startJob(jobName);
        jobProcessor.processPrintingJob(new IPrinter.IPrintingJob(){

            public void drawPage(com.arcway.lib.geometry.Rectangle totalDrawingHint, IPrinter.IPagePrinter pagePrinter) throws PrintingFailure {
                SWTPrinter.this.printer.startPage();
                Rectangle clientArea = SWTPrinter.this.printer.getClientArea();
                Color black = new Color((Device)SWTPrinter.this.printer, 0, 0, 0);
                Color white = new Color((Device)SWTPrinter.this.printer, 255, 255, 255);
                GC gc = new GC((Drawable)SWTPrinter.this.printer);
                gc.setBackground(black);
                gc.fillRectangle(clientArea.x, clientArea.y, 2, clientArea.height);
                gc.setBackground(white);
                gc.fillRectangle(clientArea.x, clientArea.y, 2, clientArea.height);
                gc.dispose();
                black.dispose();
                white.dispose();
                boolean canUseAdvancedGraphicsAPI = true;
                SWTPrinter.this.driver = new DeviceDriverSWTGC((Device)SWTPrinter.this.printer, (Drawable)SWTPrinter.this.printer, canUseAdvancedGraphicsAPI);
                com.arcway.lib.graphics.device.Device device = new com.arcway.lib.graphics.device.Device((IDeviceDriver)SWTPrinter.this.driver, (Transformation)SWTPrinter.this.mmToPrinter);
                pagePrinter.printPage(device);
                SWTPrinter.this.driver.dispose();
                SWTPrinter.this.driver = null;
                SWTPrinter.this.printer.endPage();
            }
        });
        this.printer.endJob();
    }

    @Override
    public void dispose() {
        this.printer.dispose();
    }
}

