/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.graphics.image;

import com.arcway.lib.geometry.Point;
import com.arcway.lib.graphics.image.EXCorruptImageFileContent;
import com.arcway.lib.graphics.image.EXImageDataTypeNotSupported;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import java.io.IOException;
import java.io.InputStream;

public class JPEGResolutionFetcher {
    private static final ILogger LOGGER = Logger.getLogger(JPEGResolutionFetcher.class);
    private static final int APP0 = 65504;
    private static final int APP1 = 65505;
    private static final int COM = 65534;
    private static final int SOF0 = 65472;
    private static final int SOF3 = 65475;
    private static final int SOF5 = 65477;
    private static final int SOF7 = 65479;
    private static final int SOF9 = 65481;
    private static final int SOF11 = 65483;
    private static final int SOF13 = 65485;
    private static final int SOF15 = 65487;
    private static final int SOI = 65496;
    private static final byte[] APP0_ID_JFIF;
    private static final byte[] APP1_ID_Exif;
    private static final int TIFF_BO_LE = 18761;
    private static final int TIFF_BO_BE = 19789;
    private static final int TIFF_MAGIC = 42;
    private static final int TIFF_ATTR_DT_SHORT = 3;
    private static final int TIFF_ATTR_DT_RATIONAL = 5;
    private static final int TIFF_ATTR_XResolution = 282;
    private static final int TIFF_ATTR_YResolution = 283;
    private static final int TIFF_ATTR_ResolutionUnit = 296;
    private static final int TIFF_ATTR_ResolutionUnit_IN = 2;
    private static final int TIFF_ATTR_ResolutionUnit_CM = 3;

    static {
        byte[] byArray = new byte[5];
        byArray[0] = 74;
        byArray[1] = 70;
        byArray[2] = 73;
        byArray[3] = 70;
        APP0_ID_JFIF = byArray;
        byte[] byArray2 = new byte[6];
        byArray2[0] = 69;
        byArray2[1] = 120;
        byArray2[2] = 105;
        byArray2[3] = 102;
        APP1_ID_Exif = byArray2;
    }

    public static Point fetchResolutionInPixelsPerMeter(InputStream jfifStream) throws EXImageDataTypeNotSupported, JvmExternalResourceInteractionException, EXCorruptImageFileContent {
        try {
            JFIFAnalyser analyser = new JFIFAnalyser(jfifStream);
            Point point = analyser.fetchResolutionInPixelsPerMeter();
            return point;
        }
        catch (IOException e) {
            try {
                jfifStream.close();
            }
            catch (IOException e1) {
                LOGGER.error("IOException in exception handling", (Throwable)e1);
            }
            throw new JvmExternalResourceInteractionException((Throwable)e);
        }
        finally {
            if (jfifStream != null) {
                try {
                    jfifStream.close();
                }
                catch (IOException e1) {
                    LOGGER.error("Unable to close JFIF image data Stream", (Throwable)e1);
                }
            }
        }
    }

    private JPEGResolutionFetcher() {
    }

    private static class ExifTiffAnalyser {
        private final byte[] tiff;
        private final int byteOrder;
        boolean xResolution_specified = false;
        private long xResolutionNumerator = 0L;
        private long xResolutionDenominator = 0L;
        boolean yResolution_specified = false;
        private long yResolutionNumerator = 0L;
        private long yResolutionDenominator = 0L;
        boolean resolutionUnit_specified = false;
        private int resolutionUnit = 0;

        public ExifTiffAnalyser(int byteOrder, byte[] tiff) throws EXCorruptImageFileContent {
            this.byteOrder = byteOrder;
            this.tiff = tiff;
            int magic = this.getShortValueTiffByteOrder(2);
            if (magic != 42) {
                throw new EXCorruptImageFileContent("Invalid Exif Data - Invalid magic number in TIFF Header detected: " + Integer.toHexString(magic));
            }
            this.analyse();
        }

        private void analyse() throws EXCorruptImageFileContent {
            int IFD0_offset = (int)this.getUIntValueTiffByteOrder(4);
            int numberOfFields = this.getShortValueTiffByteOrder(IFD0_offset);
            int fieldNr = 0;
            while (fieldNr < numberOfFields) {
                int fieldOffset = IFD0_offset + 2 + 12 * fieldNr;
                int fieldTag = this.getShortValueTiffByteOrder(fieldOffset);
                int fieldType = this.getShortValueTiffByteOrder(fieldOffset + 2);
                long fieldValueCount = this.getUIntValueTiffByteOrder(fieldOffset + 4);
                switch (fieldTag) {
                    case 282: {
                        this.xResolution_specified = true;
                        if (fieldType != 5 || fieldValueCount != 1L) {
                            throw new EXCorruptImageFileContent("Invalid Exif Data - Invalid XResolution specification detected.");
                        }
                        int fieldValueOffset = (int)this.getUIntValueTiffByteOrder(fieldOffset + 8);
                        this.xResolutionNumerator = this.getUIntValueTiffByteOrder(fieldValueOffset);
                        this.xResolutionDenominator = this.getUIntValueTiffByteOrder(fieldValueOffset + 4);
                        break;
                    }
                    case 283: {
                        this.yResolution_specified = true;
                        if (fieldType != 5 || fieldValueCount != 1L) {
                            throw new EXCorruptImageFileContent("Invalid Exif Data - Invalid YResolution specification detected.");
                        }
                        int fieldValueOffset = (int)this.getUIntValueTiffByteOrder(fieldOffset + 8);
                        this.yResolutionNumerator = this.getUIntValueTiffByteOrder(fieldValueOffset);
                        this.yResolutionDenominator = this.getUIntValueTiffByteOrder(fieldValueOffset + 4);
                        break;
                    }
                    case 296: {
                        this.resolutionUnit_specified = true;
                        this.resolutionUnit = this.getShortValueTiffByteOrder(fieldOffset + 8);
                        if (fieldType == 3 && fieldValueCount == 1L && (this.resolutionUnit == 2 || this.resolutionUnit == 3)) break;
                        throw new EXCorruptImageFileContent("Invalid Exif Data - Invalid/Unknown ResolutionUnit specification detected.");
                    }
                }
                ++fieldNr;
            }
            if (!(!this.xResolution_specified && !this.yResolution_specified || this.xResolution_specified && this.yResolution_specified && this.resolutionUnit_specified)) {
                throw new EXCorruptImageFileContent("Invalid Exif Data - Incomplete Exif resolution specification data detected.");
            }
        }

        private long getUIntValueTiffByteOrder(int offs) {
            if (this.byteOrder == 18761) {
                return JFIFAnalyser.getUIntLittleEndian(this.tiff, offs);
            }
            assert (this.byteOrder == 19789);
            return JFIFAnalyser.getUIntBigEndian(this.tiff, offs);
        }

        private int getShortValueTiffByteOrder(int offs) {
            if (this.byteOrder == 18761) {
                return JFIFAnalyser.getShortLittleEndian(this.tiff, offs);
            }
            assert (this.byteOrder == 19789);
            return JFIFAnalyser.getShortBigEndian(this.tiff, offs);
        }
    }

    private static class JFIFAnalyser {
        private final InputStream in;
        private boolean jfif_app0_detected = false;
        private double jfif_app0_dpiX = 0.0;
        private double jfif_app0_dpiY = 0.0;
        private boolean exif_app1_detected = false;
        private ExifTiffAnalyser exifTiffAnalyser = null;

        public JFIFAnalyser(InputStream in) throws IOException, EXImageDataTypeNotSupported, EXCorruptImageFileContent {
            this.in = in;
            this.analyse();
        }

        public Point fetchResolutionInPixelsPerMeter() {
            Point exif_resolutionInPixelsPerMeter = null;
            if (this.exif_app1_detected) {
                if (this.exifTiffAnalyser.resolutionUnit_specified && this.exifTiffAnalyser.xResolution_specified && this.exifTiffAnalyser.yResolution_specified) {
                    double xResolution = (double)this.exifTiffAnalyser.xResolutionNumerator / (double)this.exifTiffAnalyser.xResolutionDenominator;
                    double yResolution = (double)this.exifTiffAnalyser.yResolutionNumerator / (double)this.exifTiffAnalyser.yResolutionDenominator;
                    if (this.exifTiffAnalyser.resolutionUnit == 3) {
                        exif_resolutionInPixelsPerMeter = new Point(xResolution / 100.0, yResolution / 100.0);
                    } else {
                        assert (this.exifTiffAnalyser.resolutionUnit == 2);
                        exif_resolutionInPixelsPerMeter = new Point(xResolution / 0.0254, yResolution / 0.0254);
                    }
                } else {
                    exif_resolutionInPixelsPerMeter = new Point(2834.645669291339, 2834.645669291339);
                }
            }
            Point jfif_resolutionInPixelsPerMeter = this.jfif_app0_dpiX == 0.0 || this.jfif_app0_dpiY == 0.0 ? null : new Point(this.jfif_app0_dpiX / 0.0254, this.jfif_app0_dpiY / 0.0254);
            if (exif_resolutionInPixelsPerMeter != null && jfif_resolutionInPixelsPerMeter != null) {
                double tolerance1Dpi = 39.37007874015748;
                if (Math.abs(exif_resolutionInPixelsPerMeter.x - jfif_resolutionInPixelsPerMeter.x) < tolerance1Dpi && Math.abs(exif_resolutionInPixelsPerMeter.y - jfif_resolutionInPixelsPerMeter.y) < tolerance1Dpi) {
                    return exif_resolutionInPixelsPerMeter;
                }
                return jfif_resolutionInPixelsPerMeter;
            }
            if (exif_resolutionInPixelsPerMeter != null) {
                return exif_resolutionInPixelsPerMeter;
            }
            return jfif_resolutionInPixelsPerMeter;
        }

        private boolean equals(byte[] a1, int offs1, byte[] a2, int offs2, int num) {
            int i = 0;
            while (i < num) {
                if (a1[offs1 + i] != a2[offs2 + i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        private static int getShortLittleEndian(byte[] a, int offs) {
            return a[offs] & 0xFF | (a[offs + 1] & 0xFF) << 8;
        }

        private static int getShortBigEndian(byte[] a, int offs) {
            return (a[offs] & 0xFF) << 8 | a[offs + 1] & 0xFF;
        }

        private static long getUIntBigEndian(byte[] a, int offs) {
            return ((long)a[offs] & 0xFFL) << 24 | ((long)a[offs + 1] & 0xFFL) << 16 | ((long)a[offs + 2] & 0xFFL) << 8 | (long)a[offs + 3] & 0xFFL;
        }

        private static long getUIntLittleEndian(byte[] a, int offs) {
            return ((long)a[offs + 3] & 0xFFL) << 24 | ((long)a[offs + 2] & 0xFFL) << 16 | ((long)a[offs + 1] & 0xFFL) << 8 | (long)a[offs] & 0xFFL;
        }

        private int read(byte[] a, int offset, int num) throws IOException {
            return this.in.read(a, offset, num);
        }

        private void skip(int num) throws IOException {
            int remainingBytesToSkip = num;
            while (remainingBytesToSkip > 0) {
                long result = this.in.skip(remainingBytesToSkip);
                if (result <= 0L) continue;
                remainingBytesToSkip = (int)((long)remainingBytesToSkip - result);
            }
        }

        private void analyse() throws IOException, EXImageDataTypeNotSupported, EXCorruptImageFileContent {
            byte[] data = new byte[12];
            if (this.read(data, 0, 2) != 2 || JFIFAnalyser.getShortBigEndian(data, 0) != 65496) {
                throw new EXImageDataTypeNotSupported("Invalid JPEG/JFIF file header \"type\": " + Integer.toHexString(JFIFAnalyser.getShortBigEndian(data, 0)));
            }
            while (true) {
                if (this.read(data, 0, 4) != 4) {
                    throw new EXCorruptImageFileContent("Incomplete JFIF Tag/Segment Header detected.");
                }
                int marker = JFIFAnalyser.getShortBigEndian(data, 0);
                int size = JFIFAnalyser.getShortBigEndian(data, 2);
                if ((marker & 0xFF00) != 65280) {
                    throw new EXCorruptImageFileContent("Invalid JFIF Segment Header detected: " + Integer.toHexString(marker));
                }
                if (marker == 65504) {
                    this.jfif_app0_detected = true;
                    if (size < 14) {
                        throw new EXCorruptImageFileContent("APP0 Segment with invalid size detected (size=" + size + "), expected size of at least 14 bytes.");
                    }
                    if (this.read(data, 0, 12) != 12) {
                        throw new EXCorruptImageFileContent("Truncated APP0 Segment detected.");
                    }
                    if (this.equals(APP0_ID_JFIF, 0, data, 0, 5)) {
                        if (data[7] == 1) {
                            this.jfif_app0_dpiX = JFIFAnalyser.getShortBigEndian(data, 8);
                            this.jfif_app0_dpiY = JFIFAnalyser.getShortBigEndian(data, 10);
                        } else if (data[7] == 2) {
                            int x = JFIFAnalyser.getShortBigEndian(data, 8);
                            int y = JFIFAnalyser.getShortBigEndian(data, 10);
                            this.jfif_app0_dpiX = (double)x * 2.54;
                            this.jfif_app0_dpiY = (double)y * 2.54;
                        }
                    }
                    this.skip(size - 14);
                    continue;
                }
                if (marker == 65505) {
                    assert (APP1_ID_Exif.length == 6);
                    if (this.read(data, 0, 6) != 6 || !this.equals(APP1_ID_Exif, 0, data, 0, 6)) {
                        assert (false) : "Expected a vaild Exif segment here.";
                        this.skip(size - 8);
                        continue;
                    }
                    this.exif_app1_detected = true;
                    byte[] tiff = new byte[size - 8];
                    if (this.read(tiff, 0, tiff.length) != tiff.length) {
                        throw new EXCorruptImageFileContent("Truncated APP1/Exif Segment detected.");
                    }
                    if (tiff.length < 8) {
                        throw new EXCorruptImageFileContent("Invalid Exif Data - TIFF Header missing or incomplete.");
                    }
                    int byteOrder = JFIFAnalyser.getShortBigEndian(tiff, 0);
                    if (byteOrder != 18761 && byteOrder != 19789) {
                        throw new EXCorruptImageFileContent("Invalid Exif Data - Invalid byteOrder in TIFF Header detected: " + Integer.toHexString(byteOrder));
                    }
                    try {
                        this.exifTiffAnalyser = new ExifTiffAnalyser(byteOrder, tiff);
                    }
                    catch (Exception e) {
                        throw new EXCorruptImageFileContent("Invalid Exif Data - Invalid TIFF Data detected.", (Throwable)e);
                    }
                }
                if (size > 2 && marker == 65534) {
                    this.skip(size - 2);
                    continue;
                }
                if (marker >= 65472 && marker <= 65475 || marker >= 65477 && marker <= 65479 || marker >= 65481 && marker <= 65483 || marker >= 65485 && marker <= 65487) {
                    if (this.read(data, 0, 6) != 6) {
                        throw new EXCorruptImageFileContent("Truncated \"Start of Frame (SOF)\" Segment Header detected.");
                    }
                    return;
                }
                this.skip(size - 2);
            }
        }
    }
}

