/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.file;

import com.arcway.lib.eclipse.file.ExNoOSHandlerFound;
import com.arcway.lib.eclipse.file.UrlLauncher;
import com.arcway.lib.eclipse.plugin.PathEditorInputEditorsExtensionPoint;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class EclipseFileHelper {
    private static final ILogger LOGGER = Logger.getLogger(UrlLauncher.class);

    @Deprecated
    public static void openFileInOS(File file, IWorkbenchPage page) throws ExNoOSHandlerFound {
        assert (file != null);
        boolean successfullyOpenedInternalEditor = EclipseFileHelper.openFileInInternalEditorIfAvailable(file, page);
        if (!successfullyOpenedInternalEditor) {
            try {
                PathEditorInput input = new PathEditorInput(file);
                page.openEditor((IEditorInput)input, "org.eclipse.ui.systemExternalEditor");
            }
            catch (PartInitException e) {
                throw new ExNoOSHandlerFound(file, (Throwable)e);
            }
        }
    }

    public static boolean openFileInInternalEditorIfAvailable(File file, IWorkbenchPage page) {
        assert (file != null);
        IEditorDescriptor[] editorDescriptors = PlatformUI.getWorkbench().getEditorRegistry().getEditors(file.getAbsolutePath());
        IEditorDescriptor lauchedEditorDescriptor = null;
        int i = 0;
        while (lauchedEditorDescriptor == null && i < editorDescriptors.length) {
            IEditorDescriptor currentEditorDescriptor = editorDescriptors[i];
            if (PathEditorInputEditorsExtensionPoint.getInstance().getIDs().contains((Object)currentEditorDescriptor.getId())) {
                try {
                    PathEditorInput input = new PathEditorInput(file);
                    page.openEditor((IEditorInput)input, currentEditorDescriptor.getId());
                    lauchedEditorDescriptor = currentEditorDescriptor;
                }
                catch (PartInitException e) {
                    LOGGER.warn("Attempt to open internal Editor with id " + currentEditorDescriptor.getId() + " for input file " + file + " failed.");
                }
            }
            ++i;
        }
        boolean successfullyOpenedInternalEditor = lauchedEditorDescriptor != null;
        return successfullyOpenedInternalEditor;
    }

    private static class PathEditorInput
    implements IPathEditorInput {
        private final File file;

        public PathEditorInput(File file) {
            this.file = file;
        }

        public int hashCode() {
            return this.getPath().hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof IPathEditorInput) {
                return this.getPath().equals((Object)((IPathEditorInput)obj).getPath());
            }
            return false;
        }

        public IPath getPath() {
            return new Path(this.file.getAbsolutePath());
        }

        public boolean exists() {
            return this.file.exists();
        }

        public ImageDescriptor getImageDescriptor() {
            return null;
        }

        public String getName() {
            return this.file.getName();
        }

        public IPersistableElement getPersistable() {
            return null;
        }

        public String getToolTipText() {
            return this.file.getAbsolutePath();
        }

        public Object getAdapter(Class adapter) {
            return null;
        }
    }
}

