/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.ole.win32;

import org.eclipse.swt.SWTException;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.DISPPARAMS;
import org.eclipse.swt.internal.ole.win32.EXCEPINFO;
import org.eclipse.swt.internal.ole.win32.GUID;
import org.eclipse.swt.internal.ole.win32.IDispatch;
import org.eclipse.swt.internal.ole.win32.VARIANT;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.ole.win32.IOleAutomationAW;
import org.eclipse.swt.ole.win32.OLE;
import org.eclipse.swt.ole.win32.Variant;
import org.eclipse.swt.ole.win32.VariantAW;

public final class OleAutomationAW
implements IOleAutomationAW {
    private final IDispatch objIDispatch;
    private String exceptionDescription;

    public OleAutomationAW(IDispatch idispatch) {
        if (idispatch == null) {
            OLE.error((int)1011);
        }
        this.objIDispatch = idispatch;
    }

    @Override
    public int[] getIDsOfNames(String[] names) {
        int[] rgdispid = new int[names.length];
        int result = this.objIDispatch.GetIDsOfNames(new GUID(), names, names.length, 2048, rgdispid);
        if (result != 0) {
            OleAutomationAW.oleError(result, this.exceptionDescription);
        }
        return rgdispid;
    }

    @Override
    public String getLastError() {
        return this.exceptionDescription;
    }

    @Override
    public Variant getProperty(int dispIdMember) {
        Variant[] pVarResult = new Variant[1];
        int result = this.invoke(dispIdMember, 2, null, null, pVarResult);
        if (result != 0) {
            OleAutomationAW.oleError(result, this.exceptionDescription);
        }
        return pVarResult[0];
    }

    @Override
    public Variant getProperty(int dispIdMember, Variant[] rgvarg) {
        Variant[] pVarResult = new Variant[1];
        int result = this.invoke(dispIdMember, 2, rgvarg, null, pVarResult);
        if (result != 0) {
            OleAutomationAW.oleError(result, this.exceptionDescription);
        }
        return pVarResult[0];
    }

    @Override
    public Variant getProperty(int dispIdMember, Variant[] rgvarg, int[] rgdispidNamedArgs) {
        Variant[] pVarResult = new Variant[1];
        int result = this.invoke(dispIdMember, 2, rgvarg, rgdispidNamedArgs, pVarResult);
        if (result != 0) {
            OleAutomationAW.oleError(result, this.exceptionDescription);
        }
        return pVarResult[0];
    }

    @Override
    public Variant invoke(int dispIdMember) {
        Variant[] pVarResult = new Variant[1];
        int result = this.invoke(dispIdMember, 1, null, null, pVarResult);
        if (result != 0) {
            OleAutomationAW.oleError(result, this.exceptionDescription);
        }
        return pVarResult[0];
    }

    @Override
    public Variant invoke(int dispIdMember, Variant[] rgvarg) {
        Variant[] pVarResult = new Variant[1];
        int result = this.invoke(dispIdMember, 1, rgvarg, null, pVarResult);
        if (result != 0) {
            OleAutomationAW.oleError(result, this.exceptionDescription);
        }
        return pVarResult[0];
    }

    @Override
    public Variant invoke(int dispIdMember, Variant[] rgvarg, int[] rgdispidNamedArgs) {
        Variant[] pVarResult = new Variant[1];
        int result = this.invoke(dispIdMember, 1, rgvarg, rgdispidNamedArgs, pVarResult);
        if (result != 0) {
            OleAutomationAW.oleError(result, this.exceptionDescription);
        }
        return pVarResult[0];
    }

    private int invoke(int dispIdMember, int wFlags, Variant[] rgvarg, int[] rgdispidNamedArgs, Variant[] pVarResult) {
        int i;
        int offset;
        if (this.objIDispatch == null) {
            return -2147467259;
        }
        DISPPARAMS pDispParams = new DISPPARAMS();
        if (rgvarg != null && rgvarg.length > 0) {
            pDispParams.cArgs = rgvarg.length;
            pDispParams.rgvarg = OS.GlobalAlloc((int)64, (int)(VARIANT.sizeof * rgvarg.length));
            offset = 0;
            i = rgvarg.length - 1;
            while (i >= 0) {
                VariantAW.getData(rgvarg[i], pDispParams.rgvarg + offset);
                offset += VARIANT.sizeof;
                --i;
            }
        }
        if (rgdispidNamedArgs != null && rgdispidNamedArgs.length > 0) {
            pDispParams.cNamedArgs = rgdispidNamedArgs.length;
            pDispParams.rgdispidNamedArgs = OS.GlobalAlloc((int)64, (int)(4 * rgdispidNamedArgs.length));
            offset = 0;
            i = rgdispidNamedArgs.length;
            while (i > 0) {
                COM.MoveMemory((int)(pDispParams.rgdispidNamedArgs + offset), (int[])new int[]{rgdispidNamedArgs[i - 1]}, (int)4);
                offset += 4;
                --i;
            }
        }
        EXCEPINFO excepInfo = new EXCEPINFO();
        int[] pArgErr = new int[1];
        int pVarResultAddress = 0;
        if (pVarResult != null) {
            pVarResultAddress = OS.GlobalAlloc((int)64, (int)VARIANT.sizeof);
        }
        int result = this.objIDispatch.Invoke(dispIdMember, new GUID(), 2048, wFlags, pDispParams, pVarResultAddress, excepInfo, pArgErr);
        if (pVarResultAddress != 0) {
            pVarResult[0] = Variant.win32_new((int)pVarResultAddress);
            COM.VariantClear((int)pVarResultAddress);
            OS.GlobalFree((int)pVarResultAddress);
        }
        if (pDispParams.rgdispidNamedArgs != 0) {
            OS.GlobalFree((int)pDispParams.rgdispidNamedArgs);
        }
        if (pDispParams.rgvarg != 0) {
            int offset2 = 0;
            int i2 = 0;
            int length = rgvarg.length;
            while (i2 < length) {
                COM.VariantClear((int)(pDispParams.rgvarg + offset2));
                offset2 += VARIANT.sizeof;
                ++i2;
            }
            OS.GlobalFree((int)pDispParams.rgvarg);
        }
        this.manageExcepinfo(result, excepInfo);
        return result;
    }

    @Override
    public void invokeNoReply(int dispIdMember) {
        int result = this.invoke(dispIdMember, 1, null, null, null);
        if (result != 0) {
            OleAutomationAW.oleError(result, this.exceptionDescription);
        }
    }

    @Override
    public void invokeNoReply(int dispIdMember, Variant[] rgvarg) {
        int result = this.invoke(dispIdMember, 1, rgvarg, null, null);
        if (result != 0) {
            OleAutomationAW.oleError(result, this.exceptionDescription);
        }
    }

    @Override
    public void invokeNoReply(int dispIdMember, Variant[] rgvarg, int[] rgdispidNamedArgs) {
        int result = this.invoke(dispIdMember, 1, rgvarg, rgdispidNamedArgs, null);
        if (result != 0) {
            OleAutomationAW.oleError(result, this.exceptionDescription);
        }
    }

    private void manageExcepinfo(int hResult, EXCEPINFO excepInfo) {
        if (hResult == 0) {
            this.exceptionDescription = "No Error";
            return;
        }
        if (hResult == -2147352567) {
            if (excepInfo.bstrDescription != 0) {
                int size = COM.SysStringByteLen((int)excepInfo.bstrDescription);
                char[] buffer = new char[(size + 1) / 2];
                COM.MoveMemory((char[])buffer, (int)excepInfo.bstrDescription, (int)size);
                this.exceptionDescription = new String(buffer);
            } else {
                this.exceptionDescription = "OLE Automation Error Exception ";
                if (excepInfo.wCode != 0) {
                    this.exceptionDescription = String.valueOf(this.exceptionDescription) + "code = " + excepInfo.wCode;
                } else if (excepInfo.scode != 0) {
                    this.exceptionDescription = String.valueOf(this.exceptionDescription) + "code = " + excepInfo.scode;
                }
            }
        } else {
            this.exceptionDescription = "OLE Automation Error HResult : " + hResult;
        }
        if (excepInfo.bstrDescription != 0) {
            COM.SysFreeString((int)excepInfo.bstrDescription);
        }
        if (excepInfo.bstrHelpFile != 0) {
            COM.SysFreeString((int)excepInfo.bstrHelpFile);
        }
        if (excepInfo.bstrSource != 0) {
            COM.SysFreeString((int)excepInfo.bstrSource);
        }
    }

    @Override
    public void setProperty(int dispIdMember, Variant rgvarg) {
        Variant[] rgvarg2 = new Variant[]{rgvarg};
        int[] rgdispidNamedArgs = new int[]{-3};
        int dwFlags = 4;
        if ((rgvarg.getType() & 0x4000) == 16384) {
            dwFlags = 8;
        }
        Variant[] pVarResult = new Variant[1];
        int result = this.invoke(dispIdMember, dwFlags, rgvarg2, rgdispidNamedArgs, pVarResult);
        assert (pVarResult[0].getType() == 0);
        if (result != 0) {
            OleAutomationAW.oleError(result, this.exceptionDescription);
        }
    }

    @Override
    public void setProperty(int dispIdMember, Variant[] rgvarg) {
        int[] rgdispidNamedArgs = new int[]{-3};
        int dwFlags = 4;
        int i = 0;
        while (i < rgvarg.length) {
            if ((rgvarg[i].getType() & 0x4000) == 16384) {
                dwFlags = 8;
            }
            ++i;
        }
        Variant[] pVarResult = new Variant[1];
        int result = this.invoke(dispIdMember, dwFlags, rgvarg, rgdispidNamedArgs, pVarResult);
        assert (pVarResult[0].getType() == 0);
        if (result != 0) {
            OleAutomationAW.oleError(result, this.exceptionDescription);
        }
    }

    private static void oleError(int hresult, String exceptionDescription) {
        String msg = exceptionDescription;
        if (hresult != 0) {
            msg = String.valueOf(msg) + " (result = " + hresult + ")";
        }
        throw new SWTException(1014, msg);
    }
}

