/*
 * Decompiled with CFR 0.152.
 */
package au.com.swz.swttocom.swt.types;

import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.ole.win32.Variant;
import org.eclipse.swt.widgets.Display;

public class OleColor {
    private int oleColor;

    public OleColor(Variant vOleColor) {
        this.oleColor = vOleColor.getType() == 4 ? Float.floatToIntBits(vOleColor.getFloat()) : vOleColor.getInt();
    }

    public OleColor(int oleColor) {
        this.oleColor = oleColor;
    }

    public OleColor(Color color) {
        this(color.getRGB());
    }

    public OleColor(RGB rgb) {
        this(rgb.red, rgb.green, rgb.red);
    }

    public OleColor(int red, int green, int blue) {
        this.oleColor = blue << 16 | green << 8 | red;
    }

    public int getOleColor() {
        return this.oleColor;
    }

    public Color getSwtColor() {
        return this.getSwtColor(Display.getDefault());
    }

    public Color getSwtColor(Display display) {
        if ((this.oleColor & 0xFF000000) >> 24 == 128) {
            int systemColor = this.oleColor & 0xFFFFFF;
            if (systemColor == OS.COLOR_3DDKSHADOW) {
                return display.getSystemColor(17);
            }
            if (systemColor == OS.COLOR_3DSHADOW) {
                return display.getSystemColor(18);
            }
            if (systemColor == OS.COLOR_3DLIGHT) {
                return display.getSystemColor(19);
            }
            if (systemColor == OS.COLOR_3DHIGHLIGHT) {
                return display.getSystemColor(20);
            }
            if (systemColor == OS.COLOR_3DFACE) {
                return display.getSystemColor(22);
            }
            if (systemColor == OS.COLOR_WINDOWFRAME) {
                return display.getSystemColor(23);
            }
            if (systemColor == OS.COLOR_WINDOWTEXT) {
                return display.getSystemColor(21);
            }
            if (systemColor == OS.COLOR_WINDOW) {
                return display.getSystemColor(25);
            }
            if (systemColor == OS.COLOR_HIGHLIGHT) {
                return display.getSystemColor(26);
            }
            if (systemColor == OS.COLOR_HIGHLIGHTTEXT) {
                return display.getSystemColor(27);
            }
            if (systemColor == OS.COLOR_INFOTEXT) {
                return display.getSystemColor(28);
            }
            if (systemColor == OS.COLOR_INFOBK) {
                return display.getSystemColor(29);
            }
            if (systemColor == OS.COLOR_CAPTIONTEXT) {
                return display.getSystemColor(30);
            }
            if (systemColor == OS.COLOR_ACTIVECAPTION) {
                return display.getSystemColor(31);
            }
            if (systemColor == OS.COLOR_ACTIVECAPTION) {
                return display.getSystemColor(32);
            }
            if (systemColor == OS.COLOR_INACTIVECAPTIONTEXT) {
                return display.getSystemColor(33);
            }
            if (systemColor == OS.COLOR_INACTIVECAPTION) {
                return display.getSystemColor(34);
            }
            if (systemColor == OS.COLOR_GRADIENTINACTIVECAPTION) {
                return display.getSystemColor(35);
            }
            throw new SWTException("Failed to convert OLE_COLOR to SWT Color");
        }
        if ((this.oleColor & 0xFF000000) >> 24 == 0) {
            int blue = (this.oleColor & 0xFF0000) >> 16;
            int green = (this.oleColor & 0xFF00) >> 8;
            int red = this.oleColor & 0xFF;
            return new Color((Device)display, red, green, blue);
        }
        throw new SWTException("Failed to convert OLE_COLOR to SWT Color");
    }
}

