/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.ole.excel.impl;

import au.com.swz.swttocom.swt.ResourceManager;
import au.com.swz.swttocom.swt.types.AbstractOleEventsListener;
import au.com.swz.swttocom.swt.types.pointer.BooleanPointer;
import com.arcway.lib.eclipse.ole.excel.ChartEvents;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.swt.ole.win32.OleEvent;
import org.eclipse.swt.ole.win32.Variant;

public class ChartEventsListener
extends AbstractOleEventsListener {
    private final Set<ChartEvents> listeners = new HashSet<ChartEvents>();

    public ChartEventsListener(ResourceManager resourceManager) {
        super(resourceManager);
    }

    public boolean addListener(ChartEvents listener) {
        return this.listeners.add(listener);
    }

    public boolean removeListener(ChartEvents listener) {
        return this.listeners.remove(listener);
    }

    public boolean isEmpty() {
        return this.listeners.isEmpty();
    }

    public void handleEvent(OleEvent oleEvent) {
        Variant[] arguments;
        switch (oleEvent.type) {
            case 304: {
                this.fireActivate(oleEvent);
                break;
            }
            case 1530: {
                this.fireDeactivate(oleEvent);
                break;
            }
            case 256: {
                this.fireResize(oleEvent);
                break;
            }
            case 1531: {
                this.fireMouseDown(oleEvent);
                break;
            }
            case 1532: {
                this.fireMouseUp(oleEvent);
                break;
            }
            case 1533: {
                this.fireMouseMove(oleEvent);
                break;
            }
            case 1534: {
                this.fireBeforeRightClick(oleEvent);
                break;
            }
            case 1535: {
                this.fireDragPlot(oleEvent);
                break;
            }
            case 1536: {
                this.fireDragOver(oleEvent);
                break;
            }
            case 1537: {
                this.fireBeforeDoubleClick(oleEvent);
                break;
            }
            case 235: {
                this.fireSelect(oleEvent);
                break;
            }
            case 1538: {
                this.fireSeriesChange(oleEvent);
                break;
            }
            case 279: {
                this.fireCalculate(oleEvent);
            }
        }
        Variant[] variantArray = arguments = oleEvent.arguments;
        int n = arguments.length;
        int n2 = 0;
        while (n2 < n) {
            Variant argument = variantArray[n2];
            argument.dispose();
            ++n2;
        }
    }

    private void fireActivate(OleEvent oleEvent) {
        for (ChartEvents l : this.listeners) {
            l.Activate();
        }
    }

    private void fireDeactivate(OleEvent oleEvent) {
        for (ChartEvents l : this.listeners) {
            l.Deactivate();
        }
    }

    private void fireResize(OleEvent oleEvent) {
        for (ChartEvents l : this.listeners) {
            l.Resize();
        }
    }

    private void fireMouseDown(OleEvent oleEvent) {
        int button = oleEvent.arguments[0].getInt();
        int shift = oleEvent.arguments[1].getInt();
        int x = oleEvent.arguments[2].getInt();
        int y = oleEvent.arguments[3].getInt();
        for (ChartEvents l : this.listeners) {
            l.MouseDown(button, shift, x, y);
        }
    }

    private void fireMouseUp(OleEvent oleEvent) {
        int button = oleEvent.arguments[0].getInt();
        int shift = oleEvent.arguments[1].getInt();
        int x = oleEvent.arguments[2].getInt();
        int y = oleEvent.arguments[3].getInt();
        for (ChartEvents l : this.listeners) {
            l.MouseUp(button, shift, x, y);
        }
    }

    private void fireMouseMove(OleEvent oleEvent) {
        int button = oleEvent.arguments[0].getInt();
        int shift = oleEvent.arguments[1].getInt();
        int x = oleEvent.arguments[2].getInt();
        int y = oleEvent.arguments[3].getInt();
        for (ChartEvents l : this.listeners) {
            l.MouseMove(button, shift, x, y);
        }
    }

    private void fireBeforeRightClick(OleEvent oleEvent) {
        BooleanPointer cancel = new BooleanPointer(oleEvent.arguments[0].getByRef(), this.getResourceManager());
        for (ChartEvents l : this.listeners) {
            l.BeforeRightClick(cancel);
        }
        cancel.setAddress(0);
    }

    private void fireDragPlot(OleEvent oleEvent) {
        for (ChartEvents l : this.listeners) {
            l.DragPlot();
        }
    }

    private void fireDragOver(OleEvent oleEvent) {
        for (ChartEvents l : this.listeners) {
            l.DragOver();
        }
    }

    private void fireBeforeDoubleClick(OleEvent oleEvent) {
        int elementID = oleEvent.arguments[0].getInt();
        int arg1 = oleEvent.arguments[1].getInt();
        int arg2 = oleEvent.arguments[2].getInt();
        BooleanPointer cancel = new BooleanPointer(oleEvent.arguments[3].getByRef(), this.getResourceManager());
        for (ChartEvents l : this.listeners) {
            l.BeforeDoubleClick(elementID, arg1, arg2, cancel);
        }
        cancel.setAddress(0);
    }

    private void fireSelect(OleEvent oleEvent) {
        int elementID = oleEvent.arguments[0].getInt();
        int arg1 = oleEvent.arguments[1].getInt();
        int arg2 = oleEvent.arguments[2].getInt();
        for (ChartEvents l : this.listeners) {
            l.Select(elementID, arg1, arg2);
        }
    }

    private void fireSeriesChange(OleEvent oleEvent) {
        int seriesIndex = oleEvent.arguments[0].getInt();
        int pointIndex = oleEvent.arguments[1].getInt();
        for (ChartEvents l : this.listeners) {
            l.SeriesChange(seriesIndex, pointIndex);
        }
    }

    private void fireCalculate(OleEvent oleEvent) {
        for (ChartEvents l : this.listeners) {
            l.Calculate();
        }
    }
}

