/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.adapter.excel.imports;

import au.com.swz.swttocom.swt.ResourceManager;
import au.com.swz.swttocom.swt.types.AutomationObjectImpl;
import com.arcway.lib.eclipse.adapter.excel.ExcelBugWorkarounds;
import com.arcway.lib.eclipse.adapter.excel.ExcelConstants;
import com.arcway.lib.eclipse.adapter.excel.ExcelImportExportException;
import com.arcway.lib.eclipse.adapter.excel.ExcelUtils;
import com.arcway.lib.eclipse.adapter.excel.Messages;
import com.arcway.lib.eclipse.adapter.excel.imports.ColumnDescription;
import com.arcway.lib.eclipse.adapter.excel.imports.ImportedSheet;
import com.arcway.lib.eclipse.adapter.excel.imports.ImportedSheetType;
import com.arcway.lib.eclipse.ole.excel.Application;
import com.arcway.lib.eclipse.ole.excel.Range;
import com.arcway.lib.eclipse.ole.excel.Workbook;
import com.arcway.lib.eclipse.ole.excel.Workbooks;
import com.arcway.lib.eclipse.ole.excel.Worksheet;
import com.arcway.lib.eclipse.ole.excel._Application;
import com.arcway.lib.eclipse.ole.excel.util.MSExcelVersionAndSettingsHelper;
import com.arcway.lib.java.real.RealParser;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.localisation.DateFormatHelper;
import de.plans.lib.util.gui.IProgressDisplay;
import java.io.File;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import org.eclipse.swt.SWTException;

public class GenericExcelListImporter {
    private static final ILogger logger = Logger.getLogger(GenericExcelListImporter.class);
    public static final String IMPORTED_DATATYPE_ANY = "Any";
    public static final String IMPORTED_DATATYPE_STRING_SINGLELINE = "SingleLineString";
    public static final String IMPORTED_DATATYPE_STRING_MULTILINE = "MultiLineString";
    public static final String IMPORTED_DATATYPE_REAL = "Real";
    public static final String IMPORTED_DATATYPE_INTEGER = "Integer";
    public static final String IMPORTED_DATATYPE_DATE = "Date";
    public static final String IMPORTED_DATATYPE_BOOLEAN = "Boolean";
    public static final String IMPORTED_DATATYPE_ANY_LABEL = Messages.getString("ImportedDataType.Label.Any");
    public static final String IMPORTED_DATATYPE_STRING_SINGLELINE_LABEL = Messages.getString("ImportedDataType.Label.SingleLineString");
    public static final String IMPORTED_DATATYPE_STRING_MULTILINE_LABEL = Messages.getString("ImportedDataType.Label.MultiLineString");
    public static final String IMPORTED_DATATYPE_REAL_LABEL = Messages.getString("ImportedDataType.Label.Real");
    public static final String IMPORTED_DATATYPE_INTEGER_LABEL = Messages.getString("ImportedDataType.Label.Integer");
    public static final String IMPORTED_DATATYPE_DATE_LABEL = Messages.getString("ImportedDataType.Label.Date");
    public static final String IMPORTED_DATATYPE_BOOLEAN_LABEL = Messages.getString("ImportedDataType.Label.Boolean");
    private static final int NUMBER_OF_CONSECUTIVE_EMPTY_ROWS_TRIGGERING_ABORT_OF_SHEET_IMPORT = 200;
    private final String applicationName;
    private String currentFileName;
    private List<ImportedSheetType> currentImportedSheetTypes;
    private IRealParser currentRealParser;

    public static List<String> getSupportedExcelExtensions() {
        return MSExcelVersionAndSettingsHelper.getInstalledVersionOfMSExcel() >= 12 ? ExcelConstants.EXCEL_SUPPORTED_FILE_EXTENSIONS_POST2007 : ExcelConstants.EXCEL_SUPPORTED_FILE_EXTENSIONS_PRE2007;
    }

    public GenericExcelListImporter(String applicationName) {
        this.applicationName = applicationName;
    }

    public void setExcelFile(String fileName, String rootParentName, Locale expectedLocale, IProgressDisplay monitor) throws ExcelImportExportException {
        if (this.currentFileName == null || !fileName.equals(this.currentFileName)) {
            this.currentFileName = fileName;
            this.currentImportedSheetTypes = this.readDataFromFile(fileName, rootParentName, expectedLocale, monitor);
        }
    }

    public void resetImporter() {
        this.currentFileName = null;
        this.currentImportedSheetTypes = null;
        this.currentRealParser = null;
    }

    public List<ImportedSheetType> getSheetTypes() {
        assert (this.currentFileName != null);
        return this.currentImportedSheetTypes;
    }

    public boolean getBooleanValue(String cellContent, Locale expectedLocale) {
        return Boolean.TRUE.toString().equals(cellContent) || this.getAlternativeStringRepresentationsForTrue(expectedLocale).contains(cellContent) || this.getAlternativeStringRepresentationsForTrue(Locale.getDefault()).contains(cellContent);
    }

    public double getRealValue(String cellContent) {
        if (this.currentRealParser == null) {
            return 0.0;
        }
        try {
            return this.currentRealParser.parseReal(cellContent);
        }
        catch (NumberFormatException nfE) {
            return 0.0;
        }
    }

    private List<ImportedSheetType> readDataFromFile(String fileName, String rootParentName, Locale expectedLocale, IProgressDisplay monitor) throws ExcelImportExportException {
        ArrayList<ImportedSheetType> importedSheetTypes = new ArrayList<ImportedSheetType>();
        File excelFile = new File(fileName);
        if (!excelFile.exists()) {
            throw new ExcelImportExportException(Messages.getString("ExcelImporter.ExcelFileDoesNotExist"));
        }
        logger.trace(String.valueOf(this.applicationName) + ": Importer: Initializing the Java2Com Environment.");
        ResourceManager resourceManager = new ResourceManager();
        try {
            try {
                logger.trace(String.valueOf(this.applicationName) + ": Importer: Starting Excel application.");
                _Application excelApplication = Application.create((int)6, (ResourceManager)resourceManager, (boolean)true);
                Workbooks excelWorkbooks = excelApplication.get_Workbooks();
                Workbook excelWorkbook = excelWorkbooks.Open(fileName);
                this.currentRealParser = this.createRealParser(excelApplication, expectedLocale);
                int sheetCount = excelWorkbook.get_Worksheets().get_Count();
                monitor.beginQuantifiedTask(Messages.getString("ExcelImporter.TaskName"), sheetCount, false);
                int sheetIndex = 1;
                while (sheetIndex <= sheetCount) {
                    Worksheet excelSheet = new Worksheet(((AutomationObjectImpl)excelWorkbook.get_Sheets().get_Item((Object)sheetIndex)).getOleAutomation(), excelWorkbook.getResourceManager());
                    String sheetName = excelSheet.get_Name().trim();
                    String taskName = String.valueOf(Messages.getString("ExcelImporter.SubTaskName")) + sheetName;
                    monitor.reportQuantifiedProgress(sheetIndex - 1, taskName);
                    this.readSheet(excelSheet, rootParentName, expectedLocale, this.currentRealParser, importedSheetTypes, monitor, taskName);
                    ++sheetIndex;
                }
                monitor.endTask();
                excelWorkbook.Close();
                excelWorkbooks.Close();
                excelApplication.Quit();
                logger.trace(String.valueOf(this.applicationName) + ": Importer: Excel application closed.");
            }
            catch (SWTException aNEE) {
                logger.error(com.arcway.lib.eclipse.ole.excel.util.Messages.getString((String)"ExcelFacade.ExcelNotInstalled_Message"), (Throwable)aNEE);
                throw new ExcelImportExportException(com.arcway.lib.eclipse.ole.excel.util.Messages.getString((String)"ExcelFacade.ExcelNotInstalled_Message"), aNEE);
            }
            catch (Exception e) {
                logger.error(String.valueOf(this.applicationName) + ": ExcelExporter: Exception occured: ", (Throwable)e);
                throw new ExcelImportExportException(e);
            }
        }
        finally {
            resourceManager.shutdown();
        }
        return importedSheetTypes;
    }

    private IRealParser createRealParser(_Application excelApplication, Locale expectedLocale) {
        final char excelDecimalSeparator = excelApplication.get_International((Object)3).getString().charAt(0);
        final char excelThousandsSeparator = excelApplication.get_International((Object)4).getString().charAt(0);
        DecimalFormatSymbols expectedLocaleDecimalFormatSymbols = new DecimalFormatSymbols(expectedLocale);
        final char expectedLocaleDecimalSeparator = expectedLocaleDecimalFormatSymbols.getDecimalSeparator();
        final char expectedLocaleThousandsSeparator = expectedLocaleDecimalFormatSymbols.getGroupingSeparator();
        return new IRealParser(){

            @Override
            public double parseReal(String cellContent) throws NumberFormatException {
                try {
                    return RealParser.parseRealNumber((String)cellContent, (char)excelDecimalSeparator, (char)excelThousandsSeparator);
                }
                catch (NumberFormatException nfE) {
                    try {
                        return RealParser.parseRealNumber((String)cellContent, (char)expectedLocaleDecimalSeparator, (char)expectedLocaleThousandsSeparator);
                    }
                    catch (NumberFormatException nfE2) {
                        try {
                            return RealParser.parseRealNumber((String)cellContent, (char)'.', (char)',');
                        }
                        catch (NumberFormatException nfE3) {
                            try {
                                return RealParser.parseRealNumber((String)cellContent, (char)',', (char)'.');
                            }
                            catch (NumberFormatException nfE4) {
                                throw new NumberFormatException(nfE.getLocalizedMessage());
                            }
                        }
                    }
                }
            }
        };
    }

    private void readSheet(Worksheet sheet, String rootParentName, Locale expectedLocale, IRealParser realParser, List<ImportedSheetType> importedSheetTypes, IProgressDisplay monitor, String taskName) {
        String columnIndexString;
        Object cell;
        String columnHeading;
        String parentName = sheet.get_Name().trim();
        if (parentName.equals(rootParentName)) {
            parentName = null;
        }
        Range usedArea = sheet.get_UsedRange();
        int nrOfRowsWithoutHeaderRow = usedArea.get_Rows().get_Count() - 1;
        String headerRowIndex = Integer.toString(1);
        String sheetTypeKey = "";
        HashSet<String> columnKeysInUse = new HashSet<String>();
        ArrayList<ColumnDescription> initialColumnDescriptionsOfCurrentSheet = new ArrayList<ColumnDescription>();
        int columnIndex = 0;
        while ((columnHeading = ExcelBugWorkarounds.cell_get_Text((Range)(cell = sheet.get_Range((Object)(String.valueOf(columnIndexString = ExcelUtils.getColumnIndex(columnIndex)) + headerRowIndex))))).length() != 0) {
            sheetTypeKey = String.valueOf(sheetTypeKey) + columnHeading + "\n";
            int index = 1;
            while (columnKeysInUse.contains(String.valueOf(Integer.toString(index)) + "-" + columnHeading)) {
                ++index;
            }
            String columnKey = String.valueOf(Integer.toString(index)) + "-" + columnHeading;
            columnKeysInUse.add(columnKey);
            ColumnDescription genericColumnDescription = new ColumnDescription(columnKey, IMPORTED_DATATYPE_ANY, new LinkedHashSet<String>(), columnHeading, Messages.getString("ExcelImporter.NoDataForColumn"));
            initialColumnDescriptionsOfCurrentSheet.add(genericColumnDescription);
            ++columnIndex;
        }
        if (initialColumnDescriptionsOfCurrentSheet.size() > 0) {
            ImportedSheetType importedSheetType = null;
            for (ImportedSheetType sheetType : importedSheetTypes) {
                if (!sheetType.getSheetTypeKey().equals(sheetTypeKey)) continue;
                importedSheetType = sheetType;
                break;
            }
            if (importedSheetType == null) {
                importedSheetType = new ImportedSheetType(sheetTypeKey, initialColumnDescriptionsOfCurrentSheet, new ArrayList<ImportedSheet>());
                importedSheetTypes.add(importedSheetType);
            }
            List<ColumnDescription> columnDescriptions = importedSheetType.getColumnDescriptions();
            ImportedSheet importedSheet = new ImportedSheet(parentName);
            importedSheetType.getImportedSheets().add(importedSheet);
            String[] columnIndexStrings = new String[columnDescriptions.size()];
            int columnIndex2 = 0;
            while (columnIndex2 < columnDescriptions.size()) {
                columnIndexStrings[columnIndex2] = ExcelUtils.getColumnIndex(columnIndex2);
                ++columnIndex2;
            }
            int consecutiveEmptyRowCount = 0;
            int rowNumber = 0;
            while (rowNumber < nrOfRowsWithoutHeaderRow && consecutiveEmptyRowCount < 200) {
                String rowIndexString = Integer.toString(2 + rowNumber);
                monitor.beginUnquantifiedTask(String.valueOf(taskName) + " (" + Messages.getString("ExcelImporter.TaskName.Zeile") + " " + rowIndexString + ")", false);
                ArrayList<String> childValueList = new ArrayList<String>(columnDescriptions.size());
                boolean emptyRow = true;
                int columnIndex3 = 0;
                while (columnIndex3 < columnDescriptions.size()) {
                    Range cell2 = sheet.get_Range((Object)(String.valueOf(columnIndexStrings[columnIndex3]) + rowIndexString));
                    String cellContent = ExcelBugWorkarounds.cell_get_Text(cell2);
                    if (cellContent.trim().length() > 0) {
                        emptyRow = false;
                        childValueList.add(cellContent);
                    } else {
                        childValueList.add("");
                    }
                    ++columnIndex3;
                }
                if (!emptyRow) {
                    columnIndex3 = 0;
                    while (columnIndex3 < columnDescriptions.size()) {
                        this.checkColumnDataType(columnDescriptions.get(columnIndex3), (String)childValueList.get(columnIndex3), expectedLocale, realParser);
                        ++columnIndex3;
                    }
                    importedSheet.addItem(childValueList);
                    consecutiveEmptyRowCount = 0;
                } else {
                    ++consecutiveEmptyRowCount;
                }
                ++rowNumber;
            }
        }
    }

    private void checkColumnDataType(ColumnDescription columnDescription, String newValueAsString, Locale expectedLocale, IRealParser realParser) {
        LinkedHashSet<String> valueRange = columnDescription.getValueRange();
        boolean valueRangeChanged = valueRange.add(newValueAsString);
        if (valueRangeChanged && !IMPORTED_DATATYPE_STRING_MULTILINE.equals(columnDescription.getColumnDataType()) && newValueAsString.length() > 0) {
            if (columnDescription.getColumnDataType().equals(IMPORTED_DATATYPE_ANY)) {
                if (this.isStringValueOfType(newValueAsString, IMPORTED_DATATYPE_INTEGER, expectedLocale, realParser)) {
                    columnDescription.changeDataType(IMPORTED_DATATYPE_INTEGER, IMPORTED_DATATYPE_INTEGER_LABEL);
                } else if (this.isStringValueOfType(newValueAsString, IMPORTED_DATATYPE_REAL, expectedLocale, realParser)) {
                    columnDescription.changeDataType(IMPORTED_DATATYPE_REAL, IMPORTED_DATATYPE_REAL_LABEL);
                } else if (this.isStringValueOfType(newValueAsString, IMPORTED_DATATYPE_DATE, expectedLocale, realParser)) {
                    columnDescription.changeDataType(IMPORTED_DATATYPE_DATE, IMPORTED_DATATYPE_DATE_LABEL);
                } else if (this.isStringValueOfType(newValueAsString, IMPORTED_DATATYPE_BOOLEAN, expectedLocale, realParser)) {
                    columnDescription.changeDataType(IMPORTED_DATATYPE_BOOLEAN, IMPORTED_DATATYPE_BOOLEAN_LABEL);
                } else if (this.isStringValueOfType(newValueAsString, IMPORTED_DATATYPE_STRING_SINGLELINE, expectedLocale, realParser)) {
                    columnDescription.changeDataType(IMPORTED_DATATYPE_STRING_SINGLELINE, IMPORTED_DATATYPE_STRING_SINGLELINE_LABEL);
                } else {
                    columnDescription.changeDataType(IMPORTED_DATATYPE_STRING_MULTILINE, IMPORTED_DATATYPE_STRING_MULTILINE_LABEL);
                }
            } else {
                if (columnDescription.getColumnDataType().equals(IMPORTED_DATATYPE_INTEGER) && !this.isStringValueOfType(newValueAsString, IMPORTED_DATATYPE_INTEGER, expectedLocale, realParser)) {
                    columnDescription.changeDataType(IMPORTED_DATATYPE_REAL, IMPORTED_DATATYPE_REAL_LABEL);
                }
                if ((columnDescription.getColumnDataType().equals(IMPORTED_DATATYPE_DATE) || columnDescription.getColumnDataType().equals(IMPORTED_DATATYPE_REAL) || columnDescription.getColumnDataType().equals(IMPORTED_DATATYPE_BOOLEAN)) && !this.isStringValueOfType(newValueAsString, columnDescription.getColumnDataType(), expectedLocale, realParser)) {
                    columnDescription.changeDataType(IMPORTED_DATATYPE_STRING_SINGLELINE, IMPORTED_DATATYPE_STRING_SINGLELINE_LABEL);
                }
                if (columnDescription.getColumnDataType().equals(IMPORTED_DATATYPE_STRING_SINGLELINE) && !this.isStringValueOfType(newValueAsString, IMPORTED_DATATYPE_STRING_SINGLELINE, expectedLocale, realParser)) {
                    columnDescription.changeDataType(IMPORTED_DATATYPE_STRING_MULTILINE, IMPORTED_DATATYPE_STRING_MULTILINE_LABEL);
                }
            }
        }
    }

    private boolean isStringValueOfType(String newValueAsString, String dataType, Locale expectedLocale, IRealParser realParser) {
        if (dataType.equals(IMPORTED_DATATYPE_INTEGER)) {
            try {
                Long.parseLong(newValueAsString);
                return true;
            }
            catch (NumberFormatException nfE) {
                return false;
            }
        }
        if (dataType.equals(IMPORTED_DATATYPE_REAL)) {
            try {
                realParser.parseReal(newValueAsString);
                return true;
            }
            catch (NumberFormatException nfE) {
                return false;
            }
        }
        if (dataType.equals(IMPORTED_DATATYPE_BOOLEAN)) {
            return newValueAsString.equals(Boolean.TRUE.toString()) || newValueAsString.equals(Boolean.FALSE.toString()) || this.getAlternativeStringRepresentationsForTrue(expectedLocale).contains(newValueAsString) || this.getAlternativeStringRepresentationsForFalse(expectedLocale).contains(newValueAsString) || this.getAlternativeStringRepresentationsForTrue(Locale.getDefault()).contains(newValueAsString) || this.getAlternativeStringRepresentationsForFalse(Locale.getDefault()).contains(newValueAsString);
        }
        if (dataType.equals(IMPORTED_DATATYPE_DATE)) {
            return DateFormatHelper.getDefault().parse(newValueAsString, expectedLocale) != null;
        }
        if (dataType.equals(IMPORTED_DATATYPE_STRING_SINGLELINE)) {
            return !newValueAsString.contains("\r") && !newValueAsString.contains("\n");
        }
        assert (false);
        return false;
    }

    protected Collection<String> getAlternativeStringRepresentationsForTrue(Locale locale) {
        return Collections.emptySet();
    }

    protected Collection<String> getAlternativeStringRepresentationsForFalse(Locale locale) {
        return Collections.emptySet();
    }

    private static interface IRealParser {
        public double parseReal(String var1) throws NumberFormatException;
    }
}

