/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.frontend.definition.lib.ui.editor.imports.modelaccess;

import com.arcway.frontend.definition.lib.interFace.type.exceptions.RepositoryAccessExceptionLabelProvider;
import com.arcway.frontend.definition.lib.ui.editor.imports.modelaccess.ModelAccess;
import com.arcway.frontend.definition.lib.ui.editor.imports.references.ImportJobObjectTypeCategoryReference;
import com.arcway.frontend.definition.lib.ui.editor.imports.references.ImportJobPropertyReference;
import com.arcway.lib.java.Assert;
import com.arcway.lib.ui.editor.exception.EEXLockDenied;
import com.arcway.lib.ui.editor.exception.EEXNotReproducibleSnapshot;
import com.arcway.lib.ui.editor.exception.EEXPermissionDenied;
import com.arcway.lib.ui.editor.exception.EEXSnapshotClosed;
import com.arcway.lib.ui.modelaccess.agent.ILockAndPermissionProvider;
import com.arcway.repository.interFace.data.RepositoryReferences;
import com.arcway.repository.interFace.data.object.IRepositoryObject;
import com.arcway.repository.interFace.data.object.IRepositoryObjectReference;
import com.arcway.repository.interFace.data.property.IRepositoryProperty;
import com.arcway.repository.interFace.data.property.IRepositoryPropertyReference;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.dataaccess.IRepositoryInterfaceRO;
import com.arcway.repository.interFace.dataaccess.IRepositorySnapshotRO;
import com.arcway.repository.interFace.dataaccess.locksandpermissions.ILocksAndPermissionsManagerDeprecated;
import com.arcway.repository.interFace.dataaccess.locksandpermissions.exceptions.EXPermissionDenied;
import com.arcway.repository.interFace.exceptions.RepositoryAccessException;
import com.arcway.repository.interFace.importexport.imporT.importjob.ImportJobHelper;
import com.arcway.repository.interFace.importexport.imporT.importjob.ro.IObjectRO;
import com.arcway.repository.interFace.importexport.imporT.importjob.ro.IPropertyRO;
import com.arcway.repository.interFace.importexport.imporT.importjob.rw.IImportedObject;
import com.arcway.repository.interFace.importexport.imporT.importjob.rw.IProperty;
import com.arcway.repository.interFace.transactions.exceptions.EXObjectReferenceCannotBeResolved;

public class LockAndPermissionProvider
implements ILockAndPermissionProvider<ImportJobPropertyReference, ImportJobObjectTypeCategoryReference> {
    private final IRepositoryInterfaceRO repositoryInterface;
    private final ModelAccess modelAccess;
    private final IPermissionChecker<ImportJobPropertyReference> modifyPropertyPermissionChecker = new IPermissionChecker<ImportJobPropertyReference>(){

        @Override
        public void doCheckPermission(ImportJobPropertyReference propertyReference, IRepositorySnapshotRO snapshot) throws EXPermissionDenied, ImportJobHelper.RelatedObjectNotMatched, EXObjectReferenceCannotBeResolved, EXNotReproducibleSnapshot {
            IProperty property = propertyReference.getProperty();
            IRepositoryPropertyReference repositoryPropertyReference = ImportJobHelper.getPropertyReference((IPropertyRO)property);
            IRepositoryProperty repositoryProperty = RepositoryReferences.getPropertyFromReference((IRepositoryPropertyReference)repositoryPropertyReference, (IRepositorySnapshotRO)snapshot);
            ILocksAndPermissionsManagerDeprecated locksAndPermissionsMgr = LockAndPermissionProvider.this.repositoryInterface.getLocksAndPermissionsManagerDeprecated();
            locksAndPermissionsMgr.checkPermissionForModifyCockpitDataProperty(repositoryProperty);
        }
    };
    private final IPermissionChecker<ImportJobObjectTypeCategoryReference> modifyObjectTypeCategoryPermissionChecker = new IPermissionChecker<ImportJobObjectTypeCategoryReference>(){

        @Override
        public void doCheckPermission(ImportJobObjectTypeCategoryReference objectTypeCategoryReference, IRepositorySnapshotRO snapshot) throws EXPermissionDenied, ImportJobHelper.RelatedObjectNotMatched, EXObjectReferenceCannotBeResolved, EXNotReproducibleSnapshot {
            IImportedObject object = objectTypeCategoryReference.getObject();
            IRepositoryObjectReference repositoryObjectReference = ImportJobHelper.getObjectReference((IObjectRO)object);
            IRepositoryObject repositoryObject = RepositoryReferences.getObjectFromReference((IRepositoryObjectReference)repositoryObjectReference, (IRepositorySnapshotRO)snapshot);
            ILocksAndPermissionsManagerDeprecated locksAndPermissionsMgr = LockAndPermissionProvider.this.repositoryInterface.getLocksAndPermissionsManagerDeprecated();
            locksAndPermissionsMgr.checkPermissionForModifyCockpitDataObjectTypeCategory(repositoryObject);
        }
    };

    public LockAndPermissionProvider(IRepositoryInterfaceRO repositoryInterface, ModelAccess modelAccess) {
        this.repositoryInterface = repositoryInterface;
        this.modelAccess = modelAccess;
    }

    public void checkPermissionForModifyProperty(ImportJobPropertyReference propertyReference) throws EEXNotReproducibleSnapshot, EEXSnapshotClosed, EEXPermissionDenied {
        this.checkPermissionForModifyPropertyOrObjectTypeCategory(propertyReference, this.modifyPropertyPermissionChecker);
    }

    public void checkPermissionForModifyObjectTypeCategory(ImportJobObjectTypeCategoryReference objectTypeCategoryReference) throws EEXNotReproducibleSnapshot, EEXSnapshotClosed, EEXPermissionDenied {
        this.checkPermissionForModifyPropertyOrObjectTypeCategory(objectTypeCategoryReference, this.modifyObjectTypeCategoryPermissionChecker);
    }

    private <REFERENCE> void checkPermissionForModifyPropertyOrObjectTypeCategory(REFERENCE reference, IPermissionChecker<REFERENCE> permissionChecker) throws EEXPermissionDenied, EEXNotReproducibleSnapshot, EEXSnapshotClosed {
        try {
            IRepositorySnapshotRO snapshot = this.modelAccess.getSnapshot();
            Assert.checkArgumentBeeingNotNull((Object)snapshot);
            permissionChecker.doCheckPermission(reference, snapshot);
        }
        catch (EXPermissionDenied e) {
            throw new EEXPermissionDenied((Exception)((Object)e), RepositoryAccessExceptionLabelProvider.getIconForException((RepositoryAccessException)((Object)e)));
        }
        catch (EXNotReproducibleSnapshot e) {
            throw new EEXNotReproducibleSnapshot((Exception)((Object)e));
        }
        catch (EXObjectReferenceCannotBeResolved eXObjectReferenceCannotBeResolved) {
        }
        catch (ImportJobHelper.RelatedObjectNotMatched relatedObjectNotMatched) {
            // empty catch block
        }
    }

    public void checkPermissionForCreateOrDeleteRelation(Object relationTypeID, Object roleID, Object objectID) throws EEXNotReproducibleSnapshot {
    }

    public void checkPermissionForCreateOrDeleteRelation(Object relationTypeID, Object roleID, Object importedObject, Object objectReference) throws EEXNotReproducibleSnapshot, EEXPermissionDenied {
    }

    public void acquireModifyLockForProperty(ImportJobPropertyReference reference) throws EEXNotReproducibleSnapshot {
    }

    public void acquireModifyLockForObjectTypeCategory(ImportJobObjectTypeCategoryReference reference) throws EEXNotReproducibleSnapshot, EEXLockDenied, EEXSnapshotClosed {
    }

    public void acquireLockForCreateOrDeleteRelation(Object relationTypeID, Object roleID, Object objectID1, Object objectReference) throws EEXNotReproducibleSnapshot {
    }

    public void acquireLockForCreateOrDeleteRelation(Object relationSample) throws EEXNotReproducibleSnapshot {
    }

    public void releaseAllLocks() {
    }

    public void releaseModifyLockForProperty(ImportJobPropertyReference propertyReference) {
    }

    public void releaseModifyLockForObjectTypeCategory(ImportJobObjectTypeCategoryReference objectTypeCategoryReference) {
    }

    public void releaseRelationLock(Object relationTypeID, Object roleID, Object objectID1, Object objectReference) {
    }

    public void releaseRelationLock(Object relationSample) {
    }

    public boolean shallEditorsSupportViewMode() {
        ILocksAndPermissionsManagerDeprecated locksAndPermissionsMgr = this.repositoryInterface.getLocksAndPermissionsManagerDeprecated();
        return locksAndPermissionsMgr.shallEditorsSupportViewMode();
    }

    private static interface IPermissionChecker<REFERENCE> {
        public void doCheckPermission(REFERENCE var1, IRepositorySnapshotRO var2) throws EXPermissionDenied, ImportJobHelper.RelatedObjectNotMatched, EXObjectReferenceCannotBeResolved, EXNotReproducibleSnapshot;
    }
}

