/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.frontend.definition.lib.interFace.type.exceptions;

import com.arcway.frontend.definition.lib.interFace.datatype.IFrontendDataType;
import com.arcway.frontend.definition.lib.interFace.datatype.IFrontendDataTypeParameters;
import com.arcway.frontend.definition.lib.interFace.label.IFrontendLabel;
import com.arcway.frontend.definition.lib.interFace.type.exceptions.Messages;
import com.arcway.frontend.definition.lib.interFace.type.manager.IFrontendTypeManager;
import com.arcway.lib.java.locale.PresentationContext;
import com.arcway.lib.stringtools.StringUtil;
import com.arcway.repository.interFace.data.attributeset.IRepositoryPropertySetSample;
import com.arcway.repository.interFace.data.data.IRepositoryData;
import com.arcway.repository.interFace.data.property.IRepositoryPropertySample;
import com.arcway.repository.interFace.dataaccess.locksandpermissions.exceptions.AbstractEXLockDenied;
import com.arcway.repository.interFace.dataaccess.locksandpermissions.exceptions.IEXLockDenied;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import com.arcway.repository.interFace.declaration.type.property.IRepositoryPropertyTypeID;
import com.arcway.repository.interFace.registration.type.IRepositoryTypeManagerRO;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataType;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataTypeParameters;
import com.arcway.repository.interFace.registration.type.object.IRepositoryObjectType;
import com.arcway.repository.interFace.registration.type.property.IRepositoryPropertyType;

public class FrontendExceptionTypes {
    public static final String NEW_LINE = "\n";

    public static String getObjectIDAsString(IRepositoryPropertySetSample propertySetSample, IRepositoryObjectTypeID objectTypeID, IFrontendTypeManager frontendTypeManager, PresentationContext presentationContext) {
        IRepositoryTypeManagerRO repositoryTypeManager = frontendTypeManager.getRepositoryTypeManager();
        StringBuffer objectIDAsString = new StringBuffer();
        for (IRepositoryPropertyTypeID propertyTypeID : propertySetSample.getPropertyTypeIDs()) {
            IRepositoryPropertySample property = propertySetSample.getPropertySample(propertyTypeID);
            IRepositoryObjectType objectType = repositoryTypeManager.getObjectType(objectTypeID);
            IRepositoryPropertyType objectPropertyType = objectType.getAttributeSetType(propertyTypeID).getPropertyType(propertyTypeID);
            IRepositoryData idPropertyValue = property.getValue();
            IRepositoryDataType propertyValueRDataType = idPropertyValue.getDataType();
            IFrontendDataType propertyValueFDataType = frontendTypeManager.getFrontendDataType(propertyValueRDataType);
            IRepositoryDataTypeParameters dataTypeParameters = objectPropertyType.getDataTypeParameters();
            IFrontendDataTypeParameters frontendDataTypeParameters = frontendTypeManager.getFrontendPropertyType(objectPropertyType).getFrontendDataTypeParameters();
            IFrontendLabel labelPropertyValue = propertyValueFDataType.getLabelForValue(idPropertyValue, dataTypeParameters, frontendDataTypeParameters, presentationContext);
            IFrontendLabel labelPropertyType = frontendTypeManager.getFrontendPropertyType(objectPropertyType).getLabel();
            objectIDAsString.append(labelPropertyType + ": " + labelPropertyValue);
        }
        return objectIDAsString.toString();
    }

    public static String getLockInformationAsMessage(IEXLockDenied lockException) {
        String message = "";
        if (lockException.getConflictingLockInformation() != null) {
            for (AbstractEXLockDenied.ConflictingLockInformation conflictingLock : lockException.getConflictingLockInformation()) {
                String userName = String.valueOf(Messages.getString("Lock.UserName")) + conflictingLock.getUserName();
                String clientName = String.valueOf(Messages.getString("Lock.ClientName")) + conflictingLock.getClientName();
                String localizedLockType = String.valueOf(Messages.getString("Lock.LockType")) + conflictingLock.getLocalizedLockType();
                String detail = conflictingLock.getDetail();
                detail = detail == null ? "" : String.valueOf(Messages.getString("Lock.Detail")) + detail;
                message = String.valueOf(message) + userName + clientName + localizedLockType + detail;
            }
        } else {
            message = StringUtil.concatWithLineBreaks((String[])lockException.getLocalizedOtherReasons(), (boolean)true);
        }
        return message;
    }
}

