/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.ppm1.ppm1migrator;

import com.arcway.cockpit.frame.client.project.datainterchange.ProjectFileAccess;
import com.arcway.cockpit.frame.client.project.migration.ICockpitMigrator;
import com.arcway.cockpit.frame.client.project.migration.MigrationFailedException;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOProject_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.V0_EOFactory;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.IHistoricProjectDumpView;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.IHistoricServerDumpView;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.version0.HistoricProjectDumpView_0_;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.version0.HistoricServerDumpView_0_;
import com.arcway.cockpit.frame.client.project.migration.access_projectfiles.IHistoricProjectFileView;
import com.arcway.cockpit.frame.client.project.migration.access_projectfiles.version0.HistoricProjectFileView_0_;
import com.arcway.lib.codec.EXDecoderException;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import de.plans.psc.shared.message.EOPermission;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class PPM1PermissionMigrator2
implements ICockpitMigrator {
    private static final ILogger logger = Logger.getLogger(PPM1PermissionMigrator2.class);
    public static final String KEY = "ppm1.PermissionMigrator2";

    public String getKey() {
        return KEY;
    }

    public int getSourceVersion() {
        return 0;
    }

    public List<String> getRequiredPreceedingMigrators() {
        return Collections.singletonList("PPM1Migrator");
    }

    public IEncodableObjectFactory getRequiredEOFactoryForProjectFileMainData() {
        return V0_EOFactory.getDefault();
    }

    public void migrateACT(IHistoricProjectFileView projectFile) throws MigrationFailedException {
        this.migrateACTOrACP(projectFile);
    }

    public void migrateACP(IHistoricProjectFileView projectFile) throws MigrationFailedException {
        this.migrateACTOrACP(projectFile);
    }

    public void migrateProjectDump(IHistoricProjectDumpView projectDump) throws MigrationFailedException {
        HistoricProjectDumpView_0_ historicView = (HistoricProjectDumpView_0_)projectDump;
        try {
            for (EOProject_V0 currentProject : historicView.getAllProjects()) {
                EOList permissions = historicView.readPermissions(currentProject);
                this.migratePermissions((Collection<?>)permissions);
            }
        }
        catch (EXDecoderException eDE) {
            throw new MigrationFailedException((Throwable)eDE);
        }
    }

    public void migrateServerDump(IHistoricServerDumpView serverDump) {
        HistoricServerDumpView_0_ historicView = (HistoricServerDumpView_0_)serverDump;
        EOList permissions = historicView.getPermissionList();
        this.migratePermissions((Collection<?>)permissions);
    }

    private void migrateACTOrACP(IHistoricProjectFileView projectFile) throws MigrationFailedException {
        try {
            HistoricProjectFileView_0_ projectFileView_0_ = (HistoricProjectFileView_0_)projectFile;
            EOList permissions = projectFileView_0_.getDataList("permissions");
            this.migratePermissions((Collection<?>)permissions);
        }
        catch (ProjectFileAccess.ProjectFileAccessException pfaE) {
            logger.error("Can not migrate project file.", (Throwable)pfaE);
            throw new MigrationFailedException((Throwable)pfaE);
        }
    }

    private void migratePermissions(Collection<?> permissions) {
        for (Object eo : permissions) {
            if (eo instanceof EOPermission) {
                EOPermission permission = (EOPermission)eo;
                if (!"PPM2_Permission_Root".equals(permission.getOperandUID()) || !"ppm2.editUnassignedWorkItems".equals(permission.getOperation()) || !"ppm2.prmOperand.root".equals(permission.getOperandType())) continue;
                permission.setOperandType("ppm2.prmOp.unassignedWIs");
                permission.setOperandUID("PPM2PermUnassignedWorkItems");
                continue;
            }
            logger.warn("Permissions list contains object which is not of type EOPermission: " + eo.getClass().getName());
        }
    }
}

