/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.ppm1.ppm1migrator;

import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOModuleData_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOVersionedModuleData_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.modules.EOSourceFileInfo_V0;
import com.arcway.cockpit.ppm1.ppm1migrator.messages.EOPMProject;
import com.arcway.cockpit.ppm1.ppm1migrator.messages.EOTask;
import com.arcway.cockpit.ppm1.ppm1migrator.messages.EOWorkItem;
import com.arcway.lib.UUIDGenerator;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.util.Collection;
import java.util.Map;

public class PPM1MigratorCore {
    private static final ILogger logger = Logger.getLogger(PPM1MigratorCore.class);
    private static final long MIN_TO_MS_CONVERSION = 60000L;

    public static EOModuleData_V0 migrateSourceFileInfoRecord(EOSourceFileInfo_V0 oldSourceFileInfo, String projectUID, String defaultCreatorModifier, long defaultCreationModificationDate) {
        EOModuleData_V0 newSourceFileInfo = new EOModuleData_V0();
        String datatypeUID = "ppm2.sourceFile";
        long creationDate = oldSourceFileInfo.getFirstImportDate() != null ? oldSourceFileInfo.getFirstImportDate().getTime() : (oldSourceFileInfo.getLastUpdate() != null ? oldSourceFileInfo.getLastUpdate().getTime() : defaultCreationModificationDate);
        String creator = oldSourceFileInfo.getInitialImporter() != null ? oldSourceFileInfo.getInitialImporter() : (oldSourceFileInfo.getLastUpdater() != null ? oldSourceFileInfo.getLastUpdater() : defaultCreatorModifier);
        long modificationDate = oldSourceFileInfo.getLastUpdate() != null ? oldSourceFileInfo.getLastUpdate().getTime() : (oldSourceFileInfo.getFirstImportDate() != null ? oldSourceFileInfo.getFirstImportDate().getTime() : defaultCreationModificationDate);
        String modifier = oldSourceFileInfo.getLastUpdater() != null ? oldSourceFileInfo.getLastUpdater() : (oldSourceFileInfo.getInitialImporter() != null ? oldSourceFileInfo.getInitialImporter() : defaultCreatorModifier);
        PPM1MigratorCore.initializeEOModuleDataItem(newSourceFileInfo, oldSourceFileInfo.getUID(), projectUID, datatypeUID, creationDate, creator, modificationDate, modifier);
        if (oldSourceFileInfo.getFullPath() != null && oldSourceFileInfo.getFileName() != null) {
            newSourceFileInfo.addAttribute("sfFile", oldSourceFileInfo.getFullPath());
        } else {
            newSourceFileInfo.addAttribute("sfFile", "");
            logger.warn(" Filename of Source File Info should be valid. ", (Throwable)new Exception());
        }
        if (oldSourceFileInfo.getFirstImportDate() != null) {
            newSourceFileInfo.addAttribute("sfFirstImportDate", "" + oldSourceFileInfo.getFirstImportDate().getTime());
        }
        if (oldSourceFileInfo.getInitialImporter() != null) {
            newSourceFileInfo.addAttribute("sfInitialImporter", oldSourceFileInfo.getInitialImporter());
        }
        if (oldSourceFileInfo.getLastUpdate() != null) {
            newSourceFileInfo.addAttribute("sfLastUpdateDate", "" + oldSourceFileInfo.getLastUpdate().getTime());
        }
        if (oldSourceFileInfo.getLastUpdater() != null) {
            newSourceFileInfo.addAttribute("sfLastUpdater", oldSourceFileInfo.getLastUpdater());
        }
        return newSourceFileInfo;
    }

    public static EOModuleData_V0 migrateProjectPlanRecord(EOPMProject oldProjectPlan, String projectUID, String defaultCreatorModifier, long defaultCreationModificationDate) {
        EOModuleData_V0 newPlan = new EOModuleData_V0();
        String datatypeUID = "ppm2.projectplan";
        long creationDate = oldProjectPlan.getModTime() != null ? oldProjectPlan.getModTime().getTime() : defaultCreationModificationDate;
        String creator = oldProjectPlan.getModifier() != null ? oldProjectPlan.getModifier() : defaultCreatorModifier;
        long modificationDate = oldProjectPlan.getModTime() != null ? oldProjectPlan.getModTime().getTime() : defaultCreationModificationDate;
        String modifier = oldProjectPlan.getModifier() != null ? oldProjectPlan.getModifier() : defaultCreatorModifier;
        PPM1MigratorCore.initializeEOModuleDataItem(newPlan, oldProjectPlan.getUID(), projectUID, datatypeUID, creationDate, creator, modificationDate, modifier);
        if (oldProjectPlan.getDescription() != null) {
            newPlan.addAttribute("ppm.projectplan.description", oldProjectPlan.getDescription());
        }
        if (oldProjectPlan.getExternalUID() != null) {
            newPlan.addAttribute("ppm.projectplan.externalUID", oldProjectPlan.getExternalUID());
        }
        if (oldProjectPlan.getFinish() != null) {
            newPlan.addAttribute("ppm.projectplan.finish", "" + oldProjectPlan.getFinish().getTime());
        }
        newPlan.addAttribute("ppm.projectplan.hoursPerDay", "" + oldProjectPlan.getHoursPerDay());
        if (oldProjectPlan.getName() != null) {
            newPlan.addAttribute("ppm.projectplan.name", oldProjectPlan.getName());
        } else {
            newPlan.addAttribute("ppm.projectplan.name", newPlan.getUid());
            logger.warn(" A project plan should have a valid name (not null). ");
        }
        newPlan.addAttribute("ppm.projectplan.originalWork", Long.toString(oldProjectPlan.getOriginalWork() * 60000L));
        if (oldProjectPlan.getStart() != null) {
            newPlan.addAttribute("ppm.projectplan.start", "" + oldProjectPlan.getStart().getTime());
        }
        return newPlan;
    }

    public static EOModuleData_V0 migrateTaskRecord(EOTask oldTask, String projectUID, String defaultCreatorModifier, long defaultCreationModificationDate) {
        EOModuleData_V0 newTask = new EOModuleData_V0();
        String datatypeUID = "ppm2.task";
        long creationDate = defaultCreationModificationDate;
        String creator = defaultCreatorModifier;
        long modificationDate = defaultCreationModificationDate;
        String modifier = defaultCreatorModifier;
        PPM1MigratorCore.initializeEOModuleDataItem(newTask, oldTask.getUID(), projectUID, datatypeUID, creationDate, creator, modificationDate, modifier);
        if (oldTask.getExternalTaskUid() != null) {
            newTask.addAttribute("ppm.task.externalUID", oldTask.getExternalTaskUid());
        }
        if (oldTask.getFinish() != null) {
            newTask.addAttribute("ppm.task.finish", "" + oldTask.getFinish().getTime());
        }
        if (oldTask.getExternalTaskId() != null) {
            newTask.addAttribute("ppm.task.ID", oldTask.getExternalTaskId());
        }
        newTask.addAttribute("ppm.task.isCritical", "" + oldTask.getIsCritical());
        newTask.addAttribute("ppm.task.isMilestone", "" + oldTask.getIsMilestone());
        if (oldTask.getName() != null) {
            newTask.addAttribute("ppm.task.name", oldTask.getName());
        } else {
            newTask.addAttribute("ppm.task.name", newTask.getUid());
            logger.warn(" A task should have a valid name (not null). ");
        }
        if (oldTask.getPriority() != -1) {
            newTask.addAttribute("ppm.task.priority", "" + oldTask.getPriority());
        }
        if (oldTask.getResourceNames() != null) {
            newTask.addAttribute("ppm.task.resourceNames", oldTask.getResourceNames());
        }
        if (oldTask.getStart() != null) {
            newTask.addAttribute("ppm.task.start", "" + oldTask.getStart().getTime());
        }
        newTask.addAttribute("ppm.task.importedWork", Long.toString((long)Math.round(oldTask.getOriginalWork()) * 60000L));
        return newTask;
    }

    public static EOModuleData_V0 updateCategoryListAndReturnCategoryEO(Collection newWICategories, Collection newWICategoryLogs, Map categoryNameMap, EOWorkItem oldWorkItem, String projectUID, String defaultCreatorModifier, long defaultCreationModificationDate) {
        String categoryName = oldWorkItem.getCategory();
        EOModuleData_V0 categoryRecord = null;
        if (categoryName != null && !categoryName.trim().equals("") && (categoryRecord = (EOModuleData_V0)categoryNameMap.get(categoryName)) != null) {
            categoryRecord = new EOModuleData_V0();
            String uid = UUIDGenerator.getUniqueID();
            String datatypeUID = "ppm2.workitemcategory";
            long creationDate = defaultCreationModificationDate;
            String creator = defaultCreatorModifier;
            long modificationDate = defaultCreationModificationDate;
            String modifier = defaultCreatorModifier;
            PPM1MigratorCore.initializeEOModuleDataItem(categoryRecord, uid, projectUID, datatypeUID, creationDate, creator, modificationDate, modifier);
            categoryRecord.addAttribute("category", categoryName);
            newWICategories.add(categoryRecord);
            categoryNameMap.put(categoryName, categoryRecord);
            newWICategoryLogs.add(new EOVersionedModuleData_V0(categoryRecord));
        }
        return categoryRecord;
    }

    public static EOModuleData_V0 migrateWorkItemRecord(EOWorkItem oldWorkItem, String projectUID, String defaultCreatorModifier, long defaultCreationModificationDate, Map stakeholderMap) {
        String oldResource;
        EOModuleData_V0 newWorkItem = new EOModuleData_V0();
        String datatypeUID = "ppm2.workitem";
        long creationDate = oldWorkItem.getDateCreation() != null ? oldWorkItem.getDateCreation().getTime() : (oldWorkItem.getDateModification() != null ? oldWorkItem.getDateModification().getTime() : defaultCreationModificationDate);
        String creator = defaultCreatorModifier;
        long modificationDate = oldWorkItem.getDateModification() != null ? oldWorkItem.getDateModification().getTime() : (oldWorkItem.getDateCreation() != null ? oldWorkItem.getDateCreation().getTime() : defaultCreationModificationDate);
        String modifier = defaultCreatorModifier;
        PPM1MigratorCore.initializeEOModuleDataItem(newWorkItem, oldWorkItem.getUID(), projectUID, datatypeUID, creationDate, creator, modificationDate, modifier);
        if (oldWorkItem.getDescription() != null) {
            newWorkItem.addAttribute("workItem_description", oldWorkItem.getDescription());
        }
        if (oldWorkItem.getName() != null) {
            newWorkItem.addAttribute("workItem_name", oldWorkItem.getName());
        } else {
            newWorkItem.addAttribute("workItem_name", oldWorkItem.getUID());
            logger.warn(" A work item should have a valid name (not null). ");
        }
        if (oldWorkItem.getResourceNames() != null && !stakeholderMap.containsKey(oldResource = oldWorkItem.getResourceNames())) {
            newWorkItem.addAttribute("workItem_resources", oldResource);
        }
        newWorkItem.addAttribute("workItem_workDone", "" + (long)oldWorkItem.getWorkDone() * 60000L);
        newWorkItem.addAttribute("workItem_workEstimated", "" + (long)oldWorkItem.getWorkEstimated() * 60000L);
        newWorkItem.addAttribute("workItem_workRemaining", "" + (long)oldWorkItem.getWorkRemaining() * 60000L);
        return newWorkItem;
    }

    private static void initializeEOModuleDataItem(EOModuleData_V0 newEOModuleDataItem, String uid, String projectUID, String datatypeUID, long creationDate, String creator, long modificationDate, String modifier) {
        newEOModuleDataItem.setUid(uid);
        newEOModuleDataItem.setProjectUID(projectUID);
        newEOModuleDataItem.addAttribute("abstractmoduledata_creationDate", Long.toString(creationDate));
        newEOModuleDataItem.addAttribute("abstractmoduledata_creator", creator);
        newEOModuleDataItem.addAttribute("abstractmoduledata_modificationCount", Integer.toString(1));
        newEOModuleDataItem.setModCount(1);
        newEOModuleDataItem.addAttribute("abstractmoduledata_modificationDate", Long.toString(modificationDate));
        newEOModuleDataItem.setModTime(modificationDate);
        newEOModuleDataItem.addAttribute("abstractmoduledata_modifier", modifier);
    }
}

