/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.platformadapter;

import com.arcway.cockpit.modulelib2.client.core.project.AbstractDataMgr;
import com.arcway.cockpit.modulelib2.client.messages.AbstractModuleData;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.modulelib2.client.messages.attributes.IModuleDataAttribute;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeDiscrete;
import com.arcway.cockpit.modulelib2.client.messages.description.IModuleDataTypeDescription;
import com.arcway.cockpit.modulelib2.client.platformadapter.ChildrenIDFormatPropertyTypeDeclaration;
import com.arcway.cockpit.modulelib2.client.platformadapter.EnumerationDeclaration;
import com.arcway.cockpit.modulelib2.client.platformadapter.IPropertyDeclarations;
import com.arcway.cockpit.modulelib2.client.platformadapter.containerclasses.PropertyType;
import com.arcway.cockpit.modulelib2.client.platformadapter.helper.AttributeTypeConverter;
import com.arcway.cockpit.modulelib2.client.platformadapter.helper.DiscreteValueHelper;
import com.arcway.cockpit.modulelib2.client.platformadapter.helper.LabelHelper;
import com.arcway.cockpit.modulelib2.client.platformadapter.helper.RepositoryDataTypeWithDataTypeParameters;
import com.arcway.cockpit.modulelib2.client.platformadapter.helper.RepositoryIDCreator;
import com.arcway.cockpit.modulelib2.client.platformadapter.interFace.IModuleDataTypeDescriptionForPlatformAdapter;
import com.arcway.lib.java.collections.IComparator_;
import com.arcway.lib.java.collections.IHasher_;
import com.arcway.lib.java.collections.IList_;
import com.arcway.lib.java.collections.ISet_;
import com.arcway.lib.java.maps.HashMap_;
import com.arcway.lib.java.maps.IMap_;
import com.arcway.lib.java.tuples.Tuple;
import com.arcway.repository.clientadapter.interFace.INameOrIDPropertyTypeDeclaration;
import com.arcway.repository.clientadapter.interFace.IPropertyType;
import com.arcway.repository.clientadapter.lib.IDOrNamePropertyComparator;
import com.arcway.repository.clientadapter.lib.NameOrIDPropertyTypeDeclaration;
import com.arcway.repository.interFace.data.data.IRepositoryData;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import com.arcway.repository.interFace.declaration.type.property.IRepositoryPropertyTypeID;
import com.arcway.repository.lib.high.declaration.type.object.RepositoryObjectTypeID;
import de.plans.lib.util.valueranges.DiscreteValue;
import de.plans.lib.util.valueranges.ValueRangeHelperDiscrete;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;

public class PropertyDeclarationsForRealType
implements IPropertyDeclarations {
    private static final Collection<String> CREATION_AND_MODIFIACTION_ATTRIBUTES = new LinkedList<String>(AbstractModuleData.ADMINISTRATIVE_MODULE_DATA_ATTRIBUTES);
    private final IModuleDataTypeDescriptionForPlatformAdapter dataTypeDescription;
    RepositoryObjectTypeID objectTypeID;
    private final IMap_<IRepositoryPropertyTypeID, Object> propertyTypeID_2_attributeTypeID;
    private final IMap_<String, EnumerationDeclaration> enumerationDeclarations;
    private final IMap_<String, ChildrenIDFormatPropertyTypeDeclaration> childrenIDFormatPropertyTypeDeclarations;
    private final AbstractDataMgr dataManager;
    final RepositoryIDCreator repositoryIDCreator;

    public PropertyDeclarationsForRealType(IModuleDataTypeDescriptionForPlatformAdapter dataTypeDescription, AbstractDataMgr dataManager, RepositoryIDCreator repositoryIDCreator) {
        this.dataTypeDescription = dataTypeDescription;
        this.dataManager = dataManager;
        this.repositoryIDCreator = repositoryIDCreator;
        this.objectTypeID = repositoryIDCreator.createObjectTypeIDForRealType(dataTypeDescription.getTypeID());
        HashMap_ propertyTypeID_2_attributeTypeID_RW = new HashMap_(IRepositoryPropertyTypeID.IS_EQUAL_PROPERTY_TYPE_ID_HASHER);
        Collection<String> attributeIDs = dataTypeDescription.getSimpleAttributeIDs();
        attributeIDs.removeAll(CREATION_AND_MODIFIACTION_ATTRIBUTES);
        for (String attributeID : attributeIDs) {
            IRepositoryPropertyTypeID repositoryPropertyTypeID = this.createPropertyTypeID(attributeID);
            propertyTypeID_2_attributeTypeID_RW.put((Object)repositoryPropertyTypeID, (Object)attributeID);
        }
        this.propertyTypeID_2_attributeTypeID = propertyTypeID_2_attributeTypeID_RW;
        this.enumerationDeclarations = this.createEnumerationDeclarations();
        this.childrenIDFormatPropertyTypeDeclarations = this.createChildrenIDFormatPropertyTypeDeclarations();
    }

    @Override
    public IRepositoryObjectTypeID getRepositoryObjectTypeID() {
        return this.objectTypeID;
    }

    @Override
    public IPropertyType[] getPropertyTypes() {
        Collection<String> attributeIDs = this.dataTypeDescription.getSimpleAttributeIDs();
        attributeIDs.removeAll(CREATION_AND_MODIFIACTION_ATTRIBUTES);
        IModuleData dummyInstance = this.dataTypeDescription.createInstance("dummy");
        IPropertyType[] propertyTypes = new IPropertyType[attributeIDs.size()];
        int index = 0;
        for (String attributeID : attributeIDs) {
            propertyTypes[index] = this.getPropertyType(attributeID, dummyInstance);
            ++index;
        }
        return propertyTypes;
    }

    @Override
    public IPropertyType getPropertyType(String attributeID) {
        IModuleData dummyInstance = this.dataTypeDescription.createInstance("dummy");
        return this.getPropertyType(attributeID, dummyInstance);
    }

    private IPropertyType getPropertyType(String attributeID, IModuleData dummyInstance) {
        IModuleDataAttribute attribute = dummyInstance.getAttribute(attributeID);
        RepositoryDataTypeWithDataTypeParameters repositoryDataType = AttributeTypeConverter.getRepositoryDataTypeForModuleDataAttribute(attributeID, attribute, this.dataTypeDescription.isMandatoryAttribute(attributeID), this);
        IRepositoryData defaultValueSample = AttributeTypeConverter.getRepositoryDataValueSampleForModuleDataAttribute(attribute, false);
        return new PropertyType(this.createPropertyTypeID(attributeID), repositoryDataType.getDataTypeID(), repositoryDataType.getDataTypeParameters(), repositoryDataType.getFrontendDataTypeParameters(), LabelHelper.getLabelsForAttribute(this.dataTypeDescription, attributeID), defaultValueSample);
    }

    @Override
    public INameOrIDPropertyTypeDeclaration getIDPropertyTypeDeclaration() {
        String idAttribute = this.dataTypeDescription.getIDAttribute();
        if (idAttribute != null) {
            IRepositoryPropertyTypeID propertyTypeID = this.createPropertyTypeID(idAttribute);
            return new NameOrIDPropertyTypeDeclaration(propertyTypeID, (IComparator_)IDOrNamePropertyComparator.COMPARATOR_WIHOUT_NORMALIZATION);
        }
        return null;
    }

    @Override
    public INameOrIDPropertyTypeDeclaration getNamePropertyTypeDeclaration() {
        String nameAttribute = this.dataTypeDescription.getNameAttribute();
        if (nameAttribute != null) {
            IRepositoryPropertyTypeID propertyTypeID = this.createPropertyTypeID(nameAttribute);
            return new NameOrIDPropertyTypeDeclaration(propertyTypeID, (IComparator_)IDOrNamePropertyComparator.COMPARATOR_WIHOUT_NORMALIZATION);
        }
        return null;
    }

    @Override
    public EnumerationDeclaration getEnumerationDeclaration(String attributeID) {
        return (EnumerationDeclaration)this.enumerationDeclarations.getByKey((Object)attributeID);
    }

    public IList_<Tuple<String, String>> getEnumerationElementValueUserIDPairs(String attributeID) {
        return ((EnumerationDeclaration)this.enumerationDeclarations.getByKey((Object)attributeID)).getValueUserIDPairs();
    }

    @Override
    public ISet_<String> getEnumerationElementValues(String attributeID) {
        return ((EnumerationDeclaration)this.enumerationDeclarations.getByKey((Object)attributeID)).getValues();
    }

    @Override
    public ChildrenIDFormatPropertyTypeDeclaration getChildrenIDFormatPropertyTypeDeclaration(String attributeID) {
        return (ChildrenIDFormatPropertyTypeDeclaration)this.childrenIDFormatPropertyTypeDeclarations.getByKey((Object)attributeID);
    }

    @Override
    public IMap_<IRepositoryPropertyTypeID, Object> getMap_propertyTypeID_attributeTypeID() {
        return this.propertyTypeID_2_attributeTypeID;
    }

    @Override
    public IRepositoryPropertyTypeID createPropertyTypeID(String attributeID) {
        return this.repositoryIDCreator.createPropertyTypeIDForAttribute(this.objectTypeID, attributeID);
    }

    private IMap_<String, EnumerationDeclaration> createEnumerationDeclarations() {
        Collection<String> attributeIDs = this.dataTypeDescription.getSimpleAttributeIDs();
        IModuleData dummyInstance = this.dataTypeDescription.createInstance("dummy");
        HashMap_ attributeID_2_enumeration = new HashMap_(IHasher_.EQUALS_HASHER);
        for (String attributeID : attributeIDs) {
            IModuleDataAttribute moduleDataAttribute = dummyInstance.getAttribute(attributeID);
            if (!(moduleDataAttribute instanceof ModuleDataAttributeDiscrete)) continue;
            ModuleDataAttributeDiscrete moduleDataAttributeDiscrete = (ModuleDataAttributeDiscrete)moduleDataAttribute;
            EnumerationDeclaration enumerationDeclaration = this.createEnumerationDeclaration(moduleDataAttributeDiscrete);
            attributeID_2_enumeration.put((Object)attributeID, (Object)enumerationDeclaration);
        }
        return attributeID_2_enumeration;
    }

    private EnumerationDeclaration createEnumerationDeclaration(ModuleDataAttributeDiscrete moduleDataAttributeDiscrete) {
        Locale projectLanguage = this.dataManager.getProjectLanguage();
        ValueRangeHelperDiscrete valueRangeHelperDiscrete = (ValueRangeHelperDiscrete)moduleDataAttributeDiscrete.getValueRangeHelper(projectLanguage);
        int indexOfEmptyEntry = DiscreteValueHelper.getIndexOfEmptyValue(valueRangeHelperDiscrete.getDiscreteValues());
        EnumerationDeclaration enumeration = new EnumerationDeclaration(indexOfEmptyEntry < 0);
        DiscreteValue[] discreteValues = valueRangeHelperDiscrete.getDiscreteValues();
        int j = 0;
        while (j < discreteValues.length) {
            if (j != indexOfEmptyEntry) {
                DiscreteValue discreteValue = discreteValues[j];
                String elementID = DiscreteValueHelper.getPlatformEnumerationElementID(ModuleDataAttributeDiscrete.getUniqueStringRepresentation(j));
                enumeration.addEntry(elementID, LabelHelper.getLabelsForDiscreteValue(discreteValue, projectLanguage));
            }
            ++j;
        }
        return enumeration;
    }

    private IMap_<String, ChildrenIDFormatPropertyTypeDeclaration> createChildrenIDFormatPropertyTypeDeclarations() {
        List<String> attributeIDs = this.dataTypeDescription.getChildrenIDFormatAttributeIDs();
        HashMap_ attributeID_2_childrenIDFormatPropertyTypeDeclaration = new HashMap_(IHasher_.EQUALS_HASHER);
        for (String attributeID : attributeIDs) {
            ChildrenIDFormatPropertyTypeDeclaration childrenIDFormatPropertyTypeDeclaration = this.createChildrenIDFormatPropertyTypeDeclaration(attributeID);
            attributeID_2_childrenIDFormatPropertyTypeDeclaration.put((Object)attributeID, (Object)childrenIDFormatPropertyTypeDeclaration);
        }
        return attributeID_2_childrenIDFormatPropertyTypeDeclaration;
    }

    private ChildrenIDFormatPropertyTypeDeclaration createChildrenIDFormatPropertyTypeDeclaration(String childrenIDFormatAttributeID) {
        String childCockpitTypeID = this.dataTypeDescription.getChildCockpitTypeForIDFormatAttribute(childrenIDFormatAttributeID);
        IModuleDataTypeDescription childTypeDescription = this.dataManager.getDataTypesHelper().getTypeDescription(childCockpitTypeID);
        ChildrenIDFormatPropertyTypeDeclaration declaration = new ChildrenIDFormatPropertyTypeDeclaration(true, (IRepositoryObjectTypeID)this.repositoryIDCreator.createObjectTypeIDForRealType(childCockpitTypeID), childTypeDescription.getDefaultIDPrefix(this.dataManager.getProjectLanguage()));
        return declaration;
    }
}

