/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.platformadapter;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeOwner;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ObjectTypeCategoryID;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType2;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.framedata.CustomPropertiesForModuleData;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeModificationManager;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeOwnerRW;
import com.arcway.cockpit.frame.client.project.modules.IModuleDataTypeDescriptionForFrame;
import com.arcway.cockpit.frame.shared.message.EOLock;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.Messages;
import com.arcway.cockpit.modulelib2.client.core.project.AbstractDataMgr;
import com.arcway.cockpit.modulelib2.client.core.project.AbstractLockManager;
import com.arcway.cockpit.modulelib2.client.core.project.LockAccess;
import com.arcway.cockpit.modulelib2.client.core.project.LockAccessWrapper;
import com.arcway.cockpit.modulelib2.client.core.project.permissions.AbstractPermissionMgr;
import com.arcway.cockpit.modulelib2.client.gui.dataview.jfaceviewer.tree.standard.StandardTreeDataViewSorter;
import com.arcway.cockpit.modulelib2.client.gui.editor.specification.AbstractEditorSpecificationPart;
import com.arcway.cockpit.modulelib2.client.gui.editor.specification.EditorLayoutSpecificationReader;
import com.arcway.cockpit.modulelib2.client.gui.editor.specification.structure.AttributeID;
import com.arcway.cockpit.modulelib2.client.gui.editor.specification.structure.Column;
import com.arcway.cockpit.modulelib2.client.gui.editor.specification.structure.CrossModuleRelationTypeID;
import com.arcway.cockpit.modulelib2.client.gui.editor.specification.structure.CustomProperties;
import com.arcway.cockpit.modulelib2.client.gui.editor.specification.structure.EditorLayoutSpecification;
import com.arcway.cockpit.modulelib2.client.gui.editor.specification.structure.IItemID;
import com.arcway.cockpit.modulelib2.client.gui.editor.specification.structure.ObjectTypeCategory;
import com.arcway.cockpit.modulelib2.client.gui.editor.specification.structure.Page;
import com.arcway.cockpit.modulelib2.client.gui.editor.specification.structure.RelationTypeID;
import com.arcway.cockpit.modulelib2.client.gui.editor.specification.structure.Table;
import com.arcway.cockpit.modulelib2.client.gui.editor.specification.structure.Widget;
import com.arcway.cockpit.modulelib2.client.messages.AbstractModuleData;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.modulelib2.client.messages.attributes.IModuleDataAttribute;
import com.arcway.cockpit.modulelib2.client.platformadapter.IPropertyDeclarations;
import com.arcway.cockpit.modulelib2.client.platformadapter.ParentRelationshipAdapterManager;
import com.arcway.cockpit.modulelib2.client.platformadapter.PropertyDeclarationsForRealType;
import com.arcway.cockpit.modulelib2.client.platformadapter.containerclasses.Property;
import com.arcway.cockpit.modulelib2.client.platformadapter.helper.AttributeTypeConverter;
import com.arcway.cockpit.modulelib2.client.platformadapter.helper.LockHelper;
import com.arcway.cockpit.modulelib2.client.platformadapter.helper.RepositoryIDCreator;
import com.arcway.cockpit.modulelib2.client.platformadapter.helper.WidgetSpecificationConverter;
import com.arcway.cockpit.modulelib2.client.platformadapter.interFace.ILicenseTypeProvider;
import com.arcway.cockpit.modulelib2.client.platformadapter.interFace.ILinkManagerInterfaceForPlatformAdapter;
import com.arcway.cockpit.modulelib2.client.platformadapter.interFace.IModuleDataTypeDescriptionForPlatformAdapter;
import com.arcway.cockpit.modulelib2.client.platformadapter.interFace.IModuleDataTypeSubsetDefinition;
import com.arcway.frontend.definition.lib.interFace.declaration.label.Icon;
import com.arcway.frontend.definition.lib.interFace.declaration.label.Text;
import com.arcway.lib.java.collections.ArrayList_;
import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.java.maps.IMap_;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.ui.editor.ObjectTypeCategoryLabels;
import com.arcway.lib.ui.editor.WidgetTypeID;
import com.arcway.lib.ui.editor.datatype.IWidgetTypeID;
import com.arcway.lib.ui.editor.layoutspecification.CustomPropertySpecification;
import com.arcway.lib.ui.editor.layoutspecification.WidgetSpecification;
import com.arcway.lib.ui.editor.parameters.WidgetParameters;
import com.arcway.lib.ui.editor.parameters.editor.ColumnWidgetParameters;
import com.arcway.lib.ui.editor.specification.editor.ColumnSpecification;
import com.arcway.lib.ui.editor.specification.editor.Editor;
import com.arcway.lib.ui.editor.specification.editor.PageSpecification;
import com.arcway.lib.ui.editor.specification.editor.TableSpecification;
import com.arcway.lib.ui.editor.specification.sequential.Sequence;
import com.arcway.repository.clientadapter.interFace.CockpitDataID;
import com.arcway.repository.clientadapter.interFace.EXCockpitLockDenied;
import com.arcway.repository.clientadapter.interFace.EXCockpitPermissionDenied;
import com.arcway.repository.clientadapter.interFace.ICockpitDataID;
import com.arcway.repository.clientadapter.interFace.IDataManagerAdapter;
import com.arcway.repository.clientadapter.interFace.IIDSampleAndLock;
import com.arcway.repository.clientadapter.interFace.ILabel;
import com.arcway.repository.clientadapter.interFace.ILock;
import com.arcway.repository.clientadapter.interFace.INameOrIDPropertyTypeDeclaration;
import com.arcway.repository.clientadapter.interFace.IOccurrenceManager;
import com.arcway.repository.clientadapter.interFace.IParentRelationshipAdapter;
import com.arcway.repository.clientadapter.interFace.IProperty;
import com.arcway.repository.clientadapter.interFace.IPropertyType;
import com.arcway.repository.cockpit.interFace.declaration.frame.modules.COTIDsModuleData;
import com.arcway.repository.interFace.data.RepositorySamples;
import com.arcway.repository.interFace.data.data.IRepositoryData;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryNoneBaseObjectTypeDeclaration;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import com.arcway.repository.interFace.declaration.type.property.IRepositoryPropertyTypeID;
import com.arcway.repository.interFace.declaration.type.relation.IRepositoryRelationTypeID;
import com.arcway.repository.interFace.declaration.type.relationcontribution.IRepositoryRelationContributionRoleID;
import com.arcway.repository.interFace.registration.type.IRepositoryTypeManagerRO;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataType;
import com.arcway.repository.interFace.registration.type.relation.ICrossLinkRepositoryRelationType;
import com.arcway.repository.interFace.registration.type.relationcontribution.ICrossLinkRepositoryRelationContributionType;
import com.arcway.repository.lib.high.declaration.type.object.RepositoryObjectTypeID;
import com.arcway.repository.lib.high.declaration.type.relation.RepositoryRelationTypeID;
import com.arcway.repository.lib.high.registration.data.AbstractRepositoryDataType;
import com.arcway.repository.lib.high.registration.data.lib.AbstractRepositoryStringDataType;
import com.arcway.repository.lib.high.registration.data.lib.exceptions.EXValueInvalid;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class DataManagerAdapter_RealType
implements IDataManagerAdapter {
    private static final ILogger logger = Logger.getLogger(DataManagerAdapter_RealType.class);
    private final String projectUID;
    private final IFrameProjectAgent projectAgent;
    private final AbstractDataMgr dataManager;
    private final ILinkManagerInterfaceForPlatformAdapter linkManager;
    private final ICollection_<? extends IParentRelationshipAdapter> parentRelationshipAdapters;
    private final IPropertyDeclarations propertyDeclarations;
    private final RepositoryIDCreator repositoryIDCreator;
    private final RepositoryObjectTypeID objectTypeID;
    private final IModuleDataTypeDescriptionForPlatformAdapter dataTypeDescription;
    private final IModuleDataTypeSubsetDefinition subsetDefinition;
    private final AbstractPermissionMgr permissionMgr;
    private final AbstractLockManager lockMgr;
    private final ILicenseTypeProvider licenseTypeProvider;
    private final boolean hasSharedNaturalOrderingDataType;
    private static final ICollection_<? extends IParentRelationshipAdapter> EMPTY = new ArrayList_(0);
    private static final Map<File, EditorLayoutSpecification> map_specFile_formEditorLayoutSpecs = new HashMap<File, EditorLayoutSpecification>();
    private static final Map<String, Editor> map_typeIDAndLanguage_formEditorLayoutSpec = new HashMap<String, Editor>();

    public DataManagerAdapter_RealType(IFrameProjectAgent projectAgent_, AbstractDataMgr dataManager, ILinkManagerInterfaceForPlatformAdapter linkManager, IModuleDataTypeDescriptionForPlatformAdapter dataTypeDescription, IModuleDataTypeSubsetDefinition subsetDefinition, boolean hasSharedNaturalOrderDataType, ILicenseTypeProvider licenseTypeProvider, RepositoryIDCreator repositoryIDCreator) {
        this.dataManager = dataManager;
        this.linkManager = linkManager;
        this.projectUID = projectAgent_.getProjectUID();
        this.projectAgent = projectAgent_;
        this.repositoryIDCreator = repositoryIDCreator;
        this.objectTypeID = repositoryIDCreator.createObjectTypeIDForRealType(subsetDefinition.getDataTypeID());
        this.parentRelationshipAdapters = ParentRelationshipAdapterManager.getParentRelationshipAdapters(dataTypeDescription, subsetDefinition, dataManager, licenseTypeProvider, repositoryIDCreator);
        this.propertyDeclarations = new PropertyDeclarationsForRealType(dataTypeDescription, dataManager, repositoryIDCreator);
        this.dataTypeDescription = dataTypeDescription;
        this.subsetDefinition = subsetDefinition;
        this.permissionMgr = dataManager.getPermissionMgr();
        this.lockMgr = dataManager.getLockMgr();
        this.licenseTypeProvider = licenseTypeProvider;
        this.hasSharedNaturalOrderingDataType = hasSharedNaturalOrderDataType;
    }

    public String getCockpitDataTypeID() {
        return this.dataTypeDescription.getTypeID();
    }

    public IRepositoryObjectTypeID getRepositoryObjectTypeID() {
        return this.objectTypeID;
    }

    public IRepositoryObjectTypeID getRepositorySuperObjectTypeID() {
        if (this.dataTypeDescription.hasSubsetDefinitions()) {
            return this.repositoryIDCreator.createObjectTypeIDForRealType(this.dataTypeDescription.getTypeID());
        }
        if (this.hasSharedNaturalOrderingDataType) {
            return this.repositoryIDCreator.createObjectTypeIDForAbstractNaturalOrderSuperType(this.dataTypeDescription.getDataTypeForNaturalOrdering().getCockpitDataTypeID());
        }
        return COTIDsModuleData.OBJECT_TYPE_ID;
    }

    public ILabel[] getLabels() {
        return this.subsetDefinition.getLabels();
    }

    public ICollection_<? extends IParentRelationshipAdapter> getParentRelationshipAdapters() {
        if (!this.hasSharedNaturalOrderingDataType) {
            return this.parentRelationshipAdapters;
        }
        return EMPTY;
    }

    public INameOrIDPropertyTypeDeclaration getIDPropertyTypeDeclaration() {
        if (!this.dataTypeDescription.hasSubsetDefinitions()) {
            return this.propertyDeclarations.getIDPropertyTypeDeclaration();
        }
        return null;
    }

    public INameOrIDPropertyTypeDeclaration getNamePropertyTypeDeclaration() {
        if (!this.dataTypeDescription.hasSubsetDefinitions()) {
            return this.propertyDeclarations.getNamePropertyTypeDeclaration();
        }
        return null;
    }

    public IPropertyType[] getFixPropertyTypes() {
        if (!this.dataTypeDescription.hasSubsetDefinitions()) {
            return this.propertyDeclarations.getPropertyTypes();
        }
        return new IPropertyType[0];
    }

    public String getCockpitTypeThatProvidesCustomProperties() {
        if (!this.dataTypeDescription.hasSubsetDefinitions()) {
            return this.dataTypeDescription.getTypeID();
        }
        return null;
    }

    public IRepositoryNoneBaseObjectTypeDeclaration.EnumCategorySupportTypeDeclaration getCategorySupportTypeDeclaration() {
        if (!this.dataTypeDescription.hasSubsetDefinitions()) {
            return this.dataTypeDescription.isSupportingCategories() ? IRepositoryNoneBaseObjectTypeDeclaration.EnumCategorySupportTypeDeclaration.YES : IRepositoryNoneBaseObjectTypeDeclaration.EnumCategorySupportTypeDeclaration.NO;
        }
        return IRepositoryNoneBaseObjectTypeDeclaration.EnumCategorySupportTypeDeclaration.SUPERTYPE;
    }

    public com.arcway.cockpit.frame.client.project.core.categories.ObjectTypeCategory getObjectTypeCategory(ICockpitProjectData cockpitData) {
        IModuleData moduleData = (IModuleData)cockpitData;
        ObjectTypeCategoryID categoryID = moduleData.getCategoryID();
        return categoryID != null ? this.projectAgent.getObjectTypeCategoriesManager().getCategory(categoryID) : null;
    }

    public IProperty getCockpitDataProperty(ICockpitProjectData cockpitData, IRepositoryPropertyTypeID repositoryPropertyTypeID) {
        IModuleData item = (IModuleData)cockpitData;
        boolean isRoot = this.dataManager.getParent(item) == null;
        String attributeID = (String)this.propertyDeclarations.getMap_propertyTypeID_attributeTypeID().getByKey((Object)repositoryPropertyTypeID);
        IModuleDataAttribute attribute = item.getAttribute(attributeID);
        IRepositoryData repositoryDataValue = AttributeTypeConverter.getRepositoryDataValueForModuleDataAttribute(attributeID, attribute, isRoot, this.propertyDeclarations, this.getRepositoryTypeManagerRO());
        Property property = new Property(repositoryPropertyTypeID, repositoryDataValue);
        return property;
    }

    public ICockpitProjectData findData(String cockpitDataUID) {
        IModuleData item = (IModuleData)this.dataManager.getItem(this.dataTypeDescription.getTypeID(), cockpitDataUID);
        if (item != null && !this.subsetDefinition.getChildrenSubset(Collections.singleton(item)).isEmpty()) {
            return item;
        }
        return null;
    }

    public ICockpitProjectData[] getAllData() {
        Collection<? extends ICockpitProjectData> allItems = this.dataManager.getAllItems(this.dataTypeDescription.getTypeID());
        allItems = this.subsetDefinition.getChildrenSubset(allItems);
        ICockpitProjectData[] allItemsAsArray = allItems.toArray(new ICockpitProjectData[0]);
        return allItemsAsArray;
    }

    public ICockpitProjectData findDataByNameProperty(IProperty nameProperty, ICockpitProjectData parent) {
        boolean isRoot;
        Collection<IModuleData> allChildrenOfGivenParent;
        IRepositoryData repositoryData = nameProperty.getValue();
        String attributeID = this.retrieveAttributeIDFromPropertyTypeID(nameProperty.getPropertyTypeID());
        IModuleData matchingChild = null;
        ICockpitDataID realParent = DataManagerAdapter_RealType.getRealParentCockpitDataID(parent);
        if (realParent.getCockpitDataTypeID().equals("hierarchyroot")) {
            allChildrenOfGivenParent = this.dataManager.getRootItems(this.dataTypeDescription.getTypeID());
            isRoot = true;
        } else {
            IModuleData parentAsModuleData = (IModuleData)parent;
            allChildrenOfGivenParent = this.dataManager.getChildren(parentAsModuleData, this.dataTypeDescription.getTypeID());
            isRoot = false;
        }
        allChildrenOfGivenParent = this.subsetDefinition.getChildrenSubset(allChildrenOfGivenParent);
        for (IModuleData child : allChildrenOfGivenParent) {
            IModuleDataAttribute modulDataAttribute = child.getAttribute(attributeID);
            IRepositoryData foundRepositoyData = AttributeTypeConverter.getRepositoryDataValueForModuleDataAttribute(attributeID, modulDataAttribute, isRoot, this.propertyDeclarations, this.getRepositoryTypeManagerRO());
            if (!RepositorySamples.isEqual((IRepositoryData)repositoryData, (IRepositoryData)foundRepositoyData)) continue;
            matchingChild = child;
            break;
        }
        return matchingChild;
    }

    public ICockpitProjectData findDataByIDProperty(IProperty idProperty) {
        IRepositoryData repositoryData = idProperty.getValue();
        IRepositoryDataType attributeDataType = repositoryData.getDataType();
        if (attributeDataType instanceof AbstractRepositoryStringDataType) {
            String id = ((AbstractRepositoryStringDataType)attributeDataType).dataToValue(repositoryData);
            IModuleData item = (IModuleData)this.dataManager.getItemByID(this.dataTypeDescription.getTypeID(), id);
            if (item != null && !this.subsetDefinition.getChildrenSubset(Collections.singleton(item)).isEmpty()) {
                return item;
            }
            return null;
        }
        String attributeID = this.retrieveAttributeIDFromPropertyTypeID(idProperty.getPropertyTypeID());
        logger.warn("Only id attributes of type string are supported by the platform adapter so far (" + this.dataTypeDescription.getTypeName(Locale.getDefault()) + " -> " + attributeID + " )");
        return null;
    }

    public ICockpitDataID getParentCockpitDataID(ICockpitProjectData cockpitData) {
        String parentUID;
        String parentTypeID;
        IModuleData parent = this.dataManager.getParent((IModuleData)cockpitData);
        if (parent != null) {
            parentTypeID = parent.getTypeID();
            parentUID = parent.getUID();
        } else {
            parentTypeID = "frame.project";
            parentUID = this.projectUID;
        }
        return new CockpitDataID(parentTypeID, parentUID);
    }

    public ICockpitProjectData[] getChildren(ICockpitProjectData parentCockpitData) {
        ICockpitDataID realParent = DataManagerAdapter_RealType.getRealParentCockpitDataID(parentCockpitData);
        HashSet<IModuleData> childItems = new HashSet<IModuleData>();
        if (realParent.getCockpitDataTypeID().equals("hierarchyroot")) {
            if (this.dataTypeDescription.isHierarchyType()) {
                childItems.addAll(this.dataManager.getAllRootItems());
            } else {
                childItems.addAll(this.dataManager.getAllItems(this.dataTypeDescription.getTypeID()));
            }
        } else {
            IModuleData parentItem = (IModuleData)this.dataManager.getItem(realParent.getCockpitDataTypeID(), realParent.getCockpitDataUID());
            assert (parentItem != null);
            childItems.addAll(this.dataManager.getChildren(parentItem));
        }
        Iterator childIterator = childItems.iterator();
        while (childIterator.hasNext()) {
            ICockpitProjectData child = (ICockpitProjectData)childIterator.next();
            if (child.getTypeID().equals(this.dataTypeDescription.getTypeID())) continue;
            childIterator.remove();
        }
        ArrayList<ICockpitProjectData> sortedChildItems = new ArrayList<ICockpitProjectData>(this.subsetDefinition.getChildrenSubset(childItems));
        IModuleDataTypeDescriptionForFrame dataTypeForNaturalOrdering = this.dataTypeDescription.getDataTypeForNaturalOrdering();
        if (dataTypeForNaturalOrdering != null && dataTypeForNaturalOrdering.hasNaturalOrder()) {
            final Comparator<IModuleData> naturalOrderComparator = StandardTreeDataViewSorter.getComparatorForNaturalOrder(this.dataManager.getModelController());
            Comparator<ICockpitProjectData> comparator = new Comparator<ICockpitProjectData>(){

                @Override
                public int compare(ICockpitProjectData o1, ICockpitProjectData o2) {
                    if (o1 instanceof IModuleData && o2 instanceof IModuleData) {
                        return naturalOrderComparator.compare((IModuleData)o1, (IModuleData)o2);
                    }
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    return 0;
                }
            };
            if (logger.isDebugEnabled(36)) {
                DataManagerAdapter_RealType.checkChildOrder(sortedChildItems, comparator);
            }
            Collections.sort(sortedChildItems, comparator);
        }
        ICockpitProjectData[] sortedChildrenAsArray = new ICockpitProjectData[sortedChildItems.size()];
        sortedChildItems.toArray(sortedChildrenAsArray);
        return sortedChildrenAsArray;
    }

    private static void checkChildOrder(Collection<ICockpitProjectData> collection, Comparator<ICockpitProjectData> comparator) {
        ArrayList sortedObjects = new ArrayList(collection.size());
        for (ICockpitProjectData incoming : collection) {
            boolean bl = false;
            int i = 0;
            while (i < sortedObjects.size()) {
                List existingObjects = (List)sortedObjects.get(i);
                ICockpitProjectData exisiting = (ICockpitProjectData)existingObjects.get(0);
                int sgn = comparator.compare(incoming, exisiting);
                if (sgn <= 0) {
                    if (sgn == 0) {
                        existingObjects.add(incoming);
                        bl = true;
                        break;
                    }
                    ArrayList<ICockpitProjectData> newObjects = new ArrayList<ICockpitProjectData>();
                    sortedObjects.add(i, newObjects);
                    newObjects.add(incoming);
                    bl = true;
                    break;
                }
                ++i;
            }
            if (bl) continue;
            ArrayList<ICockpitProjectData> newObjects = new ArrayList<ICockpitProjectData>();
            sortedObjects.add(newObjects);
            newObjects.add(incoming);
            bl = true;
        }
        ArrayList<String> errors = new ArrayList<String>();
        int i = 0;
        while (i < sortedObjects.size()) {
            List list = (List)sortedObjects.get(i);
            for (ICockpitProjectData objectToCheck : list) {
                ICockpitProjectData predecessor22;
                int j = 0;
                while (j < i) {
                    List predecessors = (List)sortedObjects.get(j);
                    for (ICockpitProjectData predecessor22 : predecessors) {
                        int sgn = comparator.compare(objectToCheck, predecessor22);
                        if (sgn < 0) {
                            errors.add(String.valueOf(DataManagerAdapter_RealType.getLabel(objectToCheck)) + " < predecessor " + DataManagerAdapter_RealType.getLabel(predecessor22));
                        }
                        if (sgn != 0) continue;
                        errors.add(String.valueOf(DataManagerAdapter_RealType.getLabel(objectToCheck)) + " = predecessor " + DataManagerAdapter_RealType.getLabel(predecessor22));
                    }
                    ++j;
                }
                List euquals = (List)sortedObjects.get(i);
                predecessor22 = euquals.iterator();
                while (predecessor22.hasNext()) {
                    ICockpitProjectData equal = (ICockpitProjectData)predecessor22.next();
                    int sgn = comparator.compare(objectToCheck, equal);
                    if (sgn < 0) {
                        errors.add(String.valueOf(DataManagerAdapter_RealType.getLabel(objectToCheck)) + " < equal " + DataManagerAdapter_RealType.getLabel(equal));
                    }
                    if (sgn <= 0) continue;
                    errors.add(String.valueOf(DataManagerAdapter_RealType.getLabel(objectToCheck)) + " > equal " + DataManagerAdapter_RealType.getLabel(equal));
                }
                int j2 = i + 1;
                while (j2 < sortedObjects.size()) {
                    List successors = (List)sortedObjects.get(j2);
                    for (ICockpitProjectData successor : successors) {
                        int sgn = comparator.compare(objectToCheck, successor);
                        if (sgn == 0) {
                            errors.add(String.valueOf(DataManagerAdapter_RealType.getLabel(objectToCheck)) + " = successor " + DataManagerAdapter_RealType.getLabel(successor));
                        }
                        if (sgn <= 0) continue;
                        errors.add(String.valueOf(DataManagerAdapter_RealType.getLabel(objectToCheck)) + " > successor " + DataManagerAdapter_RealType.getLabel(successor));
                    }
                    ++j2;
                }
            }
            ++i;
        }
        StringBuilder errorText = new StringBuilder();
        if (!errors.isEmpty()) {
            errorText.append("Inconsistently ordered child objects. Assumed the follwing order:\n");
        } else {
            errorText.append("Consistenlty ordered child objects in the follwing order:\n");
        }
        for (List list : sortedObjects) {
            for (ICockpitProjectData object : list) {
                errorText.append("- " + DataManagerAdapter_RealType.getLabel(object) + " ");
            }
            errorText.append("\n");
        }
        if (!errors.isEmpty()) {
            errorText.append("the folling inconsistencies appear:\n");
            for (String string : errors) {
                errorText.append("- " + string + "\n");
            }
        }
        if (errors.isEmpty()) {
            logger.info(errorText.toString());
        } else {
            logger.error(errorText.toString());
        }
    }

    private static String getLabel(ICockpitProjectData object) {
        return String.valueOf(object.getTypeID()) + "/" + object.getUID();
    }

    public ICockpitProjectData createCockpitData(ICockpitProjectData parentCockpitData, String cockpitDataUID, String objectTypeCategoryIDString, IProperty[] properties) throws EXCockpitLockDenied, EXCockpitPermissionDenied {
        ICockpitDataID realParent = DataManagerAdapter_RealType.getRealParentCockpitDataID(parentCockpitData);
        final IModuleData moduleData = this.dataTypeDescription.createInstance(cockpitDataUID);
        moduleData.setProjectUID(this.projectUID);
        ObjectTypeCategoryID objectTypeCategoryID = objectTypeCategoryIDString != null ? ObjectTypeCategoryID.getObjectTypeCategoryID((String)objectTypeCategoryIDString) : null;
        moduleData.setCategoryID(objectTypeCategoryID);
        this.fillInAttributes(moduleData, properties);
        IModuleData parent = null;
        if (!realParent.getCockpitDataTypeID().equals("hierarchyroot")) {
            parent = (IModuleData)this.dataManager.getItem(realParent.getCockpitDataTypeID(), realParent.getCockpitDataUID());
            this.checkPermissionForCreateCockpitData((ICockpitProjectData)parent);
            LockAccess lockAccess = this.lockMgr.acquireInsertLock((ICockpitProjectData)parent, true);
            if (!lockAccess.hasLock()) {
                Collection<EOLock> conflictingLocks = lockAccess.getConflictingLocks();
                throw new EXCockpitLockDenied(conflictingLocks.toArray(new EOLock[conflictingLocks.size()]));
            }
            this.checkIDNameAttributeLocks(properties, realParent.getCockpitDataUID(), moduleData);
        } else {
            this.checkPermissionForCreateCockpitData(null);
            this.checkIDNameAttributeLocks(properties, null, moduleData);
        }
        final IModuleData parent_final = parent;
        this.dataManager.getModelTransactionManager().executeTransaction(new Runnable(){

            @Override
            public void run() {
                DataManagerAdapter_RealType.this.dataManager.addItem(moduleData);
                if (parent_final != null) {
                    DataManagerAdapter_RealType.this.linkManager.createLink(parent_final.getUID(), moduleData.getUID(), DataManagerAdapter_RealType.this.dataTypeDescription.getHierarchyLinkTypeForParentType(parent_final.getTypeID()));
                }
            }
        });
        return moduleData;
    }

    private static ICockpitDataID getRealParentCockpitDataID(ICockpitProjectData platformParent) {
        String platform_parentTypeID = platformParent.getTypeID();
        String platform_parentUID = platformParent.getUID();
        return DataManagerAdapter_RealType.getRealParentCockpitDataID(platform_parentTypeID, platform_parentUID);
    }

    private static ICockpitDataID getRealParentCockpitDataID(String platform_parentTypeID, String platform_parentUID) {
        String parentUID = platform_parentUID;
        String parentTypeID = platform_parentTypeID;
        if (parentTypeID.equals("frame.project") || parentTypeID.equals("com.arcway.cockpit.section")) {
            parentTypeID = "hierarchyroot";
        }
        return new CockpitDataID(parentTypeID, parentUID);
    }

    public ICockpitProjectData modifyCockpitDataObjectTypeCategory(final ICockpitProjectData cockpitData, String newCategoryID) throws EXCockpitLockDenied, EXCockpitPermissionDenied {
        this.checkPermissionForModifyCockpitDataObjectTypeCategory(cockpitData);
        this.getLockForModifyCockpitData(cockpitData);
        ObjectTypeCategoryID newCategoryIDObject = newCategoryID != null ? ObjectTypeCategoryID.getObjectTypeCategoryID((String)newCategoryID) : null;
        ((AbstractModuleData)cockpitData).setCategoryID(newCategoryIDObject);
        this.dataManager.getModelTransactionManager().executeTransaction(new Runnable(){

            @Override
            public void run() {
                DataManagerAdapter_RealType.this.dataManager.itemPropertiesModified((IModuleData)cockpitData);
            }
        });
        return cockpitData;
    }

    public ICockpitProjectData modifyCockpitData(final ICockpitProjectData cockpitData, IProperty[] newProperties) throws EXCockpitLockDenied, EXCockpitPermissionDenied {
        IProperty[] iPropertyArray = newProperties;
        int n = newProperties.length;
        int n2 = 0;
        while (n2 < n) {
            IProperty newPropertie = iPropertyArray[n2];
            this.checkPermissionForModifyCockpitDataProperty(cockpitData, newPropertie.getPropertyTypeID());
            ++n2;
        }
        LockAccess lockAccess = this.lockMgr.acquireEditLock(cockpitData);
        if (!lockAccess.hasLock()) {
            Collection<EOLock> conflictingLocks = lockAccess.getConflictingLocks();
            throw new EXCockpitLockDenied(conflictingLocks.toArray(new EOLock[conflictingLocks.size()]));
        }
        IModuleData parent = this.dataManager.getParent((IModuleData)cockpitData);
        String parentUID = parent != null ? parent.getUID() : null;
        this.checkIDNameAttributeLocks(newProperties, parentUID, (IModuleData)cockpitData);
        this.fillInAttributes((IModuleData)cockpitData, newProperties);
        this.dataManager.getModelTransactionManager().executeTransaction(new Runnable(){

            @Override
            public void run() {
                DataManagerAdapter_RealType.this.dataManager.itemPropertiesModified((IModuleData)cockpitData);
            }
        });
        return cockpitData;
    }

    public void deleteCockpitData(final ICockpitProjectData cockpitData) throws EXCockpitLockDenied, EXCockpitPermissionDenied {
        this.checkPermissionForDeleteCockpitData(cockpitData);
        LockAccess lockAccess = this.lockMgr.acquireRemoveLock(cockpitData);
        if (!lockAccess.hasLock()) {
            Collection<EOLock> conflictingLocks = lockAccess.getConflictingLocks();
            throw new EXCockpitLockDenied(conflictingLocks.toArray(new EOLock[conflictingLocks.size()]));
        }
        this.dataManager.getModelTransactionManager().executeTransaction(new Runnable(){

            @Override
            public void run() {
                DataManagerAdapter_RealType.this.dataManager.removeItem((IModuleData)cockpitData);
            }
        });
    }

    public void moveCockpitData(ICockpitProjectData cockpitData, ICockpitProjectData newParentCockpitData) throws EXCockpitLockDenied, EXCockpitPermissionDenied {
        String newParentTypeID;
        this.checkPermissionForMoveCockpitData(cockpitData, newParentCockpitData);
        LockAccess lockAccess = this.lockMgr.acquireMoveLockBeforeMoving(cockpitData, null);
        if (!lockAccess.hasLock()) {
            Collection<EOLock> conflictingLocks = lockAccess.getConflictingLocks();
            throw new EXCockpitLockDenied(conflictingLocks.toArray(new EOLock[conflictingLocks.size()]));
        }
        lockAccess = this.lockMgr.acquireMoveLock(newParentCockpitData);
        if (!lockAccess.hasLock()) {
            Collection<EOLock> conflictingLocks = lockAccess.getConflictingLocks();
            throw new EXCockpitLockDenied(conflictingLocks.toArray(new EOLock[conflictingLocks.size()]));
        }
        IModuleData item = (IModuleData)cockpitData;
        IModuleData oldParent = this.dataManager.getParent(item);
        if (oldParent != null) {
            this.linkManager.deleteLink(oldParent.getUID(), item.getUID(), this.dataTypeDescription.getHierarchyLinkTypeForParentType(oldParent.getTypeID()));
        }
        if ((newParentTypeID = newParentCockpitData.getTypeID()).equals("frame.project")) {
            newParentTypeID = "hierarchyroot";
        }
        if (!newParentTypeID.equals("hierarchyroot")) {
            this.linkManager.createLink(newParentCockpitData.getUID(), item.getUID(), this.dataTypeDescription.getHierarchyLinkTypeForParentType(newParentTypeID));
        }
    }

    public IRepositoryTypeManagerRO getRepositoryTypeManagerRO() {
        return this.projectAgent.getRepositoryInterface().getTypeManager();
    }

    private String retrieveAttributeIDFromPropertyTypeID(IRepositoryPropertyTypeID propertyTypeID) {
        String propertyIDString = propertyTypeID.toCanonicalString();
        String shortenedPropertyID = propertyIDString.substring(propertyIDString.lastIndexOf(".") + 1);
        for (String currentAttributeID : this.dataTypeDescription.getSimpleAttributeIDs()) {
            if (!currentAttributeID.equals(shortenedPropertyID) && !currentAttributeID.endsWith("." + shortenedPropertyID)) continue;
            return currentAttributeID;
        }
        assert (false);
        return null;
    }

    private void fillInAttributes(IModuleData moduleData, IProperty[] properties) {
        IProperty[] iPropertyArray = properties;
        int n = properties.length;
        int n2 = 0;
        while (n2 < n) {
            IProperty propertie = iPropertyArray[n2];
            String attributeID = this.retrieveAttributeIDFromPropertyTypeID(propertie.getPropertyTypeID());
            IModuleDataAttribute attribute = moduleData.getAttribute(attributeID);
            AttributeTypeConverter.setModuleDataAttributeWithRepositoryDataValue(attribute, propertie.getValue());
            ++n2;
        }
    }

    public Locale getProjectLanguage() {
        return this.dataManager.getProjectLanguage();
    }

    public boolean isCreatableGenerically() {
        return this.dataTypeDescription.isCreatableGenerically();
    }

    public boolean isModifiableGenerically() {
        return this.dataTypeDescription.isModifiableGenerically();
    }

    public boolean isDeletableGenerically() {
        return this.dataTypeDescription.isDeletableGenerically();
    }

    public Text getObjectLabelText() {
        return this.dataTypeDescription.getStatusDependantLabelSpecification(this.repositoryIDCreator);
    }

    public Icon getObjectLabelIcon() {
        return this.dataTypeDescription.getStatusDependantIconSpecification(this.propertyDeclarations);
    }

    public void checkPermissionForCreateCockpitData(ICockpitProjectData parentCockpitData) throws EXCockpitPermissionDenied {
        IModuleData parentForPermission;
        IClientFunctionLicenseType2 licenseType = this.licenseTypeProvider.getModificationLicenseType();
        if (licenseType != null && !this.projectAgent.getServerLicenseManager().isLicenseOperationAllowed((IClientFunctionLicenseType)licenseType)) {
            throw new EXCockpitPermissionDenied(new String[]{Messages.getString("EXPermissionDenied.NoLicense")});
        }
        IModuleData iModuleData = parentForPermission = parentCockpitData instanceof IModuleData ? (IModuleData)parentCockpitData : null;
        if (!this.permissionMgr.mayCreateChildren(parentForPermission, this.dataTypeDescription.getTypeID())) {
            throw new EXCockpitPermissionDenied(new String[]{Messages.getString("EXPermissionDenied")});
        }
    }

    public void checkPermissionForDeleteCockpitData(ICockpitProjectData cockpitData) throws EXCockpitPermissionDenied {
        IClientFunctionLicenseType2 licenseType = this.licenseTypeProvider.getModificationLicenseType();
        if (licenseType != null && !this.projectAgent.getServerLicenseManager().isLicenseOperationAllowed((IClientFunctionLicenseType)licenseType)) {
            throw new EXCockpitPermissionDenied(new String[]{Messages.getString("EXPermissionDenied.NoLicense")});
        }
        if (!this.permissionMgr.mayDeleteItem((IModuleData)cockpitData)) {
            throw new EXCockpitPermissionDenied(new String[]{Messages.getString("EXPermissionDenied")});
        }
    }

    public void checkPermissionForModifyCockpitDataProperty(ICockpitProjectData cockpitData, IRepositoryPropertyTypeID propertyTypeID) throws EXCockpitPermissionDenied {
        String attributeType;
        IModuleData parent;
        IClientFunctionLicenseType2 licenseType = this.licenseTypeProvider.getModificationLicenseType();
        if (licenseType != null && !this.projectAgent.getServerLicenseManager().isLicenseOperationAllowed((IClientFunctionLicenseType)licenseType)) {
            throw new EXCockpitPermissionDenied(new String[]{Messages.getString("EXPermissionDenied.NoLicense")});
        }
        if (this.dataManager.itemExistsOnServer(cockpitData.getUID(), cockpitData.getTypeID()) && !this.permissionMgr.mayEditAttribute((IModuleData)cockpitData, parent = this.dataManager.getParent((IModuleData)cockpitData), attributeType = this.retrieveAttributeIDFromPropertyTypeID(propertyTypeID))) {
            throw new EXCockpitPermissionDenied(new String[]{Messages.getString("EXPermissionDenied")});
        }
    }

    public void checkPermissionForModifyCockpitDataProperty(ICockpitProjectData cockpitData, IAttributeType customPropertyType) throws EXCockpitPermissionDenied {
        IModuleData parent;
        IClientFunctionLicenseType2 licenseType = this.licenseTypeProvider.getModificationLicenseType();
        if (licenseType != null && !this.projectAgent.getServerLicenseManager().isLicenseOperationAllowed((IClientFunctionLicenseType)licenseType)) {
            throw new EXCockpitPermissionDenied(new String[]{Messages.getString("EXPermissionDenied.NoLicense")});
        }
        if (this.dataManager.itemExistsOnServer(cockpitData.getUID(), cockpitData.getTypeID()) && !this.permissionMgr.mayEditAttribute((IModuleData)cockpitData, parent = this.dataManager.getParent((IModuleData)cockpitData), customPropertyType)) {
            throw new EXCockpitPermissionDenied(new String[]{Messages.getString("EXPermissionDenied")});
        }
    }

    public void checkPermissionForModifyCockpitDataObjectTypeCategory(ICockpitProjectData cockpitData) throws EXCockpitPermissionDenied {
        IModuleData parent;
        IClientFunctionLicenseType2 licenseType = this.licenseTypeProvider.getModificationLicenseType();
        if (licenseType != null && !this.projectAgent.getServerLicenseManager().isLicenseOperationAllowed((IClientFunctionLicenseType)licenseType)) {
            throw new EXCockpitPermissionDenied(new String[]{Messages.getString("EXPermissionDenied.NoLicense")});
        }
        if (this.dataManager.itemExistsOnServer(cockpitData.getUID(), cockpitData.getTypeID()) && !this.permissionMgr.mayEditItemStructurally((IModuleData)cockpitData, parent = this.dataManager.getParent((IModuleData)cockpitData))) {
            throw new EXCockpitPermissionDenied(new String[]{Messages.getString("EXPermissionDenied")});
        }
    }

    public void checkPermissionForMoveCockpitData(ICockpitProjectData cockpitData, ICockpitProjectData newParentCockpitData) throws EXCockpitPermissionDenied {
        IClientFunctionLicenseType2 licenseType = this.licenseTypeProvider.getModificationLicenseType();
        if (licenseType != null && !this.projectAgent.getServerLicenseManager().isLicenseOperationAllowed((IClientFunctionLicenseType)licenseType)) {
            throw new EXCockpitPermissionDenied(new String[]{Messages.getString("EXPermissionDenied.NoLicense")});
        }
        throw new UnsupportedOperationException("not yet implemented");
    }

    public ILock getLockForCreateCockpitData(ICockpitProjectData parentCockpitData) throws EXCockpitLockDenied {
        ICockpitDataID realParentCockpitDataID = DataManagerAdapter_RealType.getRealParentCockpitDataID(parentCockpitData);
        if (realParentCockpitDataID.getCockpitDataTypeID().equals("hierarchyroot")) {
            return ILock.DUMMY;
        }
        IModuleData parent = (IModuleData)this.dataManager.getItem(realParentCockpitDataID.getCockpitDataTypeID(), realParentCockpitDataID.getCockpitDataUID());
        LockAccess lockAccess = this.lockMgr.acquireInsertLock((ICockpitProjectData)parent, false);
        return LockHelper.getILock(lockAccess);
    }

    public ILock getLockForDeleteCockpitData(ICockpitProjectData cockpitData) throws EXCockpitLockDenied {
        LockAccess lockAccess = this.lockMgr.acquireRemoveLock(cockpitData, false);
        return LockHelper.getILock(lockAccess);
    }

    public ILock getLockForModifyCockpitData(ICockpitProjectData cockpitData) throws EXCockpitLockDenied {
        LockAccess lockAccess = this.lockMgr.acquireEditLock(cockpitData, false);
        return LockHelper.getILock(lockAccess);
    }

    public ILock getLockForMoveCockpitData(ICockpitProjectData cockpitData, ICockpitProjectData parentCockpitData) throws EXCockpitLockDenied {
        return null;
    }

    public ILock getLockForUniqueID(String id) throws EXCockpitLockDenied {
        LockAccess lockAccessIDLock = this.lockMgr.acquireUniqueIDLock(id, this.dataTypeDescription.getTypeID());
        if (!lockAccessIDLock.hasLock()) {
            Collection<EOLock> conflictingLocks = lockAccessIDLock.getConflictingLocks();
            throw new EXCockpitLockDenied(conflictingLocks.toArray(new EOLock[conflictingLocks.size()]));
        }
        return LockHelper.getILock(lockAccessIDLock);
    }

    private void checkIDNameAttributeLocks(IProperty[] properties, String parentCockpitDataUID, IModuleData moduleData) throws EXCockpitLockDenied {
        String nameAttribute = this.dataTypeDescription.getNameAttribute();
        String idAttribute = this.dataTypeDescription.getIDAttribute();
        if (nameAttribute == null && idAttribute == null) {
            return;
        }
        IProperty[] iPropertyArray = properties;
        int n = properties.length;
        int n2 = 0;
        while (n2 < n) {
            IModuleDataAttribute attribute;
            IProperty propertyToCheck = iPropertyArray[n2];
            String attributeID = this.retrieveAttributeIDFromPropertyTypeID(propertyToCheck.getPropertyTypeID());
            if (nameAttribute != null && nameAttribute.equals(attributeID)) {
                attribute = moduleData.getAttribute(attributeID).copy();
                AttributeTypeConverter.setModuleDataAttributeWithRepositoryDataValue(attribute, propertyToCheck.getValue());
                LockAccess lockAccessNameLock = this.lockMgr.acquireUniqueNameLock(attribute.getDisplayStringRepresentation(), attributeID, parentCockpitDataUID);
                if (!lockAccessNameLock.hasLock()) {
                    Collection<EOLock> conflictingLocks = lockAccessNameLock.getConflictingLocks();
                    throw new EXCockpitLockDenied(conflictingLocks.toArray(new EOLock[conflictingLocks.size()]));
                }
            } else if (idAttribute != null && idAttribute.equals(attributeID)) {
                attribute = moduleData.getAttribute(attributeID).copy();
                AttributeTypeConverter.setModuleDataAttributeWithRepositoryDataValue(attribute, propertyToCheck.getValue());
                LockAccess lockAccessIDLock = this.lockMgr.acquireUniqueIDLock(attribute.getDisplayStringRepresentation(), moduleData.getTypeID());
                if (!lockAccessIDLock.hasLock()) {
                    Collection<EOLock> conflictingLocks = lockAccessIDLock.getConflictingLocks();
                    throw new EXCockpitLockDenied(conflictingLocks.toArray(new EOLock[conflictingLocks.size()]));
                }
            }
            ++n2;
        }
    }

    public Editor getFormEditorLayoutSpecification() {
        RepositoryObjectTypeID objectTypeId = this.repositoryIDCreator.createObjectTypeIDForRealType(this.dataTypeDescription.getTypeID());
        int index = objectTypeId.toCanonicalString().lastIndexOf(".") + 1;
        String specificationType = objectTypeId.toCanonicalString().substring(index);
        Locale projectLanguage = this.getProjectLanguage();
        String typeIDAndLanguageKey = String.valueOf(this.dataTypeDescription.getTypeID()) + "\n" + projectLanguage.toString();
        if (map_typeIDAndLanguage_formEditorLayoutSpec.containsKey(typeIDAndLanguageKey)) {
            return map_typeIDAndLanguage_formEditorLayoutSpec.get(typeIDAndLanguageKey);
        }
        Editor editorSpecification = null;
        File editorSpecificationFile = this.dataTypeDescription.getEditorLayoutSpecificationFile();
        if (editorSpecificationFile != null) {
            EditorLayoutSpecification editorLayoutSpec;
            if (map_specFile_formEditorLayoutSpecs.containsKey(editorSpecificationFile)) {
                editorLayoutSpec = map_specFile_formEditorLayoutSpecs.get(editorSpecificationFile);
            } else {
                editorLayoutSpec = EditorLayoutSpecificationReader.readEditorLayoutSpecification(editorSpecificationFile);
                map_specFile_formEditorLayoutSpecs.put(editorSpecificationFile, editorLayoutSpec);
            }
            if (editorLayoutSpec != null && editorLayoutSpec.getEditor(specificationType) != null) {
                List<Page> modulePageSpecifications = editorLayoutSpec.getEditor(specificationType).getPageList();
                List<PageSpecification> pages = this.getPages(modulePageSpecifications, projectLanguage);
                editorSpecification = new Editor(pages, null);
            }
        }
        map_typeIDAndLanguage_formEditorLayoutSpec.put(typeIDAndLanguageKey, editorSpecification);
        return editorSpecification;
    }

    private List<PageSpecification> getPages(List<Page> modulePageSpecifications, Locale projectLanguage) {
        ArrayList<PageSpecification> pages = new ArrayList<PageSpecification>();
        for (Page modulePageSpecification : modulePageSpecifications) {
            List<Table> moduleTableSpecifications = modulePageSpecification.getTableList();
            List<TableSpecification> tables = this.getTables(moduleTableSpecifications, projectLanguage);
            if (tables == null || tables.isEmpty()) continue;
            PageSpecification pageSpecification = new PageSpecification(tables, WidgetSpecificationConverter.convertPageParameters(modulePageSpecification.getPageParameters(), projectLanguage));
            pages.add(pageSpecification);
        }
        return pages;
    }

    private List<TableSpecification> getTables(List<Table> moduleTableSpecifications, Locale projectLanguage) {
        ArrayList<TableSpecification> tables = new ArrayList<TableSpecification>();
        for (Table moduleTableSpecification : moduleTableSpecifications) {
            List<AbstractEditorSpecificationPart> moduleTableChildSpecifications = moduleTableSpecification.getChildList();
            ArrayList<Object> children = new ArrayList<Object>();
            for (AbstractEditorSpecificationPart part : moduleTableChildSpecifications) {
                if (part instanceof Column) {
                    ColumnSpecification columnSpec = this.getColumn((Column)part, projectLanguage);
                    if (columnSpec == null) continue;
                    children.add(columnSpec);
                    continue;
                }
                if (part instanceof Widget) {
                    WidgetSpecification widgetSpec = this.createWidget((Widget)part, projectLanguage);
                    if (widgetSpec == null) continue;
                    children.add(widgetSpec);
                    continue;
                }
                if (part instanceof Table) {
                    List<TableSpecification> childTables = this.getTables(Collections.singletonList((Table)part), projectLanguage);
                    if (childTables == null || childTables.isEmpty()) continue;
                    children.addAll(childTables);
                    continue;
                }
                if (!(part instanceof CustomProperties)) continue;
                children.add(DataManagerAdapter_RealType.createCustomProperties((CustomProperties)part, projectLanguage));
            }
            if (children.isEmpty()) continue;
            TableSpecification tableSpecification = new TableSpecification(children, (WidgetParameters)WidgetSpecificationConverter.convertTableParameters(moduleTableSpecification.getTableParameters()));
            tables.add(tableSpecification);
        }
        return tables;
    }

    private ColumnSpecification getColumn(Column column, Locale projectLanguage) {
        List<AbstractEditorSpecificationPart> moduleColumnChildSpecifications = column.getChildList();
        ArrayList<Object> children = new ArrayList<Object>();
        for (AbstractEditorSpecificationPart part : moduleColumnChildSpecifications) {
            if (part instanceof Widget) {
                WidgetSpecification widgetSpec = this.createWidget((Widget)part, projectLanguage);
                if (widgetSpec == null) continue;
                children.add(widgetSpec);
                continue;
            }
            if (!(part instanceof CustomProperties)) continue;
            children.add(DataManagerAdapter_RealType.createCustomProperties((CustomProperties)part, projectLanguage));
        }
        if (!children.isEmpty()) {
            return new ColumnSpecification(children, WidgetSpecificationConverter.convertColumnParameters(column.getColumnParameters(), projectLanguage));
        }
        return null;
    }

    private static CustomPropertySpecification createCustomProperties(CustomProperties customProperties, Locale projectLanguage) {
        ColumnWidgetParameters parameters = WidgetSpecificationConverter.convertColumnParameters(customProperties.getColumnParameters(), projectLanguage);
        return new CustomPropertySpecification((WidgetParameters)parameters);
    }

    private WidgetSpecification createWidget(Widget widget, Locale projectLanguage) {
        boolean skipWidget = false;
        boolean isObjectTypeCategoryUsed = false;
        ArrayList<String> propertyTypeIds = new ArrayList<String>();
        HashMap<String, String> relationTypeIds2relationContributionRoleIds = new HashMap<String, String>();
        List<IItemID> itemIDs = widget.getItemIDList();
        WidgetParameters widgetParameters = null;
        if (!itemIDs.isEmpty()) {
            for (IItemID itemID : itemIDs) {
                if (itemID instanceof ObjectTypeCategory) {
                    widgetParameters = WidgetSpecificationConverter.convertContentWidgetParameters(widget.getWidgetParameters(), ObjectTypeCategoryLabels.LABEL_CATEGORY, projectLanguage);
                    isObjectTypeCategoryUsed = true;
                    continue;
                }
                if (itemID instanceof AttributeID) {
                    String relationContributionRoleIDAsString;
                    IRepositoryRelationContributionRoleID relationContributionRoleID;
                    String relationTypeIDAsString;
                    RepositoryRelationTypeID relationTypeID;
                    String linkTypeID;
                    if (this.dataTypeDescription.isLinkedModuleDataAttribute(itemID.getItemID())) {
                        linkTypeID = this.dataTypeDescription.getLinkTypeIDForLinkedModuleDataAttribute(itemID.getItemID());
                        relationTypeID = this.repositoryIDCreator.createRelationTypeID(linkTypeID);
                        relationTypeIDAsString = relationTypeID.toCanonicalString();
                        relationContributionRoleID = this.repositoryIDCreator.createRelationContributionRoleID(linkTypeID, "object");
                        relationContributionRoleIDAsString = relationContributionRoleID.toCanonicalString();
                        widgetParameters = WidgetSpecificationConverter.convertContentWidgetParameters(widget.getWidgetParameters(), this.dataTypeDescription.getAttributeName(itemID.getItemID(), projectLanguage), projectLanguage);
                        relationTypeIds2relationContributionRoleIds.put(relationTypeIDAsString, relationContributionRoleIDAsString);
                        continue;
                    }
                    if (this.dataTypeDescription.isLinkedFrameDataAttribute(itemID.getItemID())) {
                        linkTypeID = this.dataTypeDescription.getLinkTypeIDForLinkedFrameDataAttribute(itemID.getItemID());
                        relationTypeID = this.repositoryIDCreator.createRelationTypeID(linkTypeID);
                        relationTypeIDAsString = relationTypeID.toCanonicalString();
                        relationContributionRoleID = this.repositoryIDCreator.createRelationContributionRoleID(linkTypeID, "object");
                        relationContributionRoleIDAsString = relationContributionRoleID.toCanonicalString();
                        widgetParameters = WidgetSpecificationConverter.convertContentWidgetParameters(widget.getWidgetParameters(), this.dataTypeDescription.getAttributeName(itemID.getItemID(), projectLanguage), projectLanguage);
                        relationTypeIds2relationContributionRoleIds.put(relationTypeIDAsString, relationContributionRoleIDAsString);
                        continue;
                    }
                    String propertyTypeID = this.propertyDeclarations.createPropertyTypeID(itemID.getItemID()).toCanonicalString();
                    String attributeName = this.dataTypeDescription.getAttributeName(itemID.getItemID(), projectLanguage);
                    widgetParameters = WidgetSpecificationConverter.convertContentWidgetParameters(widget.getWidgetParameters(), attributeName, projectLanguage);
                    propertyTypeIds.add(propertyTypeID);
                    continue;
                }
                if (!(itemID instanceof RelationTypeID) && !(itemID instanceof CrossModuleRelationTypeID)) continue;
                RepositoryRelationTypeID relationTypeID = null;
                String relationContributionRoleID = null;
                if (itemID instanceof RelationTypeID) {
                    relationTypeID = this.repositoryIDCreator.createRelationTypeID(itemID.getItemID());
                    relationContributionRoleID = ((RelationTypeID)itemID).getRoleID();
                } else {
                    relationTypeID = new RepositoryIDCreator("crossmodulelinks", itemID.getItemID()).createRelationTypeID(itemID.getItemID());
                    relationContributionRoleID = ((CrossModuleRelationTypeID)itemID).getRoleID();
                }
                try {
                    ICrossLinkRepositoryRelationType relationType = this.getRepositoryTypeManagerRO().getCrossLinkRelationType((IRepositoryRelationTypeID)relationTypeID);
                    ICollection_ relationContributionTypes = relationType.getAllRelationContributionTypes();
                    if (relationContributionRoleID == null) {
                        for (ICrossLinkRepositoryRelationContributionType relationContributionType : relationContributionTypes) {
                            IRepositoryObjectTypeID relatedObjectTypeID = relationContributionType.getRelatedObjectType().getRepositoryObjectTypeID();
                            if (!IRepositoryObjectTypeID.IS_EQUAL_OBJECT_TYPE_ID_HASHER.isEqual((Object)this.objectTypeID, (Object)relatedObjectTypeID)) continue;
                            relationContributionRoleID = relationContributionType.getRepositoryRelationContributionRoleID().toCanonicalString();
                            break;
                        }
                    }
                    relationTypeIds2relationContributionRoleIds.put(relationTypeID.toCanonicalString(), relationContributionRoleID);
                    widgetParameters = WidgetSpecificationConverter.convertContentWidgetParameters(widget.getWidgetParameters(), null, projectLanguage);
                }
                catch (RuntimeException rtE) {
                    skipWidget = true;
                }
            }
        } else {
            widgetParameters = WidgetSpecificationConverter.convertContentWidgetParameters(widget.getWidgetParameters(), null, projectLanguage);
        }
        if (!skipWidget) {
            WidgetTypeID widgetTypeID = new WidgetTypeID(widget.getWidgetTypeID());
            return new WidgetSpecification(isObjectTypeCategoryUsed, propertyTypeIds, relationTypeIds2relationContributionRoleIds, (IWidgetTypeID)widgetTypeID, widgetParameters);
        }
        return null;
    }

    public Sequence getSequentialLayoutSpecification(Locale contentLocale) {
        return this.dataTypeDescription.getSequentialLayoutSpecification(contentLocale);
    }

    public RepositoryIDCreator getRepositoryIDCreator() {
        return this.repositoryIDCreator;
    }

    public IIDSampleAndLock sampleNextFreeID(ICockpitProjectData parentCockpitData, boolean checkOnClientOnly) throws EXCockpitLockDenied {
        IRepositoryData newIDAsRepositoryData;
        IModuleData parent = parentCockpitData instanceof IModuleData ? (IModuleData)parentCockpitData : null;
        LockAccessWrapper lockWrapper = new LockAccessWrapper();
        String newID = this.dataManager.generateNewID(this.dataTypeDescription, 0, parent, !checkOnClientOnly, lockWrapper);
        IPropertyType idPropertyType = DataManagerAdapter_RealType.findPropertyOfType(this.getIDPropertyTypeDeclaration().getPropertyTypeID(), this.getFixPropertyTypes());
        IRepositoryTypeManagerRO repositoryTypeManager = this.projectAgent.getRepositoryInterface().getTypeManager();
        AbstractRepositoryStringDataType repositoryDataType = (AbstractRepositoryStringDataType)repositoryTypeManager.getDataType(idPropertyType.getDataTypeID());
        try {
            newIDAsRepositoryData = repositoryDataType.createData(newID);
            repositoryDataType.snapAndCheckData(newIDAsRepositoryData, idPropertyType.getRepositoryDataTypeParameters());
        }
        catch (AbstractRepositoryDataType.EXValueNotSet e) {
            newIDAsRepositoryData = null;
        }
        catch (EXValueInvalid e) {
            newIDAsRepositoryData = null;
        }
        ILock lock = null;
        if (lockWrapper.getLockAccess() != null) {
            lock = LockHelper.getILock(lockWrapper.getLockAccess());
        }
        return new IDSampleAndLock(newIDAsRepositoryData, lock);
    }

    private static final IPropertyType findPropertyOfType(IRepositoryPropertyTypeID propertyTypeid, IPropertyType[] allPropertyTypes) {
        IPropertyType[] iPropertyTypeArray = allPropertyTypes;
        int n = allPropertyTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IPropertyType allPropertyType = iPropertyTypeArray[n2];
            IRepositoryPropertyTypeID propertyTypeIDFromArray = allPropertyType.getPropertyTypeID();
            if (IRepositoryPropertyTypeID.IS_EQUAL_PROPERTY_TYPE_ID_HASHER.isEqual((Object)propertyTypeIDFromArray, (Object)propertyTypeid)) {
                return allPropertyType;
            }
            ++n2;
        }
        return null;
    }

    public IAttributeOwnerRW getAttributeOwnerRW(ICockpitProjectData cockpitProjectData) {
        IAttributeModificationManager modManager = this.dataManager.getModuleFacade().getAttributeModificationManager(cockpitProjectData);
        IAttributeOwner owner = this.dataManager.getModuleFacade().getAttributeOwner(cockpitProjectData);
        CustomPropertiesForModuleData attributeOwnerRW = new CustomPropertiesForModuleData(owner, modManager);
        return attributeOwnerRW;
    }

    public String getAuthorOfObject(ICockpitProjectData object) {
        return ((IModuleData)object).getCreator().getDisplayStringRepresentation();
    }

    public Date getCreationDateOfObject(ICockpitProjectData object) {
        return ((IModuleData)object).getCreationTime().getValueAsTimeStamp();
    }

    public String getLastModifierOfObject(ICockpitProjectData object) {
        return ((IModuleData)object).getModifier().getDisplayStringRepresentation();
    }

    public Date getDateOfLastModificationOfObject(ICockpitProjectData object) {
        return ((IModuleData)object).getModificationTime().getValueAsTimeStamp();
    }

    public IMap_<IRepositoryPropertyTypeID, IOccurrenceManager> getOccurrenceManagers() {
        return NO_OCCURENCE_MANAGERS;
    }

    static class IDSampleAndLock
    implements IIDSampleAndLock {
        private final IRepositoryData idSample;
        private final ILock lock;

        public IDSampleAndLock(IRepositoryData idSample, ILock lock) {
            this.idSample = idSample;
            this.lock = lock;
        }

        public IRepositoryData getIDSample() {
            return this.idSample;
        }

        public ILock getTemporaryLock() {
            return this.lock;
        }
    }
}

