/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.gui.filters;

import com.arcway.cockpit.cockpitlib.client.filter.AbstractTextValuesFilter;
import com.arcway.cockpit.cockpitlib.client.filter.gui.AbstractTreeListFilterItem;
import com.arcway.cockpit.frame.client.lib.dataviews.util.IModuleProjectSwitchListener;
import com.arcway.cockpit.frame.client.lib.dataviews.util.IModuleProjectSwitchListenerManager;
import com.arcway.cockpit.modulelib2.client.core.IModelControllerProvider;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.gui.dataview.jfaceviewer.tree.standard.StandardTreeDataViewSorter;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.graphics.Image;

public class ModuleDataTreeListFilterItem
extends AbstractTreeListFilterItem<IModuleData>
implements IModuleProjectSwitchListener {
    private static final ILogger logger = Logger.getLogger(ModuleDataTreeListFilterItem.class);
    private final IModelControllerProvider modelControllerProvider;
    private IModelController modelController;
    private final String dataTypeUid;
    private AbstractTreeListFilterItem.ITreeListFilterDataProvider<IModuleData> dataProvider;
    private List<IModuleData> rootItems;
    private Map<String, List<IModuleData>> map_parent_children;
    private Set<IModuleData> allUnselectableItems;

    public ModuleDataTreeListFilterItem(String name, String dataTypeUID, IModuleProjectSwitchListenerManager projectSwitchListenerManager, IModelControllerProvider modelControllerProvider, AbstractTextValuesFilter filter, boolean selectAncestorsAutomatically) {
        super(name, filter, selectAncestorsAutomatically);
        this.modelControllerProvider = modelControllerProvider;
        this.dataTypeUid = dataTypeUID;
        projectSwitchListenerManager.registerProjectSwitchListener((IModuleProjectSwitchListener)this);
    }

    public ModuleDataTreeListFilterItem(String name, String datatypeUID, IModelController modelController, AbstractTextValuesFilter filter, boolean selectAncestorsAutomatically) {
        super(name, filter, selectAncestorsAutomatically);
        this.modelControllerProvider = null;
        this.dataTypeUid = datatypeUID;
        this.modelController = modelController;
    }

    protected final AbstractTreeListFilterItem.ITreeListFilterDataProvider<IModuleData> getDataProvider() {
        if (this.dataProvider == null) {
            this.dataProvider = new AbstractTreeListFilterItem.ITreeListFilterDataProvider<IModuleData>(){

                public void flushCache() {
                    ModuleDataTreeListFilterItem.this.recalculateCache();
                }

                public List<IModuleData> getRootItems() {
                    return ModuleDataTreeListFilterItem.this.rootItems;
                }

                public List<IModuleData> getChildren(IModuleData parent) {
                    return (List)ModuleDataTreeListFilterItem.this.map_parent_children.get(parent.getUID());
                }

                public Set<IModuleData> getAllUnselectableItems() {
                    return ModuleDataTreeListFilterItem.this.allUnselectableItems;
                }

                public boolean isItemSelectable(IModuleData item) {
                    return item.getTypeID().equals(ModuleDataTreeListFilterItem.this.dataTypeUid);
                }

                public String getLabel(IModuleData item) {
                    return item.getDisplayRepresentation();
                }

                public Image getImage(IModuleData item) {
                    return null;
                }

                public String getUID(IModuleData item) {
                    return item.getUID();
                }

                public Collection<IModuleData> getItemsForUIDs(Collection<String> uids) {
                    HashSet<IModuleData> moduleData = new HashSet<IModuleData>(uids.size());
                    for (String uid : uids) {
                        IModuleData moduleDataItem = ModuleDataTreeListFilterItem.this.modelController.getItem(ModuleDataTreeListFilterItem.this.dataTypeUid, uid);
                        if (moduleDataItem == null) continue;
                        moduleData.add(moduleDataItem);
                    }
                    return moduleData;
                }
            };
        }
        return this.dataProvider;
    }

    private void recalculateCache() {
        this.map_parent_children = new HashMap<String, List<IModuleData>>();
        this.allUnselectableItems = new HashSet<IModuleData>();
        this.rootItems = this.recalculateCacheForDescendants(this.modelController.getAllRootItems(), this.map_parent_children, this.allUnselectableItems);
    }

    private List<IModuleData> recalculateCacheForDescendants(Collection<IModuleData> allChildItems, Map<String, List<IModuleData>> mapToWhichToAddParentChildMappings, Set<IModuleData> setToWhichToAddAllUnselectableItems) {
        ArrayList<IModuleData> relevantChildren = new ArrayList<IModuleData>();
        for (IModuleData childItem : allChildItems) {
            boolean childItemIsOfRightType = childItem.getTypeID().equals(this.dataTypeUid);
            List<IModuleData> relevantGrandChildren = this.recalculateCacheForDescendants(this.modelController.getChildren(childItem), mapToWhichToAddParentChildMappings, setToWhichToAddAllUnselectableItems);
            if (!childItemIsOfRightType && relevantGrandChildren == null) continue;
            relevantChildren.add(childItem);
            mapToWhichToAddParentChildMappings.put(childItem.getUID(), relevantGrandChildren);
            if (childItemIsOfRightType) continue;
            setToWhichToAddAllUnselectableItems.add(childItem);
        }
        Comparator<IModuleData> naturalOrderComparator = StandardTreeDataViewSorter.getComparatorForNaturalOrder(this.modelController);
        Collections.sort(relevantChildren, naturalOrderComparator);
        return !relevantChildren.isEmpty() ? relevantChildren : null;
    }

    public void projectSwitched(String projectUID) {
        this.modelController = this.modelControllerProvider.getModelController(projectUID);
    }
}

