/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.gui.editdialogs;

import com.arcway.cockpit.modulelib2.client.Messages;
import com.arcway.cockpit.modulelib2.client.gui.editdialogs.IEditDialogErrorCallback;
import com.arcway.cockpit.modulelib2.client.gui.editdialogs.IModuleDataEditAgentAdvanced;
import de.plans.lib.util.collections.ArrayUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class AdvancedCallback
implements IModuleDataEditAgentAdvanced {
    private Map<Object, String> mapCaller_message;
    private Map<Object, Boolean> mapCaller_isExclusiveProjectLockConflicting;
    private Map<Object, Integer> mapCaller_priority;
    private Map<Object, String> mapCaller_name;
    private Set changedSet;
    private Set committableSet;
    private boolean initialised = false;
    private final IEditDialogErrorCallback callback;

    public AdvancedCallback(IEditDialogErrorCallback callback) {
        assert (callback != null) : "callback must not be null";
        this.callback = callback;
    }

    public void init(Object[] callers, int[] priorities, String[] names) {
        assert (callers != null) : "callers must not be null";
        assert (priorities != null) : "priorities must not be null";
        assert (callers.length == priorities.length && callers.length == names.length);
        assert (ArrayUtil.nonNegative((int[])priorities));
        this.mapCaller_message = new HashMap<Object, String>(callers.length);
        this.mapCaller_isExclusiveProjectLockConflicting = new HashMap<Object, Boolean>(callers.length);
        this.mapCaller_priority = new HashMap<Object, Integer>(callers.length);
        this.mapCaller_name = new HashMap<Object, String>(callers.length);
        this.changedSet = new HashSet(callers.length);
        this.committableSet = new HashSet(callers.length);
        int i = 0;
        while (i < callers.length) {
            this.mapCaller_priority.put(callers[i], new Integer(priorities[i]));
            this.mapCaller_name.put(callers[i], names[i]);
            ++i;
        }
        this.initialised = true;
    }

    @Override
    public void setExclusiveProjectLockConflicting(Object caller) {
        if (this.initialised) {
            this.mapCaller_isExclusiveProjectLockConflicting.put(caller, Boolean.TRUE);
            this.setErrorMessageAndCommitableState();
        }
    }

    @Override
    public void clearExclusiveProjectLockConflicting(Object caller) {
        if (this.initialised) {
            this.mapCaller_isExclusiveProjectLockConflicting.put(caller, Boolean.FALSE);
            this.setErrorMessageAndCommitableState();
        }
    }

    @Override
    public void setErrMsg(String errorMessage, Object caller) {
        if (this.initialised) {
            String callerName = this.mapCaller_name.get(caller);
            this.mapCaller_message.put(caller, String.valueOf(callerName) + ": " + errorMessage);
            this.setErrorMessageAndCommitableState();
        }
    }

    @Override
    public void clearErrorMessage(Object caller) {
        if (this.initialised) {
            this.mapCaller_message.remove(caller);
            this.setErrorMessageAndCommitableState();
        }
    }

    private void setErrorMessageAndCommitableState() {
        if (this.isExclusiveProjectLockConflicting()) {
            this.callback.setErrMsg(Messages.getString("CreationDialogs.ExclusiveProjectLock"));
        } else {
            this.callback.setErrMsg(this.getCurrentErrorMessageByPriority());
        }
        this.callback.setCommitable(this.getCurrentErrorMessageByPriority() == null);
    }

    private String getCurrentErrorMessageByPriority() {
        int maxPriority = -1;
        String errorMessage = null;
        for (Map.Entry<Object, String> entry : this.mapCaller_message.entrySet()) {
            Object caller = entry.getKey();
            Integer callerPriority = this.mapCaller_priority.get(caller);
            if (callerPriority == null || callerPriority <= maxPriority) continue;
            maxPriority = callerPriority;
            errorMessage = entry.getValue();
        }
        return errorMessage;
    }

    private boolean isExclusiveProjectLockConflicting() {
        for (Map.Entry<Object, Boolean> entry : this.mapCaller_isExclusiveProjectLockConflicting.entrySet()) {
            Boolean isExclusiveProjectLockConflictingForCaller = entry.getValue();
            if (isExclusiveProjectLockConflictingForCaller == null || !isExclusiveProjectLockConflictingForCaller.booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setChangedStatus(boolean hasChanged, Object caller) {
        if (this.initialised) {
            if (hasChanged) {
                if (this.changedSet.isEmpty()) {
                    this.callback.setChangedStatus(true);
                }
                this.changedSet.add(caller);
            } else {
                if (this.changedSet.size() == 1 && this.changedSet.contains(caller)) {
                    this.callback.setChangedStatus(false);
                }
                this.changedSet.remove(caller);
            }
        }
    }

    @Override
    public void setCommitable(boolean commitable, Object caller) {
        if (this.initialised) {
            if (commitable) {
                if (this.committableSet.isEmpty()) {
                    this.callback.setCommitable(true);
                }
                this.committableSet.add(caller);
            } else {
                if (this.committableSet.size() == 1 && this.committableSet.contains(caller)) {
                    this.callback.setCommitable(false);
                }
                this.committableSet.remove(caller);
            }
        }
    }

    @Override
    public void setMessage(String message, int type, Object caller) {
        if (this.initialised) {
            if (type == 3) {
                this.setErrMsg(message, caller);
            } else if (this.mapCaller_message.isEmpty()) {
                this.callback.setMessage(message, type);
            }
        }
    }

    @Override
    public void setDirty(Object caller) {
        this.callback.setDirty();
    }
}

