/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.gui.actions.discreteattributes;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.EnumerationEntry;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeOwner;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.frame.client.lib.dataviews.util.IModuleProjectSwitchListenerManager;
import com.arcway.cockpit.frame.client.project.core.categories.ObjectTypeCategories;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeBoolean;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeEnumerationSingle;
import com.arcway.cockpit.frame.client.project.core.userdefinedattributetypes.IModuleUserDefinedAttributeTypesManager;
import com.arcway.cockpit.modulelib2.client.core.IModelControllerProvider;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.gui.ViewModuleAttributeAgent;
import com.arcway.cockpit.modulelib2.client.gui.actions.discreteattributes.AbstractModuleAttributeHandler;
import com.arcway.cockpit.modulelib2.client.messages.CustomModuleAttribute;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import de.plans.lib.localisation.ILabelProvider;
import de.plans.lib.localisation.LabelProviderUnlocalisedString;
import de.plans.lib.util.valueranges.DiscreteValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AttributeHandlerForCustomProperties
extends AbstractModuleAttributeHandler {
    private final IAttributeType attributeType;

    public AttributeHandlerForCustomProperties(IModuleProjectSwitchListenerManager projectSwitchListenerManager, IModelControllerProvider modelControllerProvider, IAttributeType attributeType, String dataTypeID, boolean checkPermission) {
        super(projectSwitchListenerManager, modelControllerProvider, attributeType.getAttributeTypeID().getUID(), attributeType.getDisplayName(), dataTypeID, checkPermission);
        assert (attributeType.getDataType() instanceof DataTypeBoolean || attributeType.getDataType() instanceof DataTypeEnumerationSingle) : "Change value actions are supported for boolean and single choice enumeration custom properties only";
        this.attributeType = attributeType;
    }

    @Override
    public boolean enableFor(Object domainItem) {
        IModuleData item = (IModuleData)domainItem;
        boolean customPropertyIsVisibleForItem = ObjectTypeCategories.isUserDefinedAttributeTypeVisibleForItem((IAttributeOwner)this.getModelController().getAttributeOwner(item), (IAttributeType)this.attributeType);
        if (customPropertyIsVisibleForItem) {
            return super.enableFor(domainItem);
        }
        return false;
    }

    @Override
    public void changeValue(Object domainItem, int index, DiscreteValue value) {
        IModelController modelController = this.getModelController();
        IModuleUserDefinedAttributeTypesManager customPropertiesManager = modelController.getProjectAgent().getModuleUserDefinedAttributeTypesManager();
        IModuleData item = (IModuleData)domainItem;
        ViewModuleAttributeAgent attributeAgent = new ViewModuleAttributeAgent(item, customPropertiesManager, modelController);
        IAttribute oldAttribute = item.getCustomAttribute(this.attributeType);
        Object oldAttributeValue = oldAttribute != null ? oldAttribute.getAttributeValue() : null;
        List<Object> newValue = null;
        if (this.attributeType.getDataType() instanceof DataTypeBoolean) {
            newValue = index == 0 ? Boolean.TRUE : Boolean.FALSE;
        } else if (this.attributeType.getDataType() instanceof DataTypeEnumerationSingle) {
            newValue = index == 0 ? Collections.emptyList() : Collections.singletonList(((List)this.attributeType.getValueRange().getValueRange()).get(index - 1));
        }
        CustomModuleAttribute newAttribute = new CustomModuleAttribute(this.attributeType.getAttributeTypeID(), newValue);
        attributeAgent.modifyAttributeAndNotifyDataType(newAttribute, oldAttributeValue);
        modelController.itemPropertiesModified(item, null);
    }

    @Override
    public List<? extends DiscreteValue> getValueRange() {
        IModelController modelController = this.getModelController();
        ArrayList<DiscreteValue> valueRange = null;
        if (this.attributeType.getDataType() instanceof DataTypeBoolean) {
            valueRange = new ArrayList<DiscreteValue>(2);
            String labelTrue = DataTypeBoolean.getSingleInstance().getValueAsSingleLineString((Object)Boolean.TRUE, null, null, modelController.getProjectLanguage());
            valueRange.add(new DiscreteValue((ILabelProvider)new LabelProviderUnlocalisedString(labelTrue)));
            String labelFalse = DataTypeBoolean.getSingleInstance().getValueAsSingleLineString((Object)Boolean.FALSE, null, null, modelController.getProjectLanguage());
            valueRange.add(new DiscreteValue((ILabelProvider)new LabelProviderUnlocalisedString(labelFalse)));
        } else if (this.attributeType.getDataType() instanceof DataTypeEnumerationSingle) {
            List valueList = (List)this.attributeType.getValueRange().getValueRange();
            valueRange = new ArrayList(valueList.size() + 1);
            valueRange.add(new DiscreteValue((ILabelProvider)new LabelProviderUnlocalisedString("")));
            for (Object value : valueList) {
                EnumerationEntry entry = (EnumerationEntry)value;
                valueRange.add(new DiscreteValue((ILabelProvider)new LabelProviderUnlocalisedString(entry.getValue().toString())));
            }
        }
        return valueRange;
    }

    @Override
    public int getCurrentValueIndex(Object item) {
        assert (item instanceof IModuleData);
        if (!(item instanceof IModuleData)) {
            return -1;
        }
        IAttribute attribute = ((IModuleData)item).getCustomAttribute(this.attributeType);
        Object attributeValue = attribute != null ? attribute.getAttributeValue() : this.attributeType.getDataType().getDefaultValue();
        int index = -1;
        if (this.attributeType.getDataType() instanceof DataTypeBoolean) {
            index = ((Boolean)attributeValue).equals(Boolean.TRUE) ? 0 : 1;
        } else if (this.attributeType.getDataType() instanceof DataTypeEnumerationSingle) {
            index = attributeValue == null || ((List)attributeValue).isEmpty() ? 0 : ((List)this.attributeType.getValueRange().getValueRange()).indexOf(((List)attributeValue).get(0)) + 1;
        }
        return index;
    }
}

