/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.gui;

import com.arcway.cockpit.frame.shared.message.IncompatibleDataTypeException;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.Messages;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.gui.AbstractNewItemDialog;
import com.arcway.cockpit.modulelib2.client.messages.AbstractModuleData;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import de.plans.lib.util.StringComparatorFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractListManagementDialog
extends TitleAreaDialog {
    private final Runnable commit = new Runnable(){

        @Override
        public void run() {
            AbstractListManagementDialog.this.commit();
        }
    };
    protected IModelController modelController;
    protected HashMap initiallyUsedMap;
    protected HashMap initiallyUnusedMap;
    private HashMap toBeDeletedMap;
    private HashMap toBeAddedMap;
    private HashMap toBeRenamedMap_InitialItem2RenamedItem;
    private HashMap toBeRenamedMap_RenamedString2RenamedItem;
    private HashMap toBeRenamedMap_RenamedString2InitialItem;
    private final Shell parentShell;
    protected List usedListWidget;
    protected List unusedListWidget;
    private final String datatypeUID;
    private final Collection linkTypes;
    private final String titleString;
    private final String messageString;
    private final String unusedListDescription;
    private final String usedListDescription;
    private Button deleteButton;
    private Button renameButton;
    private static final Comparator defaultComparatorForSortingListItems = new ComparatorForSortingListItems();

    public AbstractListManagementDialog(Shell parentShell, IModelController modelController, String datatypeUID, Collection linkTypes, String titleString, String messageString, String unusedListDescription, String usedListDescription) {
        super(parentShell);
        this.parentShell = parentShell;
        this.modelController = modelController;
        this.datatypeUID = datatypeUID;
        this.linkTypes = linkTypes;
        this.titleString = titleString;
        this.messageString = messageString;
        this.unusedListDescription = unusedListDescription;
        this.usedListDescription = usedListDescription;
    }

    protected Control createDialogArea(Composite parent) {
        parent.getShell().setText(this.titleString);
        this.setTitle(this.titleString);
        this.setMessage(this.messageString);
        Composite baseArea = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        baseArea.setLayout((Layout)gridLayout);
        Label label = new Label(baseArea, 0);
        label.setText(this.unusedListDescription);
        Composite unusedCategoriesArea = new Composite(baseArea, 0);
        RowLayout rowLayout = new RowLayout();
        unusedCategoriesArea.setLayout((Layout)rowLayout);
        GridData gridData = new GridData(1808);
        unusedCategoriesArea.setLayoutData((Object)gridData);
        this.unusedListWidget = new List(unusedCategoriesArea, 2562);
        ScrollBar unusedBar = this.unusedListWidget.getVerticalBar();
        if (unusedBar != null) {
            unusedBar.setVisible(true);
            unusedBar.setEnabled(true);
        }
        RowData rowData = new RowData(300, 150);
        this.unusedListWidget.setLayoutData((Object)rowData);
        this.unusedListWidget.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                AbstractListManagementDialog.this.deleteButton.setEnabled(true);
                if (AbstractListManagementDialog.this.unusedListWidget.getSelectionCount() != 1) {
                    AbstractListManagementDialog.this.renameButton.setEnabled(false);
                } else {
                    String selectionText = AbstractListManagementDialog.this.unusedListWidget.getSelection()[0];
                    IModuleData selectedItem = (IModuleData)AbstractListManagementDialog.this.initiallyUnusedMap.get(selectionText);
                    if (selectedItem == null) {
                        selectedItem = (IModuleData)AbstractListManagementDialog.this.toBeRenamedMap_RenamedString2RenamedItem.get(selectionText);
                    }
                    if (selectedItem == null) {
                        selectedItem = (IModuleData)AbstractListManagementDialog.this.toBeAddedMap.get(selectionText);
                    }
                    AbstractListManagementDialog.this.renameButton.setEnabled(AbstractListManagementDialog.this.renamingItemIsAllowed(selectedItem));
                }
                AbstractListManagementDialog.this.usedListWidget.deselectAll();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        Composite buttonArea = new Composite(unusedCategoriesArea, 0);
        rowLayout = new RowLayout(512);
        buttonArea.setLayout((Layout)rowLayout);
        rowData = new RowData();
        rowData.width = 100;
        buttonArea.setLayoutData((Object)rowData);
        Button addButton = new Button(buttonArea, 0x1000008);
        addButton.setText(Messages.getString("AbstractListManagementDialog.AddButton"));
        addButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                AbstractListManagementDialog.this.addItem();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        rowData = new RowData();
        rowData.width = 85;
        addButton.setLayoutData((Object)rowData);
        this.deleteButton = new Button(buttonArea, 0x1000008);
        this.deleteButton.setText(Messages.getString("AbstractListManagementDialog.DelButton"));
        this.deleteButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                AbstractListManagementDialog.this.deleteSelection();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.deleteButton.setEnabled(false);
        rowData = new RowData();
        rowData.width = 85;
        this.deleteButton.setLayoutData((Object)rowData);
        this.renameButton = new Button(buttonArea, 0x1000008);
        this.renameButton.setText(Messages.getString("AbstractListManagementDialog.RenameButton"));
        this.renameButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                AbstractListManagementDialog.this.renameSelection();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.renameButton.setEnabled(false);
        rowData = new RowData();
        rowData.width = 85;
        this.renameButton.setLayoutData((Object)rowData);
        Label usedLabel = new Label(baseArea, 0);
        usedLabel.setText(this.usedListDescription);
        this.usedListWidget = new List(baseArea, 2560);
        ScrollBar usedBar = this.usedListWidget.getVerticalBar();
        if (usedBar != null) {
            usedBar.setVisible(true);
            usedBar.setEnabled(true);
        }
        gridData = new GridData(300, 150);
        this.usedListWidget.setLayoutData((Object)gridData);
        this.usedListWidget.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                AbstractListManagementDialog.this.deleteButton.setEnabled(false);
                if (AbstractListManagementDialog.this.usedListWidget.getSelectionCount() != 1) {
                    AbstractListManagementDialog.this.renameButton.setEnabled(false);
                } else {
                    String selectionText = AbstractListManagementDialog.this.usedListWidget.getSelection()[0];
                    IModuleData selectedItem = (IModuleData)AbstractListManagementDialog.this.initiallyUsedMap.get(selectionText);
                    if (selectedItem == null) {
                        selectedItem = (IModuleData)AbstractListManagementDialog.this.toBeRenamedMap_RenamedString2RenamedItem.get(selectionText);
                    }
                    if (selectedItem == null) {
                        selectedItem = (IModuleData)AbstractListManagementDialog.this.toBeAddedMap.get(selectionText);
                    }
                    AbstractListManagementDialog.this.renameButton.setEnabled(AbstractListManagementDialog.this.renamingItemIsAllowed(selectedItem));
                }
                AbstractListManagementDialog.this.unusedListWidget.deselectAll();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.initializeItemLists();
        this.updateListWidgets();
        return baseArea;
    }

    private void updateListWidgets() {
        ArrayList<IModuleData> usedListWidgetContents = new ArrayList<IModuleData>();
        for (Map.Entry entry : this.initiallyUsedMap.entrySet()) {
            IModuleData iModuleDataItem = (IModuleData)entry.getValue();
            IModuleData renamedItem = (IModuleData)this.toBeRenamedMap_InitialItem2RenamedItem.get(iModuleDataItem);
            if (renamedItem != null) {
                usedListWidgetContents.add(renamedItem);
                continue;
            }
            usedListWidgetContents.add(iModuleDataItem);
        }
        this.updateListWidget(usedListWidgetContents, this.usedListWidget);
        ArrayList<IModuleData> unUsedListWidgetContents = new ArrayList<IModuleData>();
        for (Map.Entry entry : this.initiallyUnusedMap.entrySet()) {
            IModuleData iModuleDataItem = (IModuleData)entry.getValue();
            IModuleData renamedItem = (IModuleData)this.toBeRenamedMap_InitialItem2RenamedItem.get(iModuleDataItem);
            if (renamedItem != null) {
                unUsedListWidgetContents.add(renamedItem);
                continue;
            }
            if (this.toBeDeletedMap.containsKey(iModuleDataItem)) continue;
            unUsedListWidgetContents.add(iModuleDataItem);
        }
        unUsedListWidgetContents.addAll(this.toBeAddedMap.values());
        this.updateListWidget(unUsedListWidgetContents, this.unusedListWidget);
    }

    private void updateListWidget(ArrayList iModuleDataItemList, List listWidget) {
        Collections.sort(iModuleDataItemList, this.getComparatorForSortingListItems());
        listWidget.removeAll();
        int i = 0;
        while (i < iModuleDataItemList.size()) {
            listWidget.add(((IModuleData)iModuleDataItemList.get(i)).getDisplayRepresentation());
            ++i;
        }
    }

    protected Comparator getComparatorForSortingListItems() {
        return defaultComparatorForSortingListItems;
    }

    private void initializeItemLists() {
        this.toBeRenamedMap_InitialItem2RenamedItem = new HashMap();
        this.toBeRenamedMap_RenamedString2RenamedItem = new HashMap();
        this.toBeRenamedMap_RenamedString2InitialItem = new HashMap();
        this.toBeDeletedMap = new HashMap();
        this.toBeAddedMap = new HashMap();
        this.initiallyUsedMap = new HashMap();
        this.initiallyUnusedMap = new HashMap();
        this.initializeListUsedAndListUnused();
    }

    protected void initializeListUsedAndListUnused() {
        Collection<? extends IModuleData> attributeItems = this.modelController.getAllItems(this.datatypeUID);
        for (IModuleData iModuleData : attributeItems) {
            boolean used = false;
            for (String linkType : this.linkTypes) {
                Collection<ICockpitProjectData> entitiesForAttributeItem = this.modelController.getModuleData(iModuleData.getUID(), linkType);
                if (entitiesForAttributeItem.isEmpty()) continue;
                used = true;
                break;
            }
            if (used) {
                this.initiallyUsedMap.put(iModuleData.getDisplayRepresentation(), iModuleData);
                continue;
            }
            this.initiallyUnusedMap.put(iModuleData.getDisplayRepresentation(), iModuleData);
        }
    }

    private ArrayList getListContaininAllItemNamesIntitiallyAndCurrentlyInUse() {
        ArrayList allItems = new ArrayList();
        allItems.addAll(this.initiallyUnusedMap.keySet());
        allItems.addAll(this.initiallyUsedMap.keySet());
        allItems.addAll(this.toBeAddedMap.keySet());
        allItems.addAll(this.toBeRenamedMap_RenamedString2RenamedItem.keySet());
        allItems.removeAll(this.toBeDeletedMap.values());
        return allItems;
    }

    private void deleteSelection() {
        int[] selection = this.unusedListWidget.getSelectionIndices();
        int c = selection.length - 1;
        while (c >= 0) {
            IModuleData iModuleDataItem;
            String itemsDisplayName = this.unusedListWidget.getItem(selection[c]);
            boolean currentItemProcessed = false;
            if (!(currentItemProcessed || (iModuleDataItem = (IModuleData)this.initiallyUnusedMap.get(itemsDisplayName)) == null || this.toBeRenamedMap_InitialItem2RenamedItem.containsKey(iModuleDataItem) || this.toBeDeletedMap.containsKey(iModuleDataItem))) {
                this.toBeDeletedMap.put(iModuleDataItem, itemsDisplayName);
                currentItemProcessed = true;
            }
            if (!currentItemProcessed) {
                iModuleDataItem = null;
                iModuleDataItem = (IModuleData)this.toBeRenamedMap_RenamedString2RenamedItem.get(itemsDisplayName);
                IModuleData initialModuleDataItem = null;
                initialModuleDataItem = (IModuleData)this.toBeRenamedMap_RenamedString2InitialItem.get(itemsDisplayName);
                if (iModuleDataItem != null && this.initiallyUnusedMap.containsValue(initialModuleDataItem)) {
                    this.toBeRenamedMaps_remove(iModuleDataItem);
                    if (!this.toBeDeletedMap.containsKey(initialModuleDataItem)) {
                        this.toBeDeletedMap.put(initialModuleDataItem, initialModuleDataItem.getDisplayRepresentation());
                    }
                    currentItemProcessed = true;
                }
            }
            if (!currentItemProcessed) {
                this.toBeAddedMap.remove(itemsDisplayName);
            }
            --c;
        }
        this.updateListWidgets();
        this.deleteButton.setEnabled(false);
        this.renameButton.setEnabled(false);
    }

    private void renameSelection() {
        IModuleData newItem;
        IModuleData initialModuleDataItem;
        IModuleData iModuleDataItem;
        String ADDED = "ADDED";
        String INITIAL = "INITIAL";
        String RENAMED = "RENAMED";
        String selectedItemsDisplayName = null;
        IModuleData selectedIModuleDataItem = null;
        String selectedIModuleDataItemState = null;
        int[] unusedListWidgetSelection = this.unusedListWidget.getSelectionIndices();
        int[] usedListWidgetSelection = this.usedListWidget.getSelectionIndices();
        if (unusedListWidgetSelection.length == 1 && usedListWidgetSelection.length == 0) {
            selectedItemsDisplayName = this.unusedListWidget.getItem(unusedListWidgetSelection[0]);
            if (selectedIModuleDataItem == null && (iModuleDataItem = (IModuleData)this.initiallyUnusedMap.get(selectedItemsDisplayName)) != null && !this.toBeRenamedMap_InitialItem2RenamedItem.containsKey(iModuleDataItem)) {
                selectedIModuleDataItem = iModuleDataItem;
                selectedIModuleDataItemState = "INITIAL";
            }
            if (selectedIModuleDataItem == null) {
                iModuleDataItem = null;
                iModuleDataItem = (IModuleData)this.toBeRenamedMap_RenamedString2RenamedItem.get(selectedItemsDisplayName);
                initialModuleDataItem = null;
                initialModuleDataItem = (IModuleData)this.toBeRenamedMap_RenamedString2InitialItem.get(selectedItemsDisplayName);
                if (iModuleDataItem != null && this.initiallyUnusedMap.containsValue(initialModuleDataItem)) {
                    selectedIModuleDataItem = iModuleDataItem;
                    selectedIModuleDataItemState = "RENAMED";
                }
            }
            if (selectedIModuleDataItem == null) {
                selectedIModuleDataItem = (IModuleData)this.toBeAddedMap.get(selectedItemsDisplayName);
                selectedIModuleDataItemState = "ADDED";
            }
            if (selectedIModuleDataItem == null) assert (false);
        } else if (unusedListWidgetSelection.length == 0 && usedListWidgetSelection.length == 1) {
            selectedItemsDisplayName = this.usedListWidget.getItem(usedListWidgetSelection[0]);
            if (selectedIModuleDataItem == null && (iModuleDataItem = (IModuleData)this.initiallyUsedMap.get(selectedItemsDisplayName)) != null && !this.toBeRenamedMap_InitialItem2RenamedItem.containsKey(iModuleDataItem)) {
                selectedIModuleDataItem = iModuleDataItem;
                selectedIModuleDataItemState = "INITIAL";
            }
            if (selectedIModuleDataItem == null) {
                iModuleDataItem = null;
                iModuleDataItem = (IModuleData)this.toBeRenamedMap_RenamedString2RenamedItem.get(selectedItemsDisplayName);
                initialModuleDataItem = null;
                initialModuleDataItem = (IModuleData)this.toBeRenamedMap_RenamedString2InitialItem.get(selectedItemsDisplayName);
                if (iModuleDataItem != null && this.initiallyUsedMap.containsValue(initialModuleDataItem)) {
                    selectedIModuleDataItem = iModuleDataItem;
                    selectedIModuleDataItemState = "RENAMED";
                }
            }
            if (selectedIModuleDataItem == null) assert (false);
        }
        if (selectedIModuleDataItem == null) {
            return;
        }
        ArrayList allItems = this.getListContaininAllItemNamesIntitiallyAndCurrentlyInUse();
        AbstractNewItemDialog dialog = this.createNewListItemDialog(this.parentShell, this.modelController, allItems, selectedIModuleDataItem);
        if (dialog.open() == 0 && !(newItem = dialog.getItem()).getDisplayRepresentation().equals(selectedItemsDisplayName)) {
            if ("INITIAL" == selectedIModuleDataItemState) {
                this.toBeRenamedMaps_add(newItem, newItem.getDisplayRepresentation(), selectedIModuleDataItem);
            } else if ("RENAMED" == selectedIModuleDataItemState) {
                IModuleData initialModuleDataItem2 = null;
                initialModuleDataItem2 = (IModuleData)this.toBeRenamedMap_RenamedString2InitialItem.get(selectedItemsDisplayName);
                this.toBeRenamedMaps_remove(selectedIModuleDataItem);
                this.toBeRenamedMaps_add(newItem, newItem.getDisplayRepresentation(), initialModuleDataItem2);
            } else if ("ADDED" == selectedIModuleDataItemState) {
                this.toBeAddedMap.remove(selectedItemsDisplayName);
                this.toBeAddedMap.put(newItem.getDisplayRepresentation(), newItem);
            }
            this.updateListWidgets();
        }
        this.deleteButton.setEnabled(false);
        this.renameButton.setEnabled(false);
    }

    private void addItem() {
        ArrayList allItems = this.getListContaininAllItemNamesIntitiallyAndCurrentlyInUse();
        AbstractNewItemDialog dialog = this.createNewListItemDialog(this.parentShell, this.modelController, allItems);
        if (dialog.open() == 0) {
            IModuleData item = dialog.getItem();
            this.toBeAddedMap.put(item.getDisplayRepresentation(), item);
            this.updateListWidgets();
        }
    }

    protected abstract AbstractNewItemDialog createNewListItemDialog(Shell var1, IModelController var2, Collection<String> var3, IModuleData var4);

    private AbstractNewItemDialog createNewListItemDialog(Shell shell, IModelController modelCtrl, Collection existingItems) {
        return this.createNewListItemDialog(shell, modelCtrl, existingItems, null);
    }

    public void okPressed() {
        this.modelController.executeTransaction(this.commit);
        super.okPressed();
    }

    private void commit() {
        this.modelController.deleteItems(this.toBeDeletedMap.keySet());
        for (IModuleData iModuleDataItem : this.toBeAddedMap.values()) {
            this.modelController.addItem(iModuleDataItem);
        }
        for (Map.Entry entry : this.toBeRenamedMap_InitialItem2RenamedItem.entrySet()) {
            IModuleData itemToBeRenamed = (IModuleData)entry.getKey();
            IModuleData itemWithNewName = (IModuleData)entry.getValue();
            if (this.toBeDeletedMap.containsKey(itemToBeRenamed)) continue;
            try {
                itemToBeRenamed.copyDataFrom((AbstractModuleData)itemWithNewName, false);
                this.modelController.itemPropertiesModified(itemToBeRenamed, null);
            }
            catch (IncompatibleDataTypeException ex) {
                assert (false);
            }
        }
    }

    private void toBeRenamedMaps_remove(IModuleData renamedIModuleDataItem) {
        String renamedStringRepresentation = renamedIModuleDataItem.getDisplayRepresentation();
        IModuleData initialIModuleDataItem = (IModuleData)this.toBeRenamedMap_RenamedString2InitialItem.get(renamedStringRepresentation);
        this.toBeRenamedMap_InitialItem2RenamedItem.remove(initialIModuleDataItem);
        this.toBeRenamedMap_RenamedString2RenamedItem.remove(renamedStringRepresentation);
        this.toBeRenamedMap_RenamedString2InitialItem.remove(renamedStringRepresentation);
    }

    private void toBeRenamedMaps_add(IModuleData renamedIModuleDataItem, String renamedStringRepresentation, IModuleData initialIModuleDataItem) {
        this.toBeRenamedMap_InitialItem2RenamedItem.put(initialIModuleDataItem, renamedIModuleDataItem);
        this.toBeRenamedMap_RenamedString2RenamedItem.put(renamedStringRepresentation, renamedIModuleDataItem);
        this.toBeRenamedMap_RenamedString2InitialItem.put(renamedStringRepresentation, initialIModuleDataItem);
    }

    protected boolean renamingItemIsAllowed(IModuleData selectedItem) {
        return selectedItem != null;
    }

    private static class ComparatorForSortingListItems
    implements Comparator {
        private static final Comparator stringCompatrator = StringComparatorFactory.getStringComparator((boolean)true);

        private ComparatorForSortingListItems() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 instanceof IModuleData && o2 instanceof IModuleData) {
                IModuleData iModuleDataItem1 = (IModuleData)o1;
                IModuleData iModuleDataItem2 = (IModuleData)o2;
                return stringCompatrator.compare(iModuleDataItem1.getDisplayRepresentation(), iModuleDataItem2.getDisplayRepresentation());
            }
            assert (false);
            return 0;
        }
    }
}

