/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.dataexchange.adapter.util.attributemappingpage;

import com.arcway.cockpit.client.base.interfaces.frame.IProjectAgent;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeID;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IValueRangeDefiner;
import com.arcway.cockpit.client.base.interfaces.frame.permissions.EXNoPermission;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.ILocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.LocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.locking.EXNoLock;
import com.arcway.cockpit.frame.client.project.core.userdefinedattributetypes.IAttributeTypesModifier;
import com.arcway.cockpit.frame.client.project.core.userdefinedattributetypes.IModuleUserDefinedAttributeTypesManager;
import com.arcway.cockpit.modulelib2.client.Messages;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.lib.eclipse.gui.ModificationProblemsDialog;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

class EditCustomPropertyValueRangeDialogue
extends TitleAreaDialog {
    private final IAttributeType customProperty;
    private final IModuleUserDefinedAttributeTypesManager customPropertyTypesManager;
    private final IModelController modelController;
    private Control swtControl;

    public EditCustomPropertyValueRangeDialogue(IAttributeType customProperty_, IModuleUserDefinedAttributeTypesManager customPropertyTypesManager, IModelController modelController, Shell shell) {
        super(shell);
        this.customProperty = customProperty_;
        this.customPropertyTypesManager = customPropertyTypesManager;
        this.modelController = modelController;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.getString("CustomValueMappingDlg.VRDlgTitle"));
        this.setMessage(String.valueOf(Messages.getString("CustomValueMappingDlg.VRDlgMsg")) + this.customProperty.getDisplayName());
        Composite content = new Composite(parent, 0);
        content.setLayout((Layout)new GridLayout());
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        IValueRangeDefiner valueRangeDefiner = this.customProperty.getDataType().getValueRangeHelper();
        this.swtControl = valueRangeDefiner.createSWTControl(content, -1, valueRangeDefiner.getValueDeletionPolicyForOnlyIfNotInUse((IProjectAgent)this.modelController.getProjectAgent(), this.customProperty));
        valueRangeDefiner.setContentForSWTControl(this.swtControl, this.customProperty.getValueRange());
        return this.swtControl;
    }

    protected void okPressed() {
        LocksAndPermissionsTransactionController transactionController = new LocksAndPermissionsTransactionController((IFrameProjectAgent)this.modelController.getProjectAgent());
        IAttributeTypesModifier modifier = new IAttributeTypesModifier(){

            public boolean isDeleted(IAttributeTypeID attributeTypeID) {
                return false;
            }

            public Collection<? extends IAttributeType> getModifiedAttributeTypes() {
                return Collections.singleton(EditCustomPropertyValueRangeDialogue.this.customProperty);
            }

            public IAttributeType getModifiedAttributeType(IAttributeTypeID attributeTypeUID) {
                if (attributeTypeUID.equals(EditCustomPropertyValueRangeDialogue.this.customProperty.getAttributeTypeID())) {
                    return EditCustomPropertyValueRangeDialogue.this.customProperty;
                }
                return null;
            }

            public Collection<? extends IAttributeType> getAddedAttributeTypes() {
                return Collections.emptyList();
            }
        };
        this.customPropertyTypesManager.requestModifyAttributeTypePermissions(this.customProperty, (ILocksAndPermissionsTransactionController)transactionController, modifier);
        Collection modificationProblems = transactionController.execute();
        if (!modificationProblems.isEmpty()) {
            ModificationProblemsDialog dialogue = new ModificationProblemsDialog(modificationProblems, Messages.getString("CustomValueMappingDlg.ModProblem"), this.getParentShell());
            dialogue.open();
        } else {
            IValueRangeDefiner valueRangeDefiner = this.customProperty.getDataType().getValueRangeHelper();
            try {
                this.customPropertyTypesManager.setValueRange(this.customProperty.getAttributeTypeID(), valueRangeDefiner.getValueRangeFromSWTControl(this.swtControl));
            }
            catch (EXNoLock eXNoLock) {
            }
            catch (EXNoPermission eXNoPermission) {
                // empty catch block
            }
        }
        super.okPressed();
    }
}

