/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.dataexchange.adapter.importer;

import com.arcway.cockpit.frame.client.global.Icons;
import com.arcway.cockpit.modulelib2.client.Messages;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.AbstractExportAndImportWizardBase;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.ExportOrImportResult;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.IExporterOrImporterSpecificWizardPage;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.importer.AttributeAndEnumValueMappings;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.importer.IAttributeMappingPageContribution;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.importer.IImportWizardContribution;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.importer.IImporterManager;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.util.attributemappingpage.AttributeMappingPage;
import com.arcway.lib.eclipse.gui.dialogs.IArcwayWizard;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.eclipse.JFaceProgressMonitorToProgressDisplayAdapter;
import de.plans.lib.util.gui.IProgressDisplay;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;

public class ImportWizard
extends AbstractExportAndImportWizardBase
implements IArcwayWizard {
    private static final ILogger logger = Logger.getLogger(ImportWizard.class);
    private static final String ATTRIBUTE_MAPPING_PAGE_ID_PREFIX = "com.arcway.cockpit.modullib2.attributeMappingImportWizardPage.";
    private final IModelController modelController;
    private final IImporterManager importerManager;
    private final String importerID;
    private boolean attributePagesPrepared;
    private List<AttributeMappingPage> attributeMappingPages;

    public ImportWizard(String importerID, IImportWizardContribution importWizardContribution, IImporterManager importerManager, IModelController modelController) {
        super(importerID, importWizardContribution, null, modelController);
        this.setNeedsProgressMonitor(true);
        this.modelController = modelController;
        this.importerManager = importerManager;
        this.importerID = importerID;
        this.attributePagesPrepared = false;
        this.attributeMappingPages = new LinkedList<AttributeMappingPage>();
    }

    @Override
    protected String getTitle() {
        return Messages.getString("ImportWizard.WindowTitle");
    }

    @Override
    protected ImageDescriptor getImage() {
        return Icons.getImageDescriptorForBigImportLogo();
    }

    @Override
    protected ExportOrImportResult doExportOrImport(String projectUID, List<?> parameters, IProgressDisplay progressDisplay) {
        LinkedList<AttributeAndEnumValueMappings> attributeMappings = new LinkedList<AttributeAndEnumValueMappings>();
        if (this.importerManager.isUsingAttributeMapping(this.importerID)) {
            for (AttributeMappingPage page : this.attributeMappingPages) {
                attributeMappings.add(new AttributeAndEnumValueMappings(page.getAttributeMapping(), page.getEnumerationMappings()));
            }
        }
        return this.importerManager.imporT(this.modelController.getProjectUID(), this.importerID, parameters, attributeMappings, progressDisplay, this.getShell());
    }

    @Override
    protected String getExportOrImportFailedMessageDialogueTitle() {
        return Messages.getString("ImportWizard.ImportFailedMessage_Title");
    }

    @Override
    protected String getExportOrImportFailedMessageDialogueDefaultText() {
        return Messages.getString("ImportWizard.ImportFailedMessage_DefaultText");
    }

    @Override
    protected String getExportOrImportSucceededMessageDialogueTitle() {
        return Messages.getString("ImportWizard.ImportSucceededMessage_Title");
    }

    @Override
    protected String getExportOrImportSucceededMessageDialogueDefaultText() {
        return Messages.getString("ImportWizard.ImportSucceededMessage_DefaultText");
    }

    @Override
    protected List<IWizardPage> getPagesForBeginning() {
        return Collections.emptyList();
    }

    @Override
    protected List<IWizardPage> getPagesForEnd() {
        return Collections.emptyList();
    }

    public void nextPageRequested() {
        if (this.importerManager.isUsingAttributeMapping(this.importerID)) {
            IWizardPage[] pages = this.getPages();
            if (this.getContainer().getCurrentPage() == pages[pages.length - 1]) {
                this.prepareAttributeMappingPages();
            }
        }
    }

    public void prepareAttributeMappingPages() {
        this.attributePagesPrepared = false;
        this.triggerAttributeMappingPagesToStoreConfiguration();
        this.attributeMappingPages.clear();
        IWizardPage[] pages = this.getPages();
        final LinkedList<Object> parameterList = new LinkedList<Object>();
        IWizardPage[] iWizardPageArray = pages;
        int n = pages.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage page = iWizardPageArray[n2];
            if (page instanceof IExporterOrImporterSpecificWizardPage) {
                parameterList.add(((IExporterOrImporterSpecificWizardPage)page).getParameter());
            }
            ++n2;
        }
        final Shell shell = this.getShell();
        final LinkedList attributeMappingPageContributions = new LinkedList();
        final BooleanWrapper success = new BooleanWrapper();
        try {
            this.getContainer().run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    ExportOrImportResult result = ImportWizard.this.importerManager.getAttributeMappingPageContributions(ImportWizard.this.modelController.getProjectUID(), ImportWizard.this.importerID, parameterList, attributeMappingPageContributions, (IProgressDisplay)new JFaceProgressMonitorToProgressDisplayAdapter(monitor), ImportWizard.this.getShell());
                    if (!result.isSuccessful()) {
                        String message = result.getMessage();
                        if (message == null || message.length() == 0) {
                            message = ImportWizard.this.getExportOrImportFailedMessageDialogueDefaultText();
                        }
                        MessageDialog.openError((Shell)shell, (String)ImportWizard.this.getExportOrImportFailedMessageDialogueTitle(), (String)message);
                        attributeMappingPageContributions.clear();
                        success.booleanValue = false;
                    } else {
                        success.booleanValue = true;
                    }
                }
            });
        }
        catch (InvocationTargetException itE) {
            logger.warn("Exception while retrieving attribute mapping page contributions", (Throwable)itE);
        }
        catch (InterruptedException iE) {
            logger.warn("Exception while retrieving attribute mapping page contributions", (Throwable)iE);
        }
        if (success.booleanValue) {
            this.attributeMappingPages = new ArrayList<AttributeMappingPage>(attributeMappingPageContributions.size());
            int index = 0;
            for (IAttributeMappingPageContribution contribution : attributeMappingPageContributions) {
                AttributeMappingPage attributeMappingPage = new AttributeMappingPage(ATTRIBUTE_MAPPING_PAGE_ID_PREFIX + this.importerID + "." + index, contribution.getDataTypeForAttributeMapping(), contribution.getDataPots(), contribution.getAllowedAttributeMappings(), contribution.getWarningsForMappings(), contribution.isMappingOfAllDataPotsRequired(), this.modelController, contribution.getListManagementDialogueCreatorForAttributeMapping());
                attributeMappingPage.setWizard((IWizard)this);
                this.attributeMappingPages.add(attributeMappingPage);
                ++index;
            }
            this.attributePagesPrepared = true;
        }
        this.getContainer().updateButtons();
    }

    private void triggerAttributeMappingPagesToStoreConfiguration() {
        for (AttributeMappingPage attributeMappingPage : this.attributeMappingPages) {
            attributeMappingPage.performFinish();
        }
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (this.importerManager.isUsingAttributeMapping(this.importerID)) {
            int pageIndex = this.attributeMappingPages.indexOf(page);
            if (pageIndex >= 0) {
                if (pageIndex < this.attributeMappingPages.size() - 1) {
                    return (IWizardPage)this.attributeMappingPages.get(pageIndex + 1);
                }
                return null;
            }
            IWizardPage[] pages = this.getPages();
            if (page == pages[pages.length - 1]) {
                if (this.attributePagesPrepared) {
                    if (this.attributeMappingPages != null && !this.attributeMappingPages.isEmpty()) {
                        return (IWizardPage)this.attributeMappingPages.get(0);
                    }
                    return null;
                }
                return page;
            }
        }
        return super.getNextPage(page);
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        if (this.importerManager.isUsingAttributeMapping(this.importerID)) {
            int pageIndex = this.attributeMappingPages.indexOf(page);
            if (pageIndex > 0) {
                return (IWizardPage)this.attributeMappingPages.get(pageIndex - 1);
            }
            if (pageIndex == 0) {
                IWizardPage[] pages = this.getPages();
                return pages[pages.length - 1];
            }
        }
        return super.getPreviousPage(page);
    }

    public boolean canFinish() {
        if (!super.canFinish()) {
            return false;
        }
        if (this.importerManager.isUsingAttributeMapping(this.importerID)) {
            if (!this.attributePagesPrepared) {
                return false;
            }
            for (AttributeMappingPage page : this.attributeMappingPages) {
                if (page.isPageComplete()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean performCancel() {
        if (this.attributePagesPrepared) {
            this.importerManager.abortImport(this.modelController.getProjectUID(), this.importerID);
        }
        this.triggerAttributeMappingPagesToStoreConfiguration();
        return super.performCancel();
    }

    @Override
    public boolean performFinish() {
        this.triggerAttributeMappingPagesToStoreConfiguration();
        return super.performFinish();
    }

    public boolean canCancel() {
        return true;
    }

    public boolean canClose() {
        return true;
    }

    public boolean showHelpOnPreventedClose() {
        return false;
    }

    private class BooleanWrapper {
        boolean booleanValue;

        private BooleanWrapper() {
        }
    }
}

