/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.dataexchange.adapter.importer;

import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.wizards.IWizardDescription;
import com.arcway.cockpit.frame.client.global.gui.wizards.IWizardProvider;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.sections.ISection;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.ExportOrImportFailedException;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.ExportOrImportResult;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.ExportOrImportWizardDescription;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.importer.AttributeAndEnumValueMappings;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.importer.IAttributeMappingPageContribution;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.importer.IImportAdapter;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.importer.IImportableData;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.importer.IImporterManager;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.importer.ImportWizard;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.repository.cockpit.interFace.declaration.frame.project.COTIDsCockpitData;
import com.arcway.repository.interFace.data.attributeset.IRepositoryPropertySetSample;
import com.arcway.repository.interFace.dataaccess.IRepositoryInterfaceRO;
import com.arcway.repository.interFace.declaration.type.property.IRepositoryPropertyTypeID;
import de.plans.lib.util.gui.IProgressDisplay;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractImporterManager
implements IWizardProvider,
IImporterManager {
    private static final ILogger logger = Logger.getLogger(AbstractImporterManager.class);
    private final Map<String, IImportAdapter> map_importerID_importerAdapter = new HashMap<String, IImportAdapter>();

    public AbstractImporterManager() {
        this.construct();
    }

    protected final void putImporter(String importerID, IImportAdapter importAdapter) {
        this.map_importerID_importerAdapter.put(importerID, importAdapter);
    }

    @Override
    public boolean isUsingAttributeMapping(String importerID) {
        IImportAdapter importAdapter = this.map_importerID_importerAdapter.get(importerID);
        if (importAdapter != null) {
            return importAdapter.isUsingAttributeMapping();
        }
        logger.error("Module importer could not be found: " + importerID);
        return false;
    }

    @Override
    public ExportOrImportResult getAttributeMappingPageContributions(String projectUID, String importerID, List<?> parameterList, List<IAttributeMappingPageContribution> contributionList, IProgressDisplay monitor, Shell shell) {
        IImportAdapter importAdapter = this.map_importerID_importerAdapter.get(importerID);
        if (importAdapter != null) {
            try {
                contributionList.addAll(importAdapter.getAttributeMappingPageContributions(parameterList, this.getModelControllerForProject(projectUID).getProjectLanguage(), monitor, shell));
                return new ExportOrImportResult(true, null);
            }
            catch (ExportOrImportFailedException e) {
                logger.error("Module import failed: " + importerID, (Throwable)e);
                return new ExportOrImportResult(false, e.getMessageWithApplicationSemantics());
            }
        }
        logger.error("Module importer could not be found: " + importerID);
        return new ExportOrImportResult(false, null);
    }

    @Override
    public ExportOrImportResult imporT(String projectUID, String importerID, List<?> parameters, List<AttributeAndEnumValueMappings> attributeMappings, IProgressDisplay display, Shell shell) {
        IImportAdapter importAdapter = this.map_importerID_importerAdapter.get(importerID);
        if (importAdapter != null) {
            try {
                final ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(projectUID);
                IRepositoryInterfaceRO repositoryInterface = projectAgent.getRepositoryInterface();
                IImportAdapter.ICockpitObjectIDGenerator idGenerator = new IImportAdapter.ICockpitObjectIDGenerator(){

                    @Override
                    public IRepositoryPropertySetSample generateNewCockpitObjectUID() {
                        return projectAgent.getRepositoryPlattformController().allocateNewObjectID();
                    }

                    @Override
                    public IRepositoryPropertyTypeID getCockpitObjectUIDPropertyTypeID() {
                        return COTIDsCockpitData.PROPERTY_TYPE_ID_UID;
                    }
                };
                IImportableData dataToBeImported = importAdapter.getImportableData(parameters, attributeMappings, this.getModelControllerForProject(projectUID).getProjectLanguage(), repositoryInterface, idGenerator, display, shell);
                return this.importData(projectUID, importerID, dataToBeImported);
            }
            catch (ExportOrImportFailedException e) {
                logger.error("Module import failed: " + importerID, (Throwable)e);
                return new ExportOrImportResult(false, e.getMessageWithApplicationSemantics());
            }
        }
        logger.error("Module importer could not be found: " + importerID);
        return new ExportOrImportResult(false, null);
    }

    @Override
    public void abortImport(String projectUID, String importerID) {
        IImportAdapter importAdapter = this.map_importerID_importerAdapter.get(importerID);
        if (importAdapter != null) {
            importAdapter.abortImport();
        }
    }

    public final List<? extends IWizardDescription> getWizardDescriptions(Object selectedElement) {
        String projectUID;
        IModelController modelController;
        LinkedList<ExportOrImportWizardDescription> wizardDescriptions = new LinkedList<ExportOrImportWizardDescription>();
        if (selectedElement instanceof ISection && ((ISection)selectedElement).isRootSection() && (modelController = this.getModelControllerForProject(projectUID = ((ISection)selectedElement).getProjectUID())) != null) {
            for (Map.Entry<String, IImportAdapter> importer : this.map_importerID_importerAdapter.entrySet()) {
                String importerID = importer.getKey();
                IImportAdapter importAdapter = importer.getValue();
                ImportWizard importWizard = new ImportWizard(importerID, importAdapter.getWizardContribution(), this, modelController);
                importWizard.init(null, (IStructuredSelection)new StructuredSelection(selectedElement));
                wizardDescriptions.add(new ExportOrImportWizardDescription(importerID, (IWizard)importWizard, importAdapter.getWizardContribution()));
            }
        }
        return wizardDescriptions;
    }

    protected abstract void construct();

    protected abstract IModelController getModelControllerForProject(String var1);

    protected abstract ExportOrImportResult importData(String var1, String var2, IImportableData var3);
}

