/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.core.project;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.EXCorruptProjectData;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeOwner;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeDataType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IDataLabelProvider;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IDataLabelProvider2;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ILocalModificationContainer;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.framedata.CustomPropertiesForModuleData;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeModificationManager;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeOwnerRW;
import com.arcway.cockpit.frame.client.project.core.serverproxy.ServerDataContainer;
import com.arcway.cockpit.frame.client.project.modules.IExportDataProvider;
import com.arcway.cockpit.frame.client.project.modules.IFMCAModule2;
import com.arcway.cockpit.frame.client.project.modules.IImportDataAgent;
import com.arcway.cockpit.frame.client.project.modules.IModuleDataFacade;
import com.arcway.cockpit.frame.client.project.modules.IModuleLinkManager;
import com.arcway.cockpit.frame.client.project.modules.IModuleProjectAgent;
import com.arcway.cockpit.frame.client.project.modules.IRequesterForServerData;
import com.arcway.cockpit.frame.client.project.modules.ProjectionIdentifier;
import com.arcway.cockpit.frame.client.project.modules.permissionproviders.IProjectPermissionsGroup;
import com.arcway.cockpit.frame.client.project.planeditors.projections.IProjectionReceiver;
import com.arcway.cockpit.frame.shared.message.EOFrameDataModification;
import com.arcway.cockpit.frame.shared.message.EOGenericCockpitDatabaseData;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.core.project.AbstractDataMgr;
import com.arcway.cockpit.modulelib2.client.core.project.ExportDataProvider;
import com.arcway.cockpit.modulelib2.client.core.project.IDataFacade;
import com.arcway.cockpit.modulelib2.client.core.project.LinkMgr;
import com.arcway.cockpit.modulelib2.client.core.project.ModelModuleAttributeAgent;
import com.arcway.cockpit.modulelib2.client.core.project.ProjectionMgr;
import com.arcway.cockpit.modulelib2.client.core.project.ServerProxy;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData_CustomPropertiesExtension;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.repository.clientadapter.interFace.IPlatformAdapterModule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IWorkbenchPage;

public class ModuleFacade
implements IFMCAModule2 {
    private static final ILogger logger = Logger.getLogger(ModuleFacade.class);
    protected IFrameProjectAgent projectAgent;
    ProjectionMgr projectionMgr;
    ExportDataProvider exportDataProvider;
    LinkMgr linkMgr;
    Collection linkableObjectLinkedDataAccessFacades;
    Collection moduleDataLinkedDataAccessFacades;
    Collection linkTypes;
    IDataFacade dataFacade;
    protected AbstractDataMgr dataManager;
    Collection<IPlatformAdapterModule> platformAdapterModules;
    private IProjectPermissionsGroup permissionTemplateProvider;
    private ServerProxy serverProxy;
    private final IDataLabelProvider modLabelProvider = new IDataLabelProvider(){

        public void removeListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void dispose() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public String getText(Object element) {
            return null;
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getTypeDisplayName(String dataTypeID) {
            return null;
        }

        public Image getImageOfType(String dataTypeID) {
            return null;
        }
    };

    public void construct(IFrameProjectAgent projectAgent_, ProjectionMgr projectionMgrP, IProjectPermissionsGroup permissionTemplateProvider_, ExportDataProvider exportDataProviderP, LinkMgr linkMgr_, Collection linkableObjectLinkedDataAccessFacades_, Collection moduleDataLinkedDataAccessFacades_, Collection linkTypes_, IDataFacade dataFacade_, AbstractDataMgr dataManager_, Collection<IPlatformAdapterModule> platformAdapterModules_, ServerProxy serverProxy_) {
        assert (linkMgr_ != null) : "linkMgr must not be null";
        assert (linkableObjectLinkedDataAccessFacades_ != null);
        assert (moduleDataLinkedDataAccessFacades_ != null);
        assert (linkTypes_ != null) : "linkTypeIDs must not be null";
        assert (dataManager_ != null);
        this.projectAgent = projectAgent_;
        this.projectionMgr = projectionMgrP;
        this.permissionTemplateProvider = permissionTemplateProvider_;
        this.exportDataProvider = exportDataProviderP;
        this.linkMgr = linkMgr_;
        this.linkableObjectLinkedDataAccessFacades = linkableObjectLinkedDataAccessFacades_;
        this.moduleDataLinkedDataAccessFacades = moduleDataLinkedDataAccessFacades_;
        this.linkTypes = linkTypes_;
        this.dataFacade = dataFacade_;
        this.dataManager = dataManager_;
        this.platformAdapterModules = platformAdapterModules_;
        this.serverProxy = serverProxy_;
    }

    public boolean canHandleProjection(ProjectionIdentifier projectionIdentifier) {
        assert (projectionIdentifier != null);
        if (this.projectionMgr != null) {
            return this.projectionMgr.canHandleProjection(projectionIdentifier);
        }
        return false;
    }

    public boolean startProjection(ProjectionIdentifier projectionID, IProjectionReceiver projectionReceiver, IWorkbenchPage page) {
        assert (projectionID != null);
        assert (projectionReceiver != null);
        if (this.projectionMgr != null) {
            return this.projectionMgr.startProjection(projectionID, projectionReceiver, page);
        }
        return false;
    }

    public boolean stopProjection(IProjectionReceiver projectionReceiver) {
        assert (projectionReceiver != null);
        if (this.projectionMgr != null) {
            return this.projectionMgr.stopProjection(projectionReceiver);
        }
        return false;
    }

    public boolean hasChangesForProject() {
        return this.dataManager.hasUncommitedChanges();
    }

    public EOFrameDataModification<? extends EOGenericCockpitDatabaseData> getCreatedOrModifiedChangesForProject() {
        this.dataManager.synchronousUpdateHook_pre();
        return this.dataManager.getCreationAndModificationChangesForCommit();
    }

    public EOFrameDataModification<? extends EOGenericCockpitDatabaseData> getDeletedChangesForProject() {
        return this.dataManager.getDeletionChangesForCommit();
    }

    public void handleResponse(EOFrameDataModification<? extends EOGenericCockpitDatabaseData> response) {
        assert (response != null);
        this.dataManager.handleCommitResponse(response);
    }

    public void finishServerResponse() {
        this.dataManager.finishCommit();
    }

    public void handleServerUpdate(EOFrameDataModification<? extends EOGenericCockpitDatabaseData> response) {
        assert (response != null);
        this.dataManager.handleAsynchronousUpdate(response);
    }

    public void finishServerUpdate() {
        this.dataManager.finishServerUpdate();
    }

    public IModuleDataFacade getModuleDataFacade() {
        return this.dataFacade;
    }

    public void finishInitialization(IModuleProjectAgent project) {
        this.dataManager.projectInitialized();
    }

    public void savePlan(String planUID) {
    }

    public void closePlan(String planUID) {
    }

    public void discardChanges(String planUID) {
    }

    public IProjectPermissionsGroup getPermissionTemplateProvider(IModuleProjectAgent projectAgent) {
        return this.permissionTemplateProvider;
    }

    public IExportDataProvider getExportDataProvider() {
        return this.exportDataProvider;
    }

    public void registerLinkedDataAccessFacades(IModuleLinkManager moduleLinkManager) {
        this.linkMgr.registerLinkedDataAccessFacade(moduleLinkManager, this.linkableObjectLinkedDataAccessFacades, true);
        this.linkMgr.registerLinkedDataAccessFacade(moduleLinkManager, this.moduleDataLinkedDataAccessFacades, false);
    }

    public void registerLinkTypes(IModuleLinkManager linkManager) {
        this.linkMgr.registerLinkTypes(linkManager, this.linkTypes);
    }

    public IImportDataAgent getImportDataAgent() {
        return this.exportDataProvider;
    }

    public void projectCreated() {
        this.dataManager.newProjectCreated();
    }

    public void init(ServerDataContainer serverDataContainer) throws EXCorruptProjectData {
        this.dataManager.initServerState(serverDataContainer.getModuleData());
        this.dataManager.initLocalModifications();
    }

    public void discardLocalModifications1() {
        this.dataManager.clearLocalModifications();
    }

    public boolean handlesDataType(String cockpitDataTypeID) {
        Collection<String> dataTypes_ = this.dataManager.getDataTypesHelper().getAllDataTypes();
        for (String handledType : dataTypes_) {
            if (!handledType.equals(cockpitDataTypeID)) continue;
            return true;
        }
        return false;
    }

    public void setEditorStatus() {
    }

    public Collection<String> getAllDataTypeIDs() {
        return this.dataManager.getDataTypesHelper().getAllDataTypes();
    }

    public Collection<String> getTrueDataTypeIDs() {
        return this.dataManager.getDataTypesHelper().getAllTrueDataTypes();
    }

    public IDataLabelProvider2<String> getDataLabelProvider() {
        return this.dataManager.getDataLabelProvider2();
    }

    public ILocalModificationContainer getLocalModification(boolean displayableOnly) {
        if (displayableOnly) {
            return this.dataManager.getLocalModificationsForDisplayInGUI();
        }
        throw new UnsupportedOperationException();
    }

    public Image getImage() {
        return this.dataManager.getImageForData();
    }

    public String getDisplayName() {
        return this.dataManager.getDisplayNameForData();
    }

    public IAttributeModificationManager getAttributeModificationManager(ICockpitProjectData data) {
        if (!(data instanceof IModuleData_CustomPropertiesExtension)) {
            return null;
        }
        return new ModelModuleAttributeAgent((IModuleData_CustomPropertiesExtension)data, this.projectAgent.getModuleUserDefinedAttributeTypesManager(), this.dataManager);
    }

    public IAttributeOwner getAttributeOwner(ICockpitProjectData data) {
        if (!(data instanceof IModuleData_CustomPropertiesExtension)) {
            return null;
        }
        return new ModelModuleAttributeAgent((IModuleData_CustomPropertiesExtension)data, this.projectAgent.getModuleUserDefinedAttributeTypesManager(), this.dataManager);
    }

    public IAttributeOwner getParent(ICockpitProjectData child) {
        IModuleData moduleData = (IModuleData)this.dataManager.getItem(child.getTypeID(), child.getUID());
        IModuleData parent = this.dataManager.getParent(moduleData);
        if (parent != null) {
            return this.getAttributeOwner((ICockpitProjectData)parent);
        }
        return null;
    }

    public Collection<IAttributeOwner> getChildren(ICockpitProjectData parent) {
        ArrayList<IAttributeOwner> attributeOwnerChildren = new ArrayList<IAttributeOwner>();
        if (parent == null) {
            for (Object element : this.dataManager.getAllRootItems()) {
                IModuleData mc = (IModuleData)element;
                attributeOwnerChildren.add(this.getAttributeOwner((ICockpitProjectData)mc));
            }
        } else {
            IModuleData moduleData = (IModuleData)this.dataManager.getItem(parent.getTypeID(), parent.getUID());
            Collection<IModuleData> children = this.dataManager.getChildren(moduleData);
            for (IModuleData mc : children) {
                attributeOwnerChildren.add(this.getAttributeOwner((ICockpitProjectData)mc));
            }
        }
        return attributeOwnerChildren;
    }

    public void visitAllAttributeOwnerRWs(IAttributeOwnerRW.IVisitor visitor) {
        Iterator<String> iterator = this.getTrueDataTypeIDs().iterator();
        while (iterator.hasNext()) {
            String element;
            String id = element = iterator.next();
            this.visitAllAttributeOwnerRWs(id, visitor);
        }
    }

    private void visitAllAttributeOwnerRWs(String dataTypeID, IAttributeOwnerRW.IVisitor visitor) {
        Collection allItems = this.dataManager.getAllItems(dataTypeID);
        for (IModuleData moduleData : allItems) {
            CustomPropertiesForModuleData attributeOwnerRW = null;
            IAttributeModificationManager modManager = this.getAttributeModificationManager((ICockpitProjectData)moduleData);
            IAttributeOwner owner = this.getAttributeOwner((ICockpitProjectData)moduleData);
            if (modManager != null && owner != null) {
                attributeOwnerRW = new CustomPropertiesForModuleData(owner, modManager);
            }
            if (attributeOwnerRW == null) continue;
            try {
                visitor.visit(attributeOwnerRW);
            }
            catch (Throwable t) {
                logger.warn("Exception during attribute owner visitor operation", t);
            }
        }
    }

    public Collection<IAttributeType> getAllAttributeTypes(Class dataTypeClass) {
        ArrayList<IAttributeType> allAttributeTypes = new ArrayList<IAttributeType>();
        Iterator<String> iterator = this.getTrueDataTypeIDs().iterator();
        while (iterator.hasNext()) {
            String element;
            String id = element = iterator.next();
            this.addAllAttributeTypes(dataTypeClass, id, allAttributeTypes);
        }
        return allAttributeTypes;
    }

    private void addAllAttributeTypes(Class dataTypeClass, String dataTypeID, Collection<IAttributeType> allAttributeTypes) {
        for (Object element : this.dataManager.getAllItems(dataTypeID)) {
            IModuleData moduleData = (IModuleData)element;
            IAttributeOwner attributeOwner = this.getAttributeOwner((ICockpitProjectData)moduleData);
            this.addAllAttributeTypes(dataTypeClass, attributeOwner, allAttributeTypes);
        }
    }

    private void addAllAttributeTypes(Class dataTypeClass, IAttributeOwner attributeOwner, Collection<IAttributeType> allAttributeTypes) {
        for (Object element : attributeOwner.getAllAttributes()) {
            IAttribute attribute = (IAttribute)element;
            IAttributeType attributeType = attributeOwner.getAttributeType(attribute.getAttributeTypeID());
            if (!dataTypeClass.isAssignableFrom(attributeType.getDataType().getClass())) continue;
            allAttributeTypes.add(attributeType);
        }
    }

    public Map<IAttributeTypeDataType, Collection<IAttribute>> getAllAttributesOfType(Class clazz) {
        HashMap<IAttributeTypeDataType, Collection<IAttribute>> attributes = new HashMap<IAttributeTypeDataType, Collection<IAttribute>>();
        Iterator<String> iterator = this.getTrueDataTypeIDs().iterator();
        while (iterator.hasNext()) {
            String element;
            String id = element = iterator.next();
            this.addAllAtributesOfType(clazz, id, attributes);
        }
        return attributes;
    }

    private void addAllAtributesOfType(Class clazz, String dataTypeID, Map<IAttributeTypeDataType, Collection<IAttribute>> attributes) {
        Collection allItems = this.dataManager.getAllItems(dataTypeID);
        for (IModuleData moduleData : allItems) {
            IAttributeOwner attributeOwner = this.getAttributeOwner((ICockpitProjectData)moduleData);
            this.addAllAttributesOfType(clazz, attributeOwner, attributes);
        }
    }

    private void addAllAttributesOfType(Class clazz, IAttributeOwner attributeOwner, Map<IAttributeTypeDataType, Collection<IAttribute>> attributes) {
        for (Object element : attributeOwner.getAllAttributes()) {
            IAttribute attribute = (IAttribute)element;
            IAttributeType attributeType = attributeOwner.getAttributeType(attribute.getAttributeTypeID());
            if (!clazz.isAssignableFrom(attributeType.getDataType().getClass())) continue;
            Collection<IAttribute> attrColl = attributes.get(attributeType.getDataType());
            if (attrColl == null) {
                attrColl = new ArrayList<IAttribute>();
                attributes.put(attributeType.getDataType(), attrColl);
            }
            attrColl.add(attribute);
        }
    }

    public ICockpitProjectData getCockpitProjectData(String dataTypeID, String UID) {
        assert (dataTypeID != null) : "dataTypeID must not be null";
        assert (UID != null) : "UID must not be null";
        return (ICockpitProjectData)this.dataManager.getItem(dataTypeID, UID);
    }

    public IPlatformAdapterModule[] getPlatformAdapterModules() {
        IPlatformAdapterModule[] platformAdapterModules_array = this.platformAdapterModules.toArray(new IPlatformAdapterModule[this.platformAdapterModules.size()]);
        return platformAdapterModules_array;
    }

    public IRequesterForServerData getRequesterToGetModuleDataFromServer(String dataTypeID) {
        return this.serverProxy.getRequesterToGetModuleDataFromServer(dataTypeID);
    }
}

