/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.core;

import com.arcway.cockpit.frame.client.lib.dataviews.projectmanager.ProjectAssociationManager;
import com.arcway.cockpit.modulelib2.client.core.IModelControllerProvider;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.ui.IWorkbenchWindow;

public class ProjectMgr
extends ProjectAssociationManager
implements IModelControllerProvider {
    private final Map<String, IModelController> map_projectUID_modelCtrl = new HashMap<String, IModelController>();

    public void storeModelController(String projectUID, IModelController modelCtrl) {
        assert (projectUID != null);
        assert (modelCtrl != null);
        this.map_projectUID_modelCtrl.put(projectUID, modelCtrl);
    }

    private void removeModelController(String projectUID) {
        assert (projectUID != null);
        this.map_projectUID_modelCtrl.remove(projectUID);
    }

    @Override
    public IModelController getModelController(String projectUID) {
        if (this.getProjectAgent(projectUID) != null) {
            return this.map_projectUID_modelCtrl.get(projectUID);
        }
        return null;
    }

    protected void callback_projectClosed(String projectUID) {
        IModelController modelController = this.map_projectUID_modelCtrl.get(projectUID);
        modelController.projectClosed();
        this.removeModelController(projectUID);
    }

    public IModelController getModelControllerOfActiveProjectForWorkbenchWindow(IWorkbenchWindow workbenchWindow) {
        String projectUID = this.getActiveProjectForWorkbenchWindow(workbenchWindow);
        if (projectUID != null) {
            return this.getModelController(projectUID);
        }
        return null;
    }
}

