/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.interFace.client.eclipse.interFace;

import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.actions.OpenPlanWithPlanDisplayParametersAction;
import com.arcway.cockpit.frame.client.global.gui.properties.CEProperties;
import com.arcway.cockpit.frame.client.global.selection.CockpitSelectionManager;
import com.arcway.cockpit.frame.client.global.selection.CockpitSelectionService;
import com.arcway.cockpit.frame.client.project.ExProjectOpenAbortWithMessage;
import com.arcway.cockpit.frame.client.project.IFrameDataManager;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.plan.IPlan;
import com.arcway.cockpit.frame.client.project.planagents.PlanDisplayParameters;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.interFace.client.eclipse.interFace.COCKPITObjectInformationFetcher;
import com.arcway.cockpit.interFace.client.eclipse.interFace.COCKPITObjectUID;
import com.arcway.cockpit.interFace.client.eclipse.interFace.EXCouldNotOpenProject;
import com.arcway.cockpit.interFace.client.eclipse.interFace.EXInvalidParameter;
import com.arcway.cockpit.interFace.client.eclipse.interFace.EXProjectNotOpen;
import com.arcway.cockpit.interFace.client.eclipse.interFace.EXProjectUnknown;
import com.arcway.cockpit.interFace.client.eclipse.interFace.EXUnknownAction;
import com.arcway.cockpit.interFace.client.eclipse.interFace.EXUnknownObject;
import com.arcway.cockpit.interFace.client.eclipse.interFace.ICOCKPITEclipseClientController;
import com.arcway.cockpit.interFace.client.eclipse.interFace.ICOCKPITObjectInformation;
import com.arcway.cockpit.interFace.client.eclipse.interFace.SingletonCockpitDataSelectionProvider;
import com.arcway.lib.UUIDGenerator;
import com.arcway.lib.codec.EXDecoderException;
import com.arcway.lib.codec.xml.EXXMLDecodingFailed;
import com.arcway.lib.java.Assert;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.shared.serverexceptions.EXServerException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class COCKPITEclipseClientController
implements ICOCKPITEclipseClientController {
    private static final ILogger LOGGER = Logger.getLogger(COCKPITEclipseClientController.class);
    private static Map<String, Collection<String>> tinyContext2tinies = new HashMap<String, Collection<String>>();
    private static Map<String, String> tiny2longQuery = new HashMap<String, String>();

    COCKPITEclipseClientController() {
    }

    @Override
    public void openProject(String projectUID) throws EXProjectUnknown, EXCouldNotOpenProject {
        Assert.checkArgumentBeeingNotNull((Object)projectUID);
        IFrameProjectAgent projectAgent = COCKPITEclipseClientController.getProjectAgent(projectUID);
        if (!projectAgent.isOpened()) {
            IWorkbenchPage currentPage;
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window != null) {
                currentPage = window.getActivePage();
                IWorkbenchPage[] pages = window.getPages();
                if (currentPage == null && pages.length > 0) {
                    currentPage = pages[0];
                }
            } else {
                currentPage = null;
            }
            try {
                boolean triggerUserOnOpenActions = true;
                projectAgent.open(false, triggerUserOnOpenActions, currentPage);
            }
            catch (LoginCanceledException e) {
                throw new EXCouldNotOpenProject(e);
            }
            catch (ServerNotAvailableException e) {
                throw new EXCouldNotOpenProject(e);
            }
            catch (UnknownServerException e) {
                throw new EXCouldNotOpenProject(e);
            }
            catch (EXServerException e) {
                throw new EXCouldNotOpenProject(e);
            }
            catch (ExProjectOpenAbortWithMessage e) {
                throw new EXCouldNotOpenProject(e);
            }
        }
    }

    @Override
    public void closeProject(String projectUID) throws EXProjectUnknown {
        Assert.checkArgumentBeeingNotNull((Object)projectUID);
        IFrameProjectAgent projectAgent = COCKPITEclipseClientController.getProjectAgent(projectUID);
        if (projectAgent.isOpened()) {
            ProjectMgr.getProjectMgr().closeProject(projectAgent, true);
        }
    }

    @Override
    public ICOCKPITObjectInformation getObjectInformation(COCKPITObjectUID cockpitObjectUID) {
        return new COCKPITObjectInformationFetcher(cockpitObjectUID);
    }

    @Override
    public void showObject(COCKPITObjectUID cockpitObjectUID, Map<String, Object> parameters) throws EXProjectUnknown, EXProjectNotOpen, EXUnknownObject {
        Assert.checkArgumentBeeingNotNull((Object)cockpitObjectUID);
        IFrameProjectAgent projectAgent = COCKPITEclipseClientController.getProjectAgentOfOpenProject(cockpitObjectUID);
        ICockpitProjectData cockpitProjectData = COCKPITEclipseClientController.getCockpitProjectData(projectAgent, cockpitObjectUID);
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (cockpitProjectData instanceof IPlan) {
            SingletonCockpitDataSelectionProvider selectionProvider = new SingletonCockpitDataSelectionProvider(cockpitProjectData);
            IWorkbenchPage page = window.getActivePage();
            String projectUID = cockpitProjectData.getProjectUID();
            PlanDisplayParameters planDisplayParameters = (PlanDisplayParameters)parameters.get("planDisplayParameters");
            if (planDisplayParameters == null) {
                planDisplayParameters = new PlanDisplayParameters();
            }
            OpenPlanWithPlanDisplayParametersAction openPlanAction = new OpenPlanWithPlanDisplayParametersAction((ISelectionProvider)selectionProvider, page, projectUID, planDisplayParameters);
            openPlanAction.run();
        } else {
            CEProperties.Input input = CEProperties.checkSuitabilityForPropertiesCommand(Collections.singleton(cockpitProjectData));
            IWorkbenchPage page = window.getActivePage();
            CEProperties.openProperties((CEProperties.Input)input, (IWorkbenchPage)page, (boolean)false);
        }
        CockpitSelectionService css = CockpitSelectionManager.getSelectionService((ISelectionService)window.getSelectionService());
        css.fireSelection(cockpitProjectData, window.getActivePage().getActivePart());
    }

    @Override
    public void highlightObjects(Collection<COCKPITObjectUID> cockpitObjectUIDs) {
        Assert.checkArgumentBeeingNotNull(cockpitObjectUIDs);
        HashMap objects = new HashMap();
        for (COCKPITObjectUID cockpitObjectUID : cockpitObjectUIDs) {
            try {
                IFrameProjectAgent projectAgent = COCKPITEclipseClientController.getProjectAgentOfOpenProject(cockpitObjectUID);
                ICockpitProjectData cockpitProjectData = COCKPITEclipseClientController.getCockpitProjectData(projectAgent, cockpitObjectUID);
                if (!objects.containsKey(projectAgent)) {
                    objects.put(projectAgent, new ArrayList());
                }
                Collection objectsOfProject = (Collection)objects.get(projectAgent);
                objectsOfProject.add(cockpitProjectData);
            }
            catch (EXProjectUnknown projectAgent) {
            }
            catch (EXProjectNotOpen projectAgent) {
            }
            catch (EXUnknownObject projectAgent) {
                // empty catch block
            }
        }
        Iterator i = objects.entrySet().iterator();
        if (i.hasNext()) {
            Map.Entry entry = i.next();
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            CockpitSelectionService css = CockpitSelectionManager.getSelectionService((ISelectionService)window.getSelectionService());
            Collection cockpitProjectDatas = (Collection)entry.getValue();
            css.fireSelection(cockpitProjectDatas, window.getActivePage().getActivePart());
        }
    }

    @Override
    public COCKPITObjectUID getObjectUID(ICockpitProjectData cockpitProjectData) {
        Assert.checkArgumentBeeingNotNull((Object)cockpitProjectData);
        COCKPITObjectUID cockpitObjectUID = null;
        try {
            COCKPITObjectUID cockpitObjectUIDTest = new COCKPITObjectUID(cockpitProjectData.getProjectUID(), cockpitProjectData.getTypeID(), cockpitProjectData.getUID());
            IFrameProjectAgent projectAgent = COCKPITEclipseClientController.getProjectAgentOfOpenProject(cockpitObjectUIDTest);
            COCKPITEclipseClientController.getCockpitProjectData(projectAgent, cockpitObjectUIDTest);
            cockpitObjectUID = cockpitObjectUIDTest;
        }
        catch (EXProjectUnknown eXProjectUnknown) {
        }
        catch (EXProjectNotOpen eXProjectNotOpen) {
        }
        catch (EXUnknownObject eXUnknownObject) {
            // empty catch block
        }
        return cockpitObjectUID;
    }

    static IFrameProjectAgent getProjectAgent(String projectUID) throws EXProjectUnknown {
        ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(projectUID);
        if (projectAgent == null) {
            throw new EXProjectUnknown();
        }
        return projectAgent;
    }

    static IFrameProjectAgent getProjectAgentOfOpenProject(COCKPITObjectUID cockpitObjectUID) throws EXProjectUnknown, EXProjectNotOpen {
        IFrameProjectAgent projectAgent = COCKPITEclipseClientController.getProjectAgent(cockpitObjectUID.getProjectUID());
        if (!projectAgent.isOpened()) {
            throw new EXProjectNotOpen();
        }
        return projectAgent;
    }

    static ICockpitProjectData getCockpitProjectData(COCKPITObjectUID cockpitObjectUID) throws EXUnknownObject, EXProjectUnknown, EXProjectNotOpen {
        IFrameProjectAgent projectAgent = COCKPITEclipseClientController.getProjectAgentOfOpenProject(cockpitObjectUID);
        return COCKPITEclipseClientController.getCockpitProjectData(projectAgent, cockpitObjectUID);
    }

    static ICockpitProjectData getCockpitProjectData(IFrameProjectAgent projectAgent, COCKPITObjectUID cockpitObjectUID) throws EXUnknownObject {
        IFrameProjectAgent cockpitProjectData;
        if (projectAgent.getProjectUID().equals(cockpitObjectUID.getObjectUID())) {
            cockpitProjectData = projectAgent;
        } else {
            IFrameDataManager dataManager = COCKPITEclipseClientController.getDataManager(projectAgent, cockpitObjectUID);
            cockpitProjectData = dataManager.getCockpitProjectData(cockpitObjectUID.getObjectUID());
        }
        if (cockpitProjectData == null) {
            throw new EXUnknownObject();
        }
        return cockpitProjectData;
    }

    static IFrameDataManager getDataManager(IFrameProjectAgent projectAgent, COCKPITObjectUID cockpitObjectUID) throws EXUnknownObject {
        List dataManagers = projectAgent.getDataManagers();
        IFrameDataManager dataManager = COCKPITEclipseClientController.getDataManager(cockpitObjectUID.getObjectTypeUID(), dataManagers);
        if (dataManager == null) {
            throw new EXUnknownObject();
        }
        return dataManager;
    }

    private static IFrameDataManager getDataManager(String cockpitDataTypeID, Collection<? extends IFrameDataManager> dataManagers) {
        for (IFrameDataManager iFrameDataManager : dataManagers) {
            if (!iFrameDataManager.handlesDataType(cockpitDataTypeID)) continue;
            return iFrameDataManager;
        }
        return null;
    }

    @Override
    public String getCurrentProjectUID(IWorkbenchPage page) {
        CockpitSelectionService css = CockpitSelectionManager.getSelectionService((ISelectionService)page.getWorkbenchWindow().getSelectionService());
        IFrameProjectAgent projectAgent = css.getFrameProjectAgent();
        if (projectAgent != null) {
            String projectUID = projectAgent.getProjectUID();
            projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(projectUID);
            if (projectAgent != null) {
                return projectUID;
            }
        }
        return null;
    }

    @Override
    public URI getLinkForShow(ICockpitProjectData cockpitProjectData, Map<String, Object> parameters, String tinyContext) {
        COCKPITObjectUID cockpitObjectUID = this.getObjectUID(cockpitProjectData);
        HashMap<String, String> uriParameters = new HashMap<String, String>();
        uriParameters.put("action", "show");
        PlanDisplayParameters planDisplayParameters = (PlanDisplayParameters)parameters.get("planDisplayParameters");
        if (planDisplayParameters != null) {
            String encodedPlanDisplayParameters = PlanDisplayParameters.encodeIntoString((PlanDisplayParameters)planDisplayParameters);
            uriParameters.put("planDisplayParameters", encodedPlanDisplayParameters);
        }
        String query = COCKPITEclipseClientController.encodeQuery(uriParameters);
        if (tinyContext != null) {
            query = COCKPITEclipseClientController.tinyizeQuery(query, tinyContext);
        }
        return cockpitObjectUID.toURI(query);
    }

    @Override
    public void freeTinyContext(String tinyContext) {
        COCKPITEclipseClientController.freeTinies(tinyContext);
    }

    private static synchronized void freeTinies(String tinyContext) {
        Collection<String> tinies = tinyContext2tinies.remove(tinyContext);
        if (tinies != null) {
            for (String tiny : tinies) {
                tiny2longQuery.remove(tiny);
            }
        }
    }

    private static synchronized String tinyizeQuery(String longQuery, String tinyContext) {
        String tinyQuery;
        if (longQuery.length() > 800) {
            String tinyString = UUIDGenerator.getUniqueID();
            Collection<String> tinies = tinyContext2tinies.get(tinyContext);
            if (tinies == null) {
                tinies = new ArrayList<String>();
                tinyContext2tinies.put(tinyContext, tinies);
            }
            tinies.add(tinyString);
            tiny2longQuery.put(tinyString, longQuery);
            HashMap<String, String> tinyParameters = new HashMap<String, String>();
            tinyParameters.put("tiny", tinyString);
            tinyQuery = COCKPITEclipseClientController.encodeQuery(tinyParameters);
        } else {
            tinyQuery = longQuery;
        }
        return tinyQuery;
    }

    private static synchronized Map<String, String> untinyQuery(Map<String, String> uriParameters) throws EXInvalidParameter {
        Map<String, String> untiniedUriParameters;
        String tinyString = uriParameters.get("tiny");
        if (tinyString != null) {
            String longQuery = tiny2longQuery.get(tinyString);
            if (longQuery != null) {
                untiniedUriParameters = COCKPITEclipseClientController.decodeQuery(longQuery);
            } else {
                untiniedUriParameters = new HashMap<String, String>();
                untiniedUriParameters.put("action", "show");
                LOGGER.warn("Unknown tiny URL. Tiny URLs have a temporaray life time.");
            }
        } else {
            untiniedUriParameters = uriParameters;
        }
        return untiniedUriParameters;
    }

    @Override
    public boolean isCockpitURI(URI uri) {
        return "cockpit".equals(uri.getScheme());
    }

    @Override
    public void processURI(URI uri) throws EXProjectUnknown, EXProjectNotOpen, EXUnknownObject, EXUnknownAction, EXInvalidParameter {
        String query = uri.getQuery();
        Map<String, String> uriParameters = COCKPITEclipseClientController.decodeQuery(query);
        uriParameters = COCKPITEclipseClientController.untinyQuery(uriParameters);
        String action = uriParameters.get("action");
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        String planDisplayParametersAsString = uriParameters.get("planDisplayParameters");
        if (planDisplayParametersAsString != null) {
            PlanDisplayParameters planDisplayParameters;
            try {
                planDisplayParameters = PlanDisplayParameters.decodeFromString((String)planDisplayParametersAsString);
            }
            catch (EXDecoderException e) {
                throw new EXInvalidParameter((Exception)((Object)e));
            }
            catch (EXXMLDecodingFailed e) {
                throw new EXInvalidParameter((Exception)((Object)e));
            }
            parameters.put("planDisplayParameters", planDisplayParameters);
        }
        COCKPITObjectUID cockpitObjectUID = new COCKPITObjectUID(uri);
        if (!"show".equals(action)) {
            throw new EXUnknownAction();
        }
        this.showObject(cockpitObjectUID, parameters);
    }

    public static Map<String, String> decodeQuery(String query) {
        String[] pairs;
        LinkedHashMap<String, String> query_pairs = new LinkedHashMap<String, String>();
        String[] stringArray = pairs = query.split("&");
        int n = pairs.length;
        int n2 = 0;
        while (n2 < n) {
            String pair = stringArray[n2];
            int idx = pair.indexOf("=");
            try {
                query_pairs.put(URLDecoder.decode(pair.substring(0, idx), "UTF-8"), URLDecoder.decode(pair.substring(idx + 1), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            ++n2;
        }
        return query_pairs;
    }

    public static String encodeQuery(Map<String, String> query_pairs) {
        StringBuilder query = new StringBuilder();
        for (Map.Entry<String, String> pair : query_pairs.entrySet()) {
            if (query.length() > 0) {
                query.append("&");
            }
            try {
                query.append(URLEncoder.encode(pair.getKey(), "UTF-8"));
                query.append("=");
                query.append(URLEncoder.encode(pair.getValue(), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return query.toString();
    }
}

