/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure;

import com.arcway.cockpit.genericmodule.client.infrastructure.specification.AbstractModuleSpecificationPart;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.IModuleSpecificationPart;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ColumnContent;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ColumnProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Column
extends AbstractModuleSpecificationPart
implements ColumnProvider {
    private final String columnID;
    private final String columnName;
    private final String columnDescription;
    private final int columnWidth;
    private final boolean invisibleByDefault;
    private final Map<String, ColumnContent> columnContentMap;
    private final List<ColumnContent> columnContentList;

    public Column(String columnID, String columnName, String columnDescription, int columnWidth, boolean invisibleByDefault, List<ColumnContent> columnContentList) {
        this.columnID = columnID;
        this.columnName = columnName;
        this.columnDescription = columnDescription;
        this.columnWidth = columnWidth;
        this.invisibleByDefault = invisibleByDefault;
        this.columnContentMap = new HashMap<String, ColumnContent>();
        this.columnContentList = new ArrayList<ColumnContent>();
        int columnContentListCounter = 1;
        for (ColumnContent part : columnContentList) {
            ((AbstractModuleSpecificationPart)((Object)part)).setIndex(columnContentListCounter);
            String partID = part.getID();
            this.columnContentMap.put(partID, part);
            this.columnContentList.add(part);
            ++columnContentListCounter;
        }
    }

    public String getColumnID() {
        return this.columnID;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getColumnDescription() {
        return this.columnDescription;
    }

    public int getColumnWidth() {
        return this.columnWidth;
    }

    public boolean isInvisibleByDefault() {
        return this.invisibleByDefault;
    }

    public List<ColumnContent> getColumnContentList() {
        return this.columnContentList;
    }

    public ColumnContent getColumnContent(String id) {
        return this.columnContentMap.get(id);
    }

    public ColumnContent getColumnContent(int index) {
        return this.getColumnContentList().get(index);
    }

    public <T extends ColumnContent> List<T> getColumnContentListOfType(Class<T> type) {
        ArrayList<ColumnContent> list = new ArrayList<ColumnContent>(this.columnContentMap.size());
        for (ColumnContent child : this.columnContentMap.values()) {
            if (!type.isAssignableFrom(child.getClass())) continue;
            list.add((ColumnContent)type.cast(child));
        }
        Column.sortSpecificationPartList(list);
        return list;
    }

    @Override
    public String getID() {
        return this.columnID;
    }

    @Override
    public List<IModuleSpecificationPart> getChildren() {
        ArrayList<IModuleSpecificationPart> children = new ArrayList<IModuleSpecificationPart>();
        children.addAll(this.getColumnContentList());
        return children;
    }

    @Override
    public String getTypeID() {
        return "Column";
    }
}

